-- ----------------------------------------------------------------------------
-- Credits: Thanks goes to Quartz code and the Ace HOWTO page for showing me 
--          syntax on the Libraries.
-- 
-- What: A swing timer that works correctly.
-- 
-- 
-- ----------------------------------------------------------------------------
--
--local L = LibStub("AceLocale-3.0"):GetLocale("LD50_abar")
--
--LD50_abar = LibStub("AceAddon-3.0"):NewAddon("LD50_abar", "AceEvent-3.0", "AceConsole-3.0", "AceDB-3.0")
--

--local L = LibStub("AceAddon-3.0"):NewAddon("LD50_abar", "AceConsole-3.0")
--
--LD50_abar = LibStub("AceAddon-3.0"):new("AceConsole-3.0", "AceDB-3.0", "AceEvent-3.0")
--

local L = AceLibrary("AceLocale-2.2"):new("LD50_abar")

LD50_abar = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0")

LD50_abar:RegisterDB("LD50_abar_DB")

local self = LD50_abar

local sm = AceLibrary("LibSharedMedia-3.0")

-- ----------------------------------------------------------------------------
-- Local Babble like Spell List for processing
-- ----------------------------------------------------------------------------
local autoshotname;

local autoshotwand;

local mh_resetspells = {};

local bh_resetspells = {};

local bh_positionspells = {};

local bh_rangedspells = {};

local bh_notrealspells = {};

-- ----------------------------------------------------------------------------
-- The Global Variable List
-- ----------------------------------------------------------------------------
local unpack              = unpack
local GetTime             = GetTime
local db                              -- Database with all the options
local swingmode           = nil;      -- nil none, 0 meleeing, 1 autoshooting
local in_combat                       -- are we in combat?
local TimeSinceLastUpdate =0;         -- regulator on OnUpdate
local reg_events          = false     -- are events turned on?
local spell_cast          = nil;      -- Spell currently being cast.

local swingframe                      -- Main Frame
local swingframe_o                    -- Main Frame

local mh_bar                          -- status bar for main hand swining
local mh_lag                          -- overlay for latency
local mh_gcd
local mh_speed                        -- Current speed of the MH weapon
local mh_start                        -- Time when the swing started
local mh_duration                     -- Text - Time period of swing
local mh_event                        -- Text - Name of what just happened
local mh_remain                       -- Text - Time remaining on swing
local mh_avg                          -- Average damage of this weapon
local mh_extra                        -- did an extra swing just proc???

local oh_active                       -- Is there an off hand weapon??
local oh_bar
local oh_lag                          -- overlay for latency
local oh_gcd
local oh_speed        = nil;
local oh_start
local oh_duration                     -- Text - Time period of swing
local oh_event                        -- Text - Name of what just happened
local oh_remain                       -- Text - Time remaining on swing
local oh_avg

local upd_old         = nil;          -- In band com to OnUpdate to refresh
local latency         = 0;            -- amount of lag in milliseconds.
local cli_to_srv      = 0;            -- Num to add -convert clint time to server time
                                      -- server is GMT unix time

local englishClass    = nil;
local GCD             = 1.5;

-- Would like to use this but need to check copyrights.
--sm:Register("mh_bar", "Frost", "Interface\\AddOns\\Quartz\\textures\\Frost")
--sm:Register("mh_bar", "Healbot", "Interface\\AddOns\\Quartz\\textures\\Healbot")
--sm:Register("mh_bar", "LiteStep", "Interface\\AddOns\\Quartz\\textures\\LiteStep")
--sm:Register("mh_bar", "Rocks", "Interface\\AddOns\\Quartz\\textures\\Rocks")
--sm:Register("mh_bar", "Runes", "Interface\\AddOns\\Quartz\\textures\\Runes")
--sm:Register("mh_bar", "Xeon", "Interface\\AddOns\\Quartz\\textures\\Xeon")

function LD50_abar:DEBUG()

	 junk = "in_combat:"..(in_combat and "True" or "False");
	 junk = junk.."     spell_cast:"..(in_combat and spell_cast or "nil");
	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:"..junk,1,1,0);
	 junk = "mh_start:"..(mh_start and mh_start or "nil");
	 junk = junk.."     oh_start:"..(oh_start and oh_start or "nil");
	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:"..junk,1,1,0);
	 junk = "mh_speed:"..(mh_speed and mh_speed or "nil");
	 junk = junk.."     oh_speed:"..(oh_speed and oh_speed or "nil");
	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:"..junk,1,1,0);
end
-- ----------------------------------------------------------------------------
-- Description: This is called as the screen is repainted.(usually)
-- ----------------------------------------------------------------------------
function LD50_abar:OnUpdate(elapsed)

	TimeSinceLastUpdate = TimeSinceLastUpdate + elapsed; 	

  	while (TimeSinceLastUpdate > (1.0/db.profile.UpdateInterval)) do
    		--
    		-- Insert your OnUpdate code here
    		--
		if(in_combat == true) then

			-- Shitty hack cause blizzard is stupid
			-- I need to make this more generic
			if(spell_cast ~= nill and bh_notrealspells[spell_cast] and mh_start) then
				local timestamp = GetTime()+cli_to_srv;
 				local spent = timestamp - mh_start;
				if(spent > 0.5) then
					mh_start=timestamp;
					LD50_abar:MH_Update(spell_cast,nil);
					if( oh_start ~= nil and oh_active == true) then
						oh_start=timestamp;
						LD50_abar:OH_Update(spell_cast,nil);
					end
					spell_cast = nil;
				end
			end


			if mh_start then
				local timestamp = GetTime()+cli_to_srv;
 				local spent = timestamp - mh_start
				mh_remain:SetText(('%.2f'):format(mh_speed - spent))
				local perc = spent / mh_speed
				--if perc > 1 then
				--	--return swingframe:Hide()
				if perc > 2.0 then
					-- Sanity check.
					mh_bar:SetValue(0);
					mh_speed = 0;
					mh_start = nil;
					-- A MASSIVE saftey check
					if(InCombatLockdown() == nil) then
						-- wtf were not really in combat
						--LD50_abar:DEBUG();
						in_combat=false;
					end
				else
					mh_bar:SetValue(perc);
					mh_event:SetAlpha(db.profile.alpha*(1.0-perc));
				end
			end
	
			if oh_start and oh_active == true then
				local timestamp = GetTime()+cli_to_srv;
				local spent = timestamp - oh_start
				oh_remain:SetText(('%.2f'):format(oh_speed - spent))
				local perc = spent / oh_speed
				--if perc > 1 then
				--	--return swingframe:Hide()
				if perc > 2.0 then
					-- Sanity check.
					oh_bar:SetValue(0);
					oh_speed = 0;
					oh_start = nil;
				else
					oh_bar:SetValue(perc)
					oh_event:SetAlpha(db.profile.alpha*(1.0-perc));
				end
			end

	    		TimeSinceLastUpdate = TimeSinceLastUpdate - (1.0/db.profile.UpdateInterval);
		else
			--
			-- Out of combat use less cpu resources.
			--
			mh_start = nil;
			oh_start = nil;
			mh_bar:SetValue(0);
			oh_bar:SetValue(0);
			oh_remain:SetText("0.00");

	    		TimeSinceLastUpdate = TimeSinceLastUpdate - 0.1; -- 10 fps

			if (db.profile.ooc_hiding == true) then
				local alph = swingframe:GetAlpha();
				--alph = alph - 0.1;
				alph = alph - (db.profile.alpha / 10.0);
				if(alph > 0) then
					swingframe:SetAlpha(alph);
				elseif(alph ~= 0) then
					swingframe:SetAlpha(0);
				end
			end
 		end
		-- 
		-- If Off Hand status relayout the display
		--
		if(upd_old ~= oh_active) then
			upd_old = oh_active;
			if(oh_active == true) then
				--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:OnUdate:Show",1,1,0);
				mh_bar:SetHeight(db.profile.swingheight)
				mh_gcd:SetHeight(db.profile.swingheight)
				mh_lag:SetHeight(db.profile.swingheight)
				oh_bar:Show()
				if(db.profile.oh_gcd_toggle) then
					oh_gcd:Show()
				else
					oh_gcd:Hide()
				end
				if(db.profile.oh_lag_toggle) then
					oh_lag:Show()
				else
					oh_lag:Hide()
				end
				if(db.profile.oh_remain) then
					oh_remain:Show()
				else
					oh_remain:Hide()
				end;
				if(db.profile.oh_event) then
					oh_event:Show()
				else
					oh_event:Hide()
				end;
				if(db.profile.oh_duration) then
				   	oh_duration:Show()
				else
					oh_duration:Hide()
				end
			else
				--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:OnUdate:Hide",1,1,0);
				mh_bar:SetHeight(db.profile.swingheight * 2)
				mh_gcd:SetHeight(db.profile.swingheight * 2)
				mh_lag:SetHeight(db.profile.swingheight * 2)
				oh_bar:Hide()
				oh_gcd:Hide()
				oh_lag:Hide()
				oh_remain:Hide()
				oh_event:Hide()
				oh_duration:Hide()
			end
		end
  	end
end
-- ----------------------------------------------------------------------------
-- 
-- ----------------------------------------------------------------------------
function LD50_abar:OnInitialize()
	-- Called when the addon is loaded
	-- Note: Copied from Quartz
	--
	if AceLibrary:HasInstance("Waterfall-1.0") then
		AceLibrary("Waterfall-1.0"):Register('LD50_abar',
			'aceOptions', options,
			'title', L["LD50_abar"],
			'treeLevels', 3,
			'colorR', 0.8, 'colorG', 0.8, 'colorB', 0.8
		)
		self:RegisterChatCommand({"/LD50_abar"}, function()
			AceLibrary("Waterfall-1.0"):Open('LD50_abar')
		end)
		if AceLibrary:HasInstance("Dewdrop-2.0") then
			self:RegisterChatCommand({"/LD50_abarz"}, function()
				AceLibrary("Dewdrop-2.0"):Open('LD50_abarz', 'children', function()
					AceLibrary("Dewdrop-2.0"):FeedAceOptionsTable(options)
				end)
			end)
		end
		self:RegisterChatCommand({"/LD50_abarzcl"}, options)
	elseif AceLibrary:HasInstance("Dewdrop-2.0") then
		self:RegisterChatCommand({"/LD50_abarz"}, function()
			AceLibrary("Dewdrop-2.0"):Open('LD50_abarz', 'children', function()
				AceLibrary("Dewdrop-2.0"):FeedAceOptionsTable(options)
			end)
		end)
		self:RegisterChatCommand({"/LD50_abarzcl"}, options)
	else
		self:RegisterChatCommand({"/LD50_abarz"}, options)
	end
	--
	-- Build local dictionaries for use.
	--
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(75);   -- Auto Shot
	autoshotname =name;

	name,_,_,_,_,_,_,_,_ = GetSpellInfo(5019); -- Shoot - wand
        autoshotwand = name;

	name,_,_,_,_,_,_,_,_ = GetSpellInfo(845);  -- Cleave
	mh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(78);   -- Heroic Strike
	mh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(779);  -- Swipe
	mh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(6807); -- Maul
	mh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(2973); -- Raptor Strike
	mh_resetspells[name] = true;

	name,_,_,_,_,_,_,_,_ = GetSpellInfo(3411);  -- Intervene
	bh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(1464);  -- Slam
	bh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(100);   -- Charge
	bh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(20252); -- Intercept
	bh_resetspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(16979); -- Feral Charge
	bh_resetspells[name] = true;

	name,_,_,_,_,_,_,_,_ = GetSpellInfo(3411);  -- Intervene
	bh_positionspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(100);   -- Charge
	bh_positionspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(20252); -- Intercept
	bh_positionspells[name] = true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(16979); -- Feral Charge
	bh_positionspells[name] = true;

	name,_,_,_,_,_,_,_,_ = GetSpellInfo(2764); -- Throw
	bh_rangedspells[name]=true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(3018); -- Shoot - Melee
	bh_rangedspells[name]=true;
	name,_,_,_,_,_,_,_,_ = GetSpellInfo(75);   -- Auto Shot
	bh_rangedspells[name]=true;

	name,_,_,_,_,_,_,_,_ = GetSpellInfo(20549); -- War Stomp
	bh_notrealspells[name] = true;

	--for k,v in pairs(bh_rangedspells) do
	--	--DEFAULT_CHAT_FRAME:AddMessage("T:"..k..":",1,1,0)
 	--end

	--
	-- Load up the default Preferences
	--
	db = LD50_abar:AcquireDBNamespace("LD50_abar")
	LD50_abar:RegisterDefaults("LD50_abar", "profile", {
		enabbled    = true,
		ooc_hiding  = false,
		cb_hide     = false,
		swingheight = 14,
		swingwidth  = 250,
		scale       = 1,
		alpha       = 1,
		texture     = 'LiteStep',
		x           = 17,
		y           = 511,
		
		UpdateInterval = 30,

		font        = 'Friz Quadrata TT',
		font_size   = 9,

		sf_color       = {0.0, 0.0, 0.0, 1.0},

		mh_barcolor    = {1.0, 1.0, 0.5, 1.0},
		mh_gcd_toggle  = false,
		mh_gcdcolor    = {0.1, 0.0, 0.1, 0.5},
		mh_lag_toggle  = true,
		mh_lagcolor    = {0.5, 1.0, 1.0, 0.5},

		mh_duration    	      = true,
		mh_dur_font           = 'Friz Quadrata TT',
		mh_dur_font_size      = 9,
		mh_dur_font_pos       = "TOPLEFT",
		mh_dur_font_color     = {1.0, 1.0, 1.0, 1.0},
		mh_dur_font_shadow    = {0.0, 0.0, 0.0, 1.0},

		mh_event              = true,
		mh_eve_font           = 'Friz Quadrata TT',
		mh_eve_font_size      = 9,
		mh_eve_font_pos       = "TOPCENTER",
		mh_eve_font_color     = {1.0, 1.0, 1.0, 1.0},
		mh_eve_font_shadow    = {0.0, 0.0, 0.0, 1.0},

		mh_remain             = true,
		mh_rem_font           = 'Friz Quadrata TT',
		mh_rem_font_size      = 9,
		mh_rem_font_pos       = "TOPRIGHT",
		mh_rem_font_color     = {1.0, 1.0, 1.0, 1.0},
		mh_rem_font_shadow    = {0.0, 0.0, 0.0, 1.0},

		oh_barcolor  = {0.5, 1.0, 1.0, 1.0},
		oh_gcd_toggle= false,
		oh_gcdcolor  = {0.1, 0.0, 0.1, 0.5},
		oh_lag_toggle= true,
		oh_lagcolor  = {1.0, 1.0, 0.5, 0.5},

		oh_duration           = true,
		oh_dur_font           = 'Friz Quadrata TT',
		oh_dur_font_size      = 9,
		oh_dur_font_pos       = "BOTTOMLEFT",
		oh_dur_font_color     = {1.0, 1.0, 1.0, 1.0},
		oh_dur_font_shadow    = {0.0, 0.0, 0.0, 1.0},

		oh_event              = true,
		oh_eve_font           = 'Friz Quadrata TT',
		oh_eve_font_size      = 9,
		oh_eve_font_pos       = "BOTTOMCENTER",
		oh_eve_font_color     = {1.0, 1.0, 1.0, 1.0},
		oh_eve_font_shadow    = {0.0, 0.0, 0.0, 1.0},

		oh_remain             = true,
		oh_rem_font           = 'Friz Quadrata TT',
		oh_rem_font_size      = 9,
		oh_rem_font_pos       = "BOTTOMRIGHT",
		oh_rem_font_color     = {1.0, 1.0, 1.0, 1.0},
		oh_rem_font_shadow    = {0.0, 0.0, 0.0, 1.0},

	});
end
-- ----------------------------------------------------------------------------
-- 
-- ----------------------------------------------------------------------------
function LD50_abar:OnLoad()	

	DEFAULT_CHAT_FRAME:AddMessage("LD50 Attack Bar Timer 2.5 Loaded",1,1,0);
	DEFAULT_CHAT_FRAME:AddMessage(" Commands can be accessed through /LD50_abar help",1,1,0);
end
-- ----------------------------------------------------------------------------
-- 
-- ----------------------------------------------------------------------------
function LD50_abar:Register_Events()

	reg_events = true;

	--
	-- Blizard Events
	--
	-- fired when autoattack is enabled/disabled.
	--self:RegisterEvent("PLAYER_ENTER_COMBAT")
	--self:RegisterEvent("PLAYER_LEAVE_COMBAT")
	-- fired when player enters combat
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	-- fired when autoshot (or autowand) is enabled/disabled
	self:RegisterEvent("START_AUTOREPEAT_SPELL")
	self:RegisterEvent("STOP_AUTOREPEAT_SPELL")
	
	--self:RegisterEvent("UNIT_SPELLCAST_START");
	self:RegisterEvent("UNIT_SPELLCAST_SENT");
	--self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
	--self:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
	
	self:RegisterEvent("UNIT_ATTACK")
	--self:RegisterEvent("UNIT_ATTACK_SPEED")
	self:RegisterEvent("ITEM_LOCK_CHANGED")
	--self:RegisterEvent("UNIT_INVENTORY_CHANGED")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

	self:RegisterEvent("MIRROR_TIMER_START");

end
-- ----------------------------------------------------------------------------
-- 
-- ----------------------------------------------------------------------------
function LD50_abar:Unregister_Events()	

	if(reg_events == true) then
		reg_events = false;
	else
		return;
	end;
	--
	-- Blizard Events
	--
	-- fired when autoattack is enabled/disabled.
	--self:UnregisterEvent("PLAYER_ENTER_COMBAT")
	--self:UnregisterEvent("PLAYER_LEAVE_COMBAT")
	-- fired when player enters combat
	self:UnregisterEvent("PLAYER_REGEN_DISABLED")
	self:UnregisterEvent("PLAYER_REGEN_ENABLED")
	-- fired when autoshot (or autowand) is enabled/disabled
	self:UnregisterEvent("START_AUTOREPEAT_SPELL")
	self:UnregisterEvent("STOP_AUTOREPEAT_SPELL")
	
	--self:UnregisterEvent("UNIT_SPELLCAST_START")
	self:UnregisterEvent("UNIT_SPELLCAST_SENT");
	--self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	--self:UnregisterEvent("UNIT_SPELLCAST_INTERRUPTED");
	
	self:UnregisterEvent("UNIT_ATTACK")
	self:UnregisterEvent("ITEM_LOCK_CHANGED")
	--self:UnregisterEvent("UNIT_INVENTORY_CHANGED")
	self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

	self:UnregisterEvent("MIRROR_TIMER_START");
end
-- ----------------------------------------------------------------------------
-- Called when the addon is enabled
-- ----------------------------------------------------------------------------
function LD50_abar:OnEnable()

	DEFAULT_CHAT_FRAME:AddMessage("LD50 Attack Bar Timer 2.5 Loaded",1,1,0);
	DEFAULT_CHAT_FRAME:AddMessage(" Commands can be accessed through /LD50_abar help",1,1,0);

	if not IsLoggedIn() then
		return
	end
	--
	-- Register all the Events
	--
	LD50_abar:Register_Events()	
	--
	--
	--
	if not swingframe then
		swingframe = CreateFrame('Frame', 'LD50_abar_1', UIParent)
		swingframe:SetFrameStrata('MEDIUM')
		swingframe:SetScript('OnShow', LD50_abar.OnShow)
		swingframe:SetScript('OnHide', LD50_abar.OnHide)
		swingframe:SetMovable(true)
		swingframe:RegisterForDrag('LeftButton')
		swingframe:SetClampedToScreen(true)

		--swingframe:SetFrameLevel(4);

		swingframe_o = CreateFrame('Frame', nil, swingframe);
		swingframe_o:SetPoint('TOPLEFT'    , swingframe, 'TOPLEFT'    , 0, 0);
		swingframe_o:SetPoint('TOPRIGHT'   , swingframe, 'TOPRIGHT'   , 0, 0);
		swingframe_o:SetPoint('BOTTOMLEFT' , swingframe, 'BOTTOMLEFT' , 0, 0);
		swingframe_o:SetPoint('BOTTOMRIGHT', swingframe, 'BOTTOMRIGHT', 0, 0);


		local lay=swingframe:GetFrameLevel(); 
		swingframe_o:SetFrameLevel(lay+4);


	end

	if not mh_bar then
		mh_bar = CreateFrame("StatusBar", nil, swingframe)
		mh_bar:SetPoint('TOPLEFT' ,swingframe,'TOPLEFT' ,0,0);
		mh_bar:SetPoint('TOPRIGHT',swingframe,'TOPRIGHT',0,0);
		
                mh_gcd = CreateFrame("StatusBar", nil, swingframe);
		mh_gcd:SetPoint('TOPRIGHT',swingframe,'TOPRIGHT',0,0);

		mh_lag = CreateFrame("StatusBar", nil, swingframe)
		mh_lag:SetPoint('TOPRIGHT',swingframe,'TOPRIGHT',0,0);

		-- Swap Layers
		--local lay=mh_lag:GetFrameLevel(); 
		local lay=swingframe:GetFrameLevel(); 
		mh_gcd:SetFrameLevel(lay+1);
		mh_bar:SetFrameLevel(lay+3);
		mh_lag:SetFrameLevel(lay+2);

		mh_duration = swingframe_o:CreateFontString(nil, 'OVERLAY')
		mh_duration:SetPoint('TOPLEFT', swingframe_o, 'TOPLEFT')

		mh_event    = swingframe_o:CreateFontString(nil, 'OVERLAY')
		mh_event:SetPoint('TOPLEFT' ,swingframe_o, 'TOPLEFT')
		mh_event:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT')

		mh_remain   = swingframe_o:CreateFontString(nil, 'OVERLAY')
		mh_remain:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT')

	end

	if not oh_bar then
		oh_bar = CreateFrame("StatusBar", nil, swingframe)
		oh_bar:SetPoint('BOTTOMLEFT' , swingframe, 'BOTTOMLEFT' , 0, 0)
		oh_bar:SetPoint('BOTTOMRIGHT', swingframe, 'BOTTOMRIGHT', 0, 0)
		
		oh_gcd = CreateFrame("StatusBar", nil, swingframe)
		oh_gcd:SetPoint('BOTTOMRIGHT', swingframe, 'BOTTOMRIGHT', 0, 0)

		oh_lag = CreateFrame("StatusBar", nil, swingframe)
		oh_lag:SetPoint('BOTTOMRIGHT', swingframe, 'BOTTOMRIGHT', 0, 0)

		-- Swap Layers
		local lay=swingframe:GetFrameLevel(); 
		oh_gcd:SetFrameLevel(lay+2);
		oh_bar:SetFrameLevel(lay+1);
		oh_lag:SetFrameLevel(lay+3);

		oh_duration = swingframe_o:CreateFontString(nil, 'OVERLAY')
		oh_duration:SetPoint('BOTTOMLEFT', swingframe_o, 'BOTTOMLEFT',0,1)

		oh_event    = swingframe_o:CreateFontString(nil, 'OVERLAY')
		oh_event:SetPoint('BOTTOMLEFT' ,swingframe_o,'BOTTOMLEFT' ,0,1);
		oh_event:SetPoint('BOTTOMRIGHT',swingframe_o,'BOTTOMRIGHT',0,1);

		oh_remain   = swingframe_o:CreateFontString(nil, 'OVERLAY')
		oh_remain:SetPoint('BOTTOMRIGHT', swingframe_o, 'BOTTOMRIGHT',0,1)
	end

	--
	--
	--
        in_combat = false;
	mh_extra  = false;
	_,_,latency = GetNetStats();
	TimeSinceLastUpdate = 0;

	_, englishClass = UnitClass("player");

	if(englishClass == "ROGUE" ) then
		GCD = 1.0;
	end

	if(englishClass == "HUNTER"  or 
	   englishClass == "WARLOCK" or 
	   englishClass == "MAGE"    or 
	   englishClass == "PRIEST"    ) then
		swingmode = 1;
	else
		swingmode = 0;
	end

	-- we do this twice since we need fonts done.
	LD50_abar.ApplySettings();

	LD50_abar:MH_Update("",nil);
	LD50_abar:OH_Update("",nil);

	LD50_abar.ApplySettings();

	mh_speed,_ = UnitAttackSpeed('player');
	mh_remain:SetText(('%.2f'):format(mh_speed));


	if (db.profile.ooc_hiding == false) then
		swingframe:SetAlpha(db.profile.alpha)
 	end
	--
	swingframe:Show();
	swingframe:SetScript('OnUpdate', LD50_abar.OnUpdate);

end
-- ----------------------------------------------------------------------------
-- Called when the addon is disabled
-- ----------------------------------------------------------------------------
function LD50_abar:OnDisable()

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:OnDisable",1,1,0);

	-- hack to to get on enable menu otion to work?
	reg_events = false;
	swingframe:Hide()
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:OnHide()

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:OnHide",1,1,0);

	LD50_abar:Unregister_Events();
	swingframe:SetScript('OnUpdate', nil)
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:OnShow()

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:OnShow",1,1,0);

	LD50_abar:Register_Events();
	swingframe:SetScript('OnUpdate', LD50_abar.OnUpdate)
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
--   EEEEE    V     V  EEEEE  N   N   TTTTT  SSSSS
--   E         V   V   E      NN  N     T    S
--   EEEEE     V   V   EEEEE  N N N     T    SSSSS
--   E          V V    E      N  NN     T        S
--   EEEEE       V     EEEEE  N   N     T    SSSSS
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
--
-- ----------------------------------------------------------------------------
-- Description: This event is fired when you switch targets which causes the
--              swing timer to reset
--
-- PLAYER_ENTER_COMBAT and PLAYER_LEAVE_COMBAT are for *MELEE* combat only. They
-- fire when you initiate autoattack and when you turn it off. However, any spell 
-- or ability that does not turn on autoattack does not trigger it. Nor does it 
-- trigger when you get aggro.
-- ----------------------------------------------------------------------------
--function LD50_abar:PLAYER_ENTER_COMBAT()
--
--	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:PLAYER_ENTER_COMBAT",1,1,0);
--
--	--mh_start=GetTime()+cli_to_srv;
--	--LD50_abar:MH_Update("",nil);
--
--	--oh_start=GetTime()+cli_to_srv;
--	--LD50_abar:OH_Update("",nil);
--
--end
-- ----------------------------------------------------------------------------
-- Description: Fired when the player leaves combat through death, defeat of
--              opponents, or an ability. Does not fire if a player flees from
-- combat on foot. 
-- It appears this is fired when you remove your target.
-- ----------------------------------------------------------------------------
--function LD50_abar:PLAYER_LEAVE_COMBAT()
--
--	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:PLAYER_LEAVE_COMBAT",1,1,0);
--
--        --in_combat = false;
--
--	-- THis only occurs when you deslect a target but it doesn't stop the 
--        -- swing on the server. so we let the bar run if it reachs some + time
--        -- we will have onUpdate catch it.
--	--mh_bar:SetValue(0);
--	--mh_remain:SetText("0.00");
--	--mh_start=nil;
--	--LD50_abar:MH_Update("",nil);
--
--	--oh_bar:SetValue(0);
--	--oh_remain:SetText("0.00");
--	--oh_start=nil;
--	--LD50_abar:OH_Update("",nil);
--end
-- ----------------------------------------------------------------------------
-- Description: This event fires when you have entered combat for any reason.
-- ----------------------------------------------------------------------------
function LD50_abar:PLAYER_REGEN_DISABLED()

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:PLAYER_REGEN_DISABLED",1,1,0);

	if(db.profile.cb_hide == true) then
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_START");
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_STOP");
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_FAILED");
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_INTERRUPTED");
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_DELAYED");
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_CHANNEL_START");
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE");
		CastingBarFrame:UnregisterEvent("UNIT_SPELLCAST_CHANNEL_STOP");
		CastingBarFrame:Hide();
	end;

	if(in_combat == false) then
		if(CheckInteractDistance("target", 3)) then
			swingmode = 0;
		        mh_min,mh_max,_,_,_,_,_ = UnitDamage("player");
			mh_avg=(mh_max+mh_min)/2.0;
			-- assume the world is a 30% reduction
			mh_avg = mh_avg * 0.70;
			mh_start = GetTime() + cli_to_srv;

			_,oh_speed = UnitAttackSpeed('player');
			if(oh_speed ~= nil) then
				oh_active = true;

	        		_,_,oh_min,oh_max,_,_,_ = UnitDamage("player");
				oh_avg=(oh_max+oh_min)/2.0;
				-- assume the world is a 30% reduction
				oh_avg = oh_avg * 0.70;
			end
		else
			swingmode = 1; -- ranged
			mh_speed,mh_min,mh_max,_,_,_ = UnitRangedDamage("player");
			mh_avg=(mh_max+mh_min)/2.0;
			-- assume the world is a 30% reduction
			mh_avg = mh_avg * 0.70;
			mh_start = GetTime() + cli_to_srv;
		end
	end

        in_combat = true;

	if (db.profile.ooc_hiding == true) then
		swingframe:SetAlpha(db.profile.alpha)
 	end
end
-- ----------------------------------------------------------------------------
-- Description: We have left combat.
-- ----------------------------------------------------------------------------
function LD50_abar:PLAYER_REGEN_ENABLED()

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:PLAYER_REGEN_ENABLED",1,1,0);

	if(db.profile.cb_hide == true) then
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_START");
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_STOP");
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_FAILED");
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED");
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_DELAYED");
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START");
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE");
		CastingBarFrame:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP");
	end;

        in_combat = false;

	spell_cast = nil;
	
	mh_bar:SetValue(0);
	mh_remain:SetText("0.00");
	mh_start=nil;
	LD50_abar:MH_Update("",nil);

	oh_bar:SetValue(0);
	oh_remain:SetText("0.00");
	oh_start=nil;
	LD50_abar:OH_Update("",nil);
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:START_AUTOREPEAT_SPELL()

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:START_AUTOREPEAT_SPELL:"..swingmode,1,1,0);

--	if (unit ~= 'player') then
--		return;
--	end

--	spell, rank, displayName, icon, startTime, endTime = UnitCastingInfo("player")

	--if(spell ~= nil)then
	--	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_AUTOREPEAT_SPELL:"..spell..":"..swingmode,1,1,0);
	--else
	--	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_AUTOREPEAT_SPELL:nil:"..swingmode,1,1,0);
	--end

	swingmode = 1
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:STOP_AUTOREPEAT_SPELL()

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_SPELLCAST_STOP:"..swingmode,1,1,0);

	if not swingmode or swingmode == 1 then
		swingmode = 0
	end
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
--function LD50_abar:UNIT_SPELLCAST_START(unit, spell,rank,target)
--end
-- ----------------------------------------------------------------------------
-- This function sees spells that
-- Are cast and have or have not a cast time.
-- ----------------------------------------------------------------------------
function LD50_abar:UNIT_SPELLCAST_SENT(unit, spell,rank,target)

	if (unit ~= 'player') then
		return;
	end

	timestamp = GetTime()+cli_to_srv;
	local name,_,_,_,_,_, castTime, minRange, maxRange = GetSpellInfo(spell);
	--name,_, displayName,_, startTime, endTime = UnitCastingInfo("player")

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_SPELLCAST_SENT:"..spell..":"..castTime,1,1,0);

	--
	-- Some sanity Checks to set swingmode around
	--
	if((spell == autoshotname) or
	   (spell == autoshotwand) )  then
		in_combat = true;
		swingmode = 1;
	end

--- this may not be true actually
--	if (bh_resetspells[spell]) then
--		swingmode = 0;
--	end

	-- 
	-- Certain spells are only visable when they are sent these are
	-- covered below.
	-- 
	if(bh_notrealspells[spell]) then
		spell_cast = spell;
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_SPELLCAST_SENT:filtered:"..spell..":"..castTime,1,1,0);

		mh_start=timestamp;
		LD50_abar:MH_Update("",(castTime/1000))

		if( oh_start ~= nil and oh_active == true) then
			oh_start=timestamp;
			LD50_abar:OH_Update("",(castTime/1000));
		end;
		return;
	end;
	-- 
	-- We will only process instant cast spells here.
	-- 
	if(castTime ~= 0) then
		return;
	end;
	--
	-- This is the general processing for spells being sent
	-- We only need to filter instant cast ones, those with
	-- casting times are handle generically with start. also only
	-- specfic instant spells are cared about.
	--

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_SPELLCAST_SENT:filtered:"..spell,1,1,0);

	if (bh_rangedspells[spell]) then
		if(in_combat == false) then
			LD50_abar:PLAYER_REGEN_DISABLED();
		end;
		swingmode = 1;
		self:Shoot(spell,timestamp);
		--oh_start  = nil;
		--oh_bar:SetValue(0);
		return;
	end;

	-- make this close range not ranged attack
	if(bh_positionspells[spell]) then

		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_SPELLCAST_SENT:filtered:"..spell..":"..castTime,1,1,0);
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_SPELLCAST_SENT:filtered:"..timestamp,1,1,0);

		-- makeing cast time like .02 is actually a nice effect but not really truthful

		--spell_cast = nil;
		spell_cast = spell;

		if(in_combat == false) then
			--in_combat=true;
			LD50_abar:PLAYER_REGEN_DISABLED();
		end;

		swingmode = 0;
		mh_start=timestamp;
		LD50_abar:MH_Update("",0.02)

		if(oh_start ~= nil and oh_active == true) then
			oh_start=timestamp;
			LD50_abar:OH_Update("",0.2);
		end;
		return;
	end;
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
--function LD50_abar:UNIT_SPELLCAST_SUCCEEDED(event,timestamp,...)
--end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
--function LD50_abar:UNIT_SPELLCAST_INTERRUPTED(event,timestamp,...)
--end
-- ----------------------------------------------------------------------------
-- This should be the inital combat sequence
-- ----------------------------------------------------------------------------
function LD50_abar:UNIT_ATTACK(unit)

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:UNIT_ATTACK",1,1,0);

	if (unit ~= "player") then
		return;
	end;

	-- this shouldn't occur
	if (swingmode == nil) then
		return;
	end;

	timestamp = GetTime()+cli_to_srv;
	
	if (swingmode == 0) then
		-- Melee
		mh_start = timestamp;
		LD50_abar:MH_Update("",nil);

		if( oh_start and oh_active == true) then
			oh_start = timestamp;
			LD50_abar:OH_Update("",nil);
		end;
	elseif (swingmode == 1) then
		-- Ranged
		self:Shoot("",timestamp);
		oh_start  = nil;
		oh_bar:SetValue(0);
	end;
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
--function LD50_abar:UNIT_ATTACK_SPEED(unit)
--
--	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:Unit_Attack_Speed",1,1,0);
--
--end
-- ----------------------------------------------------------------------------
function LD50_abar:ITEM_LOCK_CHANGED(slot,bag)

	--if(bag == nill) and (slot ~= nill) then
	--	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:nill:"..slot,1,1,0);
	--elseif(bag ~= nill) and (slot == nill) then
	--	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:"..bag..":nill",1,1,0);
	--elseif(bag ~= nill) and (slot ~= nill) then
	--	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:"..bag..":"..slot,1,1,0);
	--else
	--	DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:??:??",1,1,0);
	--end;
	
	--
	-- filter for just MainHandSlot OffHandSlot RangedWeapon
	--
	if((slot ~= 16) and (slot ~= 17) and (slot ~= 18)) then
		return;
	end;
	--
	-- Bug workaround: Blizzard never tells you if the off hand is empty
	--                 only there is a weapon in it. You could sequence 
	--                 events so tha off hand -> bag change but that has
	--		   way to many issues.
	--
	_,l_oh_speed = UnitAttackSpeed('player');
	if(l_oh_speed == nil) then
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:no  offhand",1,1,0);
		oh_active = false;
		oh_start  = nil; 
		oh_speed  = nil;
	end;

	timestamp = GetTime()+cli_to_srv;

	--
	-- this handles main hand swaping
	--
	if (slot == 16) then
		--
		-- can't be nil since fists work
		--
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:main hand",1,1,0);
		mh_speed,_ = UnitAttackSpeed('player');
		mh_remain:SetText(('%.2f'):format(mh_speed));

		if(in_combat == true) then
			mh_start = timestamp;
		end
		LD50_abar:MH_Update("",nil);
		--
		-- This may have removed the offhand.
		--
		_,l_oh_speed = UnitAttackSpeed('player');
		if(l_oh_speed == nil) then
			--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:no  offhand",1,1,0);
			oh_active = false;
			oh_start  = nil; 
			oh_speed  = nil;
		end;
	end;
	--
	-- this handles off hand swaping
	--
	if (slot == 17) then
		--
		-- if nill then they removed their offhand
		--
		_,oh_speed = UnitAttackSpeed('player');

		if(oh_speed ~= nil) then
			--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:new offhand:"..oh_speed,1,1,0);
			oh_remain:SetText(('%.2f'):format(oh_speed));
			oh_active = true;
			if(in_combat == true) then
				oh_start = timestamp;
			end
			LD50_abar:OH_Update("",nil);
		else
			--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:no  offhand",1,1,0);
			oh_active = false;
			oh_start  = nil; 
			oh_speed  = nil;
		end;
	end;
	--
	-- this handles ranged weapon swaping
	--
	if((slot == 18)     and 
	   (swingmode == 1) )    then
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ITEM_LOCK_CHANGED:ranged weapon",1,1,0);
		--
		--
		mh_speed,_,_,_,_,_ = UnitRangedDamage("player");
		mh_remain:SetText(('%.2f'):format(mh_speed));

		if(in_combat == true) then
			mh_start = timestamp;
		end
		LD50_abar:MH_Update("",nil);
		-- just to make sure
		oh_active = false;
	end;
end;
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:UNIT_INVENTORY_CHANGED(unit)

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:Unit_Inventory_Changed",1,1,0);

	if (unit ~= 'player') then
		return;
	end

	if (swingmode == nil) then
		return;
	else
		return;
	end;

--[[
	timestamp = GetTime()+cli_to_srv;
	
	if (swingmode == nil or swingmode == 0) then
		-- Melee

		if(in_combat == true) then
			mh_start = timestamp;
		end
		LD50_abar:MH_Update("",nil);

		_,oh_speed = UnitAttackSpeed('player');

		if(oh_speed ~= nil) then
			oh_active = true;
			if(in_combat == true) then
				oh_start = timestamp;
			end
			LD50_abar:OH_Update("",nil);
		else
			oh_start = nil; 
			oh_active = false;
		end
	elseif (swingmode == 1) then
		-- Ranged
		if(in_combat == true) then
			mh_start = timestamp;
		end
		LD50_abar:MH_Update("",nil);
		oh_active = false;
	end
]]
end

-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:MIRROR_TIMER_START()

    --DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:MIRROR_TIMER_START",1,1,0);

    --if(db.profile.cb_hide == true and in_combat == true) then
--	for index = 1, MIRRORTIMER_NUMTIMERS, 1 do
--	    getglobal("MirrorTimer"..index):Hide();
--	end;
--    end;
end;
-- ----------------------------------------------------------------------------
-- This is where I process the new combat log (2.4)
-- ----------------------------------------------------------------------------
-- CCCCC OOOOO M   M BBBB    A   TTTTT     L     OOOOO GGGGG   22222    4  4
-- C     O   O MM MM B   B  A A    T       L     O   O G           2    4  4
-- C     O   O M M M BBBB   AAA    T       L     O   O G GGG   22222    44444
-- C     O   O M   M B   B A   A   T       L     O   O G  G    2     ..    4
-- CCCCC OOOOO M   M BBBB  A   A   T       LLLLL OOOOO GGGGG   22222 ..    4
-- ----------------------------------------------------------------------------
function LD50_abar:COMBAT_LOG_EVENT_UNFILTERED(a_timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags,...)

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:CLEU:"..timestamp..":"..event,1,1,0);

	cli_to_srv = 0;
	--if(cli_to_srv == 0) then
	--	cli_to_srv = a_timestamp - GetTime() - (latency/1000);
	--end

	if (UnitGUID("player") == sourceGUID) then
		--timestamp  = a_timestamp;
		--cli_to_srv = timestamp - GetTime() - (latency/1000);
	
		timestamp  = GetTime();
		cli_to_srv = 0;

		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:CLEU:"..event..":",1,1,0);

		if(event == "SPELL_EXTRA_ATTACKS") then	
			LD50_abar.ParseExtraEvent(event);

		elseif(event == "SWING_MISSED") then
			LD50_abar.ParseMissEvent(event,timestamp,...);
		elseif(event == "SPELL_MISSED") then
			LD50_abar:ParseSpellcastMissed(event,timestamp,...);
		elseif(event == "RANGE_MISSED") then
			LD50_abar:ParseSpellcastMissed(event,timestamp,...);

		elseif(event == "SWING_DAMAGE") then
			LD50_abar:ParseDamageEvent(event,timestamp,...);
		elseif(event == "SPELL_DAMAGE") then
			LD50_abar:ParseSpellcastDamage(event,timestamp,...);
		elseif(event == "RANGE_DAMAGE") then
			LD50_abar:ParseSpellcastDamage(event,timestamp,...);

		elseif(event == "SPELL_HEAL") then
			LD50_abar:ParseHealEvent(event,timestamp,...);

		elseif(event == "SPELL_CAST_START") then
			LD50_abar:ParseSpellcastStart(event,timestamp,...);

		elseif(event == "SPELL_CAST_SUCCESS") then
			LD50_abar:ParseSpellcastSuccess(event,timestamp,...);
		elseif(event == "SPELL_INTERRUPT") then
			LD50_abar:ParseSpellcastInterrupt(event,timestamp,...);
		elseif(event == "SPELL_CAST_FAILED") then
			LD50_abar:ParseSpellcastFailed(event,timestamp,...);
		else
			--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:CLEU:"..event..":"..sourceName..":",1,0,1);
		end
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:CLEU:sGUID:"..sourceGUID,1,1,0);

	elseif (UnitGUID("player") == destGUID) then
		-- if you parry a mob your swing increases
		--
		if(event == "SWING_MISSED") then

			--timestamp  = a_timestamp;
			--cli_to_srv = timestamp - GetTime() - (latency/1000);
	
			timestamp  = GetTime();
			cli_to_srv = 0;


			local missType = select(1, ...);
			if(missType == "PARRY") then
				LD50_abar.ParseParryEvent(event,timestamp,...);
			end
		end
	end
end
-- ----------------------------------------------------------------------------
-- Description: This is fired when a spell starts to cast. Usually any spell
--              cast will reset swing timer, except instant cast spells.
-- Sent actually sees more spells though.
-- Start ONLY sees spells that have a cast time.
-- ----------------------------------------------------------------------------
function LD50_abar:ParseSpellcastStart(event,timestamp,...)

	local spellId,spell,spellSchool = ...;
	local name,_,_,_,_,_, castTime, minRange, maxRange = GetSpellInfo(spellId);

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastStart:"..event..":"..spell..":"..spellSchool..":"..name..":"..timestamp,1,1,0);

	spell_cast = spell;

	-- 
	-- Catch some swingmode
	-- 
	if (bh_resetspells[spell]) then
	        in_combat  = true;
		swingmode  = 0;
	end

	--if((spell == autoshotname) or
	--  (spell == autoshotwand) )  then
	if (bh_rangedspells[spell]) then
		swingmode = 1;
		if(in_combat == false) then
			LD50_abar:PLAYER_REGEN_DISABLED();
		end;
		self:Shoot(spell,timestamp);
		return;
	end

	--
	-- Sanity Check
	--
	if (swingmode == nil) then
		return;
	end;

	if(castTime == 0) then
		return;
	end;

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastStart:"..spell..":2",1,1,0);
	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastStart:"..castTime,1,1,0);

	mh_start = timestamp;
	LD50_abar:MH_Update("",(castTime/1000));

	if(oh_start and oh_active == true) then
		oh_start = timestamp;
		LD50_abar:OH_Update("",(castTime/1000));
	end;
end
-- ----------------------------------------------------------------------------
-- Apparently this only fires when your actively interrupted by another spell
-- Thus why a second spell is passed in.
-- Since I think failed also gets called where not doing anything right now.
-- ----------------------------------------------------------------------------
function LD50_abar:ParseSpellcastInterrupt(event,timestamp,...)

	do
		return;
	end;

	local spellId,spell,spellSchool,  extraSpellID,extraSpellName,extraSpellSchool = ...

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastInterrupt:"..spell,1,1,0);

	if(spell_cast == spell) then
		spell_cast=nil;
	end;

	mh_start = timestamp;
	LD50_abar:MH_Update(spell,nil);

	if(oh_start and oh_active == true) then
		oh_start = timestamp;
		LD50_abar:OH_Update(spell,nil);
	end;

	return;
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:ParseSpellcastFailed(event,timestamp,...)

	local spellId,spell,spellSchool,   failedType = ...

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastFailed:"..spell..":"..failedType,1,1,0);

	-- 
	-- There is a bunch of failed reasons. The only one that i can see that
	-- applies to a swing timer is:
	-- "Interrupted"                           - You jump
	-- "Target needs to be in front of you."   - turn around
	-- "Out of range"                          = get closer
	--
	if((failedType ~= "Interrupted") and
	   (failedType ~= "Target needs to be in front of you.") and
	   (failedType ~= "Out of range")) then
		return;
	end;

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastFailed:processing",1,1,0);

	local name,_,_,_,_,_,castTime,_,_ = GetSpellInfo(spellId);

	--
	-- Filter out the instant cast spells
	--
	if(castTime == 0) then
		return;
	end;

	if(spell_cast == spell) then
		spell_cast=nil;
	end;

	mh_start = timestamp;
	LD50_abar:MH_Update(spell,nil)

	if(oh_start and oh_active == true) then
		oh_start = timestamp;
		LD50_abar:OH_Update(spell,nil);
	end

	return;
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:ParseHealEvent(event,timestamp,...)

	local spellId,spell,spellSchool,  amount,critical = ...;
	local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(spellId);

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseHealEvent:"..event..":"..spell..":"..name,1,1,0);

	
	return;
end

-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar.ParseExtraEvent(event,timestamp)

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseExtraEvent"..event,1,1,0);

	mh_extra = true;
end
-- ----------------------------------------------------------------------------
-- Description:
--
-- Scope: Melee events only
-- ----------------------------------------------------------------------------
function LD50_abar.ParseMissEvent(event,timestamp,...)

	missType = ...;

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseMissEvent:"..event..":"..missType,1,1,0);

        self:MeleeSwing(0,timestamp,missType);

	-- Reassert we are in melee mode
	swingmode =0;
end
-- ----------------------------------------------------------------------------
-- Do heroic Strikes missing fall into this area? yes(Heroic Strike: DODGE:0)
-- ----------------------------------------------------------------------------
function LD50_abar:ParseSpellcastMissed(event,timestamp,...)

	local spellId,spell,spellSchool,  missType = ...;
	local name,rank,_,_,_,_,castTime,_,_ = GetSpellInfo(spellId);

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastMissed:"..spell..":"..missType..":"..castTime,1,1,0);

	--
	-- Saftey Check
	--
	if(in_combat == false) then
		return;
	end
	--
	-- Extra Check for hunters basically
	--
	if(event == "RANGE_MISSED") then
		swingmode =1;
	end


	--
	-- While I LOVe all this code it turns out most spells fire
	-- a couple of events. The only spell I know I need to 
	-- catch here is slam. The rest get caught by ParseSpellcastSuccess

	if(spell == "Slam") then
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastMissed:"..spell..":"..damage,1,1,0);

		mh_start = timestamp;
		LD50_abar:MH_Update(spell,nil);

		oh_start = timestamp;
		LD50_abar:OH_Update(spell,nil);
		return;
	else
		return;
	end;



	--
	-- First we have to search for on next attack spells since they have no 
        -- cast time.
	--
	if (mh_resetspells[spell]) then
		mh_start = timestamp;
		LD50_abar:MH_Update(missType,nil);
		return;
	elseif (bh_resetspells[spell]) then
		mh_start = timestamp;
		LD50_abar:MH_Update(missType,nil);
		if( oh_start and oh_active == true) then
			oh_start = timestamp;
			LD50_abar:OH_Update(missType,nil);
		end;
		return;
	elseif (spell == autoshotname) then
		self:Shoot(missType,timestamp);
		return;
	elseif (spell == autoshotwand) then
		self:Shoot(missType,timestamp);
		return;
	end
	-- 
	-- Base idea is if it was an instant spell then it really can't reset 
	-- a swing timer. This is a General code area so it should work for
	-- al the other stuff we don't really pay attention to.
	-- 
	if(castTime == 0) then
		return
	end

	if(spell_cast == spell) then
		spell_cast=nil;

		mh_start = timestamp;
		LD50_abar:MH_Update(missType,nil);

		if( oh_start and oh_active == true) then
			oh_start = timestamp;
			LD50_abar:OH_Update(missType,nil);
		end;
	end;
end
-- ----------------------------------------------------------------------------
-- Scope: Melee Damage Only
-- ----------------------------------------------------------------------------
function LD50_abar:ParseDamageEvent(event,timestamp,...)

	local what = "Hit";

  	damage,_, resisted, blocked, absorbed, critical, glancing, crushing = ...

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseDamageEvent:"..event..":"..damage..":",1,1,0);

	--
	-- Calculate the base damage of the attack
	--
	if(critical) then
		damage = damage * 0.50;
		what = "CRIT";
	end
	if(crushing) then
		damage = damage * 0.75;
		what = "Crush";
	end
	if(glancing) then
                -- a 15% damage reduction with all Glancing Blows against level 62 mobs,
		-- and a 35% damage reduction with all Glancing Blows against level 63 mobs.
		local p_level=UnitLevel("player");
		local m_level=UnitLevel("target");
		if(m_level == -1) then
			m_level = p_level + 3;
		end
		local d_level=m_level - p_level

		if(d_level == 2) then
			damage = damage * 1.15;
		elseif(d_level == 3) then
			damage = damage * 1.35;
		else
			damage = damage * 1.20;
		end
		--level=UnitLevel("target")
		--if(level == 72) then
		--	damage = damage * 1.15;
		--elseif(level == 73) then
		--	damage = damage * 1.35;
		--elseif(level == -1) then
		--	damage = damage * 1.35;
		--else
		--	damage = damage * 1.20;
		--end
		what = "Glance";
	end
	if(blocked) then
		damage = damage + blocked;
		what = "Block";
	end
	if(resisted) then
		damage = damage + resisted;
		what = "Resisted";
	end
	if(absorbed) then
		damage = damage + absorbed;
		what = "Absorbed";
	end

        self:MeleeSwing(damage,timestamp,what)

	-- Confirm this is melee
	swingmode =0;
end
-- ----------------------------------------------------------------------------
-- Scope: Spell/Range Damage Only
-- devastate Heroic Strike alll come through here.
-- I guess the real question is can this do anything other than reset the 
-- main hand.
-- ----------------------------------------------------------------------------
function LD50_abar:ParseSpellcastDamage(event,timestamp,...)

	local what;

	spellId,spell,spellSchool,   damage,_,resisted,blocked,absorbed,critical,glancing,crushing = ...

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastDamage:"..spell..":"..damage..":"..spell,1,1,0);

	if((bh_rangedspells[spell] == true) or
	   (mh_resetspells[spell]  == true) or
           (bh_resetspells[spell]  == true) ) then
		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastDamage:"..spell..":"..damage..":"..spell,1,1,0);
	else
		return;
	end

	what = spell;
	
	--
	-- While I LOVe all this code it turns out most spells fire
	-- a couple of events. THe only spell I know I need to 
	-- catch here is slam. The rest get caught by ParseSpellcastSuccess
	--
	if((spell == "Slam") or
           (bh_rangedspells[spell] == true)) then

		--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastDamage:"..spell..":"..damage,1,1,0);

		mh_start = timestamp;
		LD50_abar:MH_Update(spell,nil);

		if(oh_start and oh_active == true) then
			oh_start = timestamp;
			LD50_abar:OH_Update(spell,nil);
		end;
		return;
	else
		return;
	end;

	--
	-- Calculate the base damage of the attack
	--
	if(critical) then
		damage = damage * 0.50;
		what = "CRIT";
	end
	if(crushing) then
		damage = damage * 0.75;
		what = "Crush";
	end
	if(glancing) then
                -- a 15% damage reduction with all Glancing Blows against level 62 mobs,
		-- and a 35% damage reduction with all Glancing Blows against level 63 mobs.
		local p_level=UnitLevel("player");
		local m_level=UnitLevel("target");
		if(m_level == -1) then
			m_level = p_level + 3;
		end
		local d_level=m_level - p_level

		if(d_level == 2) then
			damage = damage * 1.15;
		elseif(d_level == 3) then
			damage = damage * 1.35;
		else
			damage = damage * 1.20;
		end

		--level=UnitLevel("target")
		--if(level == 72) then
		--	damage = damage * 1.15;
		--elseif(level == 73) then
		--	damage = damage * 1.35;
		--elseif(level == -1) then
		--	damage = damage * 1.35;
		--else
		--	damage = damage * 1.20;
		--end
		what = "Glance";
	end
	if(blocked) then
		damage = damage + blocked;
		what = "Block";
	end
	if(resisted) then
		damage = damage + resisted;
		what = "Resisted";
	end
	if(absorbed) then
		damage = damage + absorbed;
		what = "Absorbed";
	end

        self:MeleeSwing(damage,timestamp,what)

	if(event == "RANGE_MISSED") then
		swingmode =1;
	end;
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar:ParseSpellcastSuccess(event,timestamp,...)

	local spellId,spell,spellSchool = ...
	local name,rank,_,_,_,_,castTime,_,_ = GetSpellInfo(spellId);

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseSpellcastSuccess:"..spell..":"..castTime,1,1,0);

	--
	-- Saftey Check
	--
	if(in_combat == false) then
		return;
	end
	--
	-- First we have to search for on next attack speels since they have no 
        -- cast time.
	--
	--if (swingmode == nil) then
	--	return;
	--end
	--
	-- I hate this mess not sure what to do to clean it up yet.
	--
--	if(bh_positionspells[spell]) then
--		mh_start = timestamp;
--		LD50_abar:MH_Update(spell,nil);
--
--		if(oh_start ~= nil and oh_active == true) then
--			oh_start = timestamp;
--			LD50_abar:OH_Update(spell,nil);
--		end
--		return;
--	end;

	if (mh_resetspells[spell]) then
		mh_start = timestamp;
		LD50_abar:MH_Update(spell,nil);
		return;
	elseif (bh_resetspells[spell]) then
		mh_start = timestamp;
		LD50_abar:MH_Update(spell,nil);

		if(oh_start ~= nil and oh_active == true) then
			oh_start = timestamp;
			LD50_abar:OH_Update(spell,nil);
		end
		return;

	elseif (spell == autoshotname) then
		self:Shoot(spell,timestamp);
		return;
	elseif (spell == autoshotwand) then
		self:Shoot(spell,timestamp);
		return;
	end

	-- 
	-- Base idea is if it was an instant spell then it really can't reset 
	-- a swing timer. This is a General code area so it should work for
	-- al the other stuff we don't really pay attention to.
	-- 
	if(castTime == 0) then
		return
	end

	if(spell_cast == spell) then
		spell_cast=nil;

		mh_start = timestamp;
		LD50_abar:MH_Update(missType,nil);

		if(oh_start and oh_active == true) then
			oh_start = timestamp;
			LD50_abar:OH_Update(missType,nil);
		end;
	end;
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
function LD50_abar.ParseParryEvent(event,timestamp,...)

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:ParseParryEvent",1,1,0);

	if(mh_start ~= nill) then
		local temp = mh_speed -(timestamp - mh_start);
		temp = temp / 2.0;
		if(temp < 0.0) then
			temp = 0.0;
		end
		--if(info ~= nil) then
		--	DEFAULT_CHAT_FRAME:AddMessage("Info:"..info.message..":"..mh_speed..":"..mh_start..":"..temp,1,1,0);
		--else
		--	DEFAULT_CHAT_FRAME:AddMessage("Info:nil:"..mh_speed..":"..mh_start..":"..temp,1,1,0);
		--end
		mh_start = mh_start - temp;
	end
	mh_event:SetText("Parry");
end
-- ----------------------------------------------------------------------------
-- ----------------------------------------------------------------------------
-- Utility Functions
-- ----------------------------------------------------------------------------
-- 
-- ----------------------------------------------------------------------------
function LD50_abar:MeleeSwing(dmg,timestamp,what)

	local mh_reset,oh_reset

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:MeleeSwing"..":"..what..":"..timestamp,1,1,0);

	mh_reset=false;
	oh_reset=false;

	if(mh_extra ==true) then
		mh_extra = false;

		mh_start = timestamp;
		LD50_abar:MH_Update(what,nil)
		return;
	end

--	if(bh_rangedspells[spell]) then
--		--mh_start = GetTime()
--		mh_start = nil
--		oh_start = nil
--		mh_bar:SetValue(0)
--		oh_bar:SetValue(0)
--		LD50_abar:MH_Update(what,nil)
--		return;
--	end

	_,l_oh_speed = UnitAttackSpeed('player')

	-- somehow once every now and then this error occurs on a first swing.
	if(oh_speed == nil) then
		oh_speed=l_oh_speed;
	end

	if(swingmode == 1  or l_oh_speed == nil) then
		mh_start  = timestamp;
		oh_active = false;
		mh_reset  = true;
	else
		-- were dual wielding
		if(mh_start == nil) then
			mh_start = 0;
		end
		if(oh_start == nil) then
			oh_start = 0;
		end
		local spent = timestamp - mh_start
		local mh_perc = spent / mh_speed
		
		local spent = timestamp - oh_start
		local oh_perc = spent / oh_speed
		local mh_perc_dmg = 0.0;
		local oh_perc_dmg = 0.0;
		if(dmg == 0) then
			-- was a miss
			if(mh_perc > oh_perc) then
				mh_start = timestamp;
				mh_reset = true;
			else
				oh_start = timestamp;
				oh_reset = true;
			end				
		else
			-- was a hit
			if(dmg > mh_avg) then
				mh_perc_dmg = 1.0-((dmg/mh_avg)-math.floor(dmg/mh_avg)); 
			else
				mh_perc_dmg = dmg/mh_avg;
			end 
			if(dmg > oh_avg) then
				oh_perc_dmg = 1.0-((dmg/oh_avg)-math.floor(dmg/oh_avg)); 
			else
				oh_perc_dmg = dmg/oh_avg;
			end 
			local mh_tot = mh_perc_dmg + mh_perc;
			local oh_tot = oh_perc_dmg + oh_perc;

			--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:MeleeSwing:"..mh_perc_dmg.."+"..mh_perc.." OH "..oh_perc_dmg.."+"..oh_perc,1,1,0);
				
			if(mh_tot > oh_tot) then
				mh_start = timestamp;
				mh_reset = true;
			else
				oh_start = timestamp;
				oh_reset = true;
			end				
		end
	end
	
	if(mh_reset == true) then
		LD50_abar:MH_Update(what,nil);
	end
	if(oh_reset == true) then
		LD50_abar:OH_Update(what,nil);
	end
end
-- ----------------------------------------------------------------------------
-- - Internal Interface
-- ----------------------------------------------------------------------------
-- Description: This is for ranged weapons shooting.
-- ----------------------------------------------------------------------------
function LD50_abar:Shoot(what,timestamp)
	--mh_start = GetTime() + cli_to_srv;
	mh_start = timestamp;
	swingmode=1;
	LD50_abar:MH_Update(what,nil);
	oh_start  = nil;
	oh_bar:SetValue(0);
	LD50_abar:OH_Update(what,nil)
end
-- ----------------------------------------------------------------------------
-- Update for an Main-Hand Hit.
-- Arguments:
--      what       - Text to store into mh_text
--      cus_speed  - Overide the players weapin speeds for spells.
-- ----------------------------------------------------------------------------
function LD50_abar:MH_Update(what,cus_speed)

	local mh_min;
	local mh_max;

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:MH_Update:"..(in_combat and "true" or "false"),1,1,0);

	-- This here as a sanity check/cleanup
	if(swingmode == nil) then
		if(CheckInteractDistance("target", 3)) then
			swingmode = 0;
		else
			swingmode = 1;
		end
	end

	if(cus_speed == nil) then
		if(swingmode == 1) then
			mh_speed,mh_min,mh_max,_,_,_ = UnitRangedDamage("player");
			if(mh_speed < 0.001) then
				mh_speed,_ = UnitAttackSpeed('player');
			        mh_min,mh_max,_,_,_,_,_ = UnitDamage("player");
			end
		else
			mh_speed,_ = UnitAttackSpeed('player');
		        mh_min,mh_max,_,_,_,_,_ = UnitDamage("player");
		end
	else
		mh_speed = cus_speed;
	        mh_min,mh_max,_,_,_,_,_ = UnitDamage("player");
	end
	--
	-- fairly sure there is a minimum speed for weapons
	--
	if(mh_speed < 0.001) then
		mh_speed = 0.001;
	end
	--
	-- Sound
	--
	--if((UnitMana("player") > 65) and oh_active == false) then
	--	PlaySoundFile("Sound\\Doodad\\BellTollAlliance.wav");
	--end

	if(db.profile.mh_duration) then
		mh_duration:SetText(('%.2f'):format(mh_speed));
	end;
	mh_event:SetText(what);
	mh_bar:SetValue(0);

	mh_avg=(mh_max+mh_min)/2.0;
	-- assume the world is a 30% reduction
	mh_avg = mh_avg * 0.70;

	perc = 1.5 / mh_speed;
	if(perc > 1.0) then
 		perc = 1.0;
	end;
	mh_gcd:SetWidth(db.profile.swingwidth*perc);

	_,_,latency = GetNetStats();
	local perc=(latency/1000)/mh_speed;
	if(perc > 1) then
		perc=1;
	end
	mh_lag:SetWidth(db.profile.swingwidth*perc);
end
-- ----------------------------------------------------------------------------
-- Update for an Off-Hand Hit.
-- ----------------------------------------------------------------------------
function LD50_abar:OH_Update(what,cus_speed)

	--DEFAULT_CHAT_FRAME:AddMessage("LD50_abar:OH_Update:"..what..":",1,1,0);

	-- this is outside so oh_speed ~= nil

	_,oh_speed = UnitAttackSpeed('player');

	if(cus_speed ~= nil and oh_speed ~= nil) then
		oh_speed = cus_speed;
	end

	if(oh_speed ~= nil and swingmode == 0) then
		local oh_max
		local oh_min

		oh_active = true;
		if(db.profile.oh_duration) then
			oh_duration:SetText(('%.2f'):format(oh_speed));
		end;
		oh_event:SetText(what);
		oh_bar:SetValue(0)

	        _,_,oh_min,oh_max,_,_,_ = UnitDamage("player");
		oh_avg=(oh_max+oh_min)/2.0;
		-- assume the world is a 30% reduction
		oh_avg = oh_avg * 0.70;

		perc = 1.5 / oh_speed;
		if(perc > 1.0) then
 			perc = 1.0;
		end;
		oh_gcd:SetWidth(db.profile.swingwidth*perc);

		_,_,latency = GetNetStats();
		local perc=(latency/1000)/oh_speed;
		if(perc > 1) then
			perc=1;
		end
		oh_lag:SetWidth(db.profile.swingwidth*perc);
	else
		oh_active = false;
		oh_start  = nil;
		oh_avg    = 0;

		mh_bar:SetHeight(db.profile.swingheight * 2)
		mh_gcd:SetHeight(db.profile.swingheight * 2)
		mh_lag:SetHeight(db.profile.swingheight * 2)
		oh_bar:Hide()
		oh_gcd:Hide()
		oh_lag:Hide()
		oh_remain:Hide()
		oh_event:Hide()
		oh_duration:Hide()
	end
end
-- ----------------------------------------------------------------------------
-- Description: When the user changess one of the look  - feel options
--              this funcction maps those changes to the screen.
-- ----------------------------------------------------------------------------
function LD50_abar:ApplySettings()
	if swingframe then
		--swingframe:ClearAllPoints()
		swingframe:SetPoint('BOTTOMLEFT', UIParent, 'BOTTOMLEFT', db.profile.x, db.profile.y)
		swingframe:SetHeight(db.profile.swingheight*2)
		swingframe:SetWidth(db.profile.swingwidth)

		swingframe:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16})
		swingframe:SetBackdropColor(unpack(db.profile.sf_color))
		--swingframe:SetColor(unpack(db.profile.sf_color))
		swingframe:SetAlpha(db.profile.alpha)
		swingframe:SetScale(db.profile.scale)

		swingframe_o:SetAlpha(1.0)
		swingframe_o:SetPoint('TOPLEFT'    , swingframe, 'TOPLEFT'    , 0, 0);
		swingframe_o:SetPoint('TOPRIGHT'   , swingframe, 'TOPRIGHT'   , 0, 0);
		swingframe_o:SetPoint('BOTTOMLEFT' , swingframe, 'BOTTOMLEFT' , 0, 0);
		swingframe_o:SetPoint('BOTTOMRIGHT', swingframe, 'BOTTOMRIGHT', 0, 0);

		--
		-- Main Hand
		--
		if(oh_active == false) then
			mh_bar:SetHeight(db.profile.swingheight*2)
		else
			mh_bar:SetHeight(db.profile.swingheight)
		end
		mh_bar:SetStatusBarTexture(sm:Fetch('statusbar', db.profile.texture))
		mh_bar:SetStatusBarColor(unpack(db.profile.mh_barcolor))
		mh_bar:SetMinMaxValues(0, 1)

		-- global cooldown
		if(db.profile.mh_gcd_toggle == true) then
			mh_gcd:Show()
		else
			mh_gcd:Hide()
		end
		if(oh_active == false) then
			mh_gcd:SetHeight(db.profile.swingheight*2)
		else
			mh_gcd:SetHeight(db.profile.swingheight)
		end
		mh_gcd:SetAlpha(db.profile.alpha)
		mh_gcd:SetStatusBarTexture(sm:Fetch('statusbar', db.profile.texture))
		mh_gcd:SetStatusBarColor(unpack(db.profile.mh_gcdcolor))
		mh_gcd:SetMinMaxValues(0, 1)
		mh_gcd:SetValue(1);

		-- Latency
		if(db.profile.mh_lag_toggle == true) then
			mh_lag:Show();
		else
			mh_lag:Hide();
		end;
		if(oh_active == false) then
			mh_lag:SetHeight(db.profile.swingheight*2);
		else
			mh_lag:SetHeight(db.profile.swingheight);
		end;
		mh_lag:SetAlpha(db.profile.alpha*0.5);
		mh_lag:SetStatusBarTexture(sm:Fetch('statusbar', db.profile.texture));
		mh_lag:SetStatusBarColor(unpack(db.profile.mh_lagcolor));
		mh_lag:SetMinMaxValues(0, 1);
		mh_lag:SetValue(1);

		-- mh_duration
		if(db.profile.mh_duration == true) then
			mh_duration:Show();
		else
			mh_duration:Hide();
		end;
		mh_duration:ClearAllPoints()
		if(db.profile.mh_dur_font_pos == "TOPCENTER") then
		        mh_duration:SetPoint('TOPLEFT' ,swingframe_o, 'TOPLEFT');
		    	mh_duration:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT');
		elseif(db.profile.mh_dur_font_pos == "BOTTOMCENTER") then
		        mh_duration:SetPoint('BOTTOMLEFT' ,swingframe_o, 'BOTTOMLEFT');
		    	mh_duration:SetPoint('BOTTOMRIGHT',swingframe_o, 'BOTTOMRIGHT');
		else
		        mh_duration:SetPoint(db.profile.mh_dur_font_pos,swingframe_o,db.profile.mh_dur_font_pos);
		end;
		just_pos = string.gsub(string.gsub(db.profile.mh_dur_font_pos, "TOP", ""), "BOTTOM", "");
		mh_duration:SetJustifyH(just_pos);
		mh_duration:SetFont(sm:Fetch('font', db.profile.mh_dur_font),db.profile.mh_dur_font_size  * db.profile.scale);
		mh_duration:SetShadowColor(unpack(db.profile.mh_dur_font_shadow));
		mh_duration:SetShadowOffset( 0.8, -0.8 );
		mh_duration:SetTextColor(unpack(db.profile.mh_dur_font_color));
		mh_duration:SetNonSpaceWrap(false);
		mh_duration:SetWidth(db.profile.swingwidth);

		-- mh_event
		if(db.profile.mh_event == true) then
			mh_event:Show();
		else
			mh_event:Hide();
		end;
		mh_event:ClearAllPoints()
		if(db.profile.mh_eve_font_pos == "TOPCENTER") then
		        mh_event:SetPoint('TOPLEFT' ,swingframe_o, 'TOPLEFT');
		    	mh_event:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT');
		elseif(db.profile.mh_eve_font_pos == "BOTTOMCENTER") then
		        mh_event:SetPoint('BOTTOMLEFT' ,swingframe_o, 'BOTTOMLEFT');
		    	mh_event:SetPoint('BOTTOMRIGHT',swingframe_o, 'BOTTOMRIGHT');
		else
		        mh_event:SetPoint(db.profile.mh_eve_font_pos,swingframe_o,db.profile.mh_eve_font_pos);
		end;
		just_pos = string.gsub(string.gsub(db.profile.mh_eve_font_pos, "TOP", ""), "BOTTOM", "");
		mh_event:SetJustifyH(just_pos)
		mh_event:SetFont(sm:Fetch('font', db.profile.mh_eve_font), db.profile.mh_eve_font_size * db.profile.scale)
		mh_event:SetShadowColor(unpack(db.profile.mh_eve_font_shadow));
		mh_event:SetShadowOffset( 0.8, -0.8 );
		mh_event:SetTextColor(unpack(db.profile.mh_eve_font_color));
		mh_event:SetNonSpaceWrap(false);
		mh_event:SetWidth(db.profile.swingwidth);

		-- mh_remain
		if db.profile.mh_remain then
			mh_remain:Show()
		else
			mh_remain:Hide()
		end
		mh_remain:ClearAllPoints()
		if(db.profile.mh_rem_font_pos == "TOPCENTER") then
		        mh_remain:SetPoint('TOPLEFT' ,swingframe_o, 'TOPLEFT');
		    	mh_remain:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT');
		elseif(db.profile.mh_rem_font_pos == "BOTTOMCENTER") then
		        mh_remain:SetPoint('BOTTOMLEFT' ,swingframe_o, 'BOTTOMLEFT');
		    	mh_remain:SetPoint('BOTTOMRIGHT',swingframe_o, 'BOTTOMRIGHT');
		else
		        mh_remain:SetPoint(db.profile.mh_rem_font_pos,swingframe_o,db.profile.mh_rem_font_pos);
		end;
		just_pos = string.gsub(string.gsub(db.profile.mh_rem_font_pos, "TOP", ""), "BOTTOM", "");
		mh_remain:SetJustifyH(just_pos);
		mh_remain:SetFont(sm:Fetch('font', db.profile.mh_rem_font), db.profile.mh_rem_font_size * db.profile.scale);
		mh_remain:SetShadowColor(unpack(db.profile.mh_rem_font_shadow));
		mh_remain:SetShadowOffset( 0.8, -0.8 );
		mh_remain:SetTextColor(unpack(db.profile.mh_rem_font_color));
		mh_remain:SetNonSpaceWrap(false);
		mh_remain:SetWidth(db.profile.swingwidth);
		--
		-- Off Hand
		--
		oh_bar:SetHeight(db.profile.swingheight)
		oh_bar:SetStatusBarTexture(sm:Fetch('statusbar', db.profile.texture))
		oh_bar:SetStatusBarColor(unpack(db.profile.oh_barcolor))
		oh_bar:SetMinMaxValues(0, 1)

		if(db.profile.oh_gcd_toggle) then
			oh_gcd:Show()
		else
			oh_gcd:Hide()
		end
		oh_gcd:SetHeight(db.profile.swingheight)
		oh_gcd:SetAlpha(db.profile.alpha*0.7)
		oh_gcd:SetStatusBarTexture(sm:Fetch('statusbar', db.profile.texture))
		oh_gcd:SetStatusBarColor(unpack(db.profile.oh_gcdcolor))
		oh_gcd:SetMinMaxValues(0, 1)
		oh_gcd:SetValue(1);

		if(db.profile.oh_lag_toggle == true) then
			oh_lag:Show();
		else
			oh_lag:Hide();
		end;
		oh_lag:SetHeight(db.profile.swingheight)
		oh_lag:SetAlpha(db.profile.alpha*0.5)
		oh_lag:SetStatusBarTexture(sm:Fetch('statusbar', db.profile.texture))
		oh_lag:SetStatusBarColor(unpack(db.profile.oh_lagcolor))
		oh_lag:SetMinMaxValues(0, 1)
		oh_lag:SetValue(1);

		-- oh_duration
		if(db.profile.oh_duration) then
			oh_duration:Show()
		else
			oh_duration:Hide()
		end
		oh_duration:ClearAllPoints()
		if(db.profile.oh_dur_font_pos == "TOPCENTER") then
		        oh_duration:SetPoint('TOPLEFT' ,swingframe_o, 'TOPLEFT');
		    	oh_duration:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT');
		elseif(db.profile.oh_dur_font_pos == "BOTTOMCENTER") then
		        oh_duration:SetPoint('BOTTOMLEFT' ,swingframe_o, 'BOTTOMLEFT');
		    	oh_duration:SetPoint('BOTTOMRIGHT',swingframe_o, 'BOTTOMRIGHT');
		else
		        oh_duration:SetPoint(db.profile.oh_dur_font_pos,swingframe_o,db.profile.oh_dur_font_pos);
		end;
		just_pos = string.gsub(string.gsub(db.profile.oh_dur_font_pos, "TOP", ""), "BOTTOM", "");
		oh_duration:SetJustifyH(just_pos);
		oh_duration:SetFont(sm:Fetch('font', db.profile.oh_dur_font), db.profile.oh_dur_font_size  * db.profile.scale)
		oh_duration:SetShadowColor(unpack(db.profile.oh_rem_font_shadow));
		oh_duration:SetShadowOffset( 0.8, -0.8 )
		oh_duration:SetTextColor(unpack(db.profile.oh_rem_font_color));
		oh_duration:SetNonSpaceWrap(false)
		oh_duration:SetWidth(db.profile.swingwidth)
		
		-- oh_event
		if db.profile.oh_event then
			oh_event:Show()
		else
			oh_event:Hide()
		end
		oh_event:ClearAllPoints()
		if(db.profile.oh_eve_font_pos == "TOPCENTER") then
		        oh_event:SetPoint('TOPLEFT' ,swingframe_o, 'TOPLEFT');
		    	oh_event:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT');
		elseif(db.profile.oh_eve_font_pos == "BOTTOMCENTER") then
		        oh_event:SetPoint('BOTTOMLEFT' ,swingframe_o, 'BOTTOMLEFT');
		    	oh_event:SetPoint('BOTTOMRIGHT',swingframe_o, 'BOTTOMRIGHT');
		else
		        oh_event:SetPoint(db.profile.oh_eve_font_pos,swingframe_o,db.profile.oh_eve_font_pos);
		end;
		just_pos = string.gsub(string.gsub(db.profile.oh_eve_font_pos, "TOP", ""), "BOTTOM", "");
		oh_event:SetJustifyH(just_pos);
		oh_event:SetFont(sm:Fetch('font', db.profile.oh_eve_font), db.profile.oh_eve_font_size * db.profile.scale);
		oh_event:SetShadowColor(unpack(db.profile.oh_eve_font_shadow));
		oh_event:SetShadowOffset( 0.8, -0.8 )
		oh_event:SetTextColor(unpack(db.profile.oh_eve_font_color));
		oh_event:SetNonSpaceWrap(false)
		oh_event:SetWidth(db.profile.swingwidth)

		-- oh_remain
		if db.profile.oh_remain then
			oh_remain:Show()
		else
			oh_remain:Hide()
		end
		oh_remain:ClearAllPoints()
		if(db.profile.oh_rem_font_pos == "TOPCENTER") then
		        oh_remain:SetPoint('TOPLEFT' ,swingframe_o, 'TOPLEFT');
		    	oh_remain:SetPoint('TOPRIGHT',swingframe_o, 'TOPRIGHT');
		elseif(db.profile.oh_rem_font_pos == "BOTTOMCENTER") then
		        oh_remain:SetPoint('BOTTOMLEFT' ,swingframe_o, 'BOTTOMLEFT');
		    	oh_remain:SetPoint('BOTTOMRIGHT',swingframe_o, 'BOTTOMRIGHT');
		else
		        oh_remain:SetPoint(db.profile.oh_rem_font_pos,swingframe_o,db.profile.oh_rem_font_pos);
		end;
		just_pos = string.gsub(string.gsub(db.profile.oh_rem_font_pos, "TOP", ""), "BOTTOM", "");
		oh_remain:SetJustifyH(just_pos);
		oh_remain:SetFont(sm:Fetch('font', db.profile.oh_rem_font), db.profile.oh_rem_font_size  * db.profile.scale);
		oh_remain:SetShadowColor(unpack(db.profile.oh_rem_font_shadow));
		oh_remain:SetShadowOffset( 0.8, -0.8 );
		oh_remain:SetTextColor(unpack(db.profile.oh_rem_font_color));
		oh_remain:SetNonSpaceWrap(false);
		oh_remain:SetWidth(db.profile.swingwidth);

		if(oh_active == false) then
			oh_bar:Hide();
			oh_gcd:Hide();
			oh_lag:Hide();
			oh_remain:Hide();
			oh_event:Hide();
			oh_duration:Hide();
		end
	end
end
-- ----------------------------------------------------------------------------
-- O P T I O N S
-- ----------------------------------------------------------------------------
-- 
-- ----------------------------------------------------------------------------
do
	local locked = true
	local function set(field, value)
		db.profile[field] = value
		LD50_abar.ApplySettings()
	end
	local function get(field)
		return db.profile[field]
	end
	local function setcolor(field, ...)
		db.profile[field] = {...}
		LD50_abar.ApplySettings()
	end
	local function getcolor(field)
		return unpack(db.profile[field])
	end
	local function nothing()
	end
	local function dragstart()
		swingframe:StartMoving()
	end
	local function dragstop()
		db.profile.x = swingframe:GetLeft()
		db.profile.y = swingframe:GetBottom()
		swingframe:StopMovingOrSizing()
	end
	
    --LD50_abar.options.args.LD50_abar
    options = {
	type = 'group',
	name = L["LD50_abar"],
	desc = L["LD50_abar"],
	order = 600,
	args = {
	    --[[toggle = {
		type = 'toggle',
		name = L["Enable"],
		desc = L["Enable"],
		order = 101,
		get = function()
		    return LD50_abar:OnDisable();
		end,
		set = function(v)
		    LD50_abar:OnEnable();
		end,
	    },]]
	    lock = {
		type = 'toggle',
		name = L["Lock"],
		desc = L["Toggle Cast Bar lock."],
		order = 100,
		get = function()
		    return locked
		end,
		set = function(v)
		    if v then
			swingframe.Hide = nil
			swingframe:EnableMouse(false)
			swingframe:SetScript('OnDragStart', nil)
			swingframe:SetScript('OnDragStop', nil)
		    else
			swingframe:Show()
			swingframe:EnableMouse(true)
			swingframe:SetScript('OnDragStart', dragstart)
			swingframe:SetScript('OnDragStop', dragstop)
			swingframe:SetAlpha(1)
			swingframe.Hide = nothing
		    end
		    locked = v
		end,
	    },
	    ooc_hiding = {
		type = 'toggle',
		name = L["OOC Hiding"],
		desc = L["Toggle visibility of the Swing Bar when out of combat."],
		order = 102,
		get = get,
 		set = set,
		passValue = 'ooc_hiding',
	    },
	    cb_hide = {
		type = 'toggle',
		name = L["Cast Bar Hiding"],
		desc = L["Toggle visibility of the Cast Bar when in combat."],
		order = 104,
		get = get,
 		set = set,
		passValue = 'cb_hide',
	    },
	    swingheight = {
		type = 'range',
		name = L["Height"],
		desc = L["Set the height of the swing timer bar."],
		order = 106,
		min = 1,
		max = 40,
		step = 1,
		get = get,
		set = set,
		passValue = 'swingheight',
	    },
	    swingwidth = {
		type = 'range',
		name = L["Width"],
		desc = L["Set the width of the swing timer bar."],
		order = 108,
		min = 100,
		max = 600,
		step = 1,
		get = get,
		set = set,
		passValue = 'swingwidth',
	    },
	    scale = {
		type = 'range',
		name = L["Scale"],
		desc = L["Scale"],
		order = 110,
		min = 0.3,
		max = 4,
		step = 0.02,
		get = get,
		set = set,
		passValue = 'scale',
	    },
	    sf_color = {
	    	type = 'color',
		name = L["Backdrop Color"],
		desc = L["Set the backdrop color of the main frame."],
		order = 111,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'sf_color',
	    },
	    alpha = {
		type = 'range',
		name = L["Alpha"],
		desc = L["Set the alpha of the swing timer bar."],
		order = 112,
		min = 0.05,
		max = 1,
		step = 0.05,
		isPercent = true,
		get = get,
		set = set,
		passValue = 'alpha',
	    },
	    texture = {
		type = 'text',
		name = L["Texture"],
		desc = L["Set the Swing Bar Texture."],
		order = 120,
		validate = sm:List('statusbar'),
		get = get,
		set = set,
		passValue = 'texture',
	    },
	    x = {
		type = 'text',
		name = L["X"],
		desc = L["Set an exact X value for this bar's position."],
		order = 122,
		get = get,
		set = set,
		passValue = 'x',
		validate = function(v)
			return tonumber(v) and true
		    end,
		usage = L["Number"],
	    },
	    y = {
		type = 'text',
		name = L["Y"],
		desc = L["Set an exact Y value for this bar's position."],
		order = 124,
		get = get,
		set = set,
		passValue = 'y',
		validate = function(v)
			 return tonumber(v) and true
		    end,
		usage = L["Number"],
	    },

	    update = {
		type = 'range',
		name = L["Update"],
		desc = L["Set the fps of the updates of the swing bar."],
		order = 126,
		min = 1,
		max = 100,
		step = 1,
		isPercent = false,
		get = get,
		set = set,
		passValue = 'UpdateInterval',
	    },

	    --
	    -- Global Font Options
	    --
	    gf_header = {
	    	type = "header",
	    	name = L["Global Font Options"],
		order = 150,
	    },
	    font = {
		type = 'text',
		name = L["Font"],
		desc = L["Set the font used in the swing bar."],
		validate = sm:List('font'),
		order = 151,
		get = get,
		set = function(field, value)
		        db.profile[field] = value;
			db.profile["mh_dur_font"] = value;
			db.profile["mh_eve_font"] = value;
			db.profile["mh_rem_font"] = value;
			db.profile["oh_dur_font"] = value;
			db.profile["oh_eve_font"] = value;
			db.profile["oh_rem_font"] = value;
			LD50_abar.ApplySettings()
	            end,
		passValue = 'font',
	    },
	    font_size = {
		type = 'range',
		name = L["Font Size"],
		desc = L["Font Size"],
		order = 152,
		min = 8,
		max = 20,
		step = 1,
		get = get,
		set = function(field, value)
		        db.profile[field] = value;
			db.profile["mh_dur_font_size"] = value;
			db.profile["mh_eve_font_size"] = value;
			db.profile["mh_rem_font_size"] = value;
			db.profile["oh_dur_font_size"] = value;
			db.profile["oh_eve_font_size"] = value;
			db.profile["oh_rem_font_size"] = value;
			LD50_abar.ApplySettings()
	            end,
		passValue = 'font_size',
	    },

	    --
	    -- Main Hand Options
	    --
	    --mh_header = {
	    --	type = "header",
	    --	name = "Main Hand Options",
	    --	order = 200,
	    --},
	    mh_header = {
		type = 'group',
		desc = "Main Hand Options",
		name = "Main Hand Options",
		args = {


	    mh_barcolor = {
	    	type = 'color',
		name = L["Main Hand Bar Color"],
		desc = L["Set the color of the main hand swing timer bar."],
		order = 204,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_barcolor',
	    },

	    mh_gcd_toggle = {
		type = 'toggle',
		name = L["Main Hand GCD Bar"],
		desc = L["Toggle the display of the main hand GCD bar."],
		order = 208,
		get = get,
		set = set,
		passValue = 'mh_gcd_toggle',
	    },
	    mh_gcdcolor = {
		type = 'color',
		name = L["Main Hand GCD Color"],
		desc = L["Set the color of the main hand GCD timer bar."],
		order = 212,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_gcdcolor',
	    },

	    mh_lag_toggle = {
		type = 'toggle',
		name = L["Main Hand Latency Bar"],
		desc = L["Toggle the display of the main hand latency bar."],
		order = 216,
		get = get,
		set = set,
		passValue = 'mh_lag_toggle',
	    },
	    mh_lagcolor = {
		type = 'color',
		name = L["Main Hand Latency Bar Color"],
		desc = L["Set the color of the main hand latency swing timer bar."],
		order = 218,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_lagcolor',
	    },

	    mh_header_duration = {
	    	type = "header",
	    	name = "Duration Text Options",
	    	order = 220,
	    },

	    mh_duration = {
		type = 'toggle',
		name = L["Main Hand Duration Text"],
		desc = L["Toggle the display of text showing your total main hand swing time."],
		order = 221,
		get = get,
		set = set,
		passValue = 'mh_duration',
	    },
	    mh_dur_font_color = {
		type = 'color',
		name = L["Main Hand Duration Color"],
		desc = L["Set the color of the main hand duration font."],
		order = 222,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_dur_font_color',
	    },
		--mh_dur_typeface = {
			--	type = 'group',
			--	desc = "Main Hand Duration Typeface",
			--	name = "Main Hand Duration Typeface",
			--	args = {
	    mh_dur_font = {
		type = 'text',
		name = L["Font"],
		desc = L["Set the font used for the main hand duration."],
		order = 224,
		validate = sm:List('font'),
		get = get,
		set = set,
		passValue = 'mh_dur_font',
	    },
	    mh_dur_font_size = {
		type = 'range',
		name = L["Font Size"],
		desc = L["Font Size"],
		order = 226,
		min = 8,
		max = 20,
		step = 1,
		get = get,
		set = set,
		passValue = 'mh_dur_font_size',
	    },
	    mh_dur_font_pos = {
		type = 'text',
		name = L["Font Position"],
		desc = L["Font Position"],
		order = 228,
		get = get,
		set = set,
		passValue = 'mh_dur_font_pos',
		validate = {"TOPLEFT", "TOPCENTER", "TOPRIGHT","CENTER", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT"},
	    },
	    mh_dur_font_shadow = {
		type = 'color',
		name = L["Main Hand Duration Shadow Color"],
		desc = L["Set the color of the main hand duration font shadow."],
		order = 229,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_dur_font_shadow',
 	    },
		--	},
		--},

	    mh_header_event = {
	    	type = "header",
	    	name = "Event Text Options",
	    	order = 230,
	    },

	    mh_event = {
		type = 'toggle',
		name = L["Main Hand Event Text"],
		desc = L["Toggle the display of text showing your event."],
		order = 231,
		get = get,
		set = set,
		passValue = 'mh_event',
	    },
	    mh_eve_font_color = {
		type = 'color',
		name = L["Main Hand Event Color"],
		desc = L["Set the color of the main hand event font."],
		order = 232,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_eve_font_color',
	    },
	    mh_eve_font = {
		type = 'text',
		name = L["Font"],
		desc = L["Set the font used for the main hand event."],
		order = 234,
		validate = sm:List('font'),
		get = get,
		set = set,
		passValue = 'mh_eve_font',
	    },
	    mh_eve_font_size = {
		type = 'range',
		name = L["Font Size"],
		desc = L["Font Size"],
		order = 236,
		min = 8,
		max = 20,
		step = 1,
		get = get,
		set = set,
		passValue = 'mh_eve_font_size',
	    },
	    mh_eve_font_pos = {
		type = 'text',
		name = L["Font Position"],
		desc = L["Font Position"],
		order = 238,
		get = get,
		set = set,
		passValue = 'mh_eve_font_pos',
		validate = {"TOPLEFT", "TOPCENTER", "TOPRIGHT","CENTER", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT"},
	    },
	    mh_eve_font_shadow = {
		type = 'color',
		name = L["Main Hand Event Shadow Color"],
		desc = L["Set the color of the main hand event font shadow."],
		order = 239,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_eve_font_shadow',
 	    },

	    mh_header_remain = {
	    	type = "header",
	    	name = "Remaining Text Options",
	    	order = 240,
	    },


	    mh_remain = {
		type = 'toggle',
		name = L["Main Hand Remaining Text"],
		desc = L["Toggle the display of text showing the time remaining until your main hand can swing again."],
		get = get,
		set = set,
		passValue = 'mh_remain',
		order = 241,
	    },
	    mh_rem_font_color = {
		type = 'color',
		name = L["Main Hand Remaining Color"],
		desc = L["Set the color of the main hand remaining font."],
		order = 242,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_rem_font_color',
	    },
	    mh_rem_font = {
		type = 'text',
		name = L["Font"],
		desc = L["Set the font used for the main hand remaining."],
		order = 244,
		validate = sm:List('font'),
		get = get,
		set = set,
		passValue = 'mh_rem_font',
	    },
	    mh_rem_font_size = {
		type = 'range',
		name = L["Font Size"],
		desc = L["Font Size"],
		order = 246,
		min = 8,
		max = 20,
		step = 1,
		get = get,
		set = set,
		passValue = 'mh_rem_font_size',
	    },
	    mh_rem_font_pos = {
		type = 'text',
		name = L["Font Position"],
		desc = L["Font Position"],
		order = 248,
		get = get,
		set = set,
		passValue = 'mh_rem_font_pos',
		validate = {"TOPLEFT", "TOPCENTER", "TOPRIGHT","CENTER", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT"},
	    },
	    mh_rem_font_shadow = {
		type = 'color',
		name = L["Main Hand Remaining Shadow Color"],
		desc = L["Set the color of the main hand remaining font shadow."],
		order = 249,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'mh_rem_font_shadow',
 	    },

		},
	    },



	    --
	    -- Off Hand Options
 	    --
	    --oh_header = {
	    --	type = "header",
	    --	name = "Off Hand Options",
	    --	order = 299,
	    --},
	    oh_header = {
		type = 'group',
		desc = "Off Hand Options",
		name = "Off Hand Options",
		args = {


			oh_barcolor = {
				type = 'color',
				name = L["Off Hand Bar Color"],
				desc = L["Set the color of the off-hand swing timer bar."],
		hasAlpha = true,
				get = getcolor,
				set = setcolor,
				passValue = 'oh_barcolor',
				order = 300,
			},
			oh_gcd_toggle = {
				type = 'toggle',
				name = L["Off Hand GCD Bar"],
				desc = L["Toggle the display of the off-hand GCD bar."],
				get = get,
				set = set,
				passValue = 'oh_gcd_toggle',
				order = 301,
			},
			oh_gcdcolor = {
				type = 'color',
				name = L["Off Hand GCD Color"],
				desc = L["Set the color of the off-hand GCD timer bar."],
		hasAlpha = true,
				get = getcolor,
				set = setcolor,
				passValue = 'oh_gcdcolor',
				order = 302,
			},
			oh_lag_toggle = {
				type = 'toggle',
				name = L["Off Hand Latency Bar"],
				desc = L["Toggle the display of the off-hand latency bar."],
				get = get,
				set = set,
				passValue = 'oh_lag_toggle',
				order = 302,
			},
			oh_lagcolor = {
				type = 'color',
				name = L["Off Hand Latency Bar Color"],
				desc = L["Set the color of the off-hand latency swing timer bar."],
		hasAlpha = true,
				get = getcolor,
				set = setcolor,
				passValue = 'oh_lagcolor',
				order = 302,
			},

	    oh_header_duration = {
	    	type = "header",
	    	name = "Duration Text Options",
	    	order = 319,
	    },

	    oh_duration = {
		type = 'toggle',
		name = L["Off Hand Duration Text"],
		desc = L["Toggle the display of text showing your total off hand swing time."],
		get = get,
		set = set,
		passValue = 'oh_duration',
		order = 320,
	    },
	    oh_dur_font_color = {
		type = 'color',
		name = L["Off Hand Duration Color"],
		desc = L["Set the color of the off-hand duration font."],
		order = 322,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'oh_dur_font_color',
	    },
	    oh_dur_font = {
		type = 'text',
		name = L["Font"],
		desc = L["Set the font used for the off-hand duration."],
		order = 324,
		validate = sm:List('font'),
		get = get,
		set = set,
		passValue = 'oh_dur_font',
	    },
	    oh_dur_font_size = {
		type = 'range',
		name = L["Font Size"],
		desc = L["Font Size"],
		order = 326,
		min = 8,
		max = 20,
		step = 1,
		get = get,
		set = set,
		passValue = 'oh_dur_font_size',
	    },
	    oh_dur_font_pos = {
		type = 'text',
		name = L["Font Position"],
		desc = L["Font Position"],
		order = 328,
		get = get,
		set = set,
		passValue = 'oh_dur_font_pos',
		validate = {"TOPLEFT", "TOPCENTER", "TOPRIGHT","CENTER", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT"},
	    },
	    oh_dur_font_shadow = {
		type = 'color',
		name = L["Off Hand Duration Shadow Color"],
		desc = L["Set the color of the off-hand duration font shadow."],
		order = 329,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'oh_dur_font_shadow',
 	    },


	    oh_header_event = {
	    	type = "header",
	    	name = "Event Text Options",
	    	order = 330,
	    },

	    oh_event = {
		type = 'toggle',
		name = L["Off Hand Event Text"],
		desc = L["Toggle the display of text showing your event."],
		get = get,
		set = set,
		passValue = 'oh_event',
		order = 331,
	    },
	    oh_eve_font_color = {
		type = 'color',
		name = L["Off Hand Event Color"],
		desc = L["Set the color of the off-hand event font."],
		order = 332,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'oh_eve_font_color',
	    },
	    oh_eve_font = {
		type = 'text',
		name = L["Font"],
		desc = L["Set the font used for the off-hand event."],
		order = 334,
		validate = sm:List('font'),
		get = get,
		set = set,
		passValue = 'oh_eve_font',
	    },
	    oh_eve_font_size = {
		type = 'range',
		name = L["Font Size"],
		desc = L["Font Size"],
		order = 336,
		min = 8,
		max = 20,
		step = 1,
		get = get,
		set = set,
		passValue = 'oh_eve_font_size',
	    },
	    oh_eve_font_pos = {
		type = 'text',
		name = L["Font Position"],
		desc = L["Font Position"],
		order = 338,
		get = get,
		set = set,
		passValue = 'oh_eve_font_pos',
		validate = {"TOPLEFT", "TOPCENTER", "TOPRIGHT","CENTER", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT"},
	    },
	    oh_eve_font_shadow = {
		type = 'color',
		name = L["Off Hand Event Shadow Color"],
		desc = L["Set the color of the off-hand event font shadow."],
		order = 339,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'oh_eve_font_shadow',
 	    },


	    oh_header_remain = {
	    	type = "header",
	    	name = "Remaining Text Options",
	    	order = 340,
	    },

	    oh_remain = {
		type = 'toggle',
		name = L["Off Hand Remaining Text"],
		desc = L["Toggle the display of text showing the time remaining until your off hand can swing again."],
		get = get,
		set = set,
		passValue = 'oh_remain',
		order = 341,
	    },
	    oh_rem_font_color = {
		type = 'color',
		name = L["Off Hand Remaining Color"],
		desc = L["Set the color of the off-hand remaining font."],
		order = 342,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'oh_rem_font_color',
	    },
	    oh_rem_font = {
		type = 'text',
		name = L["Font"],
		desc = L["Set the font used for the off-hand remaining."],
		order = 344,
		validate = sm:List('font'),
		get = get,
		set = set,
		passValue = 'oh_rem_font',
	    },
	    oh_rem_font_size = {
		type = 'range',
		name = L["Font Size"],
		desc = L["Font Size"],
		order = 346,
		min = 8,
		max = 20,
		step = 1,
		get = get,
		set = set,
		passValue = 'oh_rem_font_size',
	    },
	    oh_rem_font_pos = {
		type = 'text',
		name = L["Font Position"],
		desc = L["Font Position"],
		order = 348,
		get = get,
		set = set,
		passValue = 'oh_rem_font_pos',
		validate = {"TOPLEFT", "TOPCENTER", "TOPRIGHT","CENTER", "BOTTOMLEFT", "BOTTOMCENTER", "BOTTOMRIGHT"},
	    },
	    oh_rem_font_shadow = {
		type = 'color',
		name = L["Off Hand Remaining Shadow Color"],
		desc = L["Set the color of the off-hand remaining font shadow."],
		order = 349,
		hasAlpha = true,
		get = getcolor,
		set = setcolor,
		passValue = 'oh_rem_font_shadow',
 	    },

		},
	    },


		},
	} 
	LD50_abar.options = options
end
-- ---------------------------------------------------------------------------
-- End
-- ---------------------------------------------------------------------------
