function TitanPanelKillsToLevelButton_OnLoad()
	this.registry = {
		id = "KillsToLevel",
		version = "1.2",
		menuText = "KillsToLevel",
		buttonTextFunction = "TitanPanelKillsToLevelButton_GetButtonText", 
		tooltipTitle = "KillsToLevel", 
		tooltipTextFunction = "TitanPanelKillsToLevelButton_GetTooltipText",
		icon = "Interface/HelpFrame/HotIssueIcon.blp",
		iconWidth = 16,
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			ShowCounter = false,
		}
	};
end

function TitanPanelKillsToLevelButton_GetButtonText()
	return string.format(TitanGetVar("KillsToLevel", "ShowLabelText") and
	                     KillsToLevelFrame.message_format or "%s",
	                     "|cffffffff"..KillsToLevelFrame.kills_to_level.."|r")
end

function TitanPanelKillsToLevelButton_KillsChanged()
	TitanPanelButton_UpdateButton("KillsToLevel")
end

function TitanPanelKillsToLevelButton_OnShow()
	KillsToLevelFrame:RegisterCallback(TitanPanelKillsToLevelButton_KillsChanged)
	if not TitanGetVar("KillsToLevel", "ShowCounter") then
		KillsToLevelFrame:SetHideState(true)
	end
end

function TitanPanelKillsToLevelButton_OnHide()
	-- Doesn't get renabled when the button is added back to the panel, how odd. . .
	-- KillsToLevelFrame:UnregisterCallback(TitanPanelKillsToLevelButton_KillsChanged)
	KillsToLevelFrame:SetHideState(false)
end

function TitanPanelKillsToLevelButton_GetTooltipText()
	local tooltip = "Expected XP/Kill average:\t|cffffffff"..math.floor(KillsToLevelFrame:AverageExperience()+0.5).."|r"
	
	if KillsToLevelFrame.rested_experience > 0 then
		tooltip = tooltip .. "\nExpected kills until not rested:\t|cffffffff"..
		          KillsToLevelFrame:KillsNeeded(nil, KillsToLevelFrame.rested_experience).."|r"
	end
	
	local count_error = KillsToLevelFrame.kills_to_level-KillsToLevelFrame:KillsNeeded()
	if count_error > 0 then
		tooltip = tooltip .. "\nExpected estimate error:\t|cff00ff00+"..count_error.."|r"
	elseif count_error < 0 then
		tooltip = tooltip .. "\nExpected estimate error:\t|cffff0000"..count_error.."|r"
	end
	
	return tooltip
end

function TitanPanelKillsToLevelButton_ToggleShowCounter()
	if TitanGetVar("KillsToLevel", "ShowCounter") then
		TitanSetVar("KillsToLevel", "ShowCounter", false)
		KillsToLevelFrame:SetHideState(true)
	else
		TitanSetVar("KillsToLevel", "ShowCounter", true)
		KillsToLevelFrame:SetHideState(false)
	end
	TitanPanelButton_UpdateButton("KillsToLevel");
end

function TitanPanelRightClickMenu_PrepareKillsToLevelMenu()
	UIDropDownMenu_AddButton({text="Show Counter",
	                          func=TitanPanelKillsToLevelButton_ToggleShowCounter,
	                          checked=TitanGetVar("KillsToLevel", "ShowCounter")})
	
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddToggleIcon("KillsToLevel");
	TitanPanelRightClickMenu_AddToggleLabelText("KillsToLevel");
	
	TitanPanelRightClickMenu_AddSpacer();
	TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, "KillsToLevel", TITAN_PANEL_MENU_FUNC_HIDE);
end
