local KillsToLevelPref = CreateFrame("Frame", "KillsToLevelPrefFrame", UIParent)

SlashCmdList["KillsToLevel"] = function () KillsToLevelPref:Show() end
SLASH_KillsToLevel1 = "/k2l"
SLASH_KillsToLevel2 = "/kills2level"
SLASH_KillsToLevel3 = "/killstolevel"

local ColourNames =
  {"Black",  {0,0,0},
   "White",  {1,1,1},
   "Red",    {1,0,0},
   "Orange", {1,.5,0},
   "Yellow", {1,1,0},
   "Green",  {0,1,0},
   "Teal",   {0,1,1},
   "Blue",   {0,0,1},
   "Magenta",{1,0,1},
   "Light Red",   {1,.5,.5},
   "Light Orange",{1,.75,.5},
   "Light Yellow",{1,1,.5},
   "Light Green", {.5,1,.5},
   "Light Teal",  {.5,1,1},
   "Light Blue",  {.5,.5,1},
   "Light Magenta", {1,.5,1},
   "Dark Red",    {.5,0,0},
   "Brown",       {.5,.25,0},
   "Dark Yellow", {.5,.5,0},
   "Dark Green",  {0,.5,0},
   "Dark Teal",   {0,.5,.5},
   "Dark Blue",   {0,0,.5},
   "Dark Magenta",{.5,0,.5}
  }

function ColourError(a, b)
  return (a[1]-b[1])*(a[1]-b[1])+
         (a[2]-b[2])*(a[2]-b[2])+
         (a[3]-b[3])*(a[3]-b[3])
end

KillsToLevelPref:SetBackdrop({bgFile = "Interface/TutorialFrame/TutorialFrameBackground",
                            edgeFile = "Interface/DialogFrame/UI-DialogBox-Border",
                            tile = true, tileSize = 16, edgeSize = 16,
                            insets = { left = 4, right = 4, top = 4, bottom = 4 }})
--KillsToLevelPref:SetBackdropColor(0.1,0.1,0.2)
KillsToLevelPref:ClearAllPoints()
KillsToLevelPref:SetFrameStrata("HIGH")
KillsToLevelPref:SetWidth(240)
KillsToLevelPref:SetHeight(400)
KillsToLevelPref:SetPoint("CENTER", 0, 0)

KillsToLevelPref.childnum = 1
KillsToLevelPref.y = 0

function KillsToLevelPref:AddHeading(text, size)
  if not text then text = "CHILD_"..self.childnum end
  if not size then size = 14 end
  
  local frame = self:CreateFontString(self:GetName().."_Child"..self.childnum)
  frame:ClearAllPoints()
  frame:SetPoint("TOPLEFT", 4, self.y-4)
  frame:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT", -4, self.y-size-4)
  frame:SetFont(STANDARD_TEXT_FONT, size)
  frame:SetTextColor(1,.8, .2)
  frame:SetText(text)
  self.y = self.y - size - 4
  self.childnum = self.childnum + 1
end

function KillsToLevelPref:AddPair(a, b)
  a:ClearAllPoints()
  a:SetPoint("TOPLEFT", 4, self.y)
  a:SetPoint("BOTTOMRIGHT", self, "TOPLEFT", 102, self.y-15)
  b:ClearAllPoints()
  b:SetPoint("TOPLEFT", 102, self.y)
  b:SetPoint("BOTTOMRIGHT", self, "TOPRIGHT", -4, self.y-15)
  self.y = self.y - 20
end

function KillsToLevelPref:AddOption(text, frame)
  local label = self:CreateFontString(self:GetName().."_Child"..self.childnum)
  self.childnum = self.childnum + 1
  label:SetFont(STANDARD_TEXT_FONT, 12)
  label:SetTextColor(1, 1, 1)
  label:SetText(text)
  self:AddPair(label, frame)
  return frame
end

function KillsToLevelPref:CreateColourEdit()
  local button = CreateFrame("Button", self:GetName().."_Child"..self.childnum, self, "OptionsButtonTemplate")
  button.true_text = true_text or "True"
  button.false_text = false_text or "False"
  
  button.index = 1
  
  button:SetText(ColourNames[1])
  button:SetTextColor(ColourNames[2][1], ColourNames[2][2], ColourNames[2][2])
  
  function button:SetColour(colour)
    local best, best_err = 1, ColourError(ColourNames[2], colour)
    self.index = 1
    while true do
      self.index = self.index + 2
      if not ColourNames[self.index] then
        self.index = best
        self:SetText(ColourNames[best])
        self:SetTextColor(ColourNames[best+1][1], ColourNames[best+1][2], ColourNames[best+1][3])
        return
      end
      local err = ColourError(ColourNames[self.index+1], colour)
      if err < best_err then
        best_err = err
        best = self.index
      end
    end
  end
  function button:GetColour()
    return ColourNames[self.index+1]
  end
  function button:OnClick()
    self.index = self.index + 2
    if not ColourNames[self.index] then self.index = 1 end
    self:SetText(ColourNames[self.index])
    self:SetTextColor(ColourNames[self.index+1][1], ColourNames[self.index+1][2], ColourNames[self.index+1][3])
  end
  
  button:SetScript("OnClick", button.OnClick)
  self.childnum = self.childnum + 1
  return button
end

function KillsToLevelPref:CreateButton(text, func, object)
  local button = CreateFrame("Button", self:GetName().."_Child"..self.childnum, self, "OptionsButtonTemplate")
  button:SetText(text or "Button")
  if func then
    button.func = func
    button.object = object
    function button:OnClick()
      self.func(self.object)
    end
    button:SetScript("OnClick", button.OnClick)
  end
  self.childnum = self.childnum + 1
  return button
end

function KillsToLevelPref:CreateToggle(true_text, false_text)
  local button = CreateFrame("Button", self:GetName().."_Child"..self.childnum, self, "OptionsButtonTemplate")
  button.true_text = true_text or "True"
  button.false_text = false_text or "False"
  
  button.state = true
  button:SetText(button.true_text)
  
  function button:SetState(state)
    self.state = state
    self:SetText(state and self.true_text or self.false_text)
  end
  function button:GetState()
    return self.state
  end
  function button:OnClick()
    self:SetState(not self:GetState())
  end
  
  button:SetScript("OnClick", button.OnClick)
  self.childnum = self.childnum + 1
  return button
end

function KillsToLevelPref:CreateEditBox()
  local editbox = CreateFrame("EditBox", self:GetName().."_Child"..self.childnum, self)
  editbox:SetFont(STANDARD_TEXT_FONT, 12)
  self.childnum = self.childnum + 1
  return editbox
end

function KillsToLevelPref:CreateSlider(low, high, interval)
  if not low then low = 1 end
  if not high then high = 100 end
  if not interval then interval = 1 end
  local slider = CreateFrame("Slider", self:GetName().."_Child"..self.childnum, self, "OptionsSliderTemplate")
  
  getglobal(slider:GetName().."Text"):Hide()
  getglobal(slider:GetName().."High"):Hide()
  getglobal(slider:GetName().."Low"):Hide()
  slider:SetMinMaxValues(low, high)
  slider:SetValue(math.floor(low+high+0.5))
  slider:SetValueStep(interval)
  self.childnum = self.childnum + 1
  return slider
end

function KillsToLevelPref:OnShow()
  local k = KillsToLevelFrame
  
  self.hidden:SetState(k:GetPreference("hidden"))
  self.locked:SetState(k:GetPreference("locked"))
  self.message_format:SetText(k:GetPreference("message_format"))
  self.scale:SetValue(k:GetPreference("scale"))
  self.speed:SetValue(1/k:GetPreference("animation_speed"))
  
  self.solo:SetValue(k:GetPreference("solo_halflife"))
  self.party:SetValue(k:GetPreference("party_halflife"))
  self.raid:SetValue(k:GetPreference("raid_halflife"))
  
  self.text_colour:SetColour(k:GetPreference("text_colour"))
  self.number_colour:SetColour(k:GetPreference("number_colour"))
  self.decrease_colour:SetColour(k:GetPreference("decrease_colour"))
  self.increase_colour:SetColour(k:GetPreference("increase_colour"))
  
  local scale = 100/math.max(k:GetPreference("fallback_spread")[1],
                             k:GetPreference("fallback_spread")[2],
                             k:GetPreference("fallback_spread")[3],
                             k:GetPreference("fallback_spread")[4],
                             k:GetPreference("fallback_spread")[5])
  
  self.level_offset1:SetValue(k:GetPreference("fallback_spread")[1]*scale)
  self.level_offset2:SetValue(k:GetPreference("fallback_spread")[2]*scale)
  self.level_offset3:SetValue(k:GetPreference("fallback_spread")[3]*scale)
  self.level_offset4:SetValue(k:GetPreference("fallback_spread")[4]*scale)
  self.level_offset5:SetValue(k:GetPreference("fallback_spread")[5]*scale)
end

function KillsToLevelPref:Apply()
  if not self.settings then
    self.settings = {}
    self.settings.fallback_spread = {}
  end
  
  self.settings.hidden = self.hidden:GetState()
  self.settings.locked = self.locked:GetState()
  
  self.settings.message_format = self.message_format:GetText()
  
  self.settings.scale = self.scale:GetValue()
  self.settings.animation_speed = 1/self.speed:GetValue()
  
  self.settings.solo_halflife = self.solo:GetValue()
  self.settings.party_halflife = self.party:GetValue()
  self.settings.raid_halflife = self.raid:GetValue()
  
  self.settings.text_colour = self.text_colour:GetColour()
  self.settings.number_colour = self.number_colour:GetColour()
  self.settings.decrease_colour = self.decrease_colour:GetColour()
  self.settings.increase_colour = self.increase_colour:GetColour()
  
  self.settings.fallback_spread[1] = self.level_offset1:GetValue()
  self.settings.fallback_spread[2] = self.level_offset2:GetValue()
  self.settings.fallback_spread[3] = self.level_offset3:GetValue()
  self.settings.fallback_spread[4] = self.level_offset4:GetValue()
  self.settings.fallback_spread[5] = self.level_offset5:GetValue()
  
  KillsToLevelFrame:ApplyPreferences(self.settings)
end

local p = KillsToLevelPref
p:SetScript("OnShow", p.OnShow)

p:AddHeading("KillsToLevel Preferences", 16)

p:AddHeading("Display")
p.hidden = p:AddOption("Hidden:", p:CreateToggle("Hidden", "Shown"))
p.locked = p:AddOption("Locked:", p:CreateToggle("Locked", "Unlocked"))
p.message_format = p:AddOption("Text:", p:CreateEditBox())
p.scale = p:AddOption("Scale:", p:CreateSlider(0.5, 2.0, .1))
p.speed = p:AddOption("Speed:", p:CreateSlider(0.2, 5.0, .1))

p:AddHeading("Colours")
p.text_colour = p:AddOption("Text:", p:CreateColourEdit())
p.number_colour = p:AddOption("Number:", p:CreateColourEdit())
p.decrease_colour = p:AddOption("Shrink:", p:CreateColourEdit())
p.increase_colour = p:AddOption("Grow:", p:CreateColourEdit())

p:AddHeading("Experience Halflife")
p.solo = p:AddOption("Solo:", p:CreateSlider(30, 30*60, 30))
p.party = p:AddOption("Party:", p:CreateSlider(30, 30*60, 30))
p.raid = p:AddOption("Raid:", p:CreateSlider(30, 30*60, 30))

p:AddHeading("Fallback Monster Levels")
p.level_offset1 = p:AddOption("Party Mean -2", p:CreateSlider())
p.level_offset2 = p:AddOption("Party Mean -1", p:CreateSlider())
p.level_offset3 = p:AddOption("Party Mean +0", p:CreateSlider())
p.level_offset4 = p:AddOption("Party Mean +1", p:CreateSlider())
p.level_offset5 = p:AddOption("Party Mean +2", p:CreateSlider())

p:AddPair(p:CreateButton("Close", p.Hide, p), p:CreateButton("Apply", p.Apply, p))

p:SetHeight(-p.y+4)
p:Hide()
