﻿
-- module setup
local me = { name = "win"}
local mod = thismod
mod[me.name] = me

me.myconsole = 
{
	data = "begin",
}

me.onload = function()
	
	me.createframe()
	
end

me.locallist = { }

me.begin = function()
	
	me.locallist = { }
	
	for key, value in pairs(mod.main.data) do
		
		table.insert(me.locallist, { name = key, data = value } )
		
	end
	
	me.frame.scroll:redraw()
	
	me.frame:Show()
	
end

me.memsorter = function(a, b)
	
	return a.data.total.memory > b.data.total.memory
	
end

me.timesorter = function(a, b)
	
	return a.data.total.time > b.data.total.time
	
end

me.sortmemory = function()
	
	table.sort(me.locallist, me.memsorter)
	me.frame.scroll:redraw()
	
end

me.sorttime = function()
	
	table.sort(me.locallist, me.timesorter)
	me.frame.scroll:redraw()	
	
end

me.createframe = function()
	
	-- 1) The frame itself
	me.frame = mod.gui.createframe(nil, 550, 500, mod.helpmenu.background.frame)
	me.frame:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	me.frame:Hide()
	
	-- 2) Scrolling frame list on the left
	me.frame.scroll = mod.framelist.createnew(me.frame, 450, 25, 50, 2.5, me.newframecallback, me.countcallback, me.drawitemcallback, me.clickitemcallback)
	me.frame.scroll:SetPoint("TOPLEFT", me.frame, "TOPLEFT", mod.gui.border, -mod.gui.border - 20)
	
	-- 3) close Button top right
	local button = CreateFrame("Button", nil, me.frame)
	
	-- size
	button:SetHeight(25)
	button:SetWidth(25)
	
	button:SetNormalTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
	button:GetNormalTexture():SetTexCoord(0.175, 0.825, 0.175, 0.825)
	
	button:SetPushedTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Up")
	button:GetPushedTexture():SetTexCoord(0.175, 0.825, 0.175, 0.825)
	
	button:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	button:GetHighlightTexture():SetBlendMode("ADD")
	
	-- location (top right)
	button:SetPoint("TOPRIGHT", me.frame, -mod.gui.border, -mod.gui.border)
	
	-- click handlers:
	button:SetScript("OnMouseDown", function() me.frame:Hide() end)
	
	-- add to frame
	me.frame.close = button
	
	-- 3) Sort by Memory
	button = mod.gui.createbutton(me.frame, 165, 30, mod.helpmenu.background.button, 18)
	me.frame.memory = button
	button:SetPoint("TOPRIGHT", -30, -5)
	button:SetText("Sort by Memory")
	button:SetScript("OnMouseDown", me.sortmemory)
	
	-- 4) Sort by Time
	button = mod.gui.createbutton(me.frame, 165, 30, mod.helpmenu.background.button, 18)
	me.frame.time = button
	button:SetPoint("TOPRIGHT", -205, -5)
	button:SetText("Sort by Time")
	button:SetScript("OnMouseDown", me.sorttime)
		
	-- 3) Text on the middle / right
	me.frame.text = mod.gui.createfontstring(me.frame, 16, true)
	me.frame.text:SetPoint("TOPRIGHT", -10, -40)
	me.frame.text:SetJustifyH("LEFT")
	me.frame.text:SetText("Click on an item in the list")

end



me.newframecallback = function(parent)
	
	local frame = mod.gui.createframe(parent, 150, 30, mod.helpmenu.background.frame)
	
	frame.text = mod.gui.createfontstring(frame, 16, true)
	frame.text:SetPoint("TOPLEFT", mod.gui.border, -mod.gui.border)
	frame.text:SetJustifyH("LEFT")
	
	return frame
	
end

me.countcallback = function()
	
	return #me.locallist
	
end

me.drawitemcallback = function(frame, index)
	
	frame.text:SetText(me.locallist[index].name)
	
end

me.clickitemcallback = function(index)
	

	me.frame.text:SetText(me.getsummary(me.locallist[index]))
	
end

me.getsummary = function(item)
	
	local data = item.data
		
	-- header
	local text = string.format("\n\n|cffff00ff%s|r\n\nUnits are KB for memory and ms for time.\n\n", item.name)
	
	text = text .. string.format("|cffffff00OnUpdates:|r\nTime = %s, Memory = %s\n\n", me.formatfraction(data.onupdate.time), data.onupdate.memory)
	text = text .. string.format("|cffffff00Events:|r\nTime = %s, Memory = %s\n\n", me.formatfraction(data.onevent.time), data.onevent.memory)
	text = text .. string.format("|cffff0000Total:|r\nTime = %s, Memory = %s\n\n", me.formatfraction(data.total.time), data.total.memory)
	
	return text
end

me.formatfraction = function(number)
	
	if number < 1 then
		return tostring(math.floor(0.5 + number * 1000) / 1000)
		
	elseif number < 10 then
		return tostring(math.floor(0.5 + number * 100) / 100)
		
	elseif number < 100 then
		return tostring(math.floor(0.5 + number * 10) / 10)
	
	else
		return tostring(math.floor(0.5 + number))
	end
	
end