﻿
-- this isn't a module per se, just a list of constants that name the mod. We bundle them together so that the rest of the code has no explicit references to its own name, making it easy to copy the bits we like for other mods!

-- module setup
local me = { name = "global"}
local mod = thismod
mod[me.name] = me

	me.slash = 
	{
		short = "/kpm2",
		medium = "/klhpm2",
		long = "/kpm",
	}
	
	me.addonname = "KLHPerformanceMonitor2"
	me.abbreviation = "KPM2"
	me.addonmessageprefix = "KLHPM"
	me.printheader = "|cff88ff00KPM2 |r"

	-- this gives the name of the variable. Make sure it matches the "## SavedVariables: " line in the .toc.
	me.savedvariables = "klhpmsavedvariables2"
	
	me.webpage = "http://wow-en.curse-gaming.com/downloads/details/4218/"
	
	me.trace = 
	{
		info = false,		
		warning = false,
		error = true,
	}
	
	-- Mod Version
	me.release = 5		-- 5.1 build 8
	me.revision = 2
	me.build = 9

--[[ 
mod.print(message, [chatframeindex, noheader])

Prints out <message> to chat.
To print to ChatFrame3, set <chatframeindex> to 3, etc.
Adds a header identifying the mod to the message, unless <noheader> is non-nil.
]]
mod.print = function(message, noheader, chatframeindex)

	-- Get a Frame to write to
	local chatframe

	if chatframeindex == nil then
		chatframe = DEFAULT_CHAT_FRAME
		
	else
		chatframe = getglobal("ChatFrame" .. chatframeindex)
		
		if chatframe == nil then
			chatframe = DEFAULT_CHAT_FRAME
		end
	end

	-- touch up message
	message = message or "<nil>"
		
	if noheader == nil then
		message = me.printheader .. message 
	end
	
	-- write
	chatframe:AddMessage(message)

end

--[[
This is a protection wrapper on the string.format method, that will print out a rough version of the string if it is not formatted correctly.
]]
mod.format = function(message, ...)
	
	local success, result = pcall(string.format, message, ...)
	
	if success then
		return result
	end
	
	local result = "|cffff0000String.Format Failed!"
	
	
	
end