--[[ 
Kharthus's Hunter Timers by Kharthus of Deathwing

v2.3.2
	- German updates
	- Spanish updates
	- French updates
v2.3.1
	- German updates
	- Added Berserker's Call
	- Added Kill Command
	- Added Screech
v2.3
	- Updated for 2.4 patch
	- Major rewrite due to combat log changes
v2.2.1
	- Fixed Snake Trap trigger
	- Spanish updates
v2.2
	- Updates for 2.3 patch
	- Added Madness of the Betrayer
	- Added Stoneform
	- Added War Stomp
	- Added Arcane Torrent
	- Added Band of the Eternal Champion
	- Added Aimed Shot healing debuff
v2.1.5
	- Fixed German translation
v2.1.4
	- Updated German translations
	- Fixed stacked procs from Ashtongue Talisman of Swiftness
v2.1.3
	- Updated toc for 2.2 patch
v2.1.2
	- Added Beast Lord set bonus
v2.1.1
	- Added Skyguard Silver Cross
	- Fixed stacked Haste procs from Dragonspine Trophy
v2.1
	- French/German updates
	- Timers should grow up/down correctly
	- Added Talon of Al'ar
	- Added Darkmoon Card: Wrath
	- Added Darkmoon Card: Madness
	- Added pet frenzy
v2.0
	- Spanish updates
	- Added Desolation set proc
	- Added Thundering Skyfire Diamond
	- Added Tsunami Talisman
	- Added Dragonspine Trophy
	- Added Ashtongue Talisman of Swiftness
	- Corrected Snake Trap trigger

]]

local checkForSpell = 0;
local trapTimer = nil;
local trapRank = 1;
local khtAutoShot = false;
local khtImpConc = false;
local khtRapidFire = false;
local khtQuickShots = false;
local khtPetIntim = false;
local khtIntimidation = false;
local khtWingClip = false;
local khtImpWing = false;
local khtFreezing = false;
local khtScatter = false;
local khtWyvern = false;
local khtFearBeast = false;
local khtExposeWeakness = false;
local khtHuntersMark = false;
local khtPrimalBlessing = false;
local khtEntrapment = false;
local khtJomGabbar = false;
local khtFerocious = false;
local khtTactician = false;
local khtConcBarrage = false;
local khtWrath = false;
local khtPetFrenzy = false;
local khtHaste = false;
local khtSkyguard = false;
local khtBeastLord = false;
local khtAshtongue = false;
local khtMadness = false;
local khtChampion = false;
local khtAimedShot = false;
local khtScreech = false;

local khtTimeLeft = nil;
local khtDebug = false;
local khtDebugBC = false;

function KHunterTimers_OnLoad()
	local playerClass, englishClass = UnitClass("player");
	if(englishClass ~= "HUNTER") then
		return;
	end
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
	this:RegisterEvent("PLAYER_ALIVE");
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
	this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
	this:RegisterEvent("CHAT_MSG_MONSTER_EMOTE");
	this:RegisterEvent("START_AUTOREPEAT_SPELL");
	this:RegisterEvent("STOP_AUTOREPEAT_SPELL");
	this:RegisterEvent("COMBAT_TEXT_UPDATE");

	this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");

	this:RegisterEvent("ADDON_ACTION_FORBIDDEN");
	this:RegisterEvent("ADDON_ACTION_BLOCKED");

--	this:RegisterAllEvents(); 
	
	tinsert(UISpecialFrames,"KHunterTimersOptions");
	
	if(DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage("Kharthus's Hunter Timers "..KHT_VERSION.." Loaded", 1, 0, 0 );
	end
	
	SlashCmdList["KHUNTERTIMERS"] = function (msg)
		KHunterTimers_SlashCmd(msg);
	end
	SLASH_KHUNTERTIMERS1 = "/khuntertimers";
	SLASH_KHUNTERTIMERS2 = "/kht";
	
end

function KHunterTimers_SlashCmd(msg)
	if( msg == "showvars" ) then
		if( khtExposeWeakness ) then
			DEFAULT_CHAT_FRAME:AddMessage("exposeweak", 1, 0, 0 );
		else
			DEFAULT_CHAT_FRAME:AddMessage("exposeweak "..KHT_OFF, 1, 0, 0 );
		end
		return;
	elseif( msg == "menu" ) then
		KHunterTimers_ShowOptions();
		return;
	elseif( msg == "reset" ) then
		for num = 1, 11, 1 do
			frame = getglobal("KHunterTimersStatus"..num);
			frame.endTime = 0;
		end
		KHunterTimers_ClearActiveSpells();
		return;
	elseif( msg == "clear all" ) then
		KHunterTimers_ResetOptions();
		DEFAULT_CHAT_FRAME:AddMessage("KHT options reset to defaults.", 1, 0, 0);
		for num = 1, 11, 1 do
			frame = getglobal("KHunterTimersStatus"..num);
			frame.endTime = 0;
		end
		KHunterTimers_ClearActiveSpells();
		return;
	elseif( msg == "debug" ) then
		if ( khtDebug ) then
			khtDebug = false;
			DEFAULT_CHAT_FRAME:AddMessage("KHT debugging mode disabled.", 1, 0, 0);
		else
			khtDebug = true;
			DEFAULT_CHAT_FRAME:AddMessage("KHT debugging mode enabled.", 1, 0, 0);
		end
		return;
	elseif( msg == "debugbc" ) then
		if ( khtDebugBC ) then
			khtDebugBC = false;
			DEFAULT_CHAT_FRAME:AddMessage("KHT Burning Crusade debugging mode disabled.", 1, 0, 0);
		else
			khtDebugBC = true;
			DEFAULT_CHAT_FRAME:AddMessage("KHT Burning Crusade debugging mode enabled.", 1, 0, 0);
		end
		return;
	elseif( msg == KHT_ON ) then
		if( KHTvars[KHT_ON] ) then
			DEFAULT_CHAT_FRAME:AddMessage("KHT already "..KHT_ON, 1, 0, 0);
			return;
		else
			KHTvars[KHT_ON] = true;
			DEFAULT_CHAT_FRAME:AddMessage("KHT "..KHT_ON, 1, 0, 0);
			return;
		end
	elseif( msg == KHT_OFF ) then
		if( KHTvars[KHT_ON] ) then
			KHTvars[KHT_ON] = false;
			DEFAULT_CHAT_FRAME:AddMessage("KHT "..KHT_OFF, 1, 0, 0);
			return;
		else
			DEFAULT_CHAT_FRAME:AddMessage("KHT not "..KHT_ON, 1, 0, 0);
			return;
		end
	elseif( string.find( msg, "setbgcolor" ) ) then
		for r, g, b, a in string.gmatch( msg, "setcolor (%d+) (%d+) (%d+) (%d+)" ) do
			KHTvars["bg"].r = r/10;
			KHTvars["bg"].g = g/10;
			KHTvars["bg"].b = b/10;
			KHTvars["bg"].a = a/10;
			KHunterTimersFrame:SetBackdropColor( r/10, g/10, b/10, a/10 );
		end
		return;
	elseif( string.find(msg, "delay" ) ) then
		for ms in string.gmatch(msg, "delay (%d+)") do
			KHTvars["shotdelay"] = ms;
			DEFAULT_CHAT_FRAME:AddMessage("Shot delay set to "..ms.."ms");
		end
	elseif( string.find(msg, "scale" ) ) then
		for scale in string.gmatch( msg, "scale (%d+)" ) do
			if( (scale/100) < 0.1 ) then
				scale = 10;
			end
			scale = scale * UIParent:GetScale();
			KHTvars["scale"] = scale/100;
		end
		KHunterTimersFrame:SetScale( KHTvars["scale"] );
		for i=1, 11 do
			getglobal("KHunterTimersStatus"..i):SetScale( KHTvars["scale"] );
		end
	elseif( string.find(msg, "down") ) then
		KHTvars["down"] = true;
		KHunterTimers_SetSettings();
		DEFAULT_CHAT_FRAME:AddMessage("KHT: Growing down");
	elseif( string.find(msg, "up" ) ) then
		KHTvars["down"] = false;
		KHunterTimers_SetSettings();
		DEFAULT_CHAT_FRAME:AddMessage("KHT: Growing up");
	elseif( msg == "unlock" ) then
		KHTvars["locked"] = false;
		KHunterTimersAnchor:Show();
	elseif( msg == "lock" ) then
		KHTvars["locked"] = true;
		KHunterTimersAnchor:Hide();
	elseif( string.find(msg, "colorchange" ) ) then
		for on in string.gmatch(msg, "colorchange (%a+)") do
			if( on == KHT_ON ) then
				KHTvars["colorchange"] = true;
			elseif( on == KHT_OFF ) then
				KHTvars["colorchange"] = false;
			end
			if( on == KHT_ON) or ( on == KHT_OFF ) then
				DEFAULT_CHAT_FRAME:AddMessage( "KHT: Colorchange is: "..on);
			end
		end
	elseif( string.find( msg, "barcolor" ) ) then
		for r, g, b in string.gmatch(msg, "barcolor ([%d.]+) ([%d.]+) ([%d.]+)") do
			local red, green, blue = unpack( KHTvars["barstartcolor"] );
			KHTvars["barstartcolor"][1] = r;
			KHTvars["barstartcolor"][2] = g;
			KHTvars["barstartcolor"][3] = b;
			
			local rd, gd, bd = unpack( KHTvars["bardelta"] );
			red = rd + red;
			blue = bd + blue;
			green = gd + green;
			
			red = red - r;
			green = green - g;
			blue = blue - b;
			
			KHTvars["bardelta"][1] = red;
			KHTvars["bardelta"][2] = green;
			KHTvars["bardelta"][3] = blue;
			DEFAULT_CHAT_FRAME:AddMessage( "KHT: Barcolor set to: "..KHTColor(r, g, b)..r..", "..g..", "..b.."|r");
		end
	elseif( string.find( msg, "barendcolor" ) ) then
		for red, green, blue in string.gmatch(msg, "barendcolor ([%d.]+) ([%d.]+) ([%d.]+)") do
			local r, g, b = unpack( KHTvars["barstartcolor"] );
			
			r = red - r;
			g = green - g;
			b = blue - b;
			
			KHTvars["bardelta"][1] = r;
			KHTvars["bardelta"][2] = g;
			KHTvars["bardelta"][3] = b;
			DEFAULT_CHAT_FRAME:AddMessage( "KHT: Barendcolor set to: "..KHTColor(red, green, blue)..red..", "..green..", "..blue.."|r");
		end
	elseif( string.find( msg, "flash" ) ) then
		for flash in string.gmatch( msg, "flash (%d+)" ) do
			flash = flash * 1;
			KHTvars["flash"] = flash;
			if( flash == 0 ) then
				DEFAULT_CHAT_FRAME:AddMessage("KHT: Bar flash "..KHT_OFF);
			else
				DEFAULT_CHAT_FRAME:AddMessage("KHT: Bar flash set to: "..flash.." seconds");
			end
		end
	elseif( string.find( msg, "step" ) ) then
		for step in string.gmatch( msg, "step ([%d.]+)" ) do
			KHTvars["step"] = step
			DEFAULT_CHAT_FRAME:AddMessage("KHT: Step set to: "..step);
		end
	elseif( msg == "resetpos" ) then
		KHunterTimersAnchor:ClearAllPoints();
		KHunterTimersAnchor:SetPoint("CENTER", "UIParent", "CENTER", 0, 0 );
	elseif( string.find( msg, "(%a+) (%d+)" ) ) then
		for cmd1, cmd2 in string.gmatch( msg, "(%a+) (%d+)" ) do
			--DEFAULT_CHAT_FRAME:AddMessage(cmd1.."-"..cmd2, 1, 0, 0);
			KHunterTimersFrame_add( cmd2, cmd1 );
		end
	elseif( msg == "status" ) then

		local statusstring = "";
		local statusstring1 = "";
		local statusstring2 = "";
		
		if( KHTvars[KHT_ON] ) then
			statusstring1 = KHT_ON;
		else
			statusstring1 = KHT_OFF;
		end
		DEFAULT_CHAT_FRAME:AddMessage(KHT_STATUS_STRINGS[1]);
		DEFAULT_CHAT_FRAME:AddMessage(format(KHT_STATUS_STRINGS[2], statusstring1));
		DEFAULT_CHAT_FRAME:AddMessage(format(KHT_STATUS_STRINGS[3], KHTvars["shotdelay"]));
		DEFAULT_CHAT_FRAME:AddMessage(format(KHT_STATUS_STRINGS[4], KHTvars["flash"], KHTvars["step"]));

		local r, g, b = unpack( KHTvars["barstartcolor"] );
		local rd, gd, bd = unpack( KHTvars["bardelta"] );
		statusstring1 = KHTColor(r,g,b)..r..", "..g..", "..b.."|r";
		statusstring2 = KHTColor(r+rd, g+gd, b+bd)..(r+rd)..", "..(b+bd)..", "..(g+gd).."|r";
		DEFAULT_CHAT_FRAME:AddMessage(format(KHT_STATUS_STRINGS[5], statusstring1, statusstring2));
		
		if( KHTvars["colorchange"] ) then
			statusstring1 = KHT_ON;
		else
			statusstring1 = KHT_OFF;
		end
		if( KHTvars["down"] ) then
			statusstring2 = "down";
		else
			statusstring2 = "up";
		end
		DEFAULT_CHAT_FRAME:AddMessage(format(KHT_STATUS_STRINGS[6], statusstring1, statusstring2));
		DEFAULT_CHAT_FRAME:AddMessage(format(KHT_STATUS_STRINGS[7], (KHTvars["scale"]/UIParent:GetScale()*100) ) );
	else
		for key,val in ipairs(KHT_SLASH_HELP) do
			DEFAULT_CHAT_FRAME:AddMessage(val, 1, 1, 0);
		end
	end
	
end

function KHunterTimersFrame_add( spellDuration, spellName, target, GUID )
	if( KHTvars["numBars"] < 0 ) then
		KHTvars["numBars"] = 0;
	end
	
	local allReadyActive = false;
	local bar;
	
	if( KHT_sfind( spellName, KHT_STING ) or string.find( spellName, KHT_CONC_SHOT ) ) then
		spellDuration = spellDuration + KHTvars["shotdelay"];
	end
	
	if( spellName == KHT_INTIM ) then
		--DEFAULT_CHAT_FRAME:AddMessage("Intim", 1, 1, 0 );
		if( khtPetIntim ) then
			--DEFAULT_CHAT_FRAME:AddMessage("Pet Intim", 1, 1, 0 );
			for num = 1, KHTvars["numBars"], 1 do
				local barframe = getglobal("KHunterTimersStatus"..num);
				--DEFAULT_CHAT_FRAME:AddMessage("Intim: "..textBar, 1, 1, 0 );
				if( string.find( barframe.spell, KHT_PET_INTIM ) ) then
					allReadyActive = true;
					bar = num;
					break;
				end
			end
		end
	elseif( string.find( spellName, KHT_PRIMED ) ) then
		if( trapTimer ) then
			for num = 1, KHTvars["numBars"], 1 do
				local barframe = getglobal("KHunterTimersStatus"..num);
				if( string.find( barframe.spell, KHT_PRIMED ) ) then
					allReadyActive = true;
					bar = num;
					break;
				end
			end
		end
	elseif( KHT_sfind( spellName, KHT_STING ) ) then
		for num = 1, KHTvars["numBars"] do
			local barframe = getglobal("KHunterTimersStatus"..num);
			if( KHT_sfind( barframe.spell, KHT_STING ) and ( barframe.GUID == GUID ) ) then
				allReadyActive = true;
				bar = num;
				break;
			end
		end
	elseif( KHT_sfind( spellName, KHT_HUNTERS_MARK ) ) then
		for num = 1, KHTvars["numBars"] do
			local barframe = getglobal("KHunterTimersStatus"..num);
			if( KHT_sfind( barframe.spell, KHT_HUNTERS_MARK ) ) then
				allReadyActive = true;
				bar = num;
				break;
			end
		end
	elseif( spellName == KHT_AUTO_SHOT ) and KHTvars["sticky"]  then
		if( KHunterTimersStatus1.spell == KHT_AUTO_SHOT ) then
			allReadyActive = true;
			bar = 1;
		else
			KHunterTimers_shift(1);
			allReadyActive = true;
			KHTvars["numBars"] = KHTvars["numBars"] + 1;
			bar = 1;
		end
	elseif( not string.find( spellName, KHT_FLARE ) ) then
		for num = 1, KHTvars["numBars"], 1 do
			local barframe = getglobal("KHunterTimersStatus"..num);
			if( barframe.spell == spellName ) and ( barframe.GUID == GUID ) then
				allReadyActive = true;
				bar = num;
				break;
			end
		end
	end
	
	local num = bar;
	if( allReadyActive ) then
		if( KHTvars["numBars"] == 0 ) then
			KHTvars["numBars"] = 1;
		end
	else
		if( KHTvars["numBars"] == 11 ) then
			return;
		end
		KHTvars["numBars"] = KHTvars["numBars"] + 1;
		num = KHTvars["numBars"];
	end
	
	local icon = getglobal("KHunterTimersStatus"..num.."Icon");
	local barframe = getglobal("KHunterTimersStatus"..num);
	local bar = getglobal("KHunterTimersStatus"..num.."Bar");
	local leftText = getglobal("KHunterTimersStatus"..num.."BarLeftText");
	local rightText = getglobal("KHunterTimersStatus"..num.."BarRightText");
	
	if( not barframe ) then
		--DEFAULT_CHAT_FRAME:AddMessage("WTFBBQ line 214");
		return;
	end
	local texture;
	if( spellName == KHT_IMP_CONC_SHORT ) then
		texture = KHTvars["textures"][KHT_CONC_SHOT];
	elseif( spellName == KHT_IMP_WC_SHORT ) then
		texture = KHTvars["textures"][KHT_WING_CLIP];
	elseif( string.find( spellName, KHT_TRAP ) ) then
		if( string.find( spellName, KHT_FREEZING_TRAP ) )then
			texture = KHTvars["textures"][KHT_FREEZING_TRAP]
		elseif( string.find( spellName, KHT_IMMO_TRAP ) ) then
			texture = KHTvars["textures"][KHT_IMMO_TRAP]
		elseif( string.find( spellName, KHT_FROST_TRAP ) ) then
			texture = KHTvars["textures"][KHT_FROST_TRAP]
		elseif( string.find( spellName, KHT_EXPL_TRAP ) ) then
			texture = KHTvars["textures"][KHT_EXPL_TRAP]
		elseif( string.find( spellName, KHT_SNAKE_TRAP ) ) then
			texture = KHTvars["textures"][KHT_SNAKE_TRAP]
		end
	elseif( string.find( spellName, KHT_PET_INTIM ) ) then
		texture = KHTvars["textures"][KHT_INTIM];
	elseif( spellName == KHT_AUTO_SHOT ) then
		texture = GetInventoryItemTexture("player", 18);
	else
		texture = KHTvars["textures"][spellName];
	end
	icon:SetTexture(texture);
	barframe.spell = spellName;
	barframe.texture = texture;
	barframe.target = target;
	barframe.GUID = GUID;
	barframe.startTime = GetTime();
	barframe.duration = spellDuration / 1000;
	barframe.endTime = barframe.startTime + barframe.duration;
	bar:SetMinMaxValues(barframe.startTime, barframe.endTime);
	bar:SetValue( barframe.endTime );
	if( KHTvars["append"] ) and (barframe.target) then
		leftText:SetText(KHTColor(unpack(KHTvars["skillcolor"]))..spellName.."|r - "..KHTColor(unpack(KHTvars["targetcolor"]))..barframe.target);
	else
		leftText:SetText(KHTColor(unpack(KHTvars["skillcolor"]))..spellName);
	end
	if( KHTvars["mili"] == 0 ) then
		rightText:SetFormattedText(KHTColor(unpack(KHTvars["timecolor"])).."%ds", barframe.duration);
	else
		rightText:SetFormattedText(KHTColor(unpack(KHTvars["timecolor"])).."%."..KHTvars["mili"].."f", barframe.duration);
	end
	barframe.channeling = true;
	barframe.fadeOut = false;
	KHunterTimersFrame:SetAlpha(KHTvars["overallalpha"]);
	KHT_SetHeight();
	if( not KHunterTimersFrame:IsVisible() ) then
		KHunterTimersFrame:Show();
	end
	local r, g, b, a = unpack( KHTvars["barstartcolor"] );
	bar:SetStatusBarColor(r, g, b, a );
	getglobal("KHunterTimersStatus"..num.."BGBar"):SetStatusBarColor(r, g, b, 0.25*a);
	barframe:SetAlpha(KHTvars["overallalpha"]);
	KHunterTimers_SetWidths();
	barframe:Show();
end

function KHunterTimers_SetWidths()	
	local largestwidth = 180;
	if( KHTvars["showtex"] ) then
		if( KHTvars["largetex"] ) and (KHTvars["barheight"] < 16 ) then
			largestwidth = largestwidth - 16;
		else
			largestwidth = largestwidth - KHTvars["barheight"];
		end
		if( KHTvars["gap"] ) then
			largestwidth = largestwidth - 5;
		end
	end
	local tarwidth = largestwidth;
	local extrawidth = 0;
	for i=1, KHTvars["numBars"] do
		local width = getglobal("KHunterTimersStatus"..i.."BarLeftText"):GetWidth() + getglobal("KHunterTimersStatus"..i.."BarRightText"):GetWidth();
		if( width > largestwidth ) then
			largestwidth = width;
		end
	end
	if( largestwidth > tarwidth ) and (not KHTvars["hidetext"]) then
		largestwidth = largestwidth + 40;
		if( KHTvars["showtex"] ) then
			extrawidth = KHTvars["barheight"];
			if( KHTvars["largetex"] ) and ( KHTvars["barheight"] < 16 ) then
				extrawidth = 16;
			end
			if( KHTvars["gap"] ) then
				extrawidth = extrawidth + 5;
			end
		end
		for i=1, KHTvars["numBars"] do
			getglobal("KHunterTimersStatus"..i):SetWidth(largestwidth + extrawidth);
			getglobal("KHunterTimersStatus"..i.."Bar"):SetWidth(largestwidth);
			getglobal("KHunterTimersStatus"..i.."BGBar"):SetWidth(largestwidth);
			getglobal("KHunterTimersStatus"..i.."BarTooltip"):SetWidth(largestwidth);
		end
		if( KHTvars["padding"] ) then
			KHunterTimersFrame:SetWidth(largestwidth + extrawidth + 20);
		else
			KHunterTimersFrame:SetWidth(largestwidth + extrawidth + 10);
		end
	else
		if( KHTvars["padding"] ) then
			KHunterTimersFrame:SetWidth( 240 );
		else
			KHunterTimersFrame:SetWidth( 230 );
		end
		local width = 220;
		if( KHTvars["showtex"] ) then
			if( KHTvars["largetex"] ) and ( KHTvars["barheight"] < 16) then
				width = width - 16;
			else
				width = width - KHTvars["barheight"];
			end
			if( KHTvars["gap"] ) then
				width = width - 5;
			end
		end
		for i=1, KHTvars["numBars"] do
			getglobal("KHunterTimersStatus"..i):SetWidth(220);
			getglobal("KHunterTimersStatus"..i.."Bar"):SetWidth(width);
			getglobal("KHunterTimersStatus"..i.."BGBar"):SetWidth(width);
			getglobal("KHunterTimersStatus"..i.."BarTooltip"):SetWidth(width);
		end
	end
end
			
			

function KHunterTimers_OnUpdateBar( id )
	if( not KHunterTimersFrame:IsVisible() ) then
		KHunterTimersFrame:Show();
	end

	if( IsControlKeyDown() ) then
		getglobal("KHunterTimersStatus"..id.."BarTooltip"):Show();
	else
		getglobal("KHunterTimersStatus"..id.."BarTooltip"):Hide();
	end

	local barframe = getglobal("KHunterTimersStatus"..id);
	if( barframe.channeling ) then
		local time = GetTime();
		local bartext = getglobal( "KHunterTimersStatus"..id.."BarRightText");
		local text = barframe.spell;

		if( time >= barframe.endTime ) then
			if( barframe.spell == KHT_AUTO_SHOT and khtAutoShot ) then
				return;
			end
			barframe.channeling = false;
			barframe.fadeOut = true;
			barframe.step = 0;
			barframe.target = nil;
			barframe.GUID = nil;
			bartext:SetText( KHT_DONE );
			if( khtImpConc ) and ( text == KHT_IMP_CONC_SHORT ) then
				khtImpConc = false;
			elseif( khtRapidFire ) and ( text == KHT_RAPID_FIRE ) then
				khtRapidFire = false;
			elseif( khtQuickShots ) and ( text == KHT_QUICK_SHOTS ) then
				khtQuickShots = false;
			elseif( khtPetIntim ) and ( text == KHT_PET_INTIM ) then
				khtPetIntim = false;
			elseif( khtIntimidation ) and ( text == KHT_INTIM ) then
				khtIntimidation = false;
			elseif( trapTimer ) and string.find( text, KHT_PRIMED ) then
				trapTimer = false;
			elseif( khtWingClip ) and ( text == KHT_WING_CLIP ) then
				khtWingClip = false;
			elseif( khtImpWing ) and ( text == KHT_IMP_WC_SHORT ) then
				khtImpWing = false;
			elseif( khtFreezing ) and ( text == KHT_FREEZING_TRAP ) then
				khtFreezing = false;
			elseif( khtScatter ) and ( text == KHT_SCATTER ) then
				khtScatter = false;
			elseif( khtWyvern ) and ( text == KHT_WYVERN_TEXT ) then
				khtWyvern = false;
			elseif( khtFearBeast ) and ( text == KHT_FEAR_BEAST ) then
				khtFearBeast = false;
			elseif( khtExposeWeakness ) and ( text == KHT_EXPOSE_WEAKNESS ) then
				khtExposeWeakness = false;
			elseif( khtHuntersMark ) and ( text == KHT_HUNTERS_MARK ) then
				khtHuntersMark = false;
			elseif( khtPrimalBlessing ) and ( text == KHT_PRIMAL_BLESSING ) then
				khtPrimalBlessing = false;
			elseif( khtEntrapment ) and ( text == KHT_ENTRAPMENT ) then
				khtEntrapment = false;
			elseif( khtJomGabbar ) and ( text == KHT_JOM_GABBAR ) then
				khtJomGabbar = false;
			elseif( khtFerocious ) and ( text == KHT_FEROCIOUS ) then
				khtFerocious = false;
			elseif( khtTactician ) and ( text == KHT_TACTICIAN ) then
				khtTactician = false;
			elseif( khtConcBarrage ) and ( text == KHT_CONC_BARRAGE ) then
				khtConcBarrage = false;
			elseif( khtWrath ) and ( text == KHT_WRATH ) then
				khtWrath = false;
			elseif( khtPetFrenzy ) and ( text == KHT_PET_FRENZY ) then
				khtPetFrenzy = false;
			elseif( khtHaste ) and ( text == KHT_HASTE ) then
				khtHaste = false;
			elseif( khtSkyguard ) and ( text == KHT_SKYGUARD ) then
				khtSkyguard = false;
			elseif( khtBeastLord ) and ( text == KHT_BEASTLORD ) then
				khtBeastLord = false;
			elseif( khtAshtongue ) and ( text == KHT_ASHTONGUE ) then
				khtAshtongue = false;
			elseif( khtMadness ) and ( text == KHT_MADNESS ) then
				khtMadness = false;
			elseif( khtChampion ) and ( text == KHT_CHAMPION ) then
				khtChampion = false;
			elseif( khtAimedShot ) and ( text == KHT_AIMED_SHOT ) then
				khtAimedShot = false;
			elseif( khtScreech ) and ( text == KHT_SCREECH ) then
				khtScreech = false;
			end
			return;
		elseif ( khtQuickShots and text == KHT_QUICK_SHOTS and KHTvars["skills"][KHT_TALENT] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_QUICK_SHOTS ) and duration > 11 ) then
					KHunterTimersFrame_add( duration*1000, KHT_QUICK_SHOTS );
					break;
				end
				i = i + 1;
			end
		elseif ( khtPrimalBlessing and text == KHT_PRIMAL_BLESSING and KHTvars["skills"][KHT_SETITEM] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_PRIMAL_BLESSING ) and duration > 11 ) then
					KHunterTimersFrame_add( duration*1000, KHT_PRIMAL_BLESSING );
					break;
				end
				i = i + 1;
			end
		elseif ( khtFerocious and text == KHT_FEROCIOUS and KHTvars["skills"][KHT_TALENT] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_FEROCIOUS ) and duration > 9 ) then
					KHunterTimersFrame_add( duration*1000, KHT_FEROCIOUS );
					break;
				end
				i = i + 1;
			end
		elseif ( khtTactician and text == KHT_TACTICIAN and KHTvars["skills"][KHT_TALENT] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_TACTICIAN ) and duration > 7 ) then
					KHunterTimersFrame_add( duration*1000, KHT_TACTICIAN );
					break;
				end
				i = i + 1;
			end
		elseif ( khtWrath and text == KHT_WRATH and KHTvars["skills"][KHT_TRINKETS] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_WRATH ) and duration > 9 ) then
					KHunterTimersFrame_add( duration*1000, KHT_WRATH );
					break;
				end
				i = i + 1;
			end
		elseif ( khtPetFrenzy and text == KHT_PET_FRENZY and KHTvars["skills"][KHT_FRENZY] ) then
			local i = 1;
			while( UnitBuff("pet", i ) ) do
				local spellName, _, _, _, duration, timeLeft = UnitBuff("pet", i );
				if ( string.find( spellName, KHT_PET_FRENZY ) and timeLeft ~= nil ) then
					if ( timeLeft > 7 ) then
						KHunterTimersFrame_add( timeLeft*1000, KHT_PET_FRENZY );
						break;
					end
				end
				i = i + 1;
			end
		elseif ( khtScreech and text == KHT_SCREECH and KHTvars["skills"][KHT_SCREECH] ) then
			local i = 1;
			while( UnitDebuff("playertarget", i ) ) do
				local spellName, _, _, _, _, duration, timeLeft = UnitDebuff("playertarget", i );
				if ( string.find( spellName, KHT_SCREECH ) and timeLeft ~= nil ) then
					if ( timeLeft > 3 ) then
						KHunterTimersFrame_add( timeLeft*1000, KHT_SCREECH );
						break;
					end
				end
				i = i + 1;
			end
		elseif ( khtExposeWeakness and text == KHT_EXPOSE_WEAKNESS and 
		         ( KHTvars["skills"][KHT_TALENT] or KHTvars["skills"][KHT_SETITEM] ) ) then
			local i = 1;
			while( UnitDebuff("playertarget", i ) ) do
				local spellName, _, _, _, _, duration, timeLeft = UnitDebuff("playertarget", i );
				if ( string.find( spellName, KHT_EXPOSE_WEAKNESS ) and timeLeft ~= nil ) then
					if ( timeLeft > 6 ) then
						KHunterTimersFrame_add( timeLeft*1000, KHT_EXPOSE_WEAKNESS );
						break;
					end
				end
				i = i + 1;
			end
		elseif ( khtHaste and text == KHT_HASTE and KHTvars["skills"][KHT_TRINKETS] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_HASTE ) and duration > 9 ) then
					KHunterTimersFrame_add( duration*1000, KHT_HASTE );
					break;
				end
				i = i + 1;
			end
		elseif ( khtSkyguard and text == KHT_SKYGUARD and KHTvars["skills"][KHT_TRINKETS] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_SKYGUARD ) and duration > 29 ) then
					KHunterTimersFrame_add( duration*1000, KHT_SKYGUARD );
					break;
				end
				i = i + 1;
			end
		elseif ( khtBeastLord and text == KHT_BEASTLORD and KHTvars["skills"][KHT_SETITEM] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_BEASTLORD ) and duration > 14 ) then
					KHunterTimersFrame_add( duration*1000, KHT_BEASTLORD );
					break;
				end
				i = i + 1;
			end
		elseif ( khtAshtongue and text == KHT_ASHTONGUE and KHTvars["skills"][KHT_TRINKETS] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_ASHTONGUE ) and duration > 7 ) then
					KHunterTimersFrame_add( duration*1000, KHT_ASHTONGUE );
					break;
				end
				i = i + 1;
			end
		elseif ( khtMadness and text == KHT_MADNESS and KHTvars["skills"][KHT_TRINKETS] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_MADNESS ) and duration > 9 ) then
					KHunterTimersFrame_add( duration*1000, KHT_MADNESS );
					break;
				end
				i = i + 1;
			end
		elseif ( khtChampion and text == KHT_CHAMPION and KHTvars["skills"][KHT_SETITEM] ) then
			local buffIndex;
			local i = 1;
			while true do
				buffIndex = GetPlayerBuff(i, "HELPFUL");
				if buffIndex == 0 then break end

				local spellName = GetPlayerBuffName(buffIndex);
				local duration  = GetPlayerBuffTimeLeft(buffIndex);

				if ( string.find( spellName, KHT_CHAMPION ) and duration > 9 ) then
					KHunterTimersFrame_add( duration*1000, KHT_CHAMPION );
					break;
				end
				i = i + 1;
			end
		end

		local bar = getglobal("KHunterTimersStatus"..id.."Bar");
		local value = barframe.startTime + barframe.endTime - time;
		bar:SetValue( value );
		local timeleft = barframe.duration - (time - barframe.startTime);
		if( KHTvars["mili"] == 0 ) then
			getglobal("KHunterTimersStatus"..id.."BarRightText"):SetFormattedText(KHTColor(unpack(KHTvars["timecolor"])).."%ds", timeleft);
		else
			getglobal("KHunterTimersStatus"..id.."BarRightText"):SetFormattedText(KHTColor(unpack(KHTvars["timecolor"])).."%."..KHTvars["mili"].."f", timeleft);
		end
		if( KHTvars["colorchange"] ) then
			local percent = (time - barframe.startTime)/(barframe.endTime - barframe.startTime);
			local r, g, b, a = unpack( KHTvars["barstartcolor"] );
			local redd, greend, blued, alphad = unpack( KHTvars["bardelta"] );
			redd = r + redd*percent;
			greend = g + greend*percent;
			blued = b + blued*percent;
			alphad = a + alphad*percent;
			bar:SetStatusBarColor( redd, greend, blued, alphad );
			getglobal("KHunterTimersStatus"..id.."BGBar"):SetStatusBarColor( redd, greend, blued, 0.25*alphad );
		end
		
		if( timeleft < KHTvars["flash"] ) and ( barframe.spell ~= KHT_AUTO_SHOT ) then
			if( barframe.step == 0 ) then
				barframe.step = -KHTvars["step"];
			end
			
			local alpha = barframe:GetAlpha() + barframe.step;
			if( alpha < 0.2 ) then
				barframe.step = KHTvars["step"];
			elseif( alpha > KHTvars["overallalpha"] ) then
				barframe.step = -KHTvars["step"];
			end
			barframe:SetAlpha(alpha);
		end
			
			
	elseif( barframe.fadeOut ) then
		local alpha = barframe:GetAlpha() - 0.05;
		if( alpha > 0 ) then
			barframe:SetAlpha(alpha);
		else
			barframe.fadeOut = false;
			barframe:Hide();
			KHTvars["numBars"] = KHTvars["numBars"] - 1;
			KHunterTimers_AutoCascade( 1, false );
		end
	end
end

function KHunterTimersFrame_OnUpdate(elapsed)
	if( (elapsed - this.updateTime) > 1 ) then
		this.updateTime = elapsed;
		
		KHunterTimersFrame:SetScale( KHTvars["scale"] );
		for i=1, KHT_NUM_BARS do
			getglobal("KHunterTimersStatus"..i):SetScale( KHTvars["scale"] );
		end
		KHT_SetHeight();
	end
	
	if ( KHTvars["numBars"] > 0 ) then
		KHunterTimersFrame:Show();
		KHunterTimersFrame:SetAlpha( KHTvars["overallalpha"] );
	else
		local alpha = KHunterTimersFrame:GetAlpha() - 0.05;
		if( alpha > 0 ) then
			KHunterTimersFrame:SetAlpha(alpha);
		else
			KHunterTimersFrame:Hide();
		end
	end
end
function KHT_init()
	if( not KHTvars ) then
		KHTvars = {};
		KHTvars["bg"] = { r=0, g=0, b=0, a=7 };
	end
	if( KHTvars[KHT_ON] == nil ) then
		KHTvars[KHT_ON] = true;
	end
	if( not KHTvars["borderalpha"] ) then
		KHTvars["borderalpha"] = {
			[1] = 1;
			[2] = 1;
			[3] = 1;
			[4] = 1;
		};
	end
	KHunterTimersFrame:SetBackdropColor( KHTvars["bg"].r, KHTvars["bg"].g, KHTvars["bg"].b, KHTvars["bg"].a );
	KHunterTimersFrame:SetBackdropBorderColor( unpack(KHTvars["borderalpha"]) );
	KHTvars["numBars"] = 0;

	if( not KHTvars["skills"] ) then
		KHTvars["skills"] = {};
	end

	if( KHTvars["version"] == nil ) then
		KHTvars["skills"] = {};
		KHTvars["version"] = 2.0;
	end
	
	for i=1, KHT_NUM_TIMERS do
		if( KHTvars["skills"][KHT_OPTIONS_TIMERS[i]] == nil ) then
			KHTvars["skills"][KHT_OPTIONS_TIMERS[i]] = true;
		end
	end
	
	if( not KHTvars["shotdelay"] ) then
		KHTvars["shotdelay"] = 200;
	end

	if( not KHTvars["scale"] ) then
		KHTvars["scale"] = UIParent:GetScale();
	end
	
	if( KHTvars["locked"] == nil ) then
		KHTvars["locked"] = false;
	end
	
	if( not KHTvars["locked"] ) then
		KHunterTimersAnchor:Show();
	else
		KHunterTimersAnchor:Hide();
	end
	
	if( not KHTvars["mili"] ) then
		KHTvars["mili"] = 1;
	end
	
	if( KHTvars["flash"] == nil ) then
		KHTvars["flash"] = 5;
	end
	
	if( not KHTvars["skillcolor"] ) then
		local r, g, b = KHunterTimersStatus1BarLeftText:GetTextColor();
		--local a = KHunterTimersStatus1BarLeftText:GetAlpha();
		KHTvars["skillcolor"] = {
			[1] = r,
			[2] = g,
			[3] = b,
			[4] = 1
		};
	end
	
	if( not KHTvars["timecolor"] ) then
		local r, g, b = KHunterTimersStatus1BarRightText:GetTextColor();
		KHTvars["timecolor"] = {
			[1] = r,
			[2] = g,
			[3] = b,
			[4] = 1
		};
	end
	
	if( not KHTvars["targetcolor"] ) then
		local r, g, b = KHunterTimersStatus1BarLeftText:GetTextColor();
		KHTvars["targetcolor"] = {
			[1] = r,
			[2] = g,
			[3] = b,
			[4] = 1
		};
	end
	
	if( not KHTvars["barstartcolor"] ) then
		KHTvars["barstartcolor"] = {
			[1] = 0,
			[2] = 0.8,
			[3] = 0,
			[4] = 1 };
	end
	if( not KHTvars["barstartcolor"][4] ) then
		KHTvars["barstartcolor"][4] = 1;
	end
	if( not KHTvars["bardelta"] ) then
		KHTvars["bardelta"] = {
			[1] = 0.8,
			[2] = -0.8,
			[3] = 0,
			[4] = 0};
	end
	if( not KHTvars["bardelta"][4] ) then
		KHTvars["bardelta"][4] = 0;
	end
	if( KHTvars["step"] == nil ) then
		KHTvars["step"] = 0.03;
	end
	if( KHTvars["colorchange"] == nil ) then
		KHTvars["colorchange"] = false;
	end
	if( not KHTvars["bardistance"] ) then
		KHTvars["bardistance"] = 10;
	end
	
	if( KHTvars["down"] == nil ) then
		KHTvars["down"] = true;
	end
	
	if( KHTvars["append"] == nil ) then
		KHTvars["append"] = false;
	end
	
	if( not KHTvars["overallalpha"] ) then
		KHTvars["overallalpha"] = 1;
	end
	
	KHunterTimers_ClearActiveSpells();
	
	for i=1, KHT_NUM_TIMERS do --Check boxes
		getglobal("KHunterTimersOptionsTimersCheckButton"..i.."Text"):SetText(KHT_OPTIONS_TIMERS[i]);
	end
	
	for i=1, KHT_NUM_OPTIONS do --Check boxes
		getglobal("KHunterTimersOptionsBarsCheckButton"..i.."Text"):SetText(KHT_OPTIONS_BARS[i]);
	end
	
	for i=1, KHT_NUM_SLIDERS do  --Sliders
		getglobal("KHunterTimersOptionsBarsSlider"..i.."SliderTitle"):SetText(KHT_OPTIONS_SLIDER[i]);
		getglobal("KHunterTimersOptionsBarsSlider"..i.."SliderLow"):SetText(KHT_OPTIONS_SLIDER_ENDS[i][1])
		getglobal("KHunterTimersOptionsBarsSlider"..i.."SliderHigh"):SetText(KHT_OPTIONS_SLIDER_ENDS[i][2]);
	end
	
	if( not KHTvars["textures"] ) then
		KHTvars["textures"] = {};
	end
	
	if( KHTvars["showtex"] == nil ) then
		KHTvars["showtex"] = true;
	end
	if( KHTvars["largetex"] == nil ) then
		KHTvars["largetex"] = true;
	end
	
	if( KHTvars["hidetext"] == nil ) then
		KHTvars["hidetext"] = false;
	end
	
	if( KHTvars["hidetime"] == nil ) then
		KHTvars["hidetime"] = false;
	end
	
	if( KHTvars["gap"] == nil ) then
		KHTvars["gap"] = true;
	end
	
	if( KHTvars["padding"] == nil ) then
		KHTvars["padding"] = true;
	end
	
	if( not KHTvars["barheight"] ) then
		KHTvars["barheight"] = 10;
	end
	
	if( KHTvars["sticky"] == nil ) then
		KHTvars["sticky"] = true;
	end
	
	if( KHTvars["traptimemult"] == nil ) then
		KHTvars["traptimemult"] = 1;
	end
	
	getglobal("KHunterTimersOptionsTimersLabel1Label"):SetText(KHT_OPTIONS_TIMERS_TEXT);

	for i=1, KHT_NUM_LABELS do
		getglobal("KHunterTimersOptionsBarsLabel"..i.."Label"):SetText(KHT_OPTIONS_LABELS[i]);
	end
	
	getglobal("KHunterTimersOptionsTitleString"):SetText("Kharthus's Hunter Timers "..KHT_VERSION);
	
	KHunterTimers_SetSettings();
	
	KHunterTimersOptions:SetScale(UIParent:GetScale()*0.8);
end

function KHunterTimersFrame_OnEvent(frame, event, firstArg, secondArg, thirdArg, fourthArg, fifthArg, sixthArg, seventhArg, eigthArg, ninthArg, tenthArg, ...)
	if( event == "ADDON_ACTION_BLOCKED" or event == "ADDON_ACTION_FORBIDDEN" ) then
		if ( firstArg == "ItemRack" or firstArg == "CT_RaidAssist" ) then
		elseif ( khtDebugBC ) then
			DEFAULT_CHAT_FRAME:AddMessage(event.." "..firstArg.." "..secondArg, 1, 0, 0 );
		end
		return;
	end
	
	if( event == "VARIABLES_LOADED" ) then
		KHT_init();
		return;
	end
	if( event == "SPELLS_CHANGED" ) then
		KHunterTimers_UpdateSpells();
		return;
	end
	if( event == "CHARACTER_POINTS_CHANGED" or event == "PLAYER_ALIVE" ) then
		local _, _, _, _, rank = GetTalentInfo( 3, 8 ); --Clever traps
		KHTvars["traptimemult"] = 1 + (rank * 0.15);
		return;
	end
	if( not KHTvars[KHT_ON] ) then
		return;
	end

	if( event == "START_AUTOREPEAT_SPELL" ) then
		khtAutoShot = true;
	elseif( event == "STOP_AUTOREPEAT_SPELL" ) then
		khtAutoShot = false;
	end

	if ( khtDebug ) then
		if ( event ~= "COMBAT_LOG_EVENT_UNFILTERED" ) then
			if ( fourthArg ) then
				DEFAULT_CHAT_FRAME:AddMessage(event.." "..firstArg.." "..secondArg.." "..thirdArg.." "..fourthArg, 1, 0, 0 );
			elseif ( thirdArg ) then
				DEFAULT_CHAT_FRAME:AddMessage(event.." "..firstArg.." "..secondArg.." "..thirdArg, 1, 0, 0 );
			elseif ( secondArg ) then
				DEFAULT_CHAT_FRAME:AddMessage(event.." "..firstArg.." "..secondArg, 1, 0, 0 );
			elseif ( firstArg ) then
				DEFAULT_CHAT_FRAME:AddMessage(event.." "..firstArg, 1, 0, 0 );
			else
				DEFAULT_CHAT_FRAME:AddMessage(event, 1, 0, 0 );
			end
		end
	end

	if ( event == "COMBAT_LOG_EVENT_UNFILTERED" ) then
		local combatEvent, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, spellId, spellName;
		combatEvent = secondArg;
		sourceGUID = thirdArg;
		sourceName = fourthArg;
		sourceFlags = fifthArg;
		destGUID = sixthArg;
		destName = seventhArg;
		destFlags = eigthArg;
		spellId = ninthArg;
		spellName = tenthArg;

		local toPlayer, fromPlayer, toPet, fromPet, toTarget;
		if (sourceName and not CombatLog_Object_IsA(sourceFlags, COMBATLOG_OBJECT_NONE) ) then
			fromPlayer = CombatLog_Object_IsA(sourceFlags, COMBATLOG_FILTER_MINE);
			fromPet = CombatLog_Object_IsA(sourceFlags, COMBATLOG_FILTER_MY_PET);
		end
		if (destName and not CombatLog_Object_IsA(destFlags, COMBATLOG_OBJECT_NONE) ) then
			toPlayer = CombatLog_Object_IsA(destFlags, COMBATLOG_FILTER_MINE);
			toPet = CombatLog_Object_IsA(destFlags, COMBATLOG_FILTER_MY_PET);
			toTarget = CombatLog_Object_IsA(destFlags, COMBATLOG_OBJECT_TARGET);
		end
	
		if ( khtDebugBC ) then
			if ( fromPlayer or fromPet or toPlayer or toPet or toTarget ) then
				if ( sourceName and destName and spellName ) then
					DEFAULT_CHAT_FRAME:AddMessage(combatEvent.." "..sourceName.." "..destName.." "..spellName, 1, 0, 0 );
				elseif ( destName and spellName ) then
					DEFAULT_CHAT_FRAME:AddMessage(combatEvent.." "..destName.." "..spellName, 1, 0, 0 );
				elseif ( sourceName and spellName ) then
					DEFAULT_CHAT_FRAME:AddMessage(combatEvent.." "..sourceName.." "..spellName, 1, 0, 0 );
				end
			end

		end

		if( combatEvent == "PARTY_KILL" or combatEvent == "UNIT_DIED" or combatEvent == "UNIT_DESTROYED" ) then
			if( KHTvars["numBars"] > 0 ) then
				for num = 1, KHTvars["numBars"], 1 do
					local barframe = getglobal("KHunterTimersStatus"..num);
					if( barframe.GUID ~= nil ) then
						if ( barframe.GUID == destGUID ) then
							barframe.endTime = 0;
						end
					end
				end
			end
		elseif( combatEvent == "SPELL_CAST_SUCCESS" and fromPlayer ) then
			if( KHTvars["skills"][KHT_HUNTERS_MARK] and spellName == KHT_HUNTERS_MARK ) then
				KHunterTimersFrame_add( 120000, spellName, destName, destGUID );
			elseif ( KHTvars["skills"][KHT_SERPENT] and spellName == KHT_SERPENT ) then
				KHunterTimersFrame_add( 15000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_SCORPID] and spellName == KHT_SCORPID ) then
				KHunterTimersFrame_add( 20000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_VIPER] and spellName == KHT_VIPER ) then
				KHunterTimersFrame_add( 8000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_WYVERN] and spellName == KHT_WYVERN ) then
				khtWyvern = true;
				KHunterTimersFrame_add( 12000, KHT_WYVERN_TEXT, destName, destGUID );
			elseif( KHTvars["skills"][KHT_MISDIRECTION] and spellName == KHT_MISDIRECTION ) then
				KHunterTimersFrame_add( 30000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_SCATTER] and spellName == KHT_SCATTER ) then
				khtScatter = true;
				KHunterTimersFrame_add( 4000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_CONC_SHOT] and spellName == KHT_CONC_SHOT ) then
				KHunterTimersFrame_add( 4000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_SILENCE_SHOT] and spellName == KHT_SILENCE_SHOT ) then
				KHunterTimersFrame_add( 3000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_WING_CLIP] and spellName == KHT_WING_CLIP ) then
				khtWingClip = true;
				KHunterTimersFrame_add( 10000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_COUNTER] and spellName == KHT_COUNTER ) then
				KHunterTimersFrame_add( 5000, spellName, destName, destGUID );
			elseif( KHTvars["skills"][KHT_KILL_COMMAND] and spellName == KHT_KILL_COMMAND ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal("KHunterTimersStatus"..i);
					if( string.find( barframe.spell, KHT_KILL_COMMAND ) ) then
						barframe.endTime = 0;
					end
				end
			end
		elseif( combatEvent == "SPELL_MISSED" and ( fromPlayer or fromPet ) ) then
			if( trapTimer ) and ( string.find( spellName, KHT_FREEZING_TRAP ) or string.find( spellName, KHT_IMMO_TRAP ) ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal("KHunterTimersStatus"..i);
					if( string.find( barframe.spell, KHT_PRIMED ) ) then
						barframe.endTime = 0;
					end
				end
			else
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal("KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID )then
						barframe.endTime = 0;
					end
				end
			end
		elseif( combatEvent == "SPELL_AURA_APPLIED" ) then
			if( string.find( spellName, KHT_TRAP ) and trapTimer ) then
				for num = 1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..num);
					if( string.find( barframe.spell, KHT_PRIMED ) ) then
						barframe.endTime = 0;
					end
				end
				if( KHTvars["skills"][KHT_FREEZING_TRAP] and string.find( spellName, KHT_FREEZING_TRAP ) ) then
					khtFreezing = true;
					local duration = (5000 + trapRank*5000)*KHTvars["traptimemult"];
					KHunterTimersFrame_add( duration, KHT_FREEZING_TRAP, destName, destGUID );
				elseif( KHTvars["skills"][KHT_FROST_TRAP] and string.find( spellName, KHT_FROST_TRAP ) ) then
					KHunterTimersFrame_add( 30000*KHTvars["traptimemult"], KHT_FROST_TRAP.." "..KHT_AURA );
				elseif( KHTvars["skills"][KHT_IMMO_TRAP] and string.find( spellName, KHT_IMMO_TRAP ) ) then
					KHunterTimersFrame_add( 15000, KHT_IMMO_TRAP, destName, destGUID );
				elseif( KHTvars["skills"][KHT_EXPL_TRAP] and string.find( spellName, KHT_EXPL_TRAP ) ) then
					KHunterTimersFrame_add( 20000, KHT_EXPL_TRAP.." "..KHT_AURA );
				end
			elseif( toTarget ) then
				if( KHTvars["skills"][KHT_FEAR_BEAST] and spellName == KHT_FEAR_BEAST and ( not khtFearBeast ) ) then
					khtFearBeast = true;
					KHunterTimersFrame_add( 20000, spellName, destName, destGUID );
				elseif( ( KHTvars["skills"][KHT_TALENT] or KHTvars["skills"][KHT_SETITEM] )
			     	   and spellName == KHT_EXPOSE_WEAKNESS and ( not khtExposeWeakness ) ) then
					khtExposeWeakness = true;
					KHunterTimersFrame_add( 7000, spellName, destName, destGUID );
				elseif( KHTvars["skills"][KHT_ENTRAPMENT] and spellName == KHT_ENTRAPMENT ) then
					khtEntrapment = true;
					KHunterTimersFrame_add( 5000, spellName, destName, destGUID );
				elseif( KHTvars["skills"][KHT_TALENT] and spellName == KHT_CONC_BARRAGE and ( not khtConcBarrage ) ) then
					khtConcBarrage = true;
					KHunterTimersFrame_add( 4000, spellName, destName, destGUID );
				elseif( KHTvars["skills"][KHT_TALENT] and spellName == KHT_AIMED_SHOT and ( not khtAimedShot ) ) then
					khtAimedShot = true;
					KHunterTimersFrame_add( 10000, spellName, destName, destGUID );
				elseif( KHTvars["skills"][KHT_INTIM] and spellName == KHT_INTIM and ( not khtIntimidation ) ) then
					khtIntimidation = true;
					KHunterTimersFrame_add( 3000, spellName, destName, destGUID );
				elseif( KHTvars["skills"][KHT_CONC_SHOT] and spellName == KHT_IMP_CONC and ( not khtImpConc ) ) then
					khtImpConc = true;
					KHunterTimersFrame_add( 3000, KHT_IMP_CONC_SHORT, destName, destGUID );
				elseif( KHTvars["skills"][KHT_WING_CLIP] and spellName == KHT_IMP_WC and ( not khtImpWing ) ) then
					khtImpWing = true;
					KHunterTimersFrame_add( 5000, KHT_IMP_WC_SHORT, destName, destGUID );
				elseif( KHTvars["skills"][KHT_SCREECH] and spellName == KHT_SCREECH and ( not khtScreech ) ) then
					khtScreech = true;
					KHunterTimersFrame_add( 4000, spellName, destName, destGUID );
				end
			elseif( toPlayer or toPet ) then
				if( spellName == KHT_QUICK_SHOTS ) then
					khtQuickShots = true;
					if ( KHTvars["skills"][KHT_TALENT] ) then
						KHunterTimersFrame_add( 12000, KHT_QUICK_SHOTS );
					end
				elseif( spellName == KHT_PRIMAL_BLESSING ) then
					khtPrimalBlessing = true;
					if ( KHTvars["skills"][KHT_SETITEM] ) then
						KHunterTimersFrame_add( 12000, KHT_PRIMAL_BLESSING );
					end
				elseif( spellName == KHT_DETERRENCE ) then
					if ( KHTvars["skills"][KHT_DETERRENCE] ) then
						KHunterTimersFrame_add( 10000, KHT_DETERRENCE );
					end
				elseif( spellName == KHT_BERSERKING ) then
					if ( KHTvars["skills"][KHT_RACIALS] ) then
						KHunterTimersFrame_add( 10000, KHT_BERSERKING );
					end
				elseif( spellName == KHT_DEVILSAUR ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 20000, KHT_DEVILSAUR );
					end
				elseif( spellName == KHT_ZHM ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 20000, KHT_ZHM );
					end
				elseif( spellName == KHT_EARTHSTRIKE ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 20000, KHT_EARTHSTRIKE );
					end
				elseif( spellName == KHT_SWARMGUARD ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_SWARMGUARD );
					end
				elseif( spellName == KHT_JOM_GABBAR ) then
					if ( KHTvars["skills"][KHT_TRINKETS] and not khtJomGabbar ) then
						KHunterTimersFrame_add( 20000, KHT_JOM_GABBAR );
						khtJomGabbar = true;
					end
				elseif( spellName == KHT_KISS_SPIDER ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 15000, KHT_KISS_SPIDER );
					end
				elseif( spellName == KHT_RAPID_KILLING ) then
					if ( KHTvars["skills"][KHT_TALENT] ) then
						KHunterTimersFrame_add( 20000, KHT_RAPID_KILLING );
					end
				elseif( spellName == KHT_FEROCIOUS ) then
					khtFerocious = true;
					if ( KHTvars["skills"][KHT_TALENT] ) then
						KHunterTimersFrame_add( 10000, KHT_FEROCIOUS );
					end
				elseif( spellName == KHT_BLOOD_FURY ) then
					if ( KHTvars["skills"][KHT_RACIALS] ) then
						KHunterTimersFrame_add( 15000, KHT_BLOOD_FURY );
					end
				elseif( spellName == KHT_FEROCITY ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 15000, KHT_FEROCITY );
					end
				elseif( spellName == KHT_TACTICIAN ) then
					khtTactician = true;
					if ( KHTvars["skills"][KHT_TALENT] ) then
						KHunterTimersFrame_add( 8000, KHT_TACTICIAN );
					end
				elseif( spellName == KHT_BURNING_HATRED ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 15000, KHT_BURNING_HATRED );
					end
				elseif( spellName == KHT_ANCIENT_POWER ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 20000, KHT_ANCIENT_POWER );
					end
				elseif( spellName == KHT_SANTOS ) then
					if ( KHTvars["skills"][KHT_SETITEM] ) then
						KHunterTimersFrame_add( 10000, KHT_SANTOS );
					end
				elseif( spellName == KHT_NIGHTSEYE ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 12000, KHT_NIGHTSEYE );
					end
				elseif( spellName == KHT_UNRAVELLER ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 10000, KHT_UNRAVELLER );
					end
				elseif( spellName == KHT_LUST ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 20000, KHT_LUST );
					end
				elseif( spellName == KHT_HASTE ) then
					khtHaste = true;
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 10000, KHT_HASTE );
					end
				elseif( spellName == KHT_HEROISM ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 15000, KHT_HEROISM );
					end
				elseif( spellName == KHT_HEROIC ) then
					if ( KHTvars["skills"][KHT_SETITEM] ) then
						KHunterTimersFrame_add( 15000, KHT_HEROIC );
					end
				elseif( spellName == KHT_SKYFIRE ) then
					if ( KHTvars["skills"][KHT_SETITEM] ) then
						KHunterTimersFrame_add( 6000, KHT_SKYFIRE );
					end
				elseif( spellName == KHT_TSUNAMI ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 10000, KHT_TSUNAMI );
					end
				elseif( spellName == KHT_ASHTONGUE ) then
					khtAshtongue = true;
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 8000, KHT_ASHTONGUE );
					end
				elseif( spellName == KHT_WRATH ) then
					khtWrath = true;
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 10000, KHT_WRATH );
					end
				elseif( spellName == KHT_DELUSIONAL ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_DELUSIONAL );
					end
				elseif( spellName == KHT_KLEPTOMANIA ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_KLEPTOMANIA );
					end
				elseif( spellName == KHT_MANIC ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_MANIC );
					end
				elseif( spellName == KHT_MARTYR ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_MARTYR );
					end
				elseif( spellName == KHT_NARCISSISM ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_NARCISSISM );
					end
				elseif( spellName == KHT_PARANOIA ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_PARANOIA );
					end
				elseif( spellName == KHT_TALON ) then
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 6000, KHT_TALON );
					end
				elseif( string.find( spellName, KHT_PET_FRENZY ) ) then
					khtPetFrenzy = true;
					if ( KHTvars["skills"][KHT_FRENZY] ) then
						KHunterTimersFrame_add( 8000, KHT_PET_FRENZY );
					end
				elseif( spellName == KHT_SKYGUARD ) then
					khtSkyguard = true;
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 30000, KHT_SKYGUARD );
					end
				elseif( spellName == KHT_BEASTLORD ) then
					khtBeastLord = true;
					if ( KHTvars["skills"][KHT_SETITEM] ) then
						KHunterTimersFrame_add( 15000, KHT_BEASTLORD );
					end
				elseif( spellName == KHT_MADNESS ) then
					khtMadness = true;
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 10000, KHT_MADNESS );
					end
				elseif( string.find( spellName, KHT_CHAMPION ) ) then
					khtChampion = true;
					if ( KHTvars["skills"][KHT_SETITEM] ) then
						KHunterTimersFrame_add( 10000, KHT_CHAMPION );
					end
				elseif( spellName == KHT_STONEFORM ) then
					if ( KHTvars["skills"][KHT_RACIALS] ) then
						KHunterTimersFrame_add( 8000, KHT_STONEFORM );
					end
				elseif( spellName == KHT_BERSERKER ) then
					khtMadness = true;
					if ( KHTvars["skills"][KHT_TRINKETS] ) then
						KHunterTimersFrame_add( 20000, KHT_BERSERKER );
					end
				end
			end
		elseif( combatEvent == "SWING_DAMAGE" and fromPet ) then
			if( sourceName == KHT_VENOMOUS and trapTimer ) then
				for num = 1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..num);
					if( string.find( barframe.spell, KHT_PRIMED ) ) then
						barframe.endTime = 0;
					end
				end
				if( KHTvars["skills"][KHT_SNAKE_TRAP] ) then
					KHunterTimersFrame_add( 15000, KHT_SNAKE_TRAP.." "..KHT_AURA );
				end
			end
		elseif( combatEvent == "SPELL_AURA_REMOVED" and ( toPlayer or toPet ) ) then
			if( khtQuickShots ) and ( spellName == KHT_QUICK_SHOTS ) then
				khtQuickShots = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtRapidFire ) and ( spellName == KHT_RAPID_FIRE ) then
				khtRapidFire = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtPrimalBlessing ) and ( spellName == KHT_PRIMAL_BLESSING ) then
				khtPrimalBlessing = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( spellName == KHT_RAPID_KILLING ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtFerocious ) and ( spellName == KHT_FEROCIOUS ) then
				khtFerocious = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( spellName == KHT_MISDIRECTION ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( string.find( spellName, KHT_FEED_PET ) ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == KHT_FEED_PET ) then
						getglobal("KHunterTimersStatus"..i).endTime = 0;
					end
				end
			elseif( spellName == KHT_MEND_PET ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtTactician ) and ( spellName == KHT_TACTICIAN ) then
				khtTactician = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtWrath ) and ( spellName == KHT_WRATH ) then
				khtWrath = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtPetFrenzy ) and ( spellName == KHT_PET_FRENZY ) then
				khtPetFrenzy = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtHaste ) and ( spellName == KHT_HASTE ) then
				khtHaste = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtSkyguard ) and ( spellName == KHT_SKYGUARD ) then
				khtSkyguard = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtBeastLord ) and ( spellName == KHT_BEASTLORD ) then
				khtBeastLord = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtAshtongue ) and ( spellName == KHT_ASHTONGUE ) then
				khtAshtongue = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtMadness ) and ( spellName == KHT_MADNESS ) then
				khtMadness = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtChampion ) and string.find( spellName, KHT_CHAMPION ) then
				khtChampion = false;
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == KHT_CHAMPION ) then
						barframe.endTime = 0;
					end
				end
			end
		elseif( combatEvent == "SPELL_AURA_REMOVED" ) then
			if( khtFreezing ) and string.find( spellName, KHT_FREEZING_TRAP ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == KHT_FREEZING_TRAP ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtScatter ) and ( spellName == KHT_SCATTER ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i)
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtFearBeast ) and ( spellName == KHT_FEAR_BEAST ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtWyvern ) and ( spellName == KHT_WYVERN ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					local text = getglobal("KHunterTimersStatus"..i.."BarLeftText"):GetText();
					if( text == KHT_WYVERN_TEXT ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtWingClip ) and ( spellName == KHT_WING_CLIP ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtExposeWeakness ) and ( spellName == KHT_EXPOSE_WEAKNESS ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtEntrapment ) and ( spellName == KHT_ENTRAPMENT ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtHuntersMark ) and ( spellName == KHT_HUNTERS_MARK ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtConcBarrage ) and ( spellName == KHT_CONC_BARRAGE ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtAimedShot ) and ( spellName == KHT_AIMED_SHOT ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			elseif( khtScreech ) and ( spellName == KHT_SCREECH ) then
				for i=1, KHTvars["numBars"] do
					local barframe = getglobal( "KHunterTimersStatus"..i);
					if( barframe.spell == spellName ) and ( barframe.GUID == destGUID ) then
						barframe.endTime = 0;
					end
				end
			end
		end
	elseif( event == "COMBAT_TEXT_UPDATE" ) then
		if ( KHTvars["skills"][KHT_KILL_COMMAND] and firstArg == "SPELL_ACTIVE" and secondArg == KHT_KILL_COMMAND ) then
			KHunterTimersFrame_add( 5000, KHT_KILL_COMMAND );
		end
	elseif( event == "PLAYER_AURAS_CHANGED" ) then
		local buffIndex;
		local i = 1;
		while true do
			buffIndex = GetPlayerBuff(i, "HELPFUL");
			if buffIndex == 0 then break end

			local spellName = GetPlayerBuffName(buffIndex);
			local duration  = GetPlayerBuffTimeLeft(buffIndex);
			--DEFAULT_CHAT_FRAME:AddMessage(i.." "..buffIndex.." "..spellName.." "..duration);
			duration = duration * 1000;

			if ( string.find( spellName, KHT_RAPID_FIRE ) ) then
				if ( KHTvars["skills"][KHT_RAPID_FIRE] and not khtRapidFire ) then
					KHunterTimersFrame_add( duration, KHT_RAPID_FIRE );
				end
				khtRapidFire = true;
				break;
			end
			i = i + 1;
		end
	elseif( event == "UNIT_SPELLCAST_SUCCEEDED" ) then
		if( KHTvars["skills"][KHT_INTIM] and string.find( secondArg, KHT_INTIM ) ) then
			khtPetIntim = true;
			KHunterTimersFrame_add( 15000, KHT_PET_INTIM );
		elseif( KHTvars["skills"][KHT_BW] and string.find( secondArg, KHT_BW ) ) then
			KHunterTimersFrame_add( 18000, secondArg );
		elseif( KHTvars["skills"][KHT_FLARE] and string.find( secondArg, KHT_FLARE ) ) then
			KHunterTimersFrame_add( 20000, secondArg );
		elseif( string.find( secondArg, KHT_TRAP ) ) then
			if( KHTvars["skills"][secondArg] ) then
				trapTimer = true;
				if ( string.find( secondArg, KHT_FREEZING_TRAP ) ) then
					trapRank = string.match( thirdArg, "%d" );
				end
				KHunterTimersFrame_add( 60000, secondArg.." "..KHT_PRIMED );
			end
		elseif( KHTvars["skills"][KHT_AUTO_SHOT] and secondArg == KHT_AUTO_SHOT ) then
			khtAutoShot = true;
			khtTimeLeft = UnitRangedDamage("player");
			KHunterTimersFrame_add( khtTimeLeft*1000, KHT_AUTO_SHOT );
		elseif( KHTvars["skills"][KHT_FEED_PET] and secondArg == KHT_FEED_PET ) then
			KHunterTimersFrame_add( 20000, secondArg );
		elseif( KHTvars["skills"][KHT_MEND_PET] and secondArg == KHT_MEND_PET ) then
			KHunterTimersFrame_add( 15000, secondArg );
		elseif( KHTvars["skills"][KHT_RACIALS] and secondArg == KHT_WAR_STOMP ) then
			KHunterTimersFrame_add( 2000, secondArg );
		elseif( KHTvars["skills"][KHT_RACIALS] and secondArg == KHT_ARCANE ) then
			KHunterTimersFrame_add( 2000, secondArg );
		end
	elseif( event == "CHAT_MSG_MONSTER_EMOTE" ) then
		if( KHTvars["skills"][KHT_FRENZY] and ( string.find( firstArg, KHT_FRENZY_EMOTE ) or string.find( firstArg, KHT_FRENZY_FLAMEGOR ) ) ) then
			if( secondArg == KHT_CHROMAGGUS ) then
				KHunterTimersFrame_add( 15000, KHT_FRENZY, KHT_CHROMAGGUS );
			elseif( secondArg == KHT_FLAMEGOR ) then
				KHunterTimersFrame_add( 10000, KHT_FRENZY, KHT_FLAMEGOR );
			elseif( secondArg == KHT_MAGMADAR ) then
				KHunterTimersFrame_add( 15000, KHT_FRENZY, KHT_MAGMADAR );
			elseif( secondArg == KHT_HUHURAN ) then
				KHunterTimersFrame_add( 10000, KHT_FRENZY, KHT_HUHURAN );
			elseif( secondArg == KHT_GLUTH ) then
				KHunterTimersFrame_add( 10000, KHT_FRENZY, KHT_GLUTH );
			end
		end
	end

end

function KHunterTimers_cascadeBar( id )
	local barframefrom = getglobal("KHunterTimersStatus"..(id+1));
	if( not barframefrom ) or not ( barframefrom:IsVisible() and (barframefrom.channeling or barframefrom.fadeOut) )then
		getglobal("KHunterTimersStatus"..id):Hide();
		KHunterTimers_SetWidths();
		KHT_SetHeight();
		return;
	end
	
	local barframeto = getglobal("KHunterTimersStatus"..id);
	local barto = getglobal("KHunterTimersStatus"..id.."Bar");
	local textLeftto = getglobal("KHunterTimersStatus"..id.."BarLeftText");
	local textRightto = getglobal("KHunterTimersStatus"..id.."BarRightText");
	local iconto = getglobal("KHunterTimersStatus"..id.."Icon");
	
	id = id + 1;
	
	local barfrom = getglobal("KHunterTimersStatus"..id.."Bar");
	local textLeftfrom = getglobal("KHunterTimersStatus"..id.."BarLeftText");
	local textRightfrom = getglobal("KHunterTimersStatus"..id.."BarRightText");
	
	barframeto.texture = barframefrom.texture;
	iconto:SetTexture(barframeto.texture);
	
	barframeto.startTime = barframefrom.startTime;
	barframeto.endTime = barframefrom.endTime;
	barframeto.duration = barframefrom.duration;
	barframeto.channeling = barframefrom.channeling;
	barframeto.fadeOut = barframefrom.fadeOut;
	barframeto.target = barframefrom.target;
	barframeto.GUID = barframefrom.GUID;
	barframeto.spell = barframefrom.spell;
	barto:SetMinMaxValues(barframeto.startTime, barframeto.endTime);
	barto:SetValue(barfrom:GetValue());
	textLeftto:SetText(textLeftfrom:GetText());
	textRightto:SetText(textRightfrom:GetText());
	barframeto:SetAlpha(barframefrom:GetAlpha());
	barframeto:Show();
	KHunterTimers_cascadeBar( id );
end

function KHunterTimers_shift( id, curr )

	if( id > KHTvars["numBars"] ) or ( KHTvars["numBars"] == 11 ) then
		return;
	end
	
	if( not curr ) then
		curr = KHTvars["numBars"] + 1;
	end
	
	if( curr == id ) then
		--DEFAULT_CHAT_FRAME:AddMessage("shiftend");
		return;
	end
	
	KHunterTimers_CopyBar( curr, curr-1 );
	KHunterTimers_shift( id, curr-1 );
	
end

function KHunterTimers_CopyBar(to, from)
	local barframeto = getglobal("KHunterTimersStatus"..to);
	local barto = getglobal("KHunterTimersStatus"..to.."Bar");
	local textLeftto = getglobal("KHunterTimersStatus"..to.."BarLeftText");
	local textRightto = getglobal("KHunterTimersStatus"..to.."BarRightText");
	local iconto = getglobal("KHunterTimersStatus"..to.."Icon");
	
	local barframefrom = getglobal("KHunterTimersStatus"..from);
	local barfrom = getglobal("KHunterTimersStatus"..from.."Bar");
	local textLeftfrom = getglobal("KHunterTimersStatus"..from.."BarLeftText");
	local textRightfrom = getglobal("KHunterTimersStatus"..from.."BarRightText");
	
	barframeto.texture = barframefrom.texture;
	iconto:SetTexture(barframeto.texture);
	
	barframeto.startTime = barframefrom.startTime;
	barframeto.endTime = barframefrom.endTime;
	barframeto.duration = barframefrom.duration;
	barframeto.channeling = barframefrom.channeling;
	barframeto.fadeOut = barframefrom.fadeOut;
	barframeto.target = barframefrom.target;
	barframeto.GUID = barframefrom.GUID;
	barframeto.spell = barframefrom.spell;
	barto:SetMinMaxValues(barframeto.startTime, barframeto.endTime);
	barto:SetValue(barfrom:GetValue());
	textLeftto:SetText(textLeftfrom:GetText());
	textRightto:SetText(textRightfrom:GetText());
	barframeto:SetAlpha(barframefrom:GetAlpha());
	barframeto:Show();
end

function KHunterTimers_AutoCascade(id, last)
	if( id == KHT_NUM_BARS ) then
		return;
	end
	if( id == 0 ) then
		id = 1;
	end
	local barframe = getglobal("KHunterTimersStatus"..id);
	if( barframe:IsVisible() ) then
		KHunterTimers_AutoCascade(id+1, false);
	else
		local barframenext = getglobal("KHunterTimersStatus"..id+1);
		if( barframenext:IsVisible() ) then
			KHunterTimers_cascadeBar(id);
			if( last ) then
				KHunterTimers_AutoCascade( id-1, true );
			else
				KHunterTimers_AutoCascade( id+1, false );
			end
		else
			KHunterTimers_AutoCascade(id+1, true);
		end
	end
end

function KHunterTimers_ShowOptions()
	for i=1, KHT_NUM_TIMERS do
		if( KHTvars["skills"][KHT_OPTIONS_TIMERS[i]] ) then
			getglobal("KHunterTimersOptionsTimersCheckButton"..i):SetChecked(1);
		else
			getglobal("KHunterTimersOptionsTimersCheckButton"..i):SetChecked(0);
		end
	end
	
	if( KHTvars[KHT_ON] ) then
		KHunterTimersOptionsBarsCheckButtonOn:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButtonOn:SetChecked(0);
	end
	
	if( KHTvars["locked"] ) then
		KHunterTimersOptionsBarsCheckButton1:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton1:SetChecked(0);
	end
	
	if( KHTvars["colorchange"] ) then
		KHunterTimersOptionsBarsCheckButton2:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton2:SetChecked(0);
	end
	
	if( KHTvars["showtex"] ) then
		KHunterTimersOptionsBarsCheckButton3:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton3:SetChecked(0);
	end
	
	if( KHTvars["largetex"] ) then
		KHunterTimersOptionsBarsCheckButton4:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton4:SetChecked(0);
	end
	
	if( KHTvars["gap"] ) then
		KHunterTimersOptionsBarsCheckButton5:SetChecked(0);
	else
		KHunterTimersOptionsBarsCheckButton5:SetChecked(1);
	end

	if( KHTvars["append"] ) then
		KHunterTimersOptionsBarsCheckButton6:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton6:SetChecked(0);
	end

	if( KHTvars["padding"] ) then
		KHunterTimersOptionsBarsCheckButton7:SetChecked(0);
	else
		KHunterTimersOptionsBarsCheckButton7:SetChecked(1);
	end
	
	if( KHTvars["hidetext"] ) then
		KHunterTimersOptionsBarsCheckButton8:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton8:SetChecked(0);
	end

	if( KHTvars["hidetime"] ) then
		KHunterTimersOptionsBarsCheckButton9:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton9:SetChecked(0);
	end

	if( KHTvars["sticky"] ) then
		KHunterTimersOptionsBarsCheckButton10:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton10:SetChecked(0);
	end

	if( KHTvars["down"] ) then
		KHunterTimersOptionsBarsCheckButton11:SetChecked(1);
	else
		KHunterTimersOptionsBarsCheckButton11:SetChecked(0);
	end

	KHunterTimersOptionsBarsEditBox1:SetText(KHTvars["shotdelay"]);
	
	local r, g, b, a = unpack(KHTvars["barstartcolor"]);
	local rd, gd, bd, ad = unpack( KHTvars["bardelta"] );
	rd = rd + r;
	gd = gd + g;
	bd = bd + b;
	ad = ad + a;
	KHunterTimersOptionsBarsColor1Swatch:SetVertexColor(r, g, b);
	KHunterTimersOptionsBarsColor1Swatch.r = r;
	KHunterTimersOptionsBarsColor1Swatch.g = g;
	KHunterTimersOptionsBarsColor1Swatch.b = b;
	KHunterTimersOptionsBarsColor1Swatch.a = a;
	KHunterTimersOptionsBarsColor2Swatch:SetVertexColor(rd, gd, bd);
	KHunterTimersOptionsBarsColor2Swatch.r = rd;
	KHunterTimersOptionsBarsColor2Swatch.g = gd;
	KHunterTimersOptionsBarsColor2Swatch.b = bd;
	KHunterTimersOptionsBarsColor2Swatch.a = ad;
	KHunterTimersOptionsBarsColor3Swatch:SetVertexColor(KHTvars["bg"].r, KHTvars["bg"].g, KHTvars["bg"].b, KHTvars["bg"].a);
	KHunterTimersOptionsBarsColor3Swatch.r = KHTvars["bg"].r;
	KHunterTimersOptionsBarsColor3Swatch.g = KHTvars["bg"].g;
	KHunterTimersOptionsBarsColor3Swatch.b = KHTvars["bg"].b;
	KHunterTimersOptionsBarsColor3Swatch.a = KHTvars["bg"].a;
	KHunterTimersOptionsBarsColor4Swatch:SetVertexColor( unpack( KHTvars["borderalpha"]) );
	KHunterTimersOptionsBarsColor4Swatch.r, KHunterTimersOptionsBarsColor4Swatch.g, KHunterTimersOptionsBarsColor4Swatch.b, KHunterTimersOptionsBarsColor4Swatch.a = unpack( KHTvars["borderalpha"] );
	KHunterTimersOptionsBarsColor5Swatch:SetVertexColor(unpack(KHTvars["skillcolor"]));
	KHunterTimersOptionsBarsColor5Swatch.r, KHunterTimersOptionsBarsColor5Swatch.g, KHunterTimersOptionsBarsColor5Swatch.b, KHunterTimersOptionsBarsColor5Swatch.a = unpack( KHTvars["skillcolor"] );
	KHunterTimersOptionsBarsColor6Swatch:SetVertexColor(unpack(KHTvars["timecolor"]));
	KHunterTimersOptionsBarsColor6Swatch.r, KHunterTimersOptionsBarsColor6Swatch.g, KHunterTimersOptionsBarsColor6Swatch.b, KHunterTimersOptionsBarsColor6Swatch.a = unpack( KHTvars["timecolor"] );
	KHunterTimersOptionsBarsColor7Swatch:SetVertexColor(unpack(KHTvars["targetcolor"]));
	KHunterTimersOptionsBarsColor7Swatch.r, KHunterTimersOptionsBarsColor7Swatch.g, KHunterTimersOptionsBarsColor7Swatch.b, KHunterTimersOptionsBarsColor7Swatch.a = unpack( KHTvars["targetcolor"] );
	
	KHunterTimersOptionsBarsSlider1Slider:SetValue(KHTvars["bardistance"]);
	KHunterTimersOptionsBarsSlider2Slider:SetValue(KHTvars["scale"]/UIParent:GetScale());
	KHunterTimersOptionsBarsSlider3Slider:SetValue(KHTvars["mili"]);
	KHunterTimersOptionsBarsSlider4Slider:SetValue(KHTvars["flash"]);
	KHunterTimersOptionsBarsSlider5Slider:SetValue(KHTvars["step"]);
	KHunterTimersOptionsBarsSlider6Slider:SetValue(KHTvars["overallalpha"]);
	KHunterTimersOptionsBarsSlider7Slider:SetValue(KHTvars["barheight"]);
	
	KHunterTimersOptions:Show();
end

function KHunterTimers_SaveOptions()

	for i=1, KHT_NUM_TIMERS do
		if( getglobal("KHunterTimersOptionsTimersCheckButton"..i):GetChecked() == 1 ) then
			KHTvars["skills"][KHT_OPTIONS_TIMERS[i]] = true;
		else
			KHTvars["skills"][KHT_OPTIONS_TIMERS[i]] = false;
		end
	end
	
	if( KHunterTimersOptionsBarsCheckButtonOn:GetChecked() == 1 ) then
		KHTvars[KHT_ON] = true;
	else
		KHTvars[KHT_ON] = false;
	end
	
	if( KHunterTimersOptionsBarsCheckButton1:GetChecked() == 1 ) then
		KHTvars["locked"] = true;
		KHunterTimersAnchor:Hide();
	else
		KHTvars["locked"] = false;
		KHunterTimersAnchor:Show();
	end
	
	if( KHunterTimersOptionsBarsCheckButton2:GetChecked() == 1 ) then
		KHTvars["colorchange"] = true;
	else
		KHTvars["colorchange"] = false;
	end
	
	if( KHunterTimersOptionsBarsCheckButton3:GetChecked() == 1 ) then
		KHTvars["showtex"] = true;
	else
		KHTvars["showtex"] = false;
	end

	if( KHunterTimersOptionsBarsCheckButton4:GetChecked() == 1 ) then
		KHTvars["largetex"] = true;
	else
		KHTvars["largetex"] = false;
	end

	if( KHunterTimersOptionsBarsCheckButton5:GetChecked() == 1 ) then
		KHTvars["gap"] = false;
	else
		KHTvars["gap"] = true;
	end

	if( KHunterTimersOptionsBarsCheckButton6:GetChecked() == 1 ) then
		KHTvars["append"] = true;
	else
		KHTvars["append"] = false;
	end

	if( KHunterTimersOptionsBarsCheckButton7:GetChecked() == 1 ) then
		KHTvars["padding"] = false;
	else
		KHTvars["padding"] = true;
	end
	
	if( KHunterTimersOptionsBarsCheckButton8:GetChecked() == 1 ) then
		KHTvars["hidetext"] = true;
	else
		KHTvars["hidetext"] = false;
	end

	if( KHunterTimersOptionsBarsCheckButton9:GetChecked() == 1 ) then
		KHTvars["hidetime"] = true;
	else
		KHTvars["hidetime"] = false;
	end

	if( KHunterTimersOptionsBarsCheckButton10:GetChecked() == 1 ) then
		KHTvars["sticky"] = true;
	else
		KHTvars["sticky"] = false;
	end

	if( KHunterTimersOptionsBarsCheckButton11:GetChecked() == 1 ) then
		KHTvars["down"] = true;
	else
		KHTvars["down"] = false;
	end

	KHTvars["shotdelay"] = 1*KHunterTimersOptionsBarsEditBox1:GetText();
	
	KHTvars["barstartcolor"][1] = KHunterTimersOptionsBarsColor1Swatch.r; 
	KHTvars["barstartcolor"][2] = KHunterTimersOptionsBarsColor1Swatch.g; 
	KHTvars["barstartcolor"][3] = KHunterTimersOptionsBarsColor1Swatch.b;
	KHTvars["barstartcolor"][4] = KHunterTimersOptionsBarsColor1Swatch.a;
	KHTvars["bardelta"][1] = KHunterTimersOptionsBarsColor2Swatch.r - KHunterTimersOptionsBarsColor1Swatch.r;
	KHTvars["bardelta"][2] = KHunterTimersOptionsBarsColor2Swatch.g - KHunterTimersOptionsBarsColor1Swatch.g;
	KHTvars["bardelta"][3] = KHunterTimersOptionsBarsColor2Swatch.b - KHunterTimersOptionsBarsColor1Swatch.b;
	KHTvars["bardelta"][4] = KHunterTimersOptionsBarsColor2Swatch.a - KHunterTimersOptionsBarsColor1Swatch.a;
	KHTvars["borderalpha"][1] = KHunterTimersOptionsBarsColor4Swatch.r;
	KHTvars["borderalpha"][2] = KHunterTimersOptionsBarsColor4Swatch.g;
	KHTvars["borderalpha"][3] = KHunterTimersOptionsBarsColor4Swatch.b;
	KHTvars["borderalpha"][4] = KHunterTimersOptionsBarsColor4Swatch.a;
	KHTvars["skillcolor"][1] = KHunterTimersOptionsBarsColor5Swatch.r;
	KHTvars["skillcolor"][2] = KHunterTimersOptionsBarsColor5Swatch.g;
	KHTvars["skillcolor"][3] = KHunterTimersOptionsBarsColor5Swatch.b;
	KHTvars["skillcolor"][4] = KHunterTimersOptionsBarsColor5Swatch.a;
	KHTvars["timecolor"][1] = KHunterTimersOptionsBarsColor6Swatch.r;
	KHTvars["timecolor"][2] = KHunterTimersOptionsBarsColor6Swatch.g;
	KHTvars["timecolor"][3] = KHunterTimersOptionsBarsColor6Swatch.b;
	KHTvars["timecolor"][4] = KHunterTimersOptionsBarsColor6Swatch.a;
	KHTvars["targetcolor"][1] = KHunterTimersOptionsBarsColor7Swatch.r;
	KHTvars["targetcolor"][2] = KHunterTimersOptionsBarsColor7Swatch.g;
	KHTvars["targetcolor"][3] = KHunterTimersOptionsBarsColor7Swatch.b;
	KHTvars["targetcolor"][4] = KHunterTimersOptionsBarsColor7Swatch.a;
	
	KHTvars["bg"].r = KHunterTimersOptionsBarsColor3Swatch.r;
	KHTvars["bg"].g = KHunterTimersOptionsBarsColor3Swatch.g;
	KHTvars["bg"].b = KHunterTimersOptionsBarsColor3Swatch.b;
	KHTvars["bg"].a = KHunterTimersOptionsBarsColor3Swatch.a;
	
	KHTvars["bardistance"] = KHunterTimersOptionsBarsSlider1Slider:GetValue();
	KHTvars["scale"] = KHunterTimersOptionsBarsSlider2Slider:GetValue()*UIParent:GetScale();
	KHTvars["mili"] = KHunterTimersOptionsBarsSlider3Slider:GetValue();
	KHTvars["flash"] = KHunterTimersOptionsBarsSlider4Slider:GetValue();
	KHTvars["step"] = KHunterTimersOptionsBarsSlider5Slider:GetValue();
	KHTvars["overallalpha"] = KHunterTimersOptionsBarsSlider6Slider:GetValue();
	KHTvars["barheight"] = KHunterTimersOptionsBarsSlider7Slider:GetValue();
	
	KHunterTimers_SetSettings();
	
end

function KHunterTimers_SaveCloseOptions()
	
	KHunterTimers_SaveOptions();
	KHunterTimersOptions:Hide();

end

function KHunterTimers_ResetOptions()

	KHTvars = {};
	
	KHTvars["version"] = 2.0;

	KHTvars["bg"] = { r=0, g=0, b=0, a=7 };

	KHTvars[KHT_ON] = true;

	KHTvars["borderalpha"] = {
		[1] = 1;
		[2] = 1;
		[3] = 1;
		[4] = 1;
	};

	KHunterTimersFrame:SetBackdropColor( KHTvars["bg"].r, KHTvars["bg"].g, KHTvars["bg"].b, KHTvars["bg"].a );
	KHunterTimersFrame:SetBackdropBorderColor( unpack(KHTvars["borderalpha"]) );
	KHTvars["numBars"] = 0;

	KHTvars["skills"] = {};

	for i=1, KHT_NUM_TIMERS do
		if( KHTvars["skills"][KHT_OPTIONS_TIMERS[i]] == nil ) then
			KHTvars["skills"][KHT_OPTIONS_TIMERS[i]] = true;
		end
	end
	
	KHTvars["shotdelay"] = 200;

	KHTvars["scale"] = UIParent:GetScale();

	KHTvars["locked"] = false;
	KHunterTimersAnchor:Show();

	KHTvars["bardistance"] = 10;

	KHTvars["down"] = true;

	KHTvars["mili"] = 1;

	KHTvars["flash"] = 5;
	
	local r, g, b = KHunterTimersStatus1BarLeftText:GetTextColor();
	KHTvars["skillcolor"] = {
		[1] = r,
		[2] = g,
		[3] = b,
		[4] = 1
	};

	local r, g, b = KHunterTimersStatus1BarRightText:GetTextColor();
	KHTvars["timecolor"] = {
		[1] = r,
		[2] = g,
		[3] = b,
		[4] = 1
	};

	local r, g, b = KHunterTimersStatus1BarLeftText:GetTextColor();
	KHTvars["targetcolor"] = {
		[1] = r,
		[2] = g,
		[3] = b,
		[4] = 1
	};

	KHTvars["barstartcolor"] = {
		[1] = 0,
		[2] = 0.8,
		[3] = 0,
		[4] = 1
	};

	KHTvars["bardelta"] = {
		[1] = 0.8,
		[2] = -0.8,
		[3] = 0,
		[4] = 0};

	KHTvars["step"] = 0.03;

	KHTvars["colorchange"] = false;

	KHTvars["append"] = false;

	KHTvars["overallalpha"] = 1;
	
	KHunterTimers_ClearActiveSpells();
	
	for i=1, KHT_NUM_TIMERS do --Check boxes
		getglobal("KHunterTimersOptionsTimersCheckButton"..i.."Text"):SetText(KHT_OPTIONS_TIMERS[i]);
	end
	
	for i=1, KHT_NUM_OPTIONS do --Check boxes
		getglobal("KHunterTimersOptionsBarsCheckButton"..i.."Text"):SetText(KHT_OPTIONS_BARS[i]);
	end
	
	for i=1, KHT_NUM_SLIDERS do  --Sliders
		getglobal("KHunterTimersOptionsBarsSlider"..i.."SliderTitle"):SetText(KHT_OPTIONS_SLIDER[i]);
		getglobal("KHunterTimersOptionsBarsSlider"..i.."SliderLow"):SetText(KHT_OPTIONS_SLIDER_ENDS[i][1])
		getglobal("KHunterTimersOptionsBarsSlider"..i.."SliderHigh"):SetText(KHT_OPTIONS_SLIDER_ENDS[i][2]);
	end
	
	KHTvars["textures"] = {};
	KHunterTimers_UpdateSpells();
	
	KHTvars["showtex"] = true;

	KHTvars["largetex"] = true;

	KHTvars["hidetext"] = false;

	KHTvars["hidetime"] = false;

	KHTvars["gap"] = true;

	KHTvars["padding"] = true;

	KHTvars["barheight"] = 10;

	KHTvars["sticky"] = true;
	
	local _, _, _, _, rank = GetTalentInfo( 3, 8 ); --Clever traps
	KHTvars["traptimemult"] = 1 + (rank * 0.15);
	
	getglobal("KHunterTimersOptionsTimersLabel1Label"):SetText(KHT_OPTIONS_TIMERS_TEXT);

	for i=1, KHT_NUM_LABELS do
		getglobal("KHunterTimersOptionsBarsLabel"..i.."Label"):SetText(KHT_OPTIONS_LABELS[i]);
	end
	
	getglobal("KHunterTimersOptionsTitleString"):SetText("Kharthus's Hunter Timers "..KHT_VERSION);
	
	KHunterTimers_SetSettings();
	
end

function KHunterTimers_SetSettings()
	
	KHunterTimersFrame:SetBackdropColor(KHTvars["bg"].r, KHTvars["bg"].g, KHTvars["bg"].b, KHTvars["bg"].a);
	KHunterTimersFrame:SetBackdropBorderColor(unpack(KHTvars["borderalpha"] ) );
	
	for i=1, KHT_NUM_BARS do
		local barframe = getglobal("KHunterTimersStatus"..i);
		local bar = getglobal( "KHunterTimersStatus"..i.."Bar");
		local bg = getglobal( "KHunterTimersStatus"..i.."BGBar");
		local tt = getglobal( "KHunterTimersStatus"..i.."BarTooltip");
		local barwidth = 220;
		
		barframe:SetHeight( KHTvars["barheight"] );
		bar:SetHeight( KHTvars["barheight"] );
		bg:SetHeight( KHTvars["barheight"] );
		tt:SetHeight( KHTvars["barheight"] );
		local icon = getglobal("KHunterTimersStatus"..i.."Icon");
		if( KHTvars["showtex"] ) then
			
			icon:Show();
			if( KHTvars["gap"] ) then
				barwidth = barwidth - 5;
			end
			if( KHTvars["largetex"] ) and ( KHTvars["barheight"] < 16) then
				barframe:SetHeight(16);
				icon:SetHeight(16);
				icon:SetWidth(16);
				barwidth = barwidth - 16;
			else
				icon:SetHeight( KHTvars["barheight"] );
				icon:SetWidth( KHTvars["barheight"] );
				barwidth = barwidth - KHTvars["barheight"];
			end
			
			bar:ClearAllPoints();
			if( KHTvars["gap"] ) then
				bar:SetPoint("LEFT", "KHunterTimersStatus"..i.."Icon", "RIGHT", 5, 0 );
			else
				bar:SetPoint("LEFT", "KHunterTimersStatus"..i.."Icon", "RIGHT", 0, 0 );
			end
			bg:ClearAllPoints();
			if( KHTvars["gap"] ) then
				bg:SetPoint("LEFT", "KHunterTimersStatus"..i.."Icon", "RIGHT", 5, 0 );
			else
				bg:SetPoint("LEFT", "KHunterTimersStatus"..i.."Icon", "RIGHT", 0, 0 );
			end
			tt:ClearAllPoints();
			if( KHTvars["gap"] ) then
				tt:SetPoint("LEFT", "KHunterTimersStatus"..i.."Icon", "RIGHT", 5, 0 );
			else
				tt:SetPoint("LEFT", "KHunterTimersStatus"..i.."Icon", "RIGHT", 0, 0 );
			end
		else
			icon:Hide();
			bar:SetPoint("LEFT", "KHunterTimersStatus"..i, "LEFT", 0, 0 );
			bg:SetPoint("LEFT", "KHunterTimersStatus"..i, "LEFT", 0, 0 );
			tt:SetPoint("LEFT", "KHunterTimersStatus"..i, "LEFT", 0, 0 );
		end
		barframe:SetWidth(220);
		bar:SetWidth(barwidth);
		bg:SetWidth(barwidth);
		tt:SetWidth(barwidth);
		if( KHTvars["hidetext"] ) then
			getglobal("KHunterTimersStatus"..i.."BarLeftText"):Hide();
		else
			getglobal("KHunterTimersStatus"..i.."BarLeftText"):Show();
		end
		if( KHTvars["hidetime"] ) then
			getglobal("KHunterTimersStatus"..i.."BarRightText"):Hide();
		else
			getglobal("KHunterTimersStatus"..i.."BarRightText"):Show();
		end
	end
	
	
	local height;
	local padding;
	if( not KHTvars["largetex"] ) or ( KHTvars["barheight"] >= 16 ) then
		height = KHTvars["numBars"] * (KHTvars["barheight"] + KHTvars["bardistance"]) - KHTvars["bardistance"] + 10;
	else
		height = KHTvars["numBars"] * (16 + KHTvars["bardistance"]) - KHTvars["bardistance"] + 10;
	end
	
	if( KHTvars["padding"] ) then
		KHunterTimersFrame:SetWidth( 240 );
		padding = 10;
		height = height + 10;
	else
		KHunterTimersFrame:SetWidth( 230 );
		padding = 5;
	end
	
	KHunterTimersFrame:SetHeight(height);
	
	if( KHTvars["down"] ) then
		KHunterTimersFrame:ClearAllPoints();
		KHunterTimersFrame:SetPoint( "TOPLEFT", "KHunterTimersAnchor", "BOTTOMLEFT" );
		KHunterTimersStatus1:ClearAllPoints();
		KHunterTimersStatus1:SetPoint( "TOPLEFT", "KHunterTimersFrame", "TOPLEFT", padding, -padding );
		for i=2, KHT_NUM_BARS do
			getglobal("KHunterTimersStatus"..i):ClearAllPoints();
			getglobal("KHunterTimersStatus"..i):SetPoint( "TOP", "KHunterTimersStatus"..(i-1), "BOTTOM", 0, -KHTvars["bardistance"] );
		end
	else
		KHunterTimersFrame:ClearAllPoints();
		KHunterTimersFrame:SetPoint( "BOTTOMLEFT", "KHunterTimersAnchor", "TOPLEFT" );
		KHunterTimersStatus1:ClearAllPoints();
		KHunterTimersStatus1:SetPoint( "BOTTOMLEFT", "KHunterTimersFrame", "BOTTOMLEFT", padding, padding );
		for i=2, KHT_NUM_BARS do
			getglobal("KHunterTimersStatus"..i):ClearAllPoints();
			getglobal("KHunterTimersStatus"..i):SetPoint( "BOTTOM", "KHunterTimersStatus"..(i-1), "TOP", 0, KHTvars["bardistance"] );
		end
	end

	KHunterTimersFrame:SetScale( KHTvars["scale"] );
	KHunterTimersFrame:SetAlpha( KHTvars["overallalpha"] );
	for i=1, KHT_NUM_BARS do
		getglobal("KHunterTimersStatus"..i):SetScale( KHTvars["scale"] );
		getglobal("KHunterTimersStatus"..i):SetAlpha( KHTvars["overallalpha"] );
	end

end

function KHT_SetHeight()
	local height; 
	if( not KHTvars["largetex"] ) or ( KHTvars["barheight"] >= 16 ) then
		height = KHTvars["numBars"] * (KHTvars["barheight"] + KHTvars["bardistance"]) - KHTvars["bardistance"] + 10;
	else
		height = KHTvars["numBars"] * (16 + KHTvars["bardistance"]) - KHTvars["bardistance"] + 10;
	end
	
	if( KHTvars["padding"] ) then
		height = height + 10;
	end
	
	KHunterTimersFrame:SetHeight(height);
	KHunterTimers_SetWidths();
end

function KHunterTimers_UpdateSpells()

	for key,val in pairs(KHTvars["skills"]) do
		local i = 1;
		while( GetSpellTexture(i, BOOKTYPE_SPELL) ) do
			local spellName = GetSpellName(i, BOOKTYPE_SPELL);
			if( spellName == key ) then
				KHTvars["textures"][key] = GetSpellTexture(i, BOOKTYPE_SPELL);
				break;
			end
			i = i + 1;
		end
	end

	-- Racials
	KHTvars["textures"][KHT_BERSERKING]		= GetSpellTexture(KHT_BERSERKING);
	KHTvars["textures"][KHT_BLOOD_FURY]		= GetSpellTexture(KHT_BLOOD_FURY);
	KHTvars["textures"][KHT_STONEFORM]			= GetSpellTexture(KHT_STONEFORM);
	KHTvars["textures"][KHT_WAR_STOMP]			= GetSpellTexture(KHT_WAR_STOMP);
	KHTvars["textures"][KHT_ARCANE]			= GetSpellTexture(KHT_ARCANE);

	-- Set/Item Procs
	KHTvars["textures"][KHT_EXPOSE_WEAKNESS]	= "Interface\\Icons\\Ability_Hunter_SniperShot";
	KHTvars["textures"][KHT_PRIMAL_BLESSING]	= "Interface\\Icons\\Ability_Hunter_Harass";
	KHTvars["textures"][KHT_SANTOS]			= "Interface\\Icons\\Spell_Arcane_PrismaticCloak";
	KHTvars["textures"][KHT_HEROIC]			= "Interface\\Icons\\Spell_Holy_Heroism";
	KHTvars["textures"][KHT_SKYFIRE]			= "Interface\\Icons\\Ability_Hunter_SerpentSwiftness";
	KHTvars["textures"][KHT_BEASTLORD]			= "Interface\\Icons\\Ability_Hunter_AimedShot";
	KHTvars["textures"][KHT_CHAMPION]			= "Interface\\Icons\\Ability_Warrior_InnerRage";

	-- Talent Procs
	KHTvars["textures"][KHT_ENTRAPMENT]		= "Interface\\Icons\\Spell_Nature_StrangleVines";
	KHTvars["textures"][KHT_QUICK_SHOTS]		= "Interface\\Icons\\Ability_Warrior_InnerRage";
	KHTvars["textures"][KHT_FEROCIOUS]			= "Interface\\Icons\\Ability_Hunter_FerociousInspiration";
	KHTvars["textures"][KHT_RAPID_KILLING]		= "Interface\\Icons\\Ability_Hunter_RapidKilling";
	KHTvars["textures"][KHT_TACTICIAN]			= "Interface\\Icons\\Ability_Hunter_MasterTactitian";
	KHTvars["textures"][KHT_CONC_BARRAGE]		= "Interface\\Icons\\Spell_Frost_Stun";
	KHTvars["textures"][KHT_AIMED_SHOT]		= GetSpellTexture(KHT_AIMED_SHOT);
	
	-- Trinkets
	KHTvars["textures"][KHT_DEVILSAUR]			= "Interface\\Icons\\Ability_Hunter_Pet_Raptor";
	KHTvars["textures"][KHT_ZHM]				= "Interface\\Icons\\INV_Jewelry_Necklace_13";
	KHTvars["textures"][KHT_EARTHSTRIKE]		= "Interface\\Icons\\Spell_Nature_AbolishMagic";
	KHTvars["textures"][KHT_SWARMGUARD]		= "Interface\\Icons\\INV_Misc_AhnQirajTrinket_04";
	KHTvars["textures"][KHT_JOM_GABBAR]		= "Interface\\Icons\\Ability_Poisons";
	KHTvars["textures"][KHT_KISS_SPIDER]		= "Interface\\Icons\\INV_Trinket_Naxxramas04";
	KHTvars["textures"][KHT_FEROCITY]			= "Interface\\Icons\\Spell_Holy_MindVision";
	KHTvars["textures"][KHT_BURNING_HATRED]		= "Interface\\Icons\\INV_Jewelry_Talisman_04";
	KHTvars["textures"][KHT_ANCIENT_POWER]		= "Interface\\Icons\\Spell_Nature_AbolishMagic";
	KHTvars["textures"][KHT_NIGHTSEYE]			= "Interface\\Icons\\INV_Jewelcrafting_BlackPearlPanther";
	KHTvars["textures"][KHT_UNRAVELLER]		= "Interface\\Icons\\Racial_Orc_BerserkerStrength";
	KHTvars["textures"][KHT_LUST]				= "Interface\\Icons\\Spell_Shadow_DeathPact";
	KHTvars["textures"][KHT_HASTE]			= "Interface\\Icons\\Ability_Whirlwind";
	KHTvars["textures"][KHT_HEROISM]			= "Interface\\Icons\\Spell_Holy_MindVision";
	KHTvars["textures"][KHT_TSUNAMI]			= "Interface\\Icons\\Spell_Nature_UnrelentingStorm";
	KHTvars["textures"][KHT_ASHTONGUE]			= "Interface\\Icons\\Ability_Hunter_MasterMarksman";
	KHTvars["textures"][KHT_WRATH]			= "Interface\\Icons\\INV_Misc_Head_Dragon_Blue";
	KHTvars["textures"][KHT_DELUSIONAL]		= "Interface\\Icons\\Ability_Warrior_EndlessRage";
	KHTvars["textures"][KHT_KLEPTOMANIA]		= "Interface\\Icons\\INV_Misc_Bag_11";
	KHTvars["textures"][KHT_MANIC]			= "Interface\\Icons\\Ability_Rogue_Sprint";
	KHTvars["textures"][KHT_MARTYR]			= "Interface\\Icons\\Spell_Holy_SymbolOfHope";
	KHTvars["textures"][KHT_NARCISSISM]		= "Interface\\Icons\\Spell_Holy_DivinePurpose";
	KHTvars["textures"][KHT_PARANOIA]			= "Interface\\Icons\\Spell_Shadow_AuraOfDarkness";
	KHTvars["textures"][KHT_TALON]			= "Interface\\Icons\\Ability_ImpalingBolt";
	KHTvars["textures"][KHT_SKYGUARD]			= "Interface\\Icons\\INV_Jewelry_Talisman_06";
	KHTvars["textures"][KHT_MADNESS]			= "Interface\\Icons\\Ability_Warrior_WeaponMastery";
	KHTvars["textures"][KHT_BERSERKER]			= "Interface\\Icons\\Racial_Troll_Berserk";

	-- Other
	KHTvars["textures"][KHT_FRENZY]			= "Interface\\Icons\\Ability_Druid_ChallangingRoar";
	KHTvars["textures"][KHT_PET_FRENZY]		= "Interface\\Icons\\INV_Misc_MonsterClaw_03";
	KHTvars["textures"][KHT_SCREECH]			= "Interface\\Icons\\Ability_Hunter_Pet_Bat";
	
end

function KHunterTimers_ClearActiveSpells()

	khtAutoShot = false;
	khtImpConc = false;
	khtRapidFire = false;
	khtQuickShots = false;
	khtPetIntim = false;
	khtIntimidation = false;
	khtWingClip = false;
	khtImpWing = false;
	khtFreezing = false;
	khtScatter = false;
	khtWyvern = false;
	khtFearBeast = false;
	khtExposeWeakness = false;
	khtHuntersMark = false;
	khtPrimalBlessing = false;
	khtEntrapment = false;
	khtJomGabbar = false;
	khtFerocious = false;
	khtTactician = false;
	khtConcBarrage = false;
	khtWrath = false;
	khtPetFrenzy = false;
	khtHaste = false;
	khtSkyguard = false;
	khtBeastLord = false;
	khtAshtongue = false;
	khtMadness = false;
	khtChampion = false;
	khtAimedShot = false;
	khtScreech = false;

end

local KHTSetColorFunc = {
	[1] = function() KHTSetColor(1) end,
	[2] = function() KHTSetColor(2) end,
	[3] = function() KHTSetColor(3) end,
	[4] = function() KHTSetColor(4) end,
	[5] = function() KHTSetColor(5) end,
	[6] = function() KHTSetColor(6) end,
	[7] = function() KHTSetColor(7) end
};

local KHTSetOpacityFunc = {
	[1] = function() KHTSetOpacity(1) end,
	[2] = function() KHTSetOpacity(2) end,
	[3] = function() KHTSetOpacity(3) end,
	[4] = function() KHTSetOpacity(4) end,
	[5] = function() KHTSetOpacity(5) end,
	[6] = function() KHTSetOpacity(6) end,
	[7] = function() KHTSetOpacity(7) end
};

local KHTCancelFunc = {
	[1] = function(x) KHTCancelColor(1, x) end,
	[2] = function(x) KHTCancelColor(2, x) end,
	[3] = function(x) KHTCancelColor(3, x) end,
	[4] = function(x) KHTCancelColor(4, x) end,
	[5] = function(x) KHTCancelColor(5, x) end,
	[6] = function(x) KHTCancelColor(6, x) end,
	[7] = function(x) KHTCancelColor(7, x) end
};

function KHT_ColorPicker(id)
	CloseMenus();
	local texture = getglobal("KHunterTimersOptionsBarsColor"..id.."Swatch");
	ColorPickerFrame.func = KHTSetColorFunc[id];
	ColorPickerFrame:SetColorRGB(texture.r, texture.g, texture.b);
	ColorPickerFrame.previousValues = {r = texture.r, g = texture.g, b = texture.b, opacity =texture.a};
	ColorPickerFrame.cancelFunc = KHTCancelFunc[id];
	if( id < 5 ) then
		ColorPickerFrame.hasOpacity = true;
		ColorPickerFrame.opacity = 1 - texture.a;
		ColorPickerFrame.opacityFunc = KHTSetOpacityFunc[id];
	else
		ColorPickerFrame.hasOpacity = false;
	end
	
	
	--OpacityFrame.opacityFunc = KHTSetOpacityFunc[id];
	
	ColorPickerFrame:Show();
end

function KHTSetOpacity(id)
	local a = 1 - OpacitySliderFrame:GetValue();
	local texture = getglobal("KHunterTimersOptionsBarsColor"..id.."Swatch");
	--DEFAULT_CHAT_FRAME:AddMessage(id);
	texture:SetAlpha(a);
	texture.a = a;
end

function KHTSetColor(id)
	local r, g, b = ColorPickerFrame:GetColorRGB();
	local texture = getglobal("KHunterTimersOptionsBarsColor"..id.."Swatch");
	--KHTSetOpacity(id);
	texture:SetVertexColor(r, g, b);
	texture.r = r;
	texture.g = g;
	texture.b = b;
end

function KHTCancelColor(id, prev)
	local texture = getglobal("KHunterTimersOptionsBarsColor"..id.."Swatch");
	local r = prev.r;
	local g = prev.g;
	local b = prev.b;
	local a = prev.opacity;
	texture:SetVertexColor(r, g, b);
	texture:SetAlpha( a );
	texture.r = r;
	texture.g = g;
	texture.b = b;
	texture.a = a;
end

function KHTColor(r, g, b, a)
	if( not a ) then
		a = 1;
	end
	return string.format("|c%02x%02x%02x%02x", (a*255), (r*255), (g*255), (b*255));
end

function KHunterTimers_Tooltip( barframe )
	--DEFAULT_CHAT_FRAME:AddMessage(barframe:GetName());
	if( barframe.target ) then
		GameTooltip_SetDefaultAnchor(GameTooltip, barframe);
		GameTooltip:ClearLines();
		GameTooltip:AddLine( barframe.target );
		GameTooltip:Show();
	end
end

function KHunterTimers_RacialsTooltip( button )
	GameTooltip_SetDefaultAnchor(GameTooltip, button);
	GameTooltip:ClearLines();
	GameTooltip:AddLine( "Racials" );
	GameTooltip:AddLine( " " );
	GameTooltip:AddLine( "Arcane Torrent" );
	GameTooltip:AddLine( "Berserking" );
	GameTooltip:AddLine( "Blood Fury" );
	GameTooltip:AddLine( "Stoneform" );
	GameTooltip:AddLine( "War Stomp" );
	GameTooltip:Show();
end

function KHunterTimers_SetItemTooltip( button )
	GameTooltip_SetDefaultAnchor(GameTooltip, button);
	GameTooltip:ClearLines();
	GameTooltip:AddLine( "Set/Item Procs" );
	GameTooltip:AddLine( " " );
	GameTooltip:AddLine( "Band of the Eternal Champion" );
	GameTooltip:AddLine( "Exploited Weakness" );
	GameTooltip:AddLine( "Expose Weakness" );
	GameTooltip:AddLine( "Heroic Resolution" );
	GameTooltip:AddLine( "Primal Blessing" );
	GameTooltip:AddLine( "Santos' Blessing" );
	GameTooltip:AddLine( "Skyfire Swiftness" );
	GameTooltip:Show();
end

function KHunterTimers_TalentTooltip( button )
	GameTooltip_SetDefaultAnchor(GameTooltip, button);
	GameTooltip:ClearLines();
	GameTooltip:AddLine( "Talent Procs" );
	GameTooltip:AddLine( " " );
	GameTooltip:AddLine( "Aimed Shot" );
	GameTooltip:AddLine( "Concussive Barrage" );
	GameTooltip:AddLine( "Expose Weakness" );
	GameTooltip:AddLine( "Ferocious Inspiration" );
	GameTooltip:AddLine( "Master Tactician" );
	GameTooltip:AddLine( "Quick Shots" );
	GameTooltip:AddLine( "Rapid Killing" );
	GameTooltip:Show();
end

function KHunterTimers_TrinketsTooltip( button )
	GameTooltip_SetDefaultAnchor(GameTooltip, button);
	GameTooltip:ClearLines();
	GameTooltip:AddLine( "Trinkets" );
	GameTooltip:AddLine( " " );
	GameTooltip:AddLine( "Abacus of the Violent Odds" );
	GameTooltip:AddLine( "Ancient Draenei War Talisman" );
	GameTooltip:AddLine( "Ashtongue Talisman of Swiftness" );
	GameTooltip:AddLine( "Badge of the Swarmguard" );
	GameTooltip:AddLine( "Bladefist's Breath" );
	GameTooltip:AddLine( "Bloodlust Brooch" );
	GameTooltip:AddLine( "Call of the Berserker" );
	GameTooltip:AddLine( "Core of Ar'kelos" );
	GameTooltip:AddLine( "Darkmoon Card: Madness" );
	GameTooltip:AddLine( "Darkmoon Card: Wrath" );
	GameTooltip:AddLine( "Devilsaur Eye" );
	GameTooltip:AddLine( "Dragonspine Trophy" );
	GameTooltip:AddLine( "Earthstrike" );
	GameTooltip:AddLine( "Hourglass of the Unraveller" );
	GameTooltip:AddLine( "Jom Gabbar" );
	GameTooltip:AddLine( "Kiss of the Spider" );
	GameTooltip:AddLine( "Madness of the Betrayer" );
	GameTooltip:AddLine( "Nightseye Panther" );
	GameTooltip:AddLine( "Ogre Mauler's Badge" );
	GameTooltip:AddLine( "Skyguard Silver Cross" );
	GameTooltip:AddLine( "Talon of Al'ar" );
	GameTooltip:AddLine( "Terrokar Tablet of Precision" );
	GameTooltip:AddLine( "Tsunami Talisman" );
	GameTooltip:AddLine( "Uniting Charm" );
	GameTooltip:AddLine( "Zandalarian Hero Medallion" );
	GameTooltip:Show();
end

function KHT_sfind( s, pattern )
	for p in string.gmatch( pattern, "([^|]+)" ) do
		if( string.find( s, p ) )then
			return string.find( s, p );
		end
	end
	return false;
end
