KC_Items = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceModuleCore-2.0", "AceHook-2.1", "AceDB-2.0", "AceConsole-2.0")
 
local ttHandler = {}
 
function KC_Items:OnInitialize()
    self:RegisterDB("KC_ItemsDB") 
    self.dewdrop = AceLibrary("Dewdrop-2.0")
    self.tablet = AceLibrary("Tablet-2.0")
    
    self.options = {
        type = 'group',
        args = {},
    }
    
    self:RegisterChatCommand({"/kci", "/kc_items", "/kcitems"}, self.options)
    self:BuildConfigPanel()
    self:HookTooltips()
    ttHandler:OnInitialize()
    
    local func = function(object, ...) ttHandler:OnTooltipHide(object) if self.hooks[object] then return self.hooks[object].OnHide(object, ...) end end
    self:HookScript(GameTooltip, "OnHide", func)
    self:HookScript(ItemRefTooltip, "OnHide", func)
end 

local module = KC_Items.modulePrototype


function KC_Items:BuildConfigPanel()
    --[[self.frame = module:CreateHasteFrame(UIParent, 130, 500, "KC Items", true)
    self.frame.buttons = {}
    
    self.frame.buttons.fence = module:CreateHasteButton(self.frame, 120, 28, "Fence", Fence.options, true, "TOP", self.frame, "TOP", 0, -35)
    
    self.frame:Hide()]]
end

function module:RegisterDewdrop(args, parent, left)
	KC_Items.dewdrop:Register(parent,
			'children', args,
			'point', function(parent)
				if parent:GetTop() < GetScreenHeight() / 2 then
					return "BOTTOMRIGHT", "TOPRIGHT"
				else
					return "TOPRIGHT", "BOTTOMRIGHT"
				end
			end,
            left and 'donthook' or nil, left and true or nil
		)
    if left then
        parent:SetScript("OnClick", function(this) 
            if KC_Items.dewdrop:IsOpen(this) then 
                KC_Items.dewdrop:Close() 
            else 
                KC_Items.dewdrop:Open(this) 
            end 
        end)
    end
end

function module:AddDelayedTooltip(target, header, text, delay)
	if (not self.tablet) then self.tablet = AceLibrary('Tablet-2.0') end
	target:SetScript('OnEnter',
		function() self:ScheduleEvent(tostring(target),
			function()
				self.tablet:Register(target,'point', function() return "TOPLEFT", "BOTTOM" end, 'children', function()
					self.tablet:SetTitle(header)
					self.tablet:SetTitleColor(.2, 0, 1)
					local cat = self.tablet:AddCategory()
                    if type(text) == "table" then
                        for k, v in pairs(text) do
                            cat:AddLine("text", v)
                        end
                    else
                        cat:AddLine("text", text)
                    end
					end)
				end,
			delay or 1) 
		end)
	target:SetScript('OnLeave',
		function() 
			if (self:IsEventScheduled(tostring(target))) then self:CancelScheduledEvent(tostring(target)) end
			self.tablet:Close() 
			if (self.tablet:IsRegistered(target)) then self.tablet:Unregister(target) end
		end)
end 

function module:CreateQMark(parent, font, ...)
    local qmark = CreateFrame("Button", nil, parent)
    
    qmark:SetTextFontObject(font or GameFontNormalLarge)
    qmark:SetTextColor(.2, 0, 1)
    qmark:SetText("?")
    qmark:SetHeight(10)
    qmark:SetWidth(10)
    if select("#",...) > 0 then qmark:SetPoint(...) end
    
    return qmark
end

function module:CreateHasteButton(parent, width, height, text, dewdrop, left, ...)
    local button = CreateFrame("Button", nil, parent)

    button:SetWidth(width)
    button:SetHeight(height)
    
    button:SetFont("Fonts\\FRIZQT__.TTF", 16)
    button:SetTextColor(1,1,1)
    button:SetText(text)
    
    button:SetBackdrop({ bgFile = "Interface\\ChatFrame\\ChatFrameBackground", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 16, edgeSize = 16, insets = { left = 1, right = 1, top = 1, bottom = 1}})
    button:SetBackdropColor(24/255, 24/255, 24/255)
    
    if dewdrop then self:RegisterDewdrop(dewdrop, button, left) end
    if select("#",...) > 0 then button:SetPoint(...) end
    
    return button
end

function module:CreateHasteFrame(parent, width, height, title, movable, ...)
    local frame = CreateFrame("Frame", nil, parent)
    frame:SetWidth(width)
    frame:SetHeight(height)
    frame:SetScale(.64)

    frame:SetBackdrop({
            bgFile = "Interface\\ChatFrame\\ChatFrameBackground", tile = true, tileSize = 32,
            edgeFile = "Interface\\AddOns\\KC_Items\\tga\\otravi-semi-full-border", edgeSize = 32,
            insets = {left = 1, right = 1, top = 20, bottom = 20},
    })

    frame:SetBackdropColor(24/255, 24/255, 24/255)
    frame:SetPoint("CENTER", nil, "CENTER")

    frame.Title = frame:CreateFontString(nil, "OVERLAY")
    frame.Title:SetWidth(365)
    frame.Title:SetHeight(15)
    frame.Title:SetPoint("TOPLEFT", frame, "TOPLEFT", 5, -14)

    frame.Title:SetShadowOffset(.8, -.8)
    frame.Title:SetShadowColor(0, 0, 0, .5)
    frame.Title:SetTextColor(0,0,0)

    frame.Title:SetJustifyH("LEFT")
    frame.Title:SetFont("Fonts\\FRIZQT__.TTF", 13)
    frame.Title:SetText(title or "")
    
    if movable then
        frame:EnableMouse(true)
        frame:SetMovable(true)
		if (type(movable) ~= "table") then
			frame:RegisterForDrag("LeftButton")
			frame:SetScript("OnDragStart", function() this:StartMoving() end)
			frame:SetScript("OnDragStop", function() this:StopMovingOrSizing() end)
		end
    end
    
    if select("#",...) > 0 then frame:SetPoint(...) end
    
    return frame
end
-- math... yuk
function module:Round(v, y)
    y = y or 0
	return math.floor((v * (10^y)) + .5) / (10^y) 
end

function module:Sum(values)
    local r = 0
    for _,v in pairs(values) do r = r + v end
    return r
end

function module:Mean(values)
    return self:Sum(values) / # values
end

function module:Median(values)
	table.sort(values)
    if #values == 1 then 
        return values[1]
    elseif math.fmod(#values,2) == 1 then
        return values[#values/2 + .5]
    else
        return (values[#values/2] + values[#values/2 + 1]) / 2
    end
end

function module:Conformity(values)
    local median, c = self:Median(values), 0
    for _, v in pairs(values) do
        if v == median then c = c + 1 end
    end
    return c / # values
end

function module:BellMean(values)
    return self:Mean(self:BellFilter(values))    
end

function module:BellFilter(values, nv)
    local mean, stdDev = self:Mean(values), self:StdDev(values)
    local low, high = mean - (stdDev * 1.5), mean + (stdDev * 1.5)
    if not nv then nv = {} end
    
    for _,v in pairs(values) do
        if v <= high and v >= low then table.insert(nv, v) end
    end
    
    return nv
end

function module:StdDev(values)
    return math.sqrt(self:Variance(values))
end

function module:Variance(values)
    local s, mean = 0, self:Mean(values)
    for _, v in pairs(values) do 
        s = s + (v - mean) ^ 2
    end
    return s / #values
end

function module:WeightedMean(nValue, nWeight, oValue, oWeight)
    return nValue * nWeight + oValue * oWeight
end

function module:GetExactCode(link)
    return link:match("item:(%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+)")
end

function module:GetLongCode(link)
    return link:match("item:(%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:%-?%d+:)")..0
end

function module:GetShortCode(link)    
    return tonumber(link:match("item:(%-?%d+)"))
end

local qtyFuncs = {
	SetAuctionItem		= function(type, slot) local _,_,qty = GetAuctionItemInfo(type, slot); return qty; end,
	SetBagItem			= function(bag, slot) local _, qty = GetContainerItemInfo(bag, slot); return qty;  end,
	SetCraftItem		= function(skill, id) if (id) then local _, _, qty = GetCraftReagentInfo(skill, id); return qty else local info = {GetItemInfo(GetCraftItemLink(skill))}; if info then return info[8] else return 1 end end end,
	SetHyperlink		= function() return 1 end,
	SetInventoryItem	= function(type, slot) if (not this) then return end if (type) then return GetInventoryItemCount(type, slot) else local _, qty = GetContainerItemInfo(BANK_CONTAINER,this:GetID()); return qty; end end,
	SetLootItem			= function(slot) local _,_, qty = GetLootSlotInfo(slot); return qty; end,
	SetMerchantItem		= function(id) local _,_,_, qty = GetMerchantItemInfo(id); return qty; end,
	SetQuestItem		= function(type, slot) local _,_, qty = GetQuestItemInfo(type, slot); return qty; end,
	SetQuestLogItem		= function(type, slot) return 1 end,
	SetTradePlayerItem	= function(id) local _,_, qty = GetTradeTargetItemInfo(id); return qty; end,
	SetTradeSkillItem	= function(skill, id) if (id) then local _, _, qty = GetTradeSkillReagentInfo(skill, id); return qty else local info = {GetItemInfo(GetTradeSkillItemLink(skill))}; if info then return info[8] else return 1 end end end,
	SetTradeTargetItem	= function(id) local _,_, qty = GetTradeTargetItemInfo(id); return qty; end,
}

function ttHandler:OnInitialize()
    self.db = KC_Items:AcquireDBNamespace("ttHandler")
    
    KC_Items:RegisterDefaults("ttHandler", 'profile', {
        moneyformat = "full",
        lineformat = "split",
        priceLineMode = "moneyframe",
    })
    
    self.kcTooltip = CreateFrame("GameTooltip", "kcTooltip", GameTooltip, "GameTooltipTemplate")
    self.kcTooltip.moneyframes = {}
    self.kcTooltip.mfStorage = {}
    self.kcTooltip.mfCount = 0
    
    self.kcItemRef = CreateFrame("GameTooltip", "kcItemRef", UIParent, "GameTooltipTemplate")
    self.kcItemRef.moneyframes = {}
    self.kcItemRef.mfStorage = {}
    self.kcItemRef.mfCount = 0
    
    self.ItemRefTooltip = self.kcItemRef
    self.GameTooltip = self.kcTooltip
    
    self.abacus = AceLibrary("Abacus-2.0")
end

function ttHandler:AddTextLine(left, right, sep)
    if self.addBlank then self:AddBlankLine() end
    
	if (self.db.profile.lineformat == "split") then
		self.tt:AddDoubleLine(left, right, 1, 1, 1, 1, 1, 1)
	else
        if sep then
            self.tt:AddLine(("%s%s%s"):format(left, sep, right), 1, 1, 1);
        elseif right then
            self.tt:AddLine(format("%s - %s", left, right), 1, 1, 1);
        else
            self.tt:AddLine(left, 1, 1, 1);
        end            
	end
    
    local numLines = self.tt:NumLines()
	local width = getglobal(self.tt:GetName() .. "TextRight".. numLines):GetWidth() + getglobal(self.tt:GetName() .. "TextLeft".. numLines):GetWidth() + 25
	self.maxWidth = width > self.maxWidth and width or self.maxWidth
    
    self.lineAdded = True
    
    --self:UpdateWidth()
end

function ttHandler:AddPriceLine(amt, label, sep)
	if self.addBlank then self:AddBlankLine() end
	if (self.db.profile.priceLineMode == "moneyframe") then
		self.tt:AddDoubleLine(label, " ", 1, 1, 1, 1, 1, 1)

		local numLines = self.tt:NumLines()
		local mf = self:GetMoneyFrame(self.tt)
		mf:SetPoint("RIGHT", self.tt:GetName(), "RIGHT", 0, 0)
		mf:SetPoint("TOP", self.tt:GetName() .. "TextLeft".. numLines, "TOP", 0, 0)
		mf:Show()
		MoneyFrame_Update(mf:GetName(), floor(amt))
		
		local width = mf:GetWidth() + getglobal(self.tt:GetName() .. "TextLeft".. numLines):GetWidth() + 30
		self.maxWidth = width > self.maxWidth and width or self.maxWidth
        
	else
        local pricetext
        
        if self.db.profile.moneyformat == "extended" then
            pricetext = self.abacus:FormatMoneyExtended(amt, true, true)
        elseif self.db.profile.moneyformat == "full" then
            pricetext = self.abacus:FormatMoneyFull(amt, true, true)
        elseif self.db.profile.moneyformat == "short" then
            pricetext = self.abacus:FormatMoneyShort(amt, true, true)
        elseif self.db.profile.moneyformat == "condensed" then
            pricetext = self.abacus:FormatMoneyCondensed(amt, true, true)
        end
        
        self:AddTextLine(label, pricetext, sep)
	end
    
    self.lineAdded = True
    
    --self:UpdateWidth()
end

function ttHandler:AddTriplePriceLine(amt1, amt2, label, sep)
    if self.addBlank then self:AddBlankLine() end
    if (self.db.profile.priceLineMode == "moneyframe") then
        self:AddTripleTextLine(label, " ", " ", sep, true)
		
		local numLines = self.tt:NumLines()
		local mf1 = self:GetMoneyFrame(self.tt)
		mf1:SetPoint("RIGHT", self.tt:GetName(), "RIGHT", 0, 0)
		mf1:SetPoint("TOP", self.tt:GetName() .. "TextRight".. numLines, "TOP", 0, 0)
		mf1:Show()
		MoneyFrame_Update(mf1:GetName(), floor(amt2))
		
		local midPoint = -mf1:GetWidth()-10
		if not self.tt.midPoint or midPoint < self.tt.midPoint then
			self.tt.midPoint = midPoint
			
			for i=1, #self.tt.moneyframes do
				if self.tt.moneyframes[i].special then
					self.tt.moneyframes[i]:SetPoint("RIGHT", self.tt:GetName() , "RIGHT", self.tt.midPoint, 0)
				end
			end 
		end			

		local mf2 = self:GetMoneyFrame(self.tt, true)
		mf2:SetPoint("RIGHT", self.tt:GetName() , "RIGHT", self.tt.midPoint, 0)
		mf2:SetPoint("TOP", self.tt:GetName() .. "TextLeft".. numLines, "TOP", 0, 0)
		mf2:Show()
		MoneyFrame_Update(mf2:GetName(), floor(amt1))
		
		local width = mf2:GetWidth() + mf1:GetWidth() + getglobal(self.tt:GetName() .. "TextLeft".. numLines):GetWidth() + 50
		self.maxWidth = width > self.maxWidth and width or self.maxWidth
    end
	
	self.lineAdded = True
end

function ttHandler:AddTripleTextLine(left, center, right, sep, split)
    if self.addBlank then self:AddBlankLine() end
    
	if (self.db.profile.lineformat == "split" or split) then
		self.tt:AddDoubleLine(left, center, 1, 1, 1, 1, 1, 1)
		
		if not self.tt.thirds then self.tt.thirds = {} end
		
		if not self.tt.thirds[self.tt:NumLines()] then
			self.tt.thirds[self.tt:NumLines()] = self.tt:CreateFontString(self.tt:GetName().."TextFarRight"..self.tt:NumLines(), "ARTWORK", "GameTooltipText")
			self.tt.thirds[self.tt:NumLines()]:SetPoint("RIGHT", self.tt:GetName().."TextRight"..self.tt:NumLines(), "LEFT", 60, 0)
		end
		
		self.tt.thirds[self.tt:NumLines()]:SetText(right)
	else
        if sep then
            self.tt:AddLine(("%s%s%s%s%s"):format(left, sep, center, sep, right), 1, 1, 1);
        elseif right then
            self.tt:AddLine(("%s - %s - %s"):format(left, center, right), 1, 1, 1);
        elseif center then
            self.tt:AddLine(("%s - %s"):format(left, center), 1, 1, 1);
        else
            self.tt:AddLine(left, 1, 1, 1);
        end            
	end
    
    local numLines, width = self.tt:NumLines(), 0
	if self.tt.thirds[numLines] then
		width = getglobal(self.tt:GetName() .. "TextRight".. numLines):GetWidth() + getglobal(self.tt:GetName() .. "TextLeft".. numLines):GetWidth() + getglobal(self.tt:GetName() .. "TextFarRight"..numLines):GetWidth() + 25	
	else
		width = getglobal(self.tt:GetName() .. "TextRight".. numLines):GetWidth() + getglobal(self.tt:GetName() .. "TextLeft".. numLines):GetWidth() + 25	
	end
	
	
	self.maxWidth = width > self.maxWidth and width or self.maxWidth
    
    self.lineAdded = True
end

function ttHandler:AddBlankLine()
    self.addBlank = false
    self:AddTextLine(" ")
end

function ttHandler:UpdateWidth()
    if self.tt:GetWidth() < self.maxWidth then
        self.tt:SetWidth(self.maxWidth)
    end
    
    if self.tt:GetWidth() < self.parent:GetWidth() then
        self.tt:SetWidth(self.parent:GetWidth())
    end
end

function ttHandler:CleanUp()
    --if self.lineAdded then self.tt:Show() else self.tt:Hide() end
end

function ttHandler:Prep()
    if not self.lLineCount then self.lLineCount = self.tt:NumLines() return end
    if self.lLineCount ~= self.tt:NumLines() then 
        self.lLineCount = self.tt:NumLines()
        self.addBlank = true
    end
end

function ttHandler:GetMoneyFrame(tooltip, special)
    local mf
    if #tooltip.mfStorage == 0 then
        tooltip.mfCount = tooltip.mfCount + 1
        mf = CreateFrame("Frame", tooltip:GetName()..tooltip.mfCount, tooltip, "SmallMoneyFrameTemplate")
        
        mf.info = MoneyTypeInfo["STATIC"]
        mf.moneyType = "STATIC"
        getglobal(mf:GetName().."GoldButton"):EnableMouse(false)
        getglobal(mf:GetName().."SilverButton"):EnableMouse(false)
        getglobal(mf:GetName().."CopperButton"):EnableMouse(false)
    else
        mf = table.remove(tooltip.mfStorage)
    end
    
    table.insert(tooltip.moneyframes, mf)
	mf.special = special
    return mf
end

function ttHandler:ReleaseMoneyFrames(tooltip)
    for i=1, #tooltip.moneyframes do
        local tt = table.remove(tooltip.moneyframes)
		tt.special = nil
        tt:Hide()
        table.insert(tooltip.mfStorage, tt)
    end
end

function ttHandler:OnTooltipHide(tooltip)
    if not tooltip then return end
    self[tooltip:GetName()]:Hide()
    self:ReleaseMoneyFrames(self[tooltip:GetName()])
end

function KC_Items:HookTooltips()
	for key, value in pairs(qtyFuncs) do
     	local orig, qtyFunc = key, value

		local func = function(tooltip,a,b,c)
			self.itemEntered = true
            name, link = tooltip:GetItem()
            
            if link then 
                local tt = {}
                tt.tt = ttHandler[tooltip:GetName()]
                tt.link = link
                tt.name = name
                tt.qty = qtyFunc(a,b,c) or 1
                tt.parent = tooltip
                tt.maxWidth = 0
                
                setmetatable(tt, {__index=ttHandler})
                
                ttHandler:ReleaseMoneyFrames(tt.tt)
                tt.tt:ClearLines()
                tt.tt:SetScale(.95)
                tt.tt:SetOwner(tooltip, "ANCHOR_NONE")
                tt.tt:SetPoint("TOPLEFT", tooltip, "BOTTOMLEFT")
                tt:AddTextLine(("|cffffff45%s x %s"):format(tt.name, tt.qty))
                tt:AddBlankLine()
                
                self:TriggerEvent("KC_Items_ItemTooltipShown", tt)
                
                if tt.tt:NumLines() > 2 then tt.tt:Show() end
                if tt.tt:GetWidth() < tt.maxWidth then tt.tt:SetWidth(tt.maxWidth) end
                if tt.parent:GetWidth() < tt.tt:GetWidth() then tt.parent:SetWidth(tt.tt:GetWidth()) end
            end
		end
		self:SecureHook(GameTooltip,orig,func)
	end
end
