local L = AceLibrary("AceLocale-2.2"):new("AuctionSpy")
AuctionSpy = KC_Items:NewModule("AuctionSpy", "AceEvent-2.0", "AceHook-2.1", "AceConsole-2.0")

function AuctionSpy:OnInitialize()
    self.db = KC_Items:AcquireDBNamespace("AuctionSpy")
    
    KC_Items:RegisterDefaults("AuctionSpy", 'server', {
        ['*'] = {},
        targets = ",1:1,2:1,3:1,4:1,5:1,6:1,7:1,8:1,9:1,10:1,11:1,"
    })
    
    KC_Items:RegisterDefaults("AuctionSpy", 'profile', {
        labels = {
            mAvg =  "|cff00ffffRecent MinBid|r",
            hmAvg = "|cff00ffffHistoric MinBid|r",
            yAvg =  "|cff00ffffRecent Buyout|r",
            hyAvg = "|cff00ffffHistoric Buyout|r",
            sep = " ",
        },
    })
    
    -- Fixing slight update to the targets sv struct
    if not self.db.server.targets:match(",1:%d,2:%d,3:%d,4:%d,5:%d,6:%d,7:%d,8:%d,9:%d,10:%d,11:%d,") then
        self.db.server.targets = ',' .. self.db.server.targets
    end
    
    self.tablet = AceLibrary("Tablet-2.0")
    self.classes = {GetAuctionItemClasses()}    
        
    self.dewTargets = {
        type ='group',
        args = {
            header1 = {
                type = "header",
                order = 101,
                name = " "
            },
            all = {
                name = L["All"],
                desc = L["Toggle scanning of %s category."]:format(L["every"]),
                get = function()
                    if self.db.server.targets:find(",%d+:0,") then return false else return true end
                end,
                set = function(v)
                    if v then 
                        self.db.server.targets = ",1:1,2:1,3:1,4:1,5:1,6:1,7:1,8:1,9:1,10:1,11:1,"
                    else
                        self.db.server.targets = ",1:0,2:0,3:0,4:0,5:0,6:0,7:0,8:0,9:0,10:0,11:0,"
                    end
                    self:ColorFilters()
                end,
                type = "toggle",
                order = 102,
            }
        }
    }
    
    for index, value in ipairs(self.classes) do
        local i = index
        self.dewTargets.args[value:gsub("%s", "")] = {
            name = value,
            desc = L["Toggle scanning of %s category."]:format(value),
            get = function()
                local toggle =  self.db.server.targets:match((",%d:%s,"):format(i, "(%d+)"))
                return toggle == "1" and true or false
            end,
            set = function(v)
                if v then v = 1 else v = 0 end
                self.db.server.targets = self.db.server.targets:gsub((",%d:%s,"):format(i, "(%d+)"), (",%d:%s,"):format(i, v))
                self:ColorFilters()
            end,
            type = "toggle",
            order = i,
        }
    end
    
    KC_Items.options.args.auctionspy = {
	    name = L["Auction Spy"],
	    desc = L["Toggle the Auction Spy module"],
	    type = "toggle",
	    get = function() return KC_Items:IsModuleActive("AuctionSpy") end,
	    set = function(v) KC_Items:ToggleModuleActive("AuctionSpy", v) end
    }
end

function AuctionSpy:OnEnable()
    self:RegisterEvent("AUCTION_HOUSE_SHOW", function()      
        self:BuildSideBar()
        self:ColorFilters()
        
        for i=1, 15 do
            getglobal("AuctionFilterButton" .. i):RegisterForClicks("LeftButtonDown", "RightButtonDown")
        end
        
        self:Hook("AuctionFrameFilter_OnClick", function()  
            if this.type == "class" and arg1 == "RightButton" then
                v = self.db.server.targets:find(("%d:1,"):format(this.index)) and 0 or 1 
                self.db.server.targets = self.db.server.targets:gsub(("%d:%s,"):format(this.index, "(%d+)"), ("%d:%s,"):format(this.index, v))
            elseif arg1 == "LeftButton" then
                self.hooks.AuctionFrameFilter_OnClick()
            end
            self:ColorFilters()
        end, true)
        self:SecureHook("AuctionFrameFilters_Update", "ColorFilters")
        
        self.ahfaction = UnitFactionGroup("target")
        
        self:UnregisterEvent("AUCTION_HOUSE_SHOW")
        self:RegisterEvent("AUCTION_HOUSE_SHOW", function()  
            self.ahfaction = UnitFactionGroup("target")
        end)
    end)
    
    self:RegisterEvent("AuctionSpy_SnapshotUpdate", "ProcessSnapshot")
    self:RegisterEvent("KC_Items_ItemTooltipShown", "ItemTooltipShown")
    
end

function AuctionSpy:ItemTooltipShown(tt)
    tt:Prep()
    local mktV, hmktV, avgStkSz, stkSzCfrm, mAvg, hmAvg, mStdDev, mMax, yAvg, hyAvg, yStdDev, yMin, bAvg, hbAvg, bStdDev, bMax = self:GetItemInfo(UnitFactionGroup("player"), self:GetLongCode(tt.link))
    
    if mktV then 
        if mAvg > 0 then tt:AddPriceLine(self:Round((mAvg-mStdDev) * tt.qty), self.db.profile.labels.mAvg, self.db.profile.labels.sep) end
        if hmAvg > 0 then tt:AddPriceLine(self:Round((hmAvg-mStdDev) * tt.qty), self.db.profile.labels.hmAvg, self.db.profile.labels.sep) end
        tt:CleanUp()
        tt:AddBlankLine()
        if yAvg > 0 then tt:AddPriceLine(self:Round((yAvg-yStdDev) * tt.qty), self.db.profile.labels.yAvg, self.db.profile.labels.sep) end
        if hyAvg > 0 then tt:AddPriceLine(self:Round((hyAvg-yStdDev) * tt.qty), self.db.profile.labels.hyAvg, self.db.profile.labels.sep) end
    end
    
    tt:CleanUp()
end

function AuctionSpy:ColorFilters()
    for i = 1, 15 do
        local button = getglobal("AuctionFilterButton" .. i)        
        button:SetTextColor(1, .82, 0)
        if  button.type == "class" and self.db.server.targets:find((",%d:1,"):format(button.index)) then 
            button:SetTextColor(1, .6, 0) 
        end
    end
end

function AuctionSpy:BuildSideBar()
    local button, qmark, label
   
    self.frame = self:CreateHasteFrame(AuctionFrame, 250, 85, "KC Items: AuctionSpy", false, "TOPRIGHT", AuctionFrame, "BOTTOMRIGHT", 0, 15)
        
    self.frame.buttons = {}
    self.frame.labels = {}
    
    self.frame.buttons.scan = self:CreateHasteButton(self.frame, 120, 28, L["Scan"], nil, nil, "LEFT", self.frame, "LEFT", 4, -6)
    self.frame.buttons.scan:SetScript("OnClick", function()
        
        if self.scanning then
            self:ScanDone()
            return
        end
        
        self.snapshot = {}
        
        -- Clean up the frames.
        BrowseNoResultsText:Show()
        BrowseNoResultsText:SetText("")
        for i=1, NUM_BROWSE_TO_DISPLAY do
            getglobal("BrowseButton"..i):Hide()
        end
        
        if (self.db.server.targets:find(":1,")) then
            if not self.db.server.targets:find(":0") then self.scanningall = true end
            self.scanning = true
            
            self:Hook("AuctionFrameBrowse_OnEvent", function() end, true) -- nothing happens in a black hole
            self:Hook("CanSendAuctionQuery", function () 
                if (self.hooks.CanSendAuctionQuery()) then self:NextPage() end 
            end, true)
            
            self:RegisterEvent("AUCTION_ITEM_LIST_UPDATE"	, "AuctionListUpdate")
            self:RegisterEvent("AUCTION_HOUSE_CLOSED"		, "ScanDone")

            this:SetText("Cancel Scan")
        else
            BrowseNoResultsText:SetText("No Target Categories Selected.")
        end
        
    end)
    
    self.frame.buttons.targets = self:CreateHasteButton(self.frame, 120, 28, L["Targets"], self.dewTargets, true, "LEFT", self.frame.buttons.scan, "RIGHT", 2, 0)
        
    self.ahframe = AuctionFrame
    self.ahframe.qmarks = {}
    
    self.ahframe.qmarks.filters = self:CreateQMark(AuctionFilterButton1, nil, "BOTTOMRIGHT", "AuctionFilterButton1", "TOPLEFT", 10, 4)
    
    self:AddDelayedTooltip(self.ahframe.qmarks.filters, L["AuctionSpy Filter Help"], {
            L["AuctionSpy will color currently"],
            L["selected categories orange."],
            L["To change which categories are"],
            L["selected you can use the targets"],
            L["button on the sidebar or right"],
            L["click the category."]
        }, .2)    
    
    self:Hook("AuctionFrameTab_OnClick", function(index) 
        if index and index == 1 then 
            self.ahframe.qmarks.filters:Show()
        elseif this and this:GetID() == 1 then
            self.ahframe.qmarks.filters:Show()
        else
            self.ahframe.qmarks.filters:Hide()
        end      
        self.hooks.AuctionFrameTab_OnClick(index)
    end, true)
end

function AuctionSpy:NextPage()
    if self.done then self:ScanDone() return end
    
	if (self.page) then
		local numBatchAuctions, totalAuctions = GetNumAuctionItems("list")
		self.maxPages= floor(totalAuctions / NUM_AUCTION_ITEMS_PER_PAGE)

		if totalAuctions == 0 or self.target > 11 then self.done = true end
                
        BrowseNoResultsText:SetText(("|cff0055ffAuctionSpy |r \nScanning page %s of %s in %s"):format(self.page + 1, self.maxPages + 1, self.classes[self.target] or "..."))
                    
        if (self.page < self.maxPages) then
            self.page = self.page + 1
        else
            if (self.target <= 11) then
                self.target, self.page = self.target + 1, 0 
                
                while not self.db.server.targets:find("," .. self.target .. ":1,") and self.target <= 11 do 
                    if self.target == 11 then self.target = nil break end
                    self.target = self.target + 1
                end
                
                if not self.target then self.done = true end
            else
                self.done = true
            end
        end
	else
        BrowseNoResultsText:SetText("|cff0055ffAuctionSpy |r \nStarting Scanning Process")
		self.page, self.target = 0, 1
        
        while not self.db.server.targets:find("," .. self.target .. ":1,") and self.target <= 11 do 
            if self.target == 11 then self.target = nil break end
            self.target = self.target + 1
        end

        if not self.target then self.done = true end
	end
    
    if self.done then self:ScanDone() return end
    
	self.needproc = true
    QueryAuctionItems("", "", "", nil, self.target, nil, self.page, nil, nil)
end

function AuctionSpy:ScanDone()

    self:Unhook("CanSendAuctionQuery")
	self:Unhook("AuctionFrameBrowse_OnEvent")
    
    self.frame.buttons.scan:SetText("Scan")
    if BrowseNoResultsText then BrowseNoResultsText:SetText("|cff0055ffAuctionSpy |r \nScanning Process Complete") end

	self:UnregisterEvent("AUCTION_ITEM_LIST_UPDATE")
	self:UnregisterEvent("AUCTION_HOUSE_CLOSED")	

    self:TriggerEvent("AuctionSpy_SnapshotUpdate", time(), AceLibrary("AceDB-2.0").REALM, self.ahfaction or "Neutral", self.snapshot)
	
    if not self.db.profile.persistent then
        --self.snapshot = nil
    end
    
	self.page, self.needproc, self.done, self.scanning, self.maxPages = nil, nil, nil, nil, nil
end

function AuctionSpy:AuctionListUpdate()
	if (not self.needproc) then return	end

	for id = 1, GetNumAuctionItems("list") do
        local name, texture, count, _, _, _, minBid, _, buyoutPrice, bidAmount, _, seller = GetAuctionItemInfo("list", id)
        local code = self:GetLongCode(GetAuctionItemLink("list", id))
        --If I can figure out a nice way to animate this i'll do it, if not I don't know
        --BrowseNoResultsText:SetText(("|cff0055ffAuctionSpy |r \nScanning page %s of %s in %s" .. "\n\nCurrently Proccessing: %s"):format(self.page + 1, self.maxPages + 1, self.classes[self.target], link))
        if code and seller then 
            if not self.snapshot[code] then self.snapshot[code] = {} end
            if not self.snapshot[code][seller] then self.snapshot[code][seller] = {} end
            table.insert(self.snapshot[code][seller], ("c:%s,m:%s,y:%s,b:%s,"):format(count, minBid / count, buyoutPrice / count, bidAmount / count))
        end
	end

	self.needproc = false
end

--This is the function that actually is going to build my saved variable file.  The snapshot itself is not very data
--dense.  It also has more information in it than a basic build will need.  This will be nice if I ever get around to
--writing a few of the more advanced modules that I have in mind.  Its triggered via a custom event.
-- snapshot[code][seller][data]
function AuctionSpy:ProcessSnapshot(timestamp, realm, faction, snapshot)
    local tBag = {}
       
    local acquire = function() 
        if # tBag > 0 then return tremove(tBag) else return {} end
    end
    
    local release = function(tbl)
        for k, v in pairs(tbl) do tbl[k] = nil end
        tinsert(tBag, tbl)
    end
    
    local nWeight, oWeight, wm
    local datavault = self.db.server[faction]
    
    if tonumber(datavault.timestamp) then 
        nWeight, oWeight = self:GetDecay(timestamp, datavault.timestamp) 
        wm = function(n, o)
            return self:WeightedMean(n, nWeight, o, oWeight)
        end
    end
    
    
    for item, data in pairs(snapshot) do
        local stacksizes, bids, buyouts, minbids = acquire(), acquire(), acquire(), acquire()
        for seller, sellerinfo in pairs(data) do
            for i, info in pairs(sellerinfo) do
                local _, _, qty, min, buy, bid = info:find("c:(%d+%.?%d*),m:(%d+%.?%d*),y:(%d+%.?%d*),b:(%d+%.?%d*),")
                tinsert(stacksizes, tonumber(qty)) tinsert(minbids, tonumber(min))
                if tonumber(bid) > 0 then tinsert(bids, tonumber(bid)) end  
                if tonumber(buy) > 0 then tinsert(buyouts, tonumber(buy)) end 
            end
        end
        local nbids, nbuyouts, nminbids = self:BellFilter(bids, acquire()), self:BellFilter(buyouts, acquire()), self:BellFilter(minbids, acquire())
        if #nbids == 0 then table.insert(nbids, 0) end
        if #nbuyouts == 0 then table.insert(nbuyouts, 0) end
        
        local mktV, avgStkSz, stkSzCfrm = self:Sum(stacksizes), self:Median(stacksizes), self:Conformity(stacksizes)
        local bAvg, bStdDev, bMax = self:Mean(nbids),    self:StdDev(nbids),      math.max(unpack(nbids))
        local yAvg, yStdDev, yMin = self:Mean(nbuyouts), self:StdDev(nbuyouts),   math.min(unpack(nbuyouts))
        local mAvg, mStdDev, mMax = self:Mean(nminbids), self:StdDev(nminbids),   math.max(unpack(nminbids))
        
        local oinfo = {self:GetItemInfo(faction, item)}
        
        if not nWeight or #oinfo == 0 then        
            info = ("%s,%s,%s,%s;%s,%s,%s,%s;%s,%s,%s,%s;%s,%s,%s,%s;"):format(
                self:Round(mktV), self:Round(mktV), self:Round(avgStkSz), self:Round(stkSzCfrm, 2), 
                self:Round(mAvg), self:Round(mAvg), self:Round(mStdDev), self:Round(mMax),
                self:Round(yAvg), self:Round(yAvg), self:Round(yStdDev), self:Round(yMin),
                self:Round(bAvg), self:Round(bAvg), self:Round(bStdDev), self:Round(bMax))
            datavault[item] = info
        else
            --data rot! on noes!
            info = ("%s,%s,%s,%s;%s,%s,%s,%s;%s,%s,%s,%s;%s,%s,%s,%s;"):format(
                self:Round(mktV), self:Round(wm(mktV, oinfo[2])),  self:Round(wm(avgStkSz, oinfo[3])), self:Round(wm(stkSzCfrm, oinfo[4]), 2), 
                self:Round(mAvg), self:Round(wm(mAvg, oinfo[6])),  self:Round(wm(mStdDev, oinfo[7])),  oinfo[8]  > mMax and oinfo[8]  or self:Round(mMax),
                self:Round(yAvg), self:Round(wm(yAvg, oinfo[10])), self:Round(wm(yStdDev, oinfo[11])), oinfo[12] < yMin and oinfo[12] or self:Round(yMin),
                self:Round(bAvg), self:Round(wm(bAvg, oinfo[14])), self:Round(wm(bStdDev, oinfo[15])), oinfo[16] > bMax and oinfo[16] or self:Round(bMax))
            datavault[item] = info
        end
        release(stacksizes) release(bids) release(buyouts) release(minbids) release(nbids) release(nbuyouts) release(nminbids)
    end
    datavault.timestamp = timestamp
end

function AuctionSpy:GetItemInfo(faction, item)
    if self.db.server[faction][item] then
        local a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p = self.db.server[faction][item]:match("(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*);(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*);(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*);(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*),(%d+%.?%d*);")
        return tonumber(a), tonumber(b), tonumber(c), tonumber(d), tonumber(e), tonumber(f), tonumber(g), tonumber(h), tonumber(i), tonumber(j), tonumber(k), tonumber(l), tonumber(m), tonumber(n), tonumber(o), tonumber(p)
    end
end

function AuctionSpy:GetItemAuctionInfo(item)
    local mktV, hmktV, avgStkSz, stkSzCfrm, mAvg, hmAvg, mStdDev, mMax, yAvg, hyAvg, yStdDev, yMin, bAvg, hbAvg, bStdDev, bMax = self:GetItemInfo(self.ahfaction or "Neutral", item)
    if mktV then
        return (mAvg - mStdDev) * .90, (yAvg - yStdDev) * .95    
    end    
end

function AuctionSpy:GetDecay(nts, ots)
    local lapse = nts - ots
    local nw
    if lapse  < 43200 then
        nw = (.57 * ( lapse /43200 ))^1.2309492583389
    elseif lapse > 43200 then
        nw = (1/60* ( lapse /43200 ))^(math.log(2) / math.log(60))
    else
        nw = .5
    end
    return nw, 1 - nw
end

