--------------------------------------------------------------THESE COLORS SET THE TOP MIDDLE AND BOTTOM ROW COLORS
KBTTopColor = "|cFFFFFF00"
KBTMiddleColor = "|cFFFF0000"
KBTBottomColor = "|cFF00FF00"




local L = AceLibrary("AceLocale-2.2"):new("KBTracker")

local options = { 
    type='group',
    args = {
	display = 	{
		type = 'execute',
		name = 'Message',
		desc = 'Toggles the display',
		func = 'Menu',
        		},
	},
}



KBTracker = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0")
KBTracker:RegisterChatCommand("/kbt","/hkt", "/kbtracker", options)
KBTracker:RegisterDB("KBTrackerDB", "KBTrackerDBPC")
KBTracker:RegisterDefaults("profile", {
    points = 0,
	debug = 0,
} )

KBTracker:RegisterDefaults("char", {
    points = 0,
} )

------------------------------CALLED WHEN THE ADDON STARTS
function KBTracker:OnInitialize()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("UPDATE_BATTLEFIELD_SCORE")

	lasttime = time()

	HKTKillingBlows = 0
	HKTLastKillingBlows = 0
	HKTKillingBlowsTot = 0

	HKTHonorKills = 0
	HKTLastHonorKills = 0
	HKTHonorKillsTot = 0
	
     	getglobal("HKTtext"):SetText(KBTTopColor.."This BG:".."|r");
     	getglobal("HKTlasttext"):SetText(KBTMiddleColor.."Last BG:".."|r");
     	getglobal("HKTtexttoday"):SetText(KBTBottomColor.."Session:".."|r");

     	getglobal("HKTKillingBlowsnum"):SetText(KBTTopColor..HKTKillingBlows.."|r");
     	getglobal("HKTLastKillingBlowsnum"):SetText(KBTMiddleColor..HKTLastKillingBlows.."|r");
     	getglobal("HKTKillingBlowsTotnum"):SetText(KBTBottomColor..HKTKillingBlowsTot.."|r");

     	getglobal("HKTHonorKillsnum"):SetText(KBTTopColor..HKTHonorKills.."|r");
     	getglobal("HKTLastHonorKillsnum"):SetText(KBTMiddleColor..HKTLastHonorKills.."|r");
     	getglobal("HKTHonorKillsTotnum"):SetText(KBTBottomColor..HKTHonorKillsTot.."|r");

	HKTUpdate = true
	HKTTimeUpdate = time()
 
end
------------------------------------------------------------

------------------------------FUNCTIONS CALLED WHEN THE ADDON IS ENABLED OR DISABLED
function KBTracker:OnEnable()
    -- Called when the addon is enabled
end

function KBTracker:OnDisable()
    -- Called when the addon is disabled
end
------------------------------------------------------------

------------------------------TOGGLE THE SHOWING OF THE GUI
function KBTracker:Menu()
   if(  KBTrackerMenu:IsVisible() ) then
      KBTrackerMenu:Hide();
   else
      KBTrackerMenu:Show();
   end
end
------------------------------------------------------------

------------------------------5 SECOND DELAY
function KBTracker:Time()

if time() > HKTTimeUpdate + 5 then
	HKTUpdate = false
	KBTracker:Reset()
end

end
------------------------------------------------------------


------------------------------RESET THE NUMBERS IF YOU ENTER ANOTHER BATTLEGROUNDS
function KBTracker:PLAYER_ENTERING_WORLD()

HKTTimeUpdate = time()
HKTUpdate = true

end


function KBTracker:Reset()

--REMOVE VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV
local playername = UnitName('player')
if playername == "Musou" or playername == "Deathcamp" then
	--self:Print(GetZoneText())
end
--REMOVE ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



if GetZoneText() == "Alterac Valley" or GetZoneText() == "Arathi Basin" or GetZoneText() == "Eye of the Storm" or GetZoneText() == "Warsong Gulch" or GetZoneText() == "Strand of the Ancients" then
	HKTLastKillingBlows = HKTKillingBlows
	getglobal("HKTLastKillingBlowsnum"):SetText(KBTMiddleColor..HKTLastKillingBlows.."|r");
	
	HKTLastHonorKills = HKTHonorKills
	getglobal("HKTLastHonorKillsnum"):SetText(KBTMiddleColor..HKTLastHonorKills.."|r");

	HKTKillingBlowsTot = HKTKillingBlowsTot + HKTKillingBlows
	HKTHonorKillsTot = HKTHonorKillsTot + HKTHonorKills

	HKTKillingBlows = 0
	HKTHonorKills = 0
	getglobal("HKTKillingBlowsnum"):SetText(KBTTopColor..HKTKillingBlows.."|r");
	getglobal("HKTKillingBlowsTotnum"):SetText(KBTBottomColor..HKTKillingBlowsTot.."|r");
 
	getglobal("HKTHonorKillsnum"):SetText(KBTTopColor..HKTHonorKills.."|r");
	getglobal("HKTHonorKillsTotnum"):SetText(KBTBottomColor..HKTHonorKillsTot.."|r");

end

end
------------------------------------------------------------




function KBTracker:UPDATE_BATTLEFIELD_SCORE()
local playername = UnitName('player')
local petname = UnitName('pet')
local numScores = GetNumBattlefieldScores()

if not HKTUpdate then
	for i=1, numScores do
		local name, killingBlows, honorKills, deaths, honorGained, faction, rank, race, class, filename, damageDone, healingDone = GetBattlefieldScore(i);
		if name == playername then
			if honorKills >= HKTHonorKills then
				HKTKillingBlows = killingBlows
				HKTHonorKills = honorKills
			end
		end
	end
end

getglobal("HKTKillingBlowsnum"):SetText(KBTTopColor..HKTKillingBlows.."|r");
getglobal("HKTKillingBlowsTotnum"):SetText(KBTBottomColor..HKTKillingBlowsTot + HKTKillingBlows.."|r");
 
getglobal("HKTHonorKillsnum"):SetText(KBTTopColor..HKTHonorKills.."|r");
getglobal("HKTHonorKillsTotnum"):SetText(KBTBottomColor..HKTHonorKillsTot + HKTHonorKills.."|r");
end






------------------------------KILLING BLOW TRACKER
function KBTracker:COMBAT_LOG_EVENT_UNFILTERED()

if arg2 == "UNIT_DIED" or time() > lasttime + 5 then
	--self:Print(time()-lasttime)
	lasttime = time()
	RequestBattlefieldScoreData()
end


if HKTKillingBlows == nil then	HKTKillingBlows = 0 end
if HKTKillingBlowsTot == nil then HKTKillingBlowsTot = 0 end
if HKTHonorKills == nil then HKTHonorKills = 0 end
if HKTHonorKillsTot == nil then HKTHonorKillsTot = 0 end

if HKTUpdate then
	KBTracker:Time()     --This will try reset the numbers 5+ seconds after you change zones using the combat log to keep checking if enough time has passed
end

end
------------------------------------------------------------
