local L = AceLibrary("AceLocale-2.2"):new("Jude")

local options = {

	type = 'group',
	args = {

		show = {
			type = 'toggle',
			name = L["Show"],
			desc = L["Show/hide Jude"],
			get = "GetVisible",
			set = "ToggleVisible",
		},
	

		lock = {
			type = 'toggle',
			name = L["Lock"],
			desc = L["Lock/unlock Jude"],
			get = "GetLocked",
			set = "ToggleLocked",
		},

		columns = {
			type = 'range',
			name = L["Columns"],
			desc = L["Number of columns for layout"],
			get = "GetColumns",
			set = "SetColumns",
			min = 1,
			max = 9,
			step = 1,
			bigStep = 1,
		},

		scale = {
			type = 'range',
			name = L["Scale"],
			desc = L["Scale of the interface elements"],
			get = "GetScale",
			set = "SetScale",
			min = 0.7,
			max = 3,
			step = 0.1,
			bigStep = 0.1,
		},

		reset = {
			type = 'execute',
			name = L["Reset"],
			desc = L["Resets Jude to default settings"],
			func = "Reset",
		},

	},

}

Jude = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0")
Jude:RegisterChatCommand("/jude", "/jd", options)

Jude:RegisterDB("JudeDB", "JudeDBPC")
Jude:RegisterDefaults("profile", { locked = false, visible = true, columns = 9, scale = 1.0, xOffset = 0, yOffset = 0, })

function Jude:UpdateLayout()

	local cols = self.db.profile.columns
	local rows = ceil(9 / cols)
	local d = 36 * self.db.profile.scale
	local i, x, y, xm, ym, s, w, h, hw, hh
	s = 32 * self.db.profile.scale
	w = (36 * self.db.profile.scale * cols)
	h = (36 * self.db.profile.scale * rows)
	hw = w / 2 - 18 * self.db.profile.scale
	hh = h / 2 - 18 * self.db.profile.scale

	for y=1, rows do
	
		for x=1, cols do

			xm = x - 1
			ym = y - 1
			i = xm + ym * cols

			if (i <= 8) then
				obj = getglobal("JudeButton" .. i)
				obj:SetPoint("CENTER", JudeFrame, "CENTER", -hw + d * xm, hh - d * ym)
				obj:SetWidth(s)
				obj:SetHeight(s)
			end

		end

	end

	JudeAnchor:SetWidth(w + 8 * self.db.profile.scale)
	JudeAnchor:SetHeight(h + 8 * self.db.profile.scale)

end

function Jude:UpdatePosition()

	JudeFrame:SetPoint("CENTER", UIParent, "CENTER", self.db.profile.xOffset, self.db.profile.yOffset)

end


function Jude:UpdateLocked()

	if (self.db.profile.locked == true) then
		JudeAnchor:Hide()
	else
		JudeAnchor:Show()
	end

end

function Jude:UpdateVisible()

	if (self.db.profile.visible == true) then
		JudeFrame:Show()
	else
		JudeFrame:Hide()
	end

end

function Jude:UpdateAll()

	self:UpdatePosition()
	self:UpdateLayout()
	self:UpdateLocked()
	self:UpdateVisible()

end

function Jude:OnInitialize()

	self:UpdateAll()

end

function Jude:GetVisible()

	return self.db.profile.visible

end

function Jude:ToggleVisible()

	self.db.profile.visible = not self.db.profile.visible

	self:UpdateVisible()

end

function Jude:GetLocked()

	return self.db.profile.locked

end

function Jude:ToggleLocked()

	self.db.profile.locked = not self.db.profile.locked

	self:UpdateLocked()

end

function Jude:GetColumns()

	return self.db.profile.columns

end

function Jude:SetColumns(value)

	self.db.profile.columns = value

	self:UpdateLayout()

end

function Jude:GetScale()

	return self.db.profile.scale

end

function Jude:SetScale(value)

	self.db.profile.scale = value

	self:UpdateLayout()

end

function Jude:Reset()

	self.db.profile.locked = false
	self.db.profile.visible = true
	self.db.profile.columns = 9
	self.db.profile.scale = 1.0
	self.db.profile.xOffset = 0
	self.db.profile.yOffset = 0

	self:UpdateAll()

	self:Print("Reset to defaults!")

end

function Jude:SetRaidIcon(id)

	SetRaidTarget("target", id)		

end

function Jude:Moved()

	_, _, _, self.db.profile.xOffset, self.db.profile.yOffset = JudeFrame:GetPoint()

end