JQuestFu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceEvent-2.0")

JQuestFu.hasIcon = "Interface\\QuestFrame\\UI-QuestLog-BookIcon"
JQuestFu.hideWithoutStandby = true
JQuestFu.blizzardTooltip = true
JQuestFu.dewdrop = JQuest.dewdrop

function JQuestFu:OnInitialize()
	local args = AceLibrary("FuBarPlugin-2.0"):GetAceOptionsDataTable(self)
	local options = JQuest.options

	if not options.args["FuBar Options"] then
		options.args.menuSpacer = {
			type = "header",
			name = " ",
			order = 401,
		}
		options.args["FuBar Options"] = {
			type = "group",
			name = "FuBar Options",
			desc = "Options relating to FuBar and the minimap button",
			args = args,
			order = 402,
		}
	end
	self.OnMenuRequest = JQuest.options
	self.frame:RegisterForClicks("LeftButtonUp", "RightButtonUp")

	self:RegisterEvent("KillOldButton")
	self:ScheduleRepeatingEvent("KillOldButton", 1)

	-- Just use JQuest's var
	if JQuest.var and JQuest.var.FuBarDB then
		self.db = JQuest.var.FuBarDB
	elseif JQuest.var and not JQuest.var.FuBarDB then
		JQuest.var.FuBarDB = { profile = {} }
		self.db = JQuest.var.FuBarDB
		self.db.profile.minimapPosition = JQuest.var.position or 270
	end
end
function JQuestFu:OnEnable()
	self:Update()
end
function JQuestFu:OnTextUpdate()
	self:SetText("JasonQuest")
end
function JQuestFu:OnClick(button)
	if button == "LeftButton" then
		JQuest:Log_Toggle()
	end
end
function JQuest:MB_Refresh()
	JQuestFu:Update()
end
function JQuestFu:OnTooltipUpdate()
	GameTooltip:AddDoubleLine("Jason's PartyQuest", "|c00808080v" .. JQuest.version .. "|r")
	GameTooltip:AddLine("")
	GameTooltip:AddLine("|c00FFFFFFShare Quest Logs between JQuest users|r")
end
function JQuestFu:KillOldButton()
	if not JQuestMinimap then
		return
	else
		if MBB_Ignore then
			table.insert(MBB_Ignore, "JQuestMinimap")
		end
		JQuestMinimap:StopMovingOrSizing()
		JQuestMinimap:Hide()
		JQuestMinimap = nil
		JQuest.MB_OnClick = nil
		JQuest.MB_Move = nil
		JQuest.MB_OnUpdate = nil
		JQuest.MB_OnDragStart = nil
		JQuest.MB_OnDragStop = nil
		JQuest.MB_OnEnter = nil
		self:CancelScheduledEvent("KillOldButton")
		self.KillOldButton = nil
	end
end
