﻿JQuest = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceComm-2.0")
JQuest.revision = tonumber(string.sub("$Revision: 73320 $", 12, -3))

-- **************
-- Initialization
-- **************

-- ** Keybinds
BINDING_HEADER_JQUESTLOG = "Jason's PartyQuest"
BINDING_NAME_TOGGLEJQUESTLOG = "Show / Hide Log Frame"

-- 1st
function JQuest:OnInitialize()
	-- ** Comm
	self:SetCommPrefix("JQ")
	self.COMM_COMPAT = 1.04

	self.version = self.COMM_COMPAT .. "." .. tostring(self.revision)

	-- ** Saved
	if not JQuest_Save then
		JQuest_Save = {
			debugMode = false,
			showUpdates = false,
			wide = false,
			autoTrack = true,
			locked = true,
			frameLocked = true
		}
		if IsAddOnLoaded("DoubleWide") then
			JQuest_Save.wide = true
		else
			JQuest_Save.wide = false
		end
	end
	self.var = JQuest_Save
	if self.var.autotrack then self.var.autotrack = nil end

	-- ** Player
	self.Player = {
		numQuests = 0,
		sending = false,
		waitingForInit = true
	}
	self.PlayerQuests = {}

	-- ** Party
	self.Party = {}
	self.PartyQuests = {}
	self.PartyFrameData = {}
	self.PartySending = {}
	self.PartyRequested = {}
	self.PartyXP = {}
	self.PartyPing = {}

	-- ** LogFrame
	self.LogFrame = {
		waitingForInit = true,
		selectedWho = nil,
		selectedQuest = nil,
	}
	self.MB_waitingForInit = true

	-- ** QuestWatch
	self.watchedQuests = {}

	self.options = {
	    type='group',
	    args = {
	    	frameOptions = {
	    		type = 'group',
	    		name = "Frame Options",
	    		desc = "Options for the Log Frame",
	    		order = 110,
	    		args = {
					savePos = {
						type = 'toggle',
						name = 'Save Position',
						desc = 'Save position of the frame, otherwise hook into UIPanelWindows',
						get = function()
							return self.var.frameSave
						end,
						set = function(v)
							self.var.frameSave = v
							if not v then
								UIPanelWindows["JQuestLogFrame"] = { area = "left", pushable = 3, whileDead = 1 }
								JQuestLogFrame:SetAttribute("UIPanelLayout-enabled", true)
							else
								UIPanelWindows["JQuestLogFrame"] = nil
								JQuestLogFrame:SetAttribute("UIPanelLayout-enabled", false)
							end
						end
					},
					wide = {
						type = 'toggle',
						name = 'DoubleWide',
						desc = 'Toggle Single- or Double-Wide',
						get = function()
							return self.var.wide
						end,
						set = function(v)
							self.var.wide = v
							self:Log_SetWidth()
						end
					},
				}
			},
			watchOptions = {
				type = 'group',
				name = "Quest Watch Options",
				desc = "Options for the JQuest Tracker",
				order = 120,
				args = {
					locked = {
						type = 'toggle',
						name = 'Tracker Locked',
						desc = 'Lock / Unlock JQuest tracker',
						get = function()
							return self.var.locked
						end,
						set = function(v)
							self.var.locked = v
							self:QW_UpdateLock()
						end
					},
					autotrack = {
						type = 'toggle',
						name = 'Automatic Quest Tracking',
						desc = 'Toggle auto-tracking of member quests',
						get = function()
							return self.var.autoTrack
						end,
						set = function(v)
							self.var.autoTrack = v
						end
					},
					resetWatch = {
						type = 'execute',
						name = 'Reset Watch Position',
						desc = 'Reset JQuestWatch frame position',
						func = function()
							self:QW_ResetPos()
						end
					},
					clearWatch = {
						type = 'execute',
						name = 'Stop Watching',
						desc = 'Stop watching all JQuests',
						func = function()
							self:QW_ClearAll()
						end
					},
					showUpdates = {
						type = 'toggle',
						name = 'Show Updates in Chat',
						desc = 'Toggle tracking party objectives',
						get = function()
							return self.var.showUpdates
						end,
						set = function(v)
							self.var.showUpdates = v
						end
					},
				}
			},
			debugOptions = {
				type = 'group',
				name = 'Debug Options',
				desc = 'Dev stuff',
				order = 130,
				args = {
					ping = {
						type = 'execute',
						name = 'Ping the Party',
						desc = 'Send PING to party',
						func = function()
							self:Party_Ping()
						end
					},
					refreshDebug = {
						type = 'execute',
						name = 'Refresh Debug Cache',
						desc = 'Refresh debug cache',
						func = function()
							self:SetDebug()
						end
					},
					debug = {
						type = 'toggle',
						name = 'Debug Mode',
						desc = 'Toggle debug messages.',
						get = function()
							return self.var.debugMode
						end,
						set = function(v)
							self.var.debugMode = v
							self:SetDebug()
						end
					},
				}
			},
			showSpacer = {
				type = 'header',
				name = ' ',
				order = 140,
			},
	        show = {
	        	type = 'execute',
	        	name = 'Toggle the JQuest Log',
	        	desc = 'Toggle JasonQuest UI',
	        	order = 150,
	        	func = function()
	        		self:Log_Toggle()
	        	end
	        },
			matchfade = {
				name = "Search Quest Fade",
				type = "range",
				desc = "Set the transparency for unmatched quests",
				order = 160,
				max = 1,
				min = 0,
				step = 0.05,
				get = function() return self.var.unmatchedAlpha end,
				set = function(value)
					self.var.unmatchedAlpha = value;
					self:Log_Search(JQuest_SearchEditBox:GetText())
				end
			},
		}
	}
	self:RegisterChatCommand({"/jasonquest", "/jq"}, self.options)
end
-- 2nd
function JQuest:OnEnable()
	self:RegisterComm(self.commPrefix, "PARTY", "ReceiveMessage")
	self:RegisterComm(self.commPrefix, "WHISPER", "ReceiveMessage")
	self:SetDefaultCommPriority("BULK")

	-- Ace Events
	self:RegisterEvent("AceEvent_FullyInitialized", "AceEvent_FullyInitialized", true)
	self:RegisterEvent("JQuest_RegisterEvent", "RegisterQuestEvent")
	self:ScheduleRepeatingEvent("JQuest_RegisterEvent", 1)

	-- WoW Events
	self:RegisterBucketEvent("PARTY_MEMBERS_CHANGED", 1)
	self:RegisterBucketEvent("UNIT_PORTRAIT_UPDATE", 1)
	self:RegisterBucketEvent("PLAYER_XP_UPDATE", 1)
	self:RegisterEvent("CHAT_MSG_SYSTEM")
end
-- 3rd
function JQuest:AceEvent_FullyInitialized()
	self.PlayerQuests = self:Player_GetQuests()
	self.Player.waitingForInit = nil

	self:Log_Init(); self.Log_Init = nil
	self:MB_Init(); self.MB_Init = nil
	self:QW_Init(); self.QW_Init = nil
	self:PARTY_MEMBERS_CHANGED()

	self:SetDebug()
	self.tt = CreateFrame("GameTooltip")

	self:Log_CreateSearchEditBox()
	self.Log_CreateSearchEditBox = nil
	self:Log_UpdateSearchBoxPosition()
end

-- *************
-- Aux Functions
-- *************

function JQuest:SetDebug()
	if self.var.debugMode then
		self.PartyQuests[UnitName("player")] = self.PlayerQuests
		SetPortraitTexture(JQuestTab5Portrait, "player")
		JQuestTab5.tooltip = "Debug Data"
		JQuestTab5.who = UnitName("player")
		JQuestTab5.unit = "player"
		JQuestTab5:Show()
	else
		self:Party_Kill(UnitName("player"))
		JQuestTab5:Hide()
		JQuestTab5:SetChecked(false)
	end
	self:MB_Refresh()
end
function JQuest:AddQuestLevel(title, level, tag, numPlayers)
	if tag and numPlayers > 0 then
		title = "["..level..string.sub(tag, 1, 1)..numPlayers.."]"..title
	elseif tag then
		title = "["..level..string.sub(tag, 1, 1).."]"..title
	else
		title = "["..level.."] "..title
	end
	return title
end
function JQuest:CleanQuestName(q)
	if string.find(q, '^%[') then _,_,q = string.find(q, "^%[?%d*.?%d*]?%s?(.*)") end
	return q
end
function JQuest:Log(msg, force)
	if force then
		self:Print(msg)
	elseif self.var.debugMode then
		ChatFrame3:AddMessage("|cffffff78Jason's PartyQuest:|r " .. msg)
	end
end
function JQuest:copyTable(src)
	local dest = {}
	for k,v in pairs(src) do
		if type(k) == "table" then
			k = self:copyTable(k)
		end
		if type(v) == "table" then
			v = self:copyTable(v)
		end
		dest[k] = v
	end
	return dest
end

-- ************************
-- Minimap Button Functions
-- ************************

function JQuest:MB_Refresh()
	if self:Party_Exists() then
		JQuestMinimap:Show()
	else
		JQuestMinimap:Hide()
	end
end
function JQuest:MB_OnEnter()
	GameTooltip_SetDefaultAnchor(GameTooltip, UIParent)
	GameTooltip:AddDoubleLine("Jason's PartyQuest", "|c00808080v" .. JQuest.version .. "|r")
	GameTooltip:AddLine("")
	GameTooltip:AddLine("|c00FFFFFFShare Quest Logs between JQuest users|r")

	GameTooltip:Show()
end
function JQuest:MB_OnDragStart()
	this.drag = GetMinimapShape and GetMinimapShape() or "ROUND"
	this:GetScript("OnMouseDown")()
	this:LockHighlight()
	this:SetScript("OnUpdate", JQuest.MB_OnUpdate)
end
function JQuest:MB_OnDragStop()
	this:SetScript("OnUpdate", nil)
	this:UnlockHighlight()
	this:GetScript("OnMouseUp")()
end
function JQuest:MB_OnUpdate()
	local xpos, ypos = GetCursorPosition()
	local xmin, ymin = Minimap:GetLeft(), Minimap:GetBottom()

	xpos = xmin - xpos / Minimap:GetEffectiveScale() + 70
	ypos = ypos / Minimap:GetEffectiveScale() - ymin - 70

	this.position = math.deg(math.atan2(ypos, xpos))

	JQuest:MB_Move()
end

function JQuest:MB_Move(value, force)
	value = tonumber(value) or nil
	local button = _G["JQuestMinimap"]

	if button then
		if not button.locked or force then
			local x, y
			local angle = value or button.position

			if button.drag == "SQUARE" then
				x, y = 110 * cos(angle), 110 * sin(angle)
				x, y = math.max(-82, math.min(x, 84)), math.max(-86, math.min(y, 82))
			else
				x, y = 80 * cos(angle), 80 * sin(angle)
			end

			button:SetPoint("TOPLEFT", "Minimap", "TOPLEFT", 54 - x, y - 54)
			button.position = angle
			JQuest_Save.position = angle
		end
	end
end
function JQuest:MB_OnClick(button)
	local self = JQuest
	if button == "LeftButton" then
		JQuest:Log_Toggle()
	elseif self.dewdrop then
		self.dewdrop:Open(JQuestMinimap, 'children', function()
			self.dewdrop:AddLine('text', "JasonQuest", 'isTitle', true)
			self.dewdrop:FeedAceOptionsTable(self.options)
		end)
	end
end
function JQuest:MB_Init()
	local name = "JQuestMinimap"
	local frame = CreateFrame("Button", name, Minimap)
	frame:SetWidth(31)
	frame:SetHeight(31)
	frame:SetFrameStrata("LOW")
	frame:SetToplevel(1)
	frame:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	frame:SetPoint("TOPLEFT", Minimap, "TOPLEFT")

	local icon = frame:CreateTexture(name.."Icon", "BACKGROUND")
	icon:SetTexture("Interface\\QuestFrame\\UI-QuestLog-BookIcon")
	icon:SetWidth(20)
	icon:SetHeight(20)
	icon:SetPoint("TOPLEFT", frame, "TOPLEFT", 7, -5)

	local overlay = frame:CreateTexture(name.."Overlay", "OVERLAY")
	overlay:SetTexture("Interface\\Minimap\\MiniMap-TrackingBorder")
	overlay:SetWidth(53)
	overlay:SetHeight(53)
	overlay:SetPoint("TOPLEFT", frame, "TOPLEFT")

	frame:RegisterForClicks("LeftButtonUp", "RightButtonUp")
	frame:RegisterForDrag("LeftButton")
	frame:SetScript("OnClick", JQuest.MB_OnClick)
	frame:SetScript("OnMouseDown", function() _G[this:GetName().."Icon"]:SetTexCoord(0.1, 0.9, 0.1, 0.9) end)
	frame:SetScript("OnMouseUp", function() _G[this:GetName().."Icon"]:SetTexCoord(0, 1, 0, 1) end)
	frame:SetScript("OnEnter", JQuest.MB_OnEnter)
	frame:SetScript("OnLeave", function() GameTooltip:Hide() end)
	frame:SetScript("OnDragStart", JQuest.MB_OnDragStart)
	frame:SetScript("OnDragStop", JQuest.MB_OnDragStop)

	frame.position = self.var.position or 270
	frame.drag = GetMinimapShape and GetMinimapShape() or "ROUND"
	frame.locked = false

	self:MB_Move()
	self:MB_Refresh()

	self.dewdrop = AceLibrary:HasInstance("Dewdrop-2.0") and AceLibrary("Dewdrop-2.0")
end

-- ****************
-- Player Functions
-- ****************

function JQuest:RegisterQuestEvent()
	if not self:IsBucketEventRegistered("QUEST_LOG_UPDATE") and self:Party_Exists() then
		if not self.updatingLog then
			self:Log("Registering Event: QUEST_LOG_UPDATE")
			self:RegisterBucketEvent("QUEST_LOG_UPDATE", 1)
		end
	end
end
function JQuest:PLAYER_XP_UPDATE()
	self:Send("XP", UnitLevel("player"), UnitXP("player"), UnitXPMax("player"), GetXPExhaustion() or 0)
end
function JQuest:CHAT_MSG_SYSTEM()
	if self.Player.waitingForInit then return end
	local name, msg
	if strfind(arg1, "is not eligible") then
		_, _, name = strfind(arg1, "(.+) is not eligible for that quest")
		msg = "You are not eligible for that quest."
	elseif strfind(arg1, "'s quest log is full") then
		_, _, name = strfind(arg1, "(.+)'s quest log is full")
		msg = "Your quest log is full."
	elseif strfind(arg1, "is already on that quest") then
		_, _, name = strfind(arg1, "(.+) is already on that quest")
		msg = "You are already on that quest."
	elseif strfind(arg1, "is too far away to receive your quest") then
		_, _, name = strfind(arg1, "(.+) is too far away to receive your quest")
		msg = "You are too far away to receive " .. UnitName("player") .. "'s quests."
	elseif strfind(arg1, "has completed that quest") then
		_, _, name = strfind(arg1, "(.+) has completed that quest")
		msg = "You have already completed that quest."
	end

	if name then
		self:Comm_ShareResult(name, msg)
	end
end
function JQuest:QUEST_LOG_UPDATE()
	if self.Player.waitingForInit then return end
	self:Log("---- Event: QUEST_LOG_UPDATE (" .. GetTime() .. ") ----")

	if self:IsBucketEventRegistered("QUEST_LOG_UPDATE") then
		self:Log("Unregistering Event: QUEST_LOG_UPDATE")
		self:UnregisterBucketEvent("QUEST_LOG_UPDATE")
	end
	if not self:Party_Exists() then return end
	self.updatingLog = true

	local old = self:copyTable(self.PlayerQuests)
	self.PlayerQuests = self:Player_GetQuests()
	local new = self.PlayerQuests

	local changes, newBoard, oldBoard
	for title in pairs(new) do
		if not old[title] then
			self:Comm_SendQuest(title)
		elseif old[title] and new[title] then
			newBoard = new[title].leader
			oldBoard = old[title].leader
			if newBoard and oldBoard then
				for i = 1, getn(newBoard) do
					if oldBoard[i].text ~= newBoard[i].text then
						self:Comm_UpdateBoard(title)
						break
					elseif newBoard[i].status and oldBoard[i].status and newBoard[i].status ~= oldBoard[i].status then
						self:Comm_UpdateBoard(title)
						break
					elseif newBoard[i].status and not oldBoard[i].status then
						self:Comm_UpdateBoard(title)
						break
					end
				end
			end
			if (old[title].status or new[title].status) and old[title].status ~= new[title].status then
				self:Comm_UpdateQuest(title)
			end
		end
	end
	for title in pairs(old) do
		if not new[title] then
			self:Comm_DeleteQuest(title)
		end
	end

	self.updatingLog = nil
	self:SetDebug()
	self:Log_RefreshList()
	self:Log("**** End Event: QUEST_LOG_UPDATE ****")
end
function JQuest:Player_GetQuests()
	local playerQuests = {}
	local title, level, tag, group, header, isCollapsed, status, index, leader, leaderIndex, leaderText, leaderStatus
	local lastHeader = ""
	local collapsed = {}
	local selectedNow = GetQuestLogSelection()
	local numEntries, numQuests = GetNumQuestLogEntries()

	for index = 1, numEntries do
		_, _, _, _, _, isCollapsed = GetQuestLogTitle(index)
		if isCollapsed then
			tinsert(collapsed, index)
		end
	end
	if getn(collapsed) > 0 then
		ExpandQuestHeader(0)
	end

	numEntries, numQuests = GetNumQuestLogEntries()
	self.Player.numQuests = numQuests

	for index = 1, numEntries do
		title, level, tag, group, header, _, status, daily = GetQuestLogTitle(index)
		title = self:CleanQuestName(title)

		if header and title ~= lastHeader then
			lastHeader = title
		else
			SelectQuestLogEntry(index)
			playerQuests[title] = {
				id = index,
				header = lastHeader,
				pushable = GetQuestLogPushable(),
				daily = daily,
				level = level,
				tag = tag,
				group = group,
				status = status,
				questLink = GetQuestLink(index),
			}
			playerQuests[title].desc, playerQuests[title].obj = GetQuestLogQuestText()
			if GetNumQuestLeaderBoards(index) > 0 then
				leader = {}
				for leaderIndex = 1, GetNumQuestLeaderBoards(index) do
					leaderText, _, leaderStatus = GetQuestLogLeaderBoard(leaderIndex, index)
					if strfind(leaderText, " : 0/") then
						-- Try again, seems to happen during lag spikes
						leaderText, _, leaderStatus = GetQuestLogLeaderBoard(leaderIndex, index)
						self:Log("Objective Error: " .. leaderText)
					end
					leader[leaderIndex] = {
						text = leaderText,
						status = leaderStatus
					}
				end
				playerQuests[title].leader = leader
			end
			playerQuests[title].rewardInfo = self:GetRewardInfo()
			if GetQuestLogRequiredMoney() > 0 then
				if GetQuestLogRequiredMoney() > GetMoney() then
					playerQuests[title].requiredMoney = 0 - GetQuestLogRequiredMoney()
				else
					playerQuests[title].requiredMoney = GetQuestLogRequiredMoney()
				end
			end
		end
	end

	if getn(collapsed) > 0 then
		for index, header in pairs(collapsed) do
			CollapseQuestHeader(header)
		end
	end

	if selectedNow then
		_,_,_,_,header = GetQuestLogTitle(selectedNow)
		if not header then
			QuestLog_SetSelection(selectedNow)
		end
	end

	return playerQuests
end
function JQuest:GetRewardInfo()
	local money = GetQuestLogRewardMoney()
	local numQuestRewards = GetNumQuestLogRewards()
	local numQuestChoices = GetNumQuestLogChoices()
	local link, id, choices, rewards, spell
	local name, texture, numItems, isUsable

	-- Save choosable rewards
	if numQuestChoices > 0 then
		choices = {}
		for i = 1, numQuestChoices do
			link = GetQuestLogItemLink("choice", i)
			if not link then break end
			_, _, _, _, isUsable = GetQuestLogChoiceInfo(i)
			tinsert(choices, {[1]=link, [2]=(isUsable or 0)})
		end
	end
	if numQuestRewards > 0 then
		rewards = {}
		for i = 1, numQuestRewards do
			link = GetQuestLogItemLink("reward", i)
			if not link then break end
			name, _, _, _, isUsable = GetQuestLogRewardInfo(i)
			tinsert(rewards, {[1]=link, [2]=(isUsable or 0)})
		end
	end
	if GetQuestLogRewardSpell() then
		spell = {}
		texture, name, isTradeskillSpell, isSpellLearned = GetQuestLogRewardSpell()
		spell.texture = texture
		spell.name = name
		spell.isTradeskillSpell = isTradeskillSpell
		spell.isSpellLearned = isSpellLearned
	end

	if (money + numQuestChoices + numQuestRewards > 0) or spell then
		local allRewards = {
			choices = choices,
			rewards = rewards,
			spell = spell,
			money = money
		}
		return allRewards
	else
		return nil
	end
end
function JQuest:ClearShare(who)
	self.PartyRequested[who] = nil
end

-- ***************
-- Party Functions
-- ***************

-- Faster than GetPartyMember(1) even
function JQuest:Party_Exists()
	for name, status in pairs(self.Party) do
		if status > 0 then
			return true
		end
	end
	return self.var.debugMode
end
function JQuest:Party_GetNum()
	local num = 0
	for name in pairs(self.Party) do
		num = num + 1
	end
	return num
end
function JQuest:Party_GetID(who)
	for i = 1, MAX_PARTY_MEMBERS do
		if UnitName("party" .. i) == who then
			return i
		end
	end
end
function JQuest:PARTY_MEMBERS_CHANGED()
	if self.Player.waitingForInit then return end
	self:Log("Event: PARTY_MEMBERS_CHANGED")
	self:Party_Refresh()
	self:Log_RefreshTabs()
	self:Log_RefreshList()
	self:Log_RefreshDetails(1)
	self:MB_Refresh()
	self:ScheduleEvent(self.Party_Ping, 2, self)
end
function JQuest:Party_CheckRevs()
	local newer, older
	for name, revision in pairs(self.Party) do
		if revision and self.revision < revision then
			newer = revision
		elseif revision and self.revision > revision then
			older = revision
		elseif revision == 1 then
			older = 1
		end
	end
	if newer then
		JQuestLogVersionText:SetHeight(28)
		JQuestLogVersionText:SetText("JasonQuest v" .. self.version .. "\n|cffff0000new! r|r" .. newer)
	elseif older and older > 1 then
		JQuestLogVersionText:SetHeight(28)
		JQuestLogVersionText:SetText("JasonQuest v" .. self.version .. "\n|cffff0000old versions detected! r|r" .. older)
	elseif older then
		JQuestLogVersionText:SetHeight(28)
		JQuestLogVersionText:SetText("JasonQuest v" .. self.version .. "\n|cffff0000old versions detected! r|r70617")
	else
		JQuestLogVersionText:SetHeight(14)
		JQuestLogVersionText:SetText("JasonQuest v" .. self.version)
	end
end
function JQuest:Party_Ping()
	for name, status in pairs(self.Party) do
		if status and status < 1 then
			-- Don't ping known-good users
			self:Comm_Ping(name)
		end
	end
end
function JQuest:Party_Refresh()
	local currentMembers = {}
	local name

	for i = 1, MAX_PARTY_MEMBERS do
		if GetPartyMember(i) then
			name = UnitName("party" .. i)
			currentMembers[name] = i
			
			if not self.Party[name] or (self.Party[name] and self.Party[name] < 0) then
				-- New member, or non-JQuest member, update ID
				self.Party[name] = -i
			elseif self.Party[name] and self.Party[name] > 0 then
				-- Already a member, update ID
				self.Party[name] = i
			end
		end
	end
	for name in pairs(self.Party) do
		if not currentMembers[name] then
			-- Departed member
			self:Party_Kill(name)
		end
	end
end
function JQuest:Party_Kill(who)
	self.Party[who] = nil
	self.PartyQuests[who] = nil
	self.PartyFrameData[who] = nil
	self.PartySending[who] = nil
	self.PartyXP[who] = nil

	if self.LogFrame.selectedWho == who then
		self.LogFrame.selectedWho = nil
		self.LogFrame.selectedQuest = nil
		self:Log_FrameBlank()
	end
end
