﻿function JQuest:ReceiveMessage(prefix, sender, dist, compat, action, a, b, c, d)
	if self.Player.waitingForInit or not action then return end
	self:Log("ReceiveMessage(): " .. sender .. " - " .. action)
	if compat < self.COMM_COMPAT then
		-- When other sends request and they're running an older version
		if not self.Party[sender] or (self.Party[sender] and self.Party[sender] ~= 0) then
			self:Log(sender .. " is running an older version of JQuest (" .. compat .. ") - Not sending.", 1)
		end
		self.Party[sender] = 0
		self:Log_RefreshTabs()
	elseif compat > self.COMM_COMPAT then
		-- When other sends request and they're running a newer version
		if not self.Party[sender] or (self.Party[sender] and self.Party[sender] ~= 0) then
			self:Log(sender .. " is using a newer version of JQuest (" .. compat .. ") - Please upgrade.", 1)
		end
		self.Party[sender] = 0
		self:Log_RefreshTabs()
	elseif type(action) == 'string' and self.Comm[action] then
		if self.Party[sender] and self.Party[sender] <= 0 then
			self:Comm_Ping(sender)	-- Re-ping someone who shouldn't be pinging, probably a /rl
		end
		self.Comm[action](self, sender, a, b, c, d)
	end
end
function JQuest:Send(action, a, b, c, d)
	--self:Log("Send(): " .. action)
	self:SendCommMessage("PARTY", self.COMM_COMPAT, action, a, b, c, d)
	if action == "ENDL" then
		self.Player.sending = nil
		self:Log("Completed sending questlog")
	end
end
function JQuest:SendTo(who, action, a, b, c, d)
	if not self:Party_GetID(who) then return end
	if strfind(who, "party") then
		self:Log("Trying to SendTo \"" .. who .. "\" - " .. action)
		return
	end
	if self.Party[who] and abs(self.Party[who]) > 0 and not UnitInRaid("player") then
		local unit = "party" .. self:Party_GetID(who)
		if UnitExists(unit) and UnitIsConnected(unit) and strfind(who, "-") == nil then
			self:Log("SendTo(): " .. who .. " - " .. action)
			self:SendCommMessage("WHISPER", who, self.COMM_COMPAT, action, a, b, c, d)
		end
	end
end

-- **********************
-- Outgoing Comm Handlers (We send with these)
-- **********************
function JQuest:Comm_Ping(who)
	if not self.PartyPing[who] then
		self.PartyPing[who] = GetTime()
		self:SendTo(who, "PING")
	elseif self.PartyPing[who] > GetTime() + 5 then
		self.PartyPing[who] = GetTime()
		self:SendTo(who, "PING")
	end
end
function JQuest:Comm_SendLog(who)
	if not self.Player.sending then
		self.Player.sending = true
		self:Log("Starting questlog transfer...")
		self:Send("STARTL", self.Player.numQuests)
		for title, data in pairs(self.PlayerQuests) do
			self:Send("ADDQ", title, data)
		end
		self:Send("ENDL")
	else
		self:SendTo(who, "BUSY")
	end
end
function JQuest:Comm_SendQuest(title)
	self:Log("Sending quest ADD: " .. title)
	self:Send("ADDQ", title, self.PlayerQuests[title])
end
function JQuest:Comm_DeleteQuest(title)
	self:Log("Sending quest DEL: " .. title)
	self:Send("DELQ", title)
end
function JQuest:Comm_UpdateQuest(title)
	self:Log("Sending quest UPD: " .. title)
	self:Send("UPDQ", title, self.PlayerQuests[title].status)
end
function JQuest:Comm_UpdateBoard(title)
	self:Log("Sending leaderboard UPD: " .. title)
	self:Send("UPDB", title, self.PlayerQuests[title].leader)
end
function JQuest:Comm_SyncQuests(who)
	if not who then who = self.LogFrame.selectedWho end
	if who and self.PartyQuests[who] and not self.Player.sending then
		local known = {}
		for title in pairs(self.PartyQuests[who]) do
			tinsert(known, title)
		end
		self:SendTo(who, "SYNC", known)
	elseif who then
		self:SendTo(who, "BUSY")
	end
end
function JQuest:Comm_RequestQuest(who, title)
	self:SendTo(who, "REQQ", title)
end
function JQuest:Comm_RequestShare()
	local who = self.LogFrame.selectedWho
	local title = self.LogFrame.selectedQuest
	if not who or not title then return end
	self.PartyRequested[who] = 1
	self:SendTo(who, "SHAREQ", title)
	self:ScheduleEvent(self.ClearShare, 15, self, who)
end
function JQuest:Comm_ShareResult(who, message)
	self:SendTo(who, "SHARER", message)
end

-- ***********************
-- Incomming Comm Handlers (We received these)
-- ***********************
JQuest.Comm = {}
function JQuest.Comm:XP(sender, level, xp, xpmax, xprest)
	self.PartyXP[sender] = {
		level = level,
		xp = xp,
		xpmax = xpmax,
		xprest = xprest
	}
end
function JQuest.Comm:BUSY(sender)
	self:Log("Comm:BUSY(): " .. sender)
	self:ScheduleEvent(self.Comm_SyncQuests, 5, self, sender)
end
function JQuest.Comm:PING(sender)
	self:Log("Comm:PING(): " .. sender)
	self:SendTo(sender, "PONG", self.revision)
	self:PLAYER_XP_UPDATE()
end
function JQuest.Comm:PONG(sender, revision)
	self:Log("Comm:PONG(): " .. sender)
	if not self.Party[sender] or self.Party[sender] < 0 then
		local id = self:Party_GetID(sender)
		if id then
			if revision then
				self.Party[sender] = revision
			else
				self.Party[sender] = 1
			end
			self:Log_RefreshTabs()
			self:SendTo(sender, "REQL")
			self:MB_Refresh()
		end
	end
	self:Party_CheckRevs()
end
function JQuest.Comm:STARTL(sender, totalQuests)
	if not self.PartyQuests[sender] then
		self:Log("Comm:STARTL(): " .. sender .. " - " .. totalQuests)
		self.PartySending[sender] = totalQuests
		self.PartyQuests[sender] = {}
		self:Log_RefreshTabs()
	end
end
function JQuest.Comm:ENDL(sender)
	if self.PartySending[sender] then
		self:Log(sender .. "'s Quest Log is now available.", 1)
		self.PartySending[sender] = nil
		self:Log_RefreshTabs()
	end
end
function JQuest.Comm:ADDQ(sender, title, quest)
	if not self.PartyQuests[sender] then
		self.PartyQuests[sender] = {}
	end
	self:Log("Comm:ADDQ(): " .. sender .. " - " .. title)
	self.PartyQuests[sender][title] = quest
	self:Log_CacheRewards(quest.rewardInfo)

	self:Log_RefreshTabs()
	self:Log_RefreshList()
end
function JQuest.Comm:DELQ(sender, title)
	self:Log("Comm:DELQ(): " .. sender .. " - " .. title)
	if not self.PartyQuests[sender] or not self.PartyQuests[sender][title] then
		return
	end

	self.PartyQuests[sender][title] = nil

	if self.LogFrame.selectedWho == sender then
		self:Log_RefreshList()
		if self.LogFrame.selectedQuest == title then
			self.LogFrame.selectedQuest = nil
			self:Log_RefreshDetails()
		end
	end

	if self:QW_IsWatched(sender, title) then
		self:QW_Refresh()
	end
end
function JQuest.Comm:UPDQ(sender, title, status)
	self:Log("Comm:UPDQ(): " .. sender .. " - " .. title)
	local tag
	if status and status < 0 then
		tag = FAILED
	elseif status and status > 0 then
		tag = COMPLETE
	else
		-- Probably turned in
		if self.PartyQuests[sender] and self.PartyQuests[sender][title] then
			self.PartyQuests[sender][title].status = status
		end
		self:Log_RefreshList()
		return
	end
	if self.PartyQuests[sender] and self.PartyQuests[sender][title] then
		self.PartyQuests[sender][title].status = status
		self:Log("[" .. sender .. "] " .. title .. ": " .. tag, self.var.showUpdates)
	end
	if self:QW_IsWatched(sender, title) then
		self:QW_Refresh()
	end
	self:Log_RefreshList()
	if self.LogFrame.selectedQuest == title then
		self:Log_RefreshDetails()
	end
end
function JQuest.Comm:UPDB(sender, title, board)
	self:Log("Comm:UPDB(): " .. sender .. " - " .. title)
	if self.PartyQuests[sender] and self.PartyQuests[sender][title] then
		local old = self:copyTable(self.PartyQuests[sender][title])
		self.PartyQuests[sender][title].leader = board

		local watchit
		if old and old.leader then
			local oldBoard = old.leader
			for i = 1, getn(oldBoard) do
				watchit = false
				if board[i].status and oldBoard[i].status and board[i].status ~= oldBoard[i].status then
					watchit = true
					break
				elseif board[i].status and not oldBoard[i].status then
					watchit = true
					break
				end
				if oldBoard[i].text and board[i].text and oldBoard[i].text ~= board[i].text then
					local _,_,num = strfind(board[i].text, "(%d+)/%d+")
					if not num or (tonumber(num) and tonumber(num) ~= 0) then
						watchit = true
						break
					end
				end
				if watchit then
					self:Log("[" .. sender .. "] " .. title .. ": " .. board[i].text, self.var.showUpdates)
				end
			end
			if self.var.autoTrack and watchit then
				self:QW_Add(sender, title, GetTime() + 300)
			end
		end
		if self.LogFrame.selectedWho == sender and self.LogFrame.selectedQuest == title then
			self:Log_RefreshDetails()
		end
	end
end
function JQuest.Comm:SYNC(sender, data)
	self:Log("Comm:SYNC(): " .. sender)
	self:QUEST_LOG_UPDATE()
	local missing, extra = {}, {}
	local found
	for title in pairs(self.PlayerQuests) do
		for _,remoteTitle in pairs(data) do
			if remoteTitle == title then
				found = true
				break
			end
		end
		if not found then
			tinsert(missing, title)
		end
		found = nil
	end
	for _,title in pairs(missing) do
		self:Comm_SendQuest(title)
	end
	for _,remoteTitle in pairs(data) do
		for title in pairs(self.PlayerQuests) do
			if remoteTitle == title then
				found = true
				break
			end
		end
		if not found then
			tinsert(extra, title)
		end
		found = nil
	end
	for _,title in pairs(extra) do
		self:Comm_DeleteQuest(title)
	end
end
function JQuest.Comm:REQL(sender)
	self:Log("Comm:REQL(): " .. sender)
	self:Comm_SendLog(sender)
end
function JQuest.Comm:REQQ(sender, title)
	self:Log("Comm:REQQ(): " .. sender .. " - " .. title)
	self.PlayerQuests = self:Player_GetQuests()

	if self.PlayerQuests[title] then
		self:Comm_SendQuest(title)
	end
end
function JQuest.Comm:SHAREQ(sender, title)
	self:Log("Comm:SHAREQ(): " .. sender .. " - " .. title)

	self.PartyRequested[sender] = true

	if self:IsBucketEventRegistered("QUEST_LOG_UPDATE") then
		self:Log("Unregistering Event: QUEST_LOG_UPDATE")
		self:UnregisterBucketEvent("QUEST_LOG_UPDATE")
	end
	self.updatingLog = true

	local collapsed = {}
	local logId
	local selectedNow = GetQuestLogSelection()
	local numEntries, numQuests = GetNumQuestLogEntries()

	-- Save what zones are collapsed, and expand them all
	for index = 1, numEntries do
		_, _, _, _, _, isCollapsed = GetQuestLogTitle(index)
		if isCollapsed then
			tinsert(collapsed, index)
		end
	end
	if getn(collapsed) > 0 then
		ExpandQuestHeader(0)
	end

	numEntries, numQuests = GetNumQuestLogEntries()
	for index = 1, numEntries do
		logTitle = GetQuestLogTitle(index)
		logTitle = self:CleanQuestName(logTitle)
		if logTitle == title then
			logId = index
			break
		end
	end
	if logId then
		QuestLog_SetSelection(logId)
		QuestLogPushQuest()
	end
	if getn(collapsed) > 0 then
		for index, header in pairs(collapsed) do
			CollapseQuestHeader(header)
		end
	end
	if selectedNow then
		_,_,_,_,header = GetQuestLogTitle(selectedNow)
		if not header then
			QuestLog_SetSelection(selectedNow)
		end
	end
	self.updatingLog = nil
end
function JQuest.Comm:SHARER(sender, msg)
	if self.PartyRequested[sender] then
		self:Log(msg, 1)
	end
end
