-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
-- Jamba - Jafula's Awesome Multi-Boxer's Assistant Addon.
-- Locale for Jamba - enUS.
-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
local L = LibStub("AceLocale-3.0"):NewLocale("Jamba", "enUS", true)

if L then

-------------------------------------------------------------------------------------------------------------
-- Key Press To Activate Text
-------------------------------------------------------------------------------------------------------------
L["__KEY_PRESS_TO_ACTIVATE__"] = function( key1, key2 )
	local message = ""
	if key1 or key2 then
		message = message.."Press "
	end
	if key1 then
		message = message..key1.." "
	end
	if key2 then
		if key1 then
			message = message.."or "..key2.." "
		else
			message = message..key2.." "
		end
	end
	if key1 or key2 then
		message = message.."to activate."
	end	
	return message
end

-------------------------------------------------------------------------------------------------------------
-- Common Phrases
-------------------------------------------------------------------------------------------------------------

L["Add"] = true
L["Remove"] = true
L["Enable"] = true
L["Disable"] = true
L["on"] = true
L["off"] = true

-------------------------------------------------------------------------------------------------------------
-- Settings
-------------------------------------------------------------------------------------------------------------

L["Push To Characters"] = true
L["Push these settings to all characters that are enabled (in Jamba) and online."] = true
L["Failed to read settings received from "] = true
L[" settings updated successfully."] = true

-------------------------------------------------------------------------------------------------------------
-- JambaComms
-------------------------------------------------------------------------------------------------------------

-- Name
L["Jamba"] = true

-- Keybindings
L["Set Focus"] = true

-- Jamba Interface / Member Management
L["Team"] = true
L["Welcome to Jamba.  For information please visit: http://wow.jafula.com/addons/jamba"] = true
L["Select Master"] = true
L["Select the master character."] = true
L["Team List"] = true
L["Characters in your 'group'; check to enable communication with them."] = true
L["Add a new member to the member list."] = true
L["Enter name of character to add:"] = true
L["Remove selected members from the member list."] = true
L["Are you sure you wish to remove the selected characters from the member list?"] = true
L["Did not set master as that character is not in my member list."] = true
L["Set Me As Master"] = true
L["Set this character as the master."] = true
L["Set Master As Target"] = true
L["Update the set master as target command to set the current master as the target.  You need to press the key assigned to 'Set Master As Target' to actually set the master as the target."] = true
L["Enable a member."] = true
L["Disable a member."] = true
									
-- Focus Management
L["?"] = true
L["Set Focus To The Master"] = true
L["Update the set Focus command to set Focus to the master.  You need to press the key assigned to 'Set Focus' to actually set the Focus."] = true
L["Set Focus To A Target"] = true
L["Update the set Focus command to set Focus to a target specified as the first parameter.  You need to press the key assigned to 'Set Focus' to actually set the Focus."] = true
L["IN COMBAT - FAILED to update Focus target to X."] = function( X )
  return "IN COMBAT - FAILED to update Focus target to "..X.."."
end
L["Focus target is now W (currently X).  "] = function( focusTarget, resolvedFocusTarget )
	return string.format( "Focus target is now %s (currently %s).  ", focusTarget, resolvedFocusTarget )
end
L["Set Focus To Master When Changing Master"] = true
L["When the master changes, make sure that Focus changes to the new master."] = true
L["Set Target To Master When Changing Master"] = true
L["When the master changes, make sure that target changes to the new master."] = true
L["On Focus Change Set Focus To Master"] = true
L["When this characters Focus changes, set the new focus to be the master."] = true
														
-- Target Management
L["Set Target To Master When Changing Master"] = true
L["When the master changes, make sure that target changes to the new master."] = true
L["Set Master"]  = true
L["Set the target specified in the first parameter to be the master."]  = true
L["Set Master As Target"]  = true
L["Update the set master as target command to set the current master as the target.  You need to press the key assigned to 'Set Master As Target' to actually set the master as the target."] = true
L["IN COMBAT - FAILED to update master target to X."] = function( X )
  return "IN COMBAT - FAILED to update master target to "..X.."."
end
L["Master target is now X.  "] = function( masterTarget )
	return string.format( "Master target is now %s.  ", masterTarget )
end

-- Tags		
L["all"] = true	
L["Tags"] = true
L["Names that this character answers to when given a command."] = true
L["Edit Tags For"] = true
L["Select the character to edit tags for."] = true
L["Add Tag"] = true
L["Add a new tag to the tag list."] = true
L["Remove Tags"] = true
L["Remove selected tags from the tag list."] = true
L["Enter a tag:"] = true
L["Are you sure you wish to remove the selected tags?"] = true
L["Add Tag To Character"] = true
L["Add a tag to a character."] = true
L["Remove Tag From Character"] = true
L["Remove a tag from a character."] = true

-- Warning
L["Warning"] = true
L["Show Warnings In Default Chat (On Master)"] = true
L["Display warnings from slaves in default chat.  Must be checked on both master and slave."] = true
L["Show Warnings In Raid Warning (On Master)"] = true
L["Display warnings from slaves using a raid warning.  Must be checked on both master and slave."] = true
L["Send Warnings To Channel (All)"] = true
L["Send all warnings to a channel."] = true
L["Warning Channel Name"] = true
L["The name of the channel to join for warnings."] = true
L["Warning Channel Password"] = true
L["The password of the channel to join for warnings."] = true
L["Send Warnings To Guild Chat (All)"] = true
L["Send all warnings to guild chat."] = true
L["Send Warnings To Guild Officer Chat (All)"] = true
L["Send all warnings to guild officer chat."] = true
L["Send Warnings To Party Chat (All)"] = true
L["Send all warnings to party chat."] = true
L["Send Warnings Via Whisper (To Master)"] = true
L["Send all warnings to the master via whisper."] = true

-- Chat
L["Chat"] = true
L["Show Messages In Default Chat (On Master)"] = true
L["Display messages from slaves in default chat.  Must be checked on both master and slave."] = true
L["Show System Messages In Default Chat (On Master)"] = true
L["Display system messages (clickable links) from slaves in default chat.  Must be checked on both master and slave."] = true
L["Send Messages To Channel (All)"] = true
L["Send all messages to a channel."] = true
L["Message Channel Name"] = true
L["The name of the channel to join for messages."] = true
L["Message Channel Password"] = true
L["The password of the channel to join for messages."] = true
L["Send Messages To Guild Chat (All)"] = true
L["Send all messages to guild chat."] = true
L["Send Messages To Guild Officer Chat (All)"] = true
L["Send all messages to guild officer chat."] = true
L["Send Messages To Party Chat (All)"] = true
L["Send all messages to party chat."] = true
L["Send Messages Via Whisper (To Master)"] = true
L["Send all messages to the master via whisper."] = true
														
-- Target & Focus
L["Target & Focus"] = true
								
-------------------------------------------------------------------------------------------------------------
-- JambaMe
-------------------------------------------------------------------------------------------------------------

L["Warn If Hit First Time In Combat (Slave)"] = true
L["Warn the master when I get hit for the first time in combat."] = true
L["Warn If Target Not Master On Combat (Slave)"] = true
L["Warn the master if my target is not the master when entering combat."] = true
L["Warn If My Health Drops Below"] = true
L["Warn the master if my health drops below a set percentage."] = true
L["Health Amount"] = true
L["The percentage of health allowed before warning."] = true
L["Warn If My Mana Drops Below"] = true
L["Warn the master if my mana drops below a set percentage."] = true
L["Mana Amount"] = true
L["The percentage of mana allowed before warning."] = true
L["Low Health!"] = true
L["Low Mana!"] = true
L["Not Targeting!"] = true
L["I'm Attacked!"] = true
L["Auto Accept Resurrect Request"] = true
L["Automatically accept a resurrection request."] = true
L["Hit First Time Message"] = true
L["The message to send the master when hit for the first time on combat."] = true
L["Warn Target Not Master Message"] = true
L["The message to send the master when entering combat and the target is not the master."] = true
L["Warn Health Drop Message"] = true
L["The message to send the master when my health drops below a set percentage."] = true
L["Warn Mana Drop Message"] = true
L["The message to send the master when my mana drops below a set percentage."] = true
										
-------------------------------------------------------------------------------------------------------------
-- JambaFollow
-------------------------------------------------------------------------------------------------------------

L["Warn If I Stop Following"] = true
L["Warn the master if I stop following."] = true
L["Auto Follow After Combat"] = true
L["Automatically follow after combat."] = true
L["Follow Broken Message"] = true
L["The message to tell the master when follow has broken."] = true
L["Follow Broken!"] = true
L["Auto Follow After Follow Breaks"] = true
L["Automatically follow after follow was broken unexpectedly."] = true
L["Auto Follow After Zoning"] = true
L["Automatically follow after changing zones."] = true
L["Follow The Master"] = true
L["Follow the current master."] = true
L["Follow A Target"] = true 
L["Follow the target specified."] = true
L["Begin Follow Strobing Target."] = true
L["Begin a sequence of follow commands that strobe every second (configurable) a specified target."] = true
L["Begin Follow Strobing Me."] = true
L["Begin a sequence of follow commands that strobe every second (configurable) this character."] = true
L["Begin Follow Strobing Last Target."] = true
L["Begin a sequence of follow commands that strobe every second (configurable) the last follow target character."] = true
L["End Follow Strobing."] = true
L["End the strobing of follow commands."] = true
L["Seconds Between Strobe Follow"] = true
L["The number of seconds delay before issuing a follow command."] = true
L["Follow Options"] = true
L["Follow Strobing"] = true
															
-------------------------------------------------------------------------------------------------------------
-- JambaTalk
-------------------------------------------------------------------------------------------------------------

L["Options"] = true
L["Forward Whispers And Relay"] = true
L["Forward whispers to character to the master and relay replies back."] = true
L["Request Who Information"] = true
L["Request /who information from server about character that whispered.  To view on master, enable forwarding of system messages."] = true
L["Forward System Messages"] = true
L["Forward system messages (like /who information) to master."] = true
L["Forward Messages"] = true
L["System Messages To Forward"] = true
L["System messages to forward."] = true
L["Chat Snippets"] = true
L["Snippets of text to send and their associated shortcut text."] = true
L["Add a partial system message to forward."] = true
L["Remove selected partial system messages."] = true
L["Remove a partial system message to forward."] = true
L["Add a snippet of chat text."] = true
L["Remove a snippet of chat text."] = true
L["Whisper received from "] = true
L["."] = true
L["GM"] = true
L["<GM>"] = true
L["Are you sure you wish to remove the selected chat snippets?"] = true
L["Enter a chat snippet in the form name=text.  (e.g. no=Sorry, I am busy right now.) :"] = true
L["Enter part of a system message to forward on:"] = true
L["Are you sure you wish to remove the selected forward messages?"] = true
L["Whisper forwarding will forward a whisper directed to a slave to the master.  Reply to the slave from the master and the slave will reply to the original whisper with the masters reply."] = true
L["For commonly used replies, set up a chat snippet on the slave to save typing.  To send a chat snippet, use a ! followed by the name of the chat snippet."] = true
L["To direct a whisper to another character from the slave, begin the whisper to the slave with @ followed by the name of the character."] = true
L["With this option and the forwarding system messages option, the master receives /who information about the whisperer and a clickable link to the orginal whisperer."] = true
L["Forwarding system messages will forward the specifed system messages (yellow text) to the master.  To specify a message to be forwarded, you can add a part of the message to forward to the forward message list."] = true
L["Level"] = true

-------------------------------------------------------------------------------------------------------------
-- JambaMerchant
-------------------------------------------------------------------------------------------------------------

-- Auto sell.
L["Auto Sell"] = true
L["Auto Sell Poor Quality Items"] = true
L["Automatically sell poor quality (grey) items."]  = true
L["I have sold: "] = true

-- Auto repair.
L["Auto Repair"] = true
L["Automatically repair all items."] = true
L["Auto Repair With Guild Funds"] = true
L["Automatically repair all items using guild funds."] = true
L["I do not have enough money to repair all my items."] = true
L["Repairing cost me: "] = true

-- Auto buy.
L["Auto Buy"] = true
L["Automatically re-stock items."] = true
L["Auto Buy Overflow"] = true
L["Allow automatic buying to overflow on maximum amount when buying items in stacks."] = true
L["Items to Buy"] = true
L["Items To Buy Automatically"] = true
L["Items to Buy (check to mark for removal)"] = true
L["Add Item"] = true
L["Item (drag an item to the edit box)"] = true
L["The item to buy (drag item to the edit box)."] = true
L["Item Tag"] = true
L["The tag for this item.  Only characters that have this tag will buy this item."] = true
L["Add an item to the auto buy list."] = true
L["[Item Link] <number of items> <tag>"] = true
L["Add Items"] = true
L["Amount"] = true
L["The amount of the item to buy."] = true
L["Remove Items"] = true
L["Remove selected items from the auto buy list."] = true
L["Remove Item"] = true
L["Remove an item from the auto buy list."] = true
L["[Item Link]"] = true
L["I do not have enough space in my bags to complete my purchases."] = true
L["I do not have enough money to complete my purchases."] = true
L["I do not have enough other currency to complete my purchases."] = true
L["Are you sure you wish to remove the selected items from the auto buy list?"] = true

-- Quietly now...
L["Do Merchant Business Silently"] = true
L["Do not tell the master if the character has completed business with a merchant."] = true
                                        
-------------------------------------------------------------------------------------------------------------
-- JambaGroup
-------------------------------------------------------------------------------------------------------------

-- Group auto accept/decline.
L["Auto Accept Members"] = true
L["Automatically accept group invites from enabled members."] = true
L["Auto Accept Friends"] = true
L["Automatically accept group invites from friends."] = true
L["Auto Decline Stranger Invites"] = true
L["Automatically decline group invites from strangers."] = true
L["Auto Set Loot To Free For All"]  = true
L["When the party leader is this character or the loot method changes, automatically set the party loot method to 'free for all'."] = true
L["Auto Pass On Loot Rolls"] = true
L["Automatically pass on loot rolls."] = true
L["Opt Out Of Loot"] = true
L["When in a party, automatically set opt out of loot to on."] = true
L["Invite Team"] = true
L["Invite all the enabled members in the team to a group.  You can also use /jamba-group invite."] = true
L["Disband Team"] = true
L["All the enabled members in the team leave their group.  You can also use /jamba-group disband."] = true
L["Auto Promote Master To Leader"] = true
L["Promote the master to the party leader when the master changes."] = true
					
-------------------------------------------------------------------------------------------------------------
-- JambaTaxi
-------------------------------------------------------------------------------------------------------------

L["Take Master's Taxi"] = true
L["Take the same flight as the master did (slaves's must have NPC Flight Master window open)."] = true
L["I cannot take the same flight as you.  I do not know where to go."] = true

-------------------------------------------------------------------------------------------------------------
-- JambaQuest
-------------------------------------------------------------------------------------------------------------

L["Jamba-Quest"] = true
L["(No Quest Selected)"] = true
L["Select"] = true
L["Abandon"] = true
L["Add Watch"] = true
L["Remove Watch"] = true
L["Quest Options"] = true
L["Send Control"] = true
L["These advanced options are for finer control over when the master sends quest log updates to the slaves.  If you have certain addons installed, they may cause delays in the slaves responses.  Here you can specify key modifiers that must be pressed before a command will be sent to a slave."] = true
L["Only Send If Quest Log Visible"] = true
L["The master will only react to quest log interactions if the quest log is visible."] = true
L["Key Modifiers Required To Send"] = true
L["Key modifiers are required to be pressed on the master before commands will be sent to the slaves."] = true
L["Left Alt"] = true
L["Left alt must be pressed on the master before commands will be sent to the slaves."] = true
L["Left Ctrl"] = true
L["Left control must be pressed on the master before commands will be sent to the slaves."] = true
L["Left Shift"] = true
L["Left shift must be pressed on the master before commands will be sent to the slaves."] = true
L["Right Alt"] = true
L["Right alt must be pressed on the master before commands will be sent to the slaves."] = true
L["Right Ctrl"] = true
L["Right control must be pressed on the master before commands will be sent to the slaves."] = true
L["Right Shift"] = true
L["Right shift must be pressed on the master before commands will be sent to the slaves."] = true
L["Mirror Master Quest Selection"] = true
L["Slaves follow the same steps as the master for quest selection.  All toons must have the quest dialog open."] = true
L["Slave Auto Accept ANY Quests"] = true
L["Slave automatically accepts quests when interacting with an npc or when a quest is shared with them."] = true
L["Slave Auto Accept Escort Quest"] = true
L["Slave automatically accepts escort quests."] = true
L["Mirror Master Decline Quest"] = true
L["Slaves follow the same steps as the master for declining quests.  All toons must have the quest dialog open."] = true
L["Mirror Master Abandon Quest"] = true
L["Slaves follow the same steps as the master for abandoning quests.  All toons must have the quest dialog open."] = true
L["Mirror Master Complete Quest (No Reward Choice)"] = true
L["Slaves follow the same steps as the master for completing quests that have no reward choices.  All toons must have the quest dialog open."] = true
L["Mirror Master Complete Quest (WITH Reward Choice)"] = true
L["Slaves follow the same steps as the master for completing quests that have a reward choice.  All toons must have the quest dialog open."] = true
L["Slave Auto Complete Quest (No Reward Choice)"] = true
L["Slave automatically completes quests that have no reward choices."] = true
L["Mirror Master Quest Watch"] = true
L["Slaves follow the same steps as the master for watching quests."] = true
L["Quest Silently"] = true
L["Do not tell the master about this toon's quests."] = true
L["Show Jamba-Quest Log With WoW Quest Log"] = true
L["Show the Jamba-Quest log with the normal WoW quest log."] = true
L["Accepted Quest: "] = true
L["I do not have the quest: "] = true
L["I have abandoned the quest: "] = true
L["I have declined the quest: "] = true
L["Completed Quest: "] = true
L["Show Quest Command"] = true
L["Show or hide the quest command window."] = true
L["Quest has X reward choices."] = function( choices )
	return string.format( "Quest has %s reward choices.", choices )
end
L["Other Options"] = true
L["Quest NPC (Advanced)"] = true
L["Quest Log (Safe)"] = true
L["Quest NPC (Safe)"] = true

-------------------------------------------------------------------------------------------------------------
-- JambaNo
-------------------------------------------------------------------------------------------------------------

L["Auto Deny Duels"] = true
L["Automatically deny duel requests."] = true
L["Deny Duels Silently"] = true
L["Do not tell the master if the character has denied a duel."] = true
L["Auto Deny Guild Invites"] = true
L["Automatically deny guild invitations."] = true
L["Deny Guild Invites Silently"] = true
L["Do not tell the master if the character has denied a guild invite."] = true
L["I refused a duel from: "] = true
L["I refused a guild invite to: "] = true
L[" from: "] = true

end
