-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
-- Jamba - Jafula's Awesome Multi-Boxer's Assistant Addon.
-- JambaUtils - Miscellaneous functions and constants.
-------------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------------------------
local MAJOR, MINOR = "JambaUtils-1.0", 0.1
local JambaUtils = LibStub:NewLibrary(MAJOR, MINOR)
if not JambaUtils then 
	return 
end

-------------------------------------------------------------------------------------------------------------
-- JambaUtils:Constants
-------------------------------------------------------------------------------------------------------------

-- Bags.
JambaUtils.BAG_PLAYER_BACKPACK = 0
-- NUM_BAG_SLOTS is defined as 4 in Blizzard's FrameXML\BankFrame.lua.
JambaUtils.BAG_PLAYER_MAXIMUM = NUM_BAG_SLOTS

-- Item constants.
JambaUtils.ITEM_QUALITY_POOR = 0

-- Money constants.
JambaUtils.COPPER_PER_SILVER = 100;
JambaUtils.SILVER_PER_GOLD = 100;
JambaUtils.COPPER_PER_GOLD = JambaUtils.COPPER_PER_SILVER * JambaUtils.SILVER_PER_GOLD;

-- Colour constants.
JambaUtils.COLOUR_COPPER = "eda55f"
JambaUtils.COLOUR_SILVER = "c7c7cf"
JambaUtils.COLOUR_GOLD = "ffd700"

-- Communication.
JambaUtils.COMMUNICATION_PREFIX = "JambaCommsMessage"
JambaUtils.COMMUNICATION_WHISPER = "WHISPER"
JambaUtils.COMMUNICATION_PRIORITY_BULK = "BULK"
JambaUtils.COMMUNICATION_PRIORITY_NORMAL = "NORMAL"
JambaUtils.COMMUNICATION_PRIORITY_ALERT = "ALERT"
JambaUtils.COMMAND_PREFIX = "JambaCommsCommand"
JambaUtils.COMMAND_SEPERATOR = "\004"
JambaUtils.COMMAND_ARGUMENT_SEPERATOR = "\005"
JambaUtils.WARNING_PREFIX = "JambaCommsWarning"

-- Communication commands.
-- Taxi.
JambaUtils.COMMAND_TAKE_TAXI = "TakeTaxi"
-- Quests.
JambaUtils.COMMAND_SELECT_GOSSIP_OPTION = "SelectGossipOption"
JambaUtils.COMMAND_SELECT_GOSSIP_ACTIVE_QUEST = "SelectGossipActiveQuest"
JambaUtils.COMMAND_SELECT_GOSSIP_AVAILABLE_QUEST = "SelectGossipAvailableQuest"
JambaUtils.COMMAND_SELECT_ACTIVE_QUEST = "SelectActiveQuest"
JambaUtils.COMMAND_SELECT_AVAILABLE_QUEST = "SelectAvailableQuest"
JambaUtils.COMMAND_ACCEPT_QUEST = "AcceptQuest"
JambaUtils.COMMAND_COMPLETE_QUEST = "CompleteQuest"
JambaUtils.COMMAND_CHOOSE_QUEST_REWARD = "ChooseQuestReward"
JambaUtils.COMMAND_DECLINE_QUEST = "DeclineQuest"
JambaUtils.COMMAND_ABANDON_QUEST = "AbandonQuest"
JambaUtils.COMMAND_QUEST_WATCH_ADD = "QuestWatchAdd"
JambaUtils.COMMAND_QUEST_WATCH_REMOVE = "QuestWatchRemove"
JambaUtils.COMMAND_SELECT_QUEST_LOG_ENTRY = "SelectQuestLogEntry"
-- Push Settings
JambaUtils.COMMAND_PUSH_SETTINGS = "PushSettings"
-- Set Focus
JambaUtils.COMMAND_SET_FOCUS = "SetFocus"
JambaUtils.COMMAND_SET_MASTER = "SetMaster"
-- Set Target
JambaUtils.COMMAND_SET_MASTER_AS_TARGET = "SetMasterAsTarget"
-- Leave Group
JambaUtils.COMMAND_LEAVE_GROUP = "LeaveGroup"
-- Follow
JambaUtils.COMMAND_FOLLOW_TARGET = "FollowTarget"
JambaUtils.COMMAND_AUTO_FOLLOW_AFTER_COMBAT = "AutoFollowAfterCombat"
JambaUtils.COMMAND_FOLLOW_STROBE_ON = "FollowStrobeOn"
JambaUtils.COMMAND_FOLLOW_STROBE_OFF = "FollowStrobeOff"

-- Trade information.
JambaUtils.TRADE_WINDOW_SLOT_START = 1
-- MAX_TRADABLE_ITEMS is defined as 6 in Blizzard's FrameXML\TradeFrame.lua.
JambaUtils.TRADE_WINDOW_SLOT_END = MAX_TRADABLE_ITEMS

-- Party loot settings.
JambaUtils.PARTY_LOOT_FREEFORALL = "freeforall"
JambaUtils.PARTY_LOOT_GROUP = "group"
JambaUtils.PARTY_LOOT_MASTER = "master"
JambaUtils.PARTY_LOOT_NEEDBEFOREGREED = "needbeforegreed"
JambaUtils.PARTY_LOOT_ROUNDROBIN = "roundrobin"
JambaUtils.LOOT_ROLL_PASS = 0
JambaUtils.LOOT_ROLL_NEED = 1
JambaUtils.LOOT_ROLL_GREED = 2

-------------------------------------------------------------------------------------------------------------
-- JambaUtils:FixValueToRange
-- value - the value to fix.
-- minValue - the minimum the value can be.
-- maxValue - the maximum the value can be.
-- Returns the fixed value.
-------------------------------------------------------------------------------------------------------------
function JambaUtils:FixValueToRange( value, minValue, maxValue )

	if value < minValue then
		value = minValue
	end		
	
	if value > maxValue then
		value = maxValue
	end	
	
	return value
	
end

-------------------------------------------------------------------------------------------------------------
-- JambaUtils:GetOnOrOffFromCommand
-- state - string value containing "on" or "off".#
-- onCommand - string that is equivalent to true, like "on".
-- offCommand - string that is equivalent to false, like "off".
-- Returns true for "on"; false for "off"; nil for invalid.
-------------------------------------------------------------------------------------------------------------
function JambaUtils:GetOnOrOffFromCommand( state, onCommand, offCommand )

	local setToOn = nil
	
	state = state:lower():trim()

	if state == onCommand then
		setToOn = true
	end
	if state == offCommand then
		setToOn = false
	end

	return setToOn
	
end

-------------------------------------------------------------------------------------------------------------
-- JambaUtils:ClearTable
-- tableToClear - the table to clear.
-------------------------------------------------------------------------------------------------------------
function JambaUtils:ClearTable( tableToClear )
	
	if tableToClear then
		for key, value in pairs( tableToClear ) do
			tableToClear[key] = nil
		end
	end
	
end

-------------------------------------------------------------------------------------------------------------
-- JambaUtils:ClearTableWithInnerTable
-- tableToClear - the table to clear.
-------------------------------------------------------------------------------------------------------------
function JambaUtils:ClearTableWithInnerTable( tableToClear )
	
	if tableToClear then
		for key, innerTable in pairs( tableToClear ) do
			for innerKey, innerValue in pairs( innerTable ) do
				innerTable[innerKey] = nil
			end
			tableToClear[key] = nil
		end
	end
	
end

-------------------------------------------------------------------------------------------------------------
-- JambaUtils:FormatMoneyString
-- value - the amount of money to display formatted.
-- Creates a money string from the value passed; don't pass negative values!
-------------------------------------------------------------------------------------------------------------
function JambaUtils:FormatMoneyString( value )

	local gold = floor( value / ( JambaUtils.COPPER_PER_SILVER * JambaUtils.SILVER_PER_GOLD ) );
	local silver = floor( ( value - ( gold * JambaUtils.COPPER_PER_SILVER * JambaUtils.SILVER_PER_GOLD ) ) 
		/ JambaUtils.COPPER_PER_SILVER );
	local copper = mod( value, JambaUtils.COPPER_PER_SILVER );
	
	local goldFormat = format( "|cff%s%s|r", JambaUtils.COLOUR_GOLD, gold )	
	local silverFormat = format( "|cff%s%s|r", JambaUtils.COLOUR_SILVER, silver )
	local copperFormat = format( "|cff%s%s|r", JambaUtils.COLOUR_COPPER, copper )
	
	if gold <=0 then
		goldFormat = ""
		if silver <= 0 then
			silverFormat = ""
		end
	end
	
	return strtrim(goldFormat.." "..silverFormat.." "..copperFormat)
	
end

-------------------------------------------------------------------------------------------------------------
-- JambaUtils:Capitalise
-- name - the name to capitalise.
-- Returns the capitalised name.
-------------------------------------------------------------------------------------------------------------
function JambaUtils:Capitalise( name )

	-- Capitalise the name.
	return name:utf8sub(1,1):utf8upper()..name:utf8sub(2)
			
end