--[[
	### ItemValue ###
	ItemValue Jewel Data
	
--]]

local Enable24JewelData = false -- change false to true to be able to use the 2.4 gems with a 2.3 client

local L = AceLibrary("AceLocale-2.2"):new("ItemValue")
ItemValue.EmptySocket = {EnchantId = 0, ItemId = 0, Name = L["Empty"], Quality = 0}

local Version, Major, Minor = (GetBuildInfo()):match("(%d).(%d).(%d)")
Version, Major, Minor = tonumber(Version), tonumber(Major), tonumber(Minor)

if Major == 4 then Enable24JewelData = true end

local Jewels
if not Enable24JewelData then
	-- 2.3 Jewels
	Jewels = {
		--{EnchantId = 2686, ItemId = 23233, Name = L["Red Bryanite of Strength stuff"], Quality = 2},
		--{EnchantId = 2687, ItemId = 23234, Name = L["Blue Bryanite of Agility"], Quality = 2},
		--{EnchantId = 2688, ItemId = 23235, Name = L["Yellow Bryanite of Stamina"], Quality = 2},
		{EnchantId = 2690, ItemId = 23094, Name = L["Teardrop Blood Garnet"], Quality = 2, IsRed = true},
		{EnchantId = 2691, ItemId = 23095, Name = L["Bold Blood Garnet"], Quality = 2, IsRed = true},
		{EnchantId = 2692, ItemId = 23096, Name = L["Runed Blood Garnet"], Quality = 2, IsRed = true},
		{EnchantId = 2693, ItemId = 23097, Name = L["Delicate Blood Garnet"], Quality = 2, IsRed = true},
		{EnchantId = 2694, ItemId = 23113, Name = L["Brilliant Golden Draenite"], Quality = 2, IsYellow = true},
		{EnchantId = 2695, ItemId = 23114, Name = L["Gleaming Golden Draenite"], Quality = 2, IsYellow = true},
		{EnchantId = 2696, ItemId = 23115, Name = L["Thick Golden Draenite"], Quality = 2, IsYellow = true},
		{EnchantId = 2697, ItemId = 23116, Name = L["Rigid Golden Draenite"], Quality = 2, IsYellow = true},
		{EnchantId = 2698, ItemId = 23118, Name = L["Solid Azure Moonstone"], Quality = 2, IsBlue = true},
		{EnchantId = 2699, ItemId = 23119, Name = L["Sparkling Azure Moonstone"], Quality = 2, IsBlue = true},
		{EnchantId = 2700, ItemId = 23120, Name = L["Stormy Azure Moonstone"], Quality = 2, IsBlue = true},
		{EnchantId = 2701, ItemId = 23121, Name = L["Lustrous Azure Moonstone"], Quality = 2, IsBlue = true},
		--{EnchantId = 2703, ItemId = 23364, Name = L["zzDEPRECATEDHeart of the Sky"], Quality = 3},
		--{EnchantId = 2704, ItemId = 23366, Name = L["zzDEPRECATEDPerfect Diamond"], Quality = 3, IsBlue = true},
		{EnchantId = 2705, ItemId = 23099, Name = L["Luminous Flame Spessarite"], Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2706, ItemId = 23105, Name = L["Enduring Deep Peridot"], Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2707, ItemId = 23106, Name = L["Dazzling Deep Peridot"], Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2708, ItemId = 23108, Name = L["Glowing Shadow Draenite"], Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2709, ItemId = 23109, Name = L["Royal Shadow Draenite"], Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2710, ItemId = 23110, Name = L["Shifting Shadow Draenite"], Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2711, ItemId = 23111, Name = L["Sovereign Shadow Draenite"], Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2725, ItemId = 24027, Name = L["Bold Living Ruby"], Quality = 3, IsRed = true},
		{EnchantId = 2726, ItemId = 24028, Name = L["Delicate Living Ruby"], Quality = 3, IsRed = true},
		{EnchantId = 2727, ItemId = 24029, Name = L["Teardrop Living Ruby"], Quality = 3, IsRed = true},
		{EnchantId = 2728, ItemId = 24030, Name = L["Runed Living Ruby"], Quality = 3, IsRed = true},
		{EnchantId = 2729, ItemId = 24031, Name = L["Bright Living Ruby"], Quality = 3, IsRed = true},
		{EnchantId = 2730, ItemId = 24032, Name = L["Subtle Living Ruby"], Quality = 3, IsRed = true},
		{EnchantId = 2731, ItemId = 24033, Name = L["Solid Star of Elune"], Quality = 3, IsBlue = true},
		{EnchantId = 2732, ItemId = 24035, Name = L["Sparkling Star of Elune"], Quality = 3, IsBlue = true},
		{EnchantId = 2733, ItemId = 24037, Name = L["Lustrous Star of Elune"], Quality = 3, IsBlue = true},
		{EnchantId = 2734, ItemId = 24047, Name = L["Brilliant Dawnstone"], Quality = 3, IsYellow = true},
		{EnchantId = 2735, ItemId = 24048, Name = L["Smooth Dawnstone"], Quality = 3, IsYellow = true},
		{EnchantId = 2736, ItemId = 24050, Name = L["Gleaming Dawnstone"], Quality = 3, IsYellow = true},
		{EnchantId = 2737, ItemId = 24052, Name = L["Thick Dawnstone"], Quality = 3, IsYellow = true},
		{EnchantId = 2738, ItemId = 24054, Name = L["Sovereign Nightseye"], Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2739, ItemId = 24055, Name = L["Shifting Nightseye"], Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2740, ItemId = 24056, Name = L["Glowing Nightseye"], Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2741, ItemId = 24057, Name = L["Royal Nightseye"], Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2742, ItemId = 24060, Name = L["Luminous Noble Topaz"], Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2743, ItemId = 24062, Name = L["Enduring Talasite"], Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2744, ItemId = 24065, Name = L["Dazzling Talasite"], Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2752, ItemId = 23098, Name = L["Inscribed Flame Spessarite"], Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2753, ItemId = 24058, Name = L["Inscribed Noble Topaz"], Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2754, ItemId = 24036, Name = L["Flashing Living Ruby"], Quality = 3, IsRed = true},
		{EnchantId = 2755, ItemId = 23100, Name = L["Glinting Flame Spessarite"], Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2756, ItemId = 24061, Name = L["Glinting Noble Topaz"], Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2757, ItemId = 23104, Name = L["Jagged Deep Peridot"], Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2758, ItemId = 24067, Name = L["Jagged Talasite"], Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2759, ItemId = 24053, Name = L["Mystic Dawnstone"], Quality = 3, IsYellow = true},
		{EnchantId = 2760, ItemId = 23101, Name = L["Potent Flame Spessarite"], Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2761, ItemId = 24059, Name = L["Potent Noble Topaz"], Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2762, ItemId = 23103, Name = L["Radiant Deep Peridot"], Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2763, ItemId = 24066, Name = L["Radiant Talasite"], Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2764, ItemId = 24051, Name = L["Rigid Dawnstone"], Quality = 3, IsYellow = true},
		{EnchantId = 2765, ItemId = 24039, Name = L["Stormy Star of Elune"], Quality = 3, IsBlue = true},
		{EnchantId = 2827, ItemId = 25890, Name = L["Destructive Skyfire Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2828, ItemId = 25893, Name = L["Mystical Skyfire Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2829, ItemId = 25894, Name = L["Swift Skyfire Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2830, ItemId = 25895, Name = L["Enigmatic Skyfire Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2831, ItemId = 25896, Name = L["Powerful Earthstorm Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2832, ItemId = 25897, Name = L["Bracing Earthstorm Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2833, ItemId = 25898, Name = L["Tenacious Earthstorm Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2834, ItemId = 25899, Name = L["Brutal Earthstorm Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2835, ItemId = 25901, Name = L["Insightful Earthstorm Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 2891, ItemId = 27679, Name = L["Sublime Mystic Dawnstone"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		--{EnchantId = 2894, ItemId = 27774, Name = L["zzOLDMighty Blood Garnet"], Quality = 3, IsUnique = true, IsRed = true},
		{EnchantId = 2896, ItemId = 27777, Name = L["Stark Blood Garnet"], Quality = 3, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 2898, ItemId = 27785, Name = L["Notched Deep Peridot"], Quality = 3, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 2899, ItemId = 27786, Name = L["Barbed Deep Peridot"], Quality = 3, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		--{EnchantId = 2911, ItemId = 28117, Name = L["zzOLDBold Ornate Ruby"], Quality = 4, IsUnique = true, IsRed = true},
		{EnchantId = 2912, ItemId = 28118, Name = L["Runed Ornate Ruby"], Quality = 4, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 2913, ItemId = 28119, Name = L["Smooth Ornate Dawnstone"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 2914, ItemId = 28120, Name = L["Gleaming Ornate Dawnstone"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		--{EnchantId = 2915, ItemId = 28122, Name = L["zzOLDEnscribed Ornate Topaz"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true},
		{EnchantId = 2916, ItemId = 28123, Name = L["Potent Ornate Topaz"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		--{EnchantId = 2917, ItemId = 27864, Name = L["Brian's Bryanite of Extended Cost Copying"], Quality = 2},
		{EnchantId = 2918, ItemId = 27786, Name = L["Barbed Deep Peridot"], Quality = 3, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 2921, ItemId = 27809, Name = L["Barbed Deep Peridot"], Quality = 3, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		--{EnchantId = 2922, ItemId = 27811, Name = L["zzOLDMighty Blood Garnet"], Quality = 3, IsUnique = true, IsRed = true},
		{EnchantId = 2923, ItemId = 27820, Name = L["Notched Deep Peridot"], Quality = 3, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 2924, ItemId = 27812, Name = L["Stark Blood Garnet"], Quality = 3, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 2942, ItemId = 28290, Name = L["Smooth Golden Draenite"], Quality = 2, IsYellow = true},
		{EnchantId = 2943, ItemId = 28360, Name = L["Mighty Blood Garnet"], Quality = 3, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 2944, ItemId = 28361, Name = L["Mighty Blood Garnet"], Quality = 3, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 2945, ItemId = 28362, Name = L["Bold Ornate Ruby"], Quality = 4, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 2946, ItemId = 28363, Name = L["Inscribed Ornate Topaz"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 2947, ItemId = 22460, Name = L["Prismatic Sphere"], Quality = 3, IsRed = true, IsYellow = true, IsBlue = true},
		{EnchantId = 2948, ItemId = 22459, Name = L["Void Sphere"], Quality = 4, IsRed = true, IsYellow = true, IsBlue = true},
		--{EnchantId = 2949, ItemId = 28388, Name = L["TCHILTON TEST RUBY"], Quality = 4, IsRed = true},
		--{EnchantId = 2950, ItemId = 28389, Name = L["TCHILTON TEST DAWNSTONE"], Quality = 4, IsYellow = true},
		{EnchantId = 2956, ItemId = 28458, Name = L["Bold Tourmaline"], Quality = 1, IsRed = true},
		{EnchantId = 2957, ItemId = 28459, Name = L["Delicate Tourmaline"], Quality = 1, IsRed = true},
		{EnchantId = 2958, ItemId = 28460, Name = L["Teardrop Tourmaline"], Quality = 1, IsRed = true},
		{EnchantId = 2959, ItemId = 28461, Name = L["Runed Tourmaline"], Quality = 1, IsRed = true},
		{EnchantId = 2960, ItemId = 28462, Name = L["Bright Tourmaline"], Quality = 1, IsRed = true},
		{EnchantId = 2961, ItemId = 28463, Name = L["Solid Zircon"], Quality = 1, IsBlue = true},
		{EnchantId = 2962, ItemId = 28464, Name = L["Sparkling Zircon"], Quality = 1, IsBlue = true},
		{EnchantId = 2963, ItemId = 28465, Name = L["Lustrous Zircon"], Quality = 1, IsBlue = true},
		{EnchantId = 2964, ItemId = 28466, Name = L["Brilliant Amber"], Quality = 1, IsYellow = true},
		{EnchantId = 2965, ItemId = 28467, Name = L["Smooth Amber"], Quality = 1, IsYellow = true},
		{EnchantId = 2966, ItemId = 28468, Name = L["Rigid Amber"], Quality = 1, IsYellow = true},
		{EnchantId = 2967, ItemId = 28469, Name = L["Gleaming Amber"], Quality = 1, IsYellow = true},
		{EnchantId = 2968, ItemId = 28470, Name = L["Thick Amber"], Quality = 1, IsYellow = true},
		{EnchantId = 2969, ItemId = 28556, Name = L["Swift Windfire Diamond"], Quality = 3, IsUnique = true, IsMeta = true, IsBoP = true},
		{EnchantId = 2970, ItemId = 28557, Name = L["Swift Starfire Diamond"], Quality = 3, IsUnique = true, IsMeta = true, IsBoP = true},
		{EnchantId = 2971, ItemId = 28595, Name = L["Bright Blood Garnet"], Quality = 2, IsRed = true},
		{EnchantId = 3045, ItemId = 30546, Name = L["Sovereign Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3046, ItemId = 30547, Name = L["Luminous Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3047, ItemId = 30548, Name = L["Polished Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3048, ItemId = 30549, Name = L["Shifting Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3049, ItemId = 30550, Name = L["Sundered Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3050, ItemId = 30551, Name = L["Infused Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3051, ItemId = 30552, Name = L["Blessed Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3052, ItemId = 30553, Name = L["Pristine Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3053, ItemId = 30554, Name = L["Stalwart Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3054, ItemId = 30555, Name = L["Glowing Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3055, ItemId = 30556, Name = L["Glinting Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3056, ItemId = 30558, Name = L["Glimmering Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3057, ItemId = 30559, Name = L["Etched Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3058, ItemId = 30560, Name = L["Rune Covered Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3060, ItemId = 30563, Name = L["Regal Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3061, ItemId = 30564, Name = L["Shining Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3062, ItemId = 30565, Name = L["Assassin's Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3063, ItemId = 30566, Name = L["Defender's Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3064, ItemId = 30572, Name = L["Imperial Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3065, ItemId = 30571, Name = L["Don Rodrigo's Heart"], Quality = 3, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 3066, ItemId = 30573, Name = L["Mysterious Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3067, ItemId = 30574, Name = L["Brutal Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3068, ItemId = 30575, Name = L["Nimble Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3069, ItemId = 30581, Name = L["Durable Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3070, ItemId = 30582, Name = L["Deadly Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3071, ItemId = 30583, Name = L["Timeless Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3072, ItemId = 30584, Name = L["Enscribed Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3073, ItemId = 30585, Name = L["Glistening Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3074, ItemId = 30586, Name = L["Seer's Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3075, ItemId = 30587, Name = L["Champion's Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3076, ItemId = 30588, Name = L["Potent Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3077, ItemId = 30589, Name = L["Dazzling Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3078, ItemId = 30590, Name = L["Enduring Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3079, ItemId = 30591, Name = L["Empowered Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3080, ItemId = 30592, Name = L["Steady Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3081, ItemId = 30593, Name = L["Iridescent Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3082, ItemId = 30594, Name = L["Effulgent Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3083, ItemId = 30600, Name = L["Fluorescent Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3084, ItemId = 30601, Name = L["Beaming Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3085, ItemId = 30602, Name = L["Jagged Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3086, ItemId = 30603, Name = L["Royal Tanzanite"], Quality = 4, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3087, ItemId = 30604, Name = L["Resplendent Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3088, ItemId = 30605, Name = L["Vivid Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3089, ItemId = 30606, Name = L["Lambent Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3090, ItemId = 30607, Name = L["Splendid Fire Opal"], Quality = 4, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3091, ItemId = 30608, Name = L["Radiant Chrysoprase"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3099, ItemId = 31116, Name = L["Infused Amethyst"], Quality = 4, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3100, ItemId = 31117, Name = L["Soothing Amethyst"], Quality = 4, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3101, ItemId = 31118, Name = L["Pulsing Amethyst"], Quality = 4, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3103, ItemId = 30598, Name = L["Don Amancio's Heart"], Quality = 3, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 3104, ItemId = 31860, Name = L["Great Golden Draenite"], Quality = 2, IsYellow = true},
		{EnchantId = 3105, ItemId = 31861, Name = L["Great Dawnstone"], Quality = 3, IsYellow = true},
		{EnchantId = 3106, ItemId = 31862, Name = L["Balanced Shadow Draenite"], Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 3107, ItemId = 31863, Name = L["Balanced Nightseye"], Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 3108, ItemId = 31864, Name = L["Infused Shadow Draenite"], Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 3109, ItemId = 31865, Name = L["Infused Nightseye"], Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 3110, ItemId = 31866, Name = L["Veiled Flame Spessarite"], Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 3111, ItemId = 31867, Name = L["Veiled Noble Topaz"], Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 3112, ItemId = 31868, Name = L["Wicked Noble Topaz"], Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 3113, ItemId = 31869, Name = L["Wicked Flame Spessarite"], Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 3115, ItemId = 32193, Name = L["Bold Crimson Spinel"], Quality = 4, IsRed = true},
		{EnchantId = 3116, ItemId = 32194, Name = L["Delicate Crimson Spinel"], Quality = 4, IsRed = true},
		{EnchantId = 3117, ItemId = 32195, Name = L["Teardrop Crimson Spinel"], Quality = 4, IsRed = true},
		{EnchantId = 3118, ItemId = 32196, Name = L["Runed Crimson Spinel"], Quality = 4, IsRed = true},
		{EnchantId = 3119, ItemId = 32197, Name = L["Bright Crimson Spinel"], Quality = 4, IsRed = true},
		{EnchantId = 3120, ItemId = 32198, Name = L["Subtle Crimson Spinel"], Quality = 4, IsRed = true},
		{EnchantId = 3121, ItemId = 32199, Name = L["Flashing Crimson Spinel"], Quality = 4, IsRed = true},
		{EnchantId = 3122, ItemId = 32200, Name = L["Solid Empyrean Sapphire"], Quality = 4, IsBlue = true},
		{EnchantId = 3123, ItemId = 32201, Name = L["Sparkling Empyrean Sapphire"], Quality = 4, IsBlue = true},
		{EnchantId = 3124, ItemId = 32202, Name = L["Lustrous Empyrean Sapphire"], Quality = 4, IsBlue = true},
		{EnchantId = 3125, ItemId = 32203, Name = L["Stormy Empyrean Sapphire"], Quality = 4, IsBlue = true},
		{EnchantId = 3126, ItemId = 32204, Name = L["Brilliant Lionseye"], Quality = 4, IsYellow = true},
		{EnchantId = 3127, ItemId = 32205, Name = L["Smooth Lionseye"], Quality = 4, IsYellow = true},
		{EnchantId = 3128, ItemId = 32206, Name = L["Rigid Lionseye"], Quality = 4, IsYellow = true},
		{EnchantId = 3129, ItemId = 32207, Name = L["Gleaming Lionseye"], Quality = 4, IsYellow = true},
		{EnchantId = 3130, ItemId = 32208, Name = L["Thick Lionseye"], Quality = 4, IsYellow = true},
		{EnchantId = 3131, ItemId = 32209, Name = L["Mystic Lionseye"], Quality = 4, IsYellow = true},
		{EnchantId = 3132, ItemId = 32210, Name = L["Great Lionseye"], Quality = 4, IsYellow = true},
		{EnchantId = 3133, ItemId = 32211, Name = L["Sovereign Shadowsong Amethyst"], Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3134, ItemId = 32212, Name = L["Shifting Shadowsong Amethyst"], Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3135, ItemId = 32213, Name = L["Balanced Shadowsong Amethyst"], Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3136, ItemId = 32214, Name = L["Infused Shadowsong Amethyst"], Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3137, ItemId = 32215, Name = L["Glowing Shadowsong Amethyst"], Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3138, ItemId = 32216, Name = L["Royal Shadowsong Amethyst"], Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3139, ItemId = 32217, Name = L["Inscribed Pyrestone"], Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3140, ItemId = 32218, Name = L["Potent Pyrestone"], Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3141, ItemId = 32219, Name = L["Luminous Pyrestone"], Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3142, ItemId = 32220, Name = L["Glinting Pyrestone"], Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3143, ItemId = 32221, Name = L["Veiled Pyrestone"], Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3144, ItemId = 32222, Name = L["Wicked Pyrestone"], Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3145, ItemId = 32223, Name = L["Enduring Seaspray Emerald"], Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3146, ItemId = 32224, Name = L["Radiant Seaspray Emerald"], Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3147, ItemId = 32225, Name = L["Dazzling Seaspray Emerald"], Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3148, ItemId = 32226, Name = L["Jagged Seaspray Emerald"], Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3154, ItemId = 32409, Name = L["Relentless Earthstorm Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 3155, ItemId = 32410, Name = L["Thundering Skyfire Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 3156, ItemId = 32634, Name = L["Unstable Amethyst"], Quality = 3, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3157, ItemId = 32635, Name = L["Unstable Peridot"], Quality = 3, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3158, ItemId = 32636, Name = L["Unstable Sapphire"], Quality = 3, IsUnique = true, IsRed = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3159, ItemId = 32637, Name = L["Unstable Citrine"], Quality = 3, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3160, ItemId = 32638, Name = L["Unstable Topaz"], Quality = 3, IsUnique = true, IsRed = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3161, ItemId = 32639, Name = L["Unstable Talasite"], Quality = 3, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3162, ItemId = 32640, Name = L["Potent Unstable Diamond"], Quality = 3, IsMeta = true, IsBoP = true},
		{EnchantId = 3163, ItemId = 32641, Name = L["Imbued Unstable Diamond"], Quality = 3, IsMeta = true, IsBoP = true},
		--{EnchantId = 3197, ItemId = 32735, Name = L["Radiant Spencerite"], Quality = 4, IsUnique = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3201, ItemId = 32833, Name = L["Purified Jaggal Pearl"], Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 3202, ItemId = 32836, Name = L["Purified Shadow Pearl"], Quality = 3, IsRed = true, IsBlue = true},
		--{EnchantId = 3206, ItemId = 33060, Name = L["Soulbound Test Gem"], Quality = 3, IsRed = true, IsYellow = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3208, ItemId = 33131, Name = L["Crimson Sun"], Quality = 4, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 3209, ItemId = 33132, Name = L["Delicate Fire Ruby"], Quality = 4, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 3210, ItemId = 33133, Name = L["Don Julio's Heart"], Quality = 4, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 3211, ItemId = 33134, Name = L["Kailee's Rose"], Quality = 4, IsUnique = true, IsRed = true, IsBoP = true},
		{EnchantId = 3212, ItemId = 33135, Name = L["Falling Star"], Quality = 4, IsUnique = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3214, ItemId = 33137, Name = L["Sparkling Falling Star"], Quality = 4, IsUnique = true, IsBlue = true, IsBoP = true},
		{EnchantId = 3215, ItemId = 33138, Name = L["Mystic Bladestone"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3216, ItemId = 33139, Name = L["Brilliant Bladestone"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3217, ItemId = 33140, Name = L["Blood of Amber"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3218, ItemId = 33141, Name = L["Great Bladestone"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3219, ItemId = 33142, Name = L["Rigid Bladestone"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3220, ItemId = 33143, Name = L["Stone of Blades"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3221, ItemId = 33144, Name = L["Facet of Eternity"], Quality = 4, IsUnique = true, IsYellow = true, IsBoP = true},
		{EnchantId = 3226, ItemId = 33782, Name = L["Steady Talasite"], Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 3261, ItemId = 34220, Name = L["Chaotic Skyfire Diamond"], Quality = 3, IsMeta = true},
		{EnchantId = 3262, ItemId = 34256, Name = L["Charmed Amani Jewel"], Quality = 4, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
	}
else
	-- 2.4 Jewels
	Jewels = {
		--{EnchantId = 2686, ItemId = 23233, Name = "Red Bryanite of Strength stuff", Quality = 2},
		--{EnchantId = 2687, ItemId = 23234, Name = "Blue Bryanite of Agility", Quality = 2},
		--{EnchantId = 2688, ItemId = 23235, Name = "Yellow Bryanite of Stamina", Quality = 2},
		{EnchantId = 2690, ItemId = 23094, Name = "Teardrop Blood Garnet", Quality = 2, IsRed = true},
		{EnchantId = 2691, ItemId = 23095, Name = "Bold Blood Garnet", Quality = 2, IsRed = true},
		{EnchantId = 2692, ItemId = 23096, Name = "Runed Blood Garnet", Quality = 2, IsRed = true},
		{EnchantId = 2693, ItemId = 23097, Name = "Delicate Blood Garnet", Quality = 2, IsRed = true},
		{EnchantId = 2694, ItemId = 23113, Name = "Brilliant Golden Draenite", Quality = 2, IsYellow = true},
		{EnchantId = 2695, ItemId = 23114, Name = "Gleaming Golden Draenite", Quality = 2, IsYellow = true},
		{EnchantId = 2696, ItemId = 23115, Name = "Thick Golden Draenite", Quality = 2, IsYellow = true},
		{EnchantId = 2697, ItemId = 23116, Name = "Rigid Golden Draenite", Quality = 2, IsYellow = true},
		{EnchantId = 2698, ItemId = 23118, Name = "Solid Azure Moonstone", Quality = 2, IsBlue = true},
		{EnchantId = 2699, ItemId = 23119, Name = "Sparkling Azure Moonstone", Quality = 2, IsBlue = true},
		{EnchantId = 2700, ItemId = 23120, Name = "Stormy Azure Moonstone", Quality = 2, IsBlue = true},
		{EnchantId = 2701, ItemId = 23121, Name = "Lustrous Azure Moonstone", Quality = 2, IsBlue = true},
		--{EnchantId = 2703, ItemId = 23364, Name = "zzDEPRECATEDHeart of the Sky", Quality = 3},
		--{EnchantId = 2704, ItemId = 23366, Name = "zzDEPRECATEDPerfect Diamond", Quality = 3, IsBlue = true},
		{EnchantId = 2705, ItemId = 23099, Name = "Luminous Flame Spessarite", Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2706, ItemId = 23105, Name = "Enduring Deep Peridot", Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2707, ItemId = 23106, Name = "Dazzling Deep Peridot", Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2708, ItemId = 23108, Name = "Glowing Shadow Draenite", Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2709, ItemId = 23109, Name = "Royal Shadow Draenite", Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2710, ItemId = 23110, Name = "Shifting Shadow Draenite", Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2711, ItemId = 23111, Name = "Sovereign Shadow Draenite", Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 2725, ItemId = 24027, Name = "Bold Living Ruby", Quality = 3, IsRed = true},
		{EnchantId = 2726, ItemId = 24028, Name = "Delicate Living Ruby", Quality = 3, IsRed = true},
		{EnchantId = 2727, ItemId = 24029, Name = "Teardrop Living Ruby", Quality = 3, IsRed = true},
		{EnchantId = 2728, ItemId = 24030, Name = "Runed Living Ruby", Quality = 3, IsRed = true},
		{EnchantId = 2729, ItemId = 24031, Name = "Bright Living Ruby", Quality = 3, IsRed = true},
		{EnchantId = 2730, ItemId = 24032, Name = "Subtle Living Ruby", Quality = 3, IsRed = true},
		{EnchantId = 2731, ItemId = 24033, Name = "Solid Star of Elune", Quality = 3, IsBlue = true},
		{EnchantId = 2732, ItemId = 24035, Name = "Sparkling Star of Elune", Quality = 3, IsBlue = true},
		{EnchantId = 2733, ItemId = 24037, Name = "Lustrous Star of Elune", Quality = 3, IsBlue = true},
		{EnchantId = 2734, ItemId = 24047, Name = "Brilliant Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 2735, ItemId = 24048, Name = "Smooth Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 2736, ItemId = 24050, Name = "Gleaming Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 2737, ItemId = 24052, Name = "Thick Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 2738, ItemId = 24054, Name = "Sovereign Nightseye", Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2739, ItemId = 24055, Name = "Shifting Nightseye", Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2740, ItemId = 24056, Name = "Glowing Nightseye", Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2741, ItemId = 24057, Name = "Royal Nightseye", Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 2742, ItemId = 24060, Name = "Luminous Noble Topaz", Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2743, ItemId = 24062, Name = "Enduring Talasite", Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2744, ItemId = 24065, Name = "Dazzling Talasite", Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2752, ItemId = 23098, Name = "Inscribed Flame Spessarite", Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2753, ItemId = 24058, Name = "Inscribed Noble Topaz", Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2754, ItemId = 24036, Name = "Flashing Living Ruby", Quality = 3, IsRed = true},
		{EnchantId = 2755, ItemId = 23100, Name = "Glinting Flame Spessarite", Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2756, ItemId = 24061, Name = "Glinting Noble Topaz", Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2757, ItemId = 23104, Name = "Jagged Deep Peridot", Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2758, ItemId = 24067, Name = "Jagged Talasite", Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2759, ItemId = 24053, Name = "Mystic Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 2760, ItemId = 23101, Name = "Potent Flame Spessarite", Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 2761, ItemId = 24059, Name = "Potent Noble Topaz", Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 2762, ItemId = 23103, Name = "Radiant Deep Peridot", Quality = 2, IsYellow = true, IsBlue = true},
		{EnchantId = 2763, ItemId = 24066, Name = "Radiant Talasite", Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 2764, ItemId = 24051, Name = "Rigid Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 2765, ItemId = 24039, Name = "Stormy Star of Elune", Quality = 3, IsBlue = true},
		{EnchantId = 2827, ItemId = 25890, Name = "Destructive Skyfire Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2828, ItemId = 25893, Name = "Mystical Skyfire Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2829, ItemId = 25894, Name = "Swift Skyfire Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2830, ItemId = 25895, Name = "Enigmatic Skyfire Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2831, ItemId = 25896, Name = "Powerful Earthstorm Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2832, ItemId = 25897, Name = "Bracing Earthstorm Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2833, ItemId = 25898, Name = "Tenacious Earthstorm Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2834, ItemId = 25899, Name = "Brutal Earthstorm Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2835, ItemId = 25901, Name = "Insightful Earthstorm Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 2891, ItemId = 27679, Name = "Sublime Mystic Dawnstone", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		--{EnchantId = 2894, ItemId = 27774, Name = "zzOLDMighty Blood Garnet", Quality = 3, IsRed = true, IsUnique = true},
		{EnchantId = 2896, ItemId = 27777, Name = "Stark Blood Garnet", Quality = 3, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2898, ItemId = 27785, Name = "Notched Deep Peridot", Quality = 3, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2899, ItemId = 27786, Name = "Barbed Deep Peridot", Quality = 3, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		--{EnchantId = 2911, ItemId = 28117, Name = "zzOLDBold Ornate Ruby", Quality = 4, IsRed = true, IsUnique = true},
		{EnchantId = 2912, ItemId = 28118, Name = "Runed Ornate Ruby", Quality = 4, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2913, ItemId = 28119, Name = "Smooth Ornate Dawnstone", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2914, ItemId = 28120, Name = "Gleaming Ornate Dawnstone", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		--{EnchantId = 2915, ItemId = 28122, Name = "zzOLDEnscribed Ornate Topaz", Quality = 4, IsRed = true, IsYellow = true, IsUnique = true},
		{EnchantId = 2916, ItemId = 28123, Name = "Potent Ornate Topaz", Quality = 4, IsRed = true, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		--{EnchantId = 2917, ItemId = 27864, Name = "Brian's Bryanite of Extended Cost Copying", Quality = 2},
		{EnchantId = 2918, ItemId = 27786, Name = "Barbed Deep Peridot", Quality = 3, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2921, ItemId = 27809, Name = "Barbed Deep Peridot", Quality = 3, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		--{EnchantId = 2922, ItemId = 27811, Name = "zzOLDMighty Blood Garnet", Quality = 3, IsRed = true, IsUnique = true},
		{EnchantId = 2923, ItemId = 27820, Name = "Notched Deep Peridot", Quality = 3, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2924, ItemId = 27812, Name = "Stark Blood Garnet", Quality = 3, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2942, ItemId = 28290, Name = "Smooth Golden Draenite", Quality = 2, IsYellow = true},
		{EnchantId = 2943, ItemId = 28360, Name = "Mighty Blood Garnet", Quality = 3, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2944, ItemId = 28361, Name = "Mighty Blood Garnet", Quality = 3, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2945, ItemId = 28362, Name = "Bold Ornate Ruby", Quality = 4, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2946, ItemId = 28363, Name = "Inscribed Ornate Topaz", Quality = 4, IsRed = true, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2947, ItemId = 22460, Name = "Prismatic Sphere", Quality = 3, IsRed = true, IsYellow = true, IsBlue = true},
		{EnchantId = 2948, ItemId = 22459, Name = "Void Sphere", Quality = 4, IsRed = true, IsYellow = true, IsBlue = true},
		--{EnchantId = 2949, ItemId = 28388, Name = "TCHILTON TEST RUBY", Quality = 4, IsRed = true},
		--{EnchantId = 2950, ItemId = 28389, Name = "TCHILTON TEST DAWNSTONE", Quality = 4, IsYellow = true},
		{EnchantId = 2956, ItemId = 28458, Name = "Bold Tourmaline", Quality = 1, IsRed = true},
		{EnchantId = 2957, ItemId = 28459, Name = "Delicate Tourmaline", Quality = 1, IsRed = true},
		{EnchantId = 2958, ItemId = 28460, Name = "Teardrop Tourmaline", Quality = 1, IsRed = true},
		{EnchantId = 2959, ItemId = 28461, Name = "Runed Tourmaline", Quality = 1, IsRed = true},
		{EnchantId = 2960, ItemId = 28462, Name = "Bright Tourmaline", Quality = 1, IsRed = true},
		{EnchantId = 2961, ItemId = 28463, Name = "Solid Zircon", Quality = 1, IsBlue = true},
		{EnchantId = 2962, ItemId = 28464, Name = "Sparkling Zircon", Quality = 1, IsBlue = true},
		{EnchantId = 2963, ItemId = 28465, Name = "Lustrous Zircon", Quality = 1, IsBlue = true},
		{EnchantId = 2964, ItemId = 28466, Name = "Brilliant Amber", Quality = 1, IsYellow = true},
		{EnchantId = 2965, ItemId = 28467, Name = "Smooth Amber", Quality = 1, IsYellow = true},
		{EnchantId = 2966, ItemId = 28468, Name = "Rigid Amber", Quality = 1, IsYellow = true},
		{EnchantId = 2967, ItemId = 28469, Name = "Gleaming Amber", Quality = 1, IsYellow = true},
		{EnchantId = 2968, ItemId = 28470, Name = "Thick Amber", Quality = 1, IsYellow = true},
		{EnchantId = 2969, ItemId = 28556, Name = "Swift Windfire Diamond", Quality = 3, IsMeta = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2970, ItemId = 28557, Name = "Swift Starfire Diamond", Quality = 3, IsMeta = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 2971, ItemId = 28595, Name = "Bright Blood Garnet", Quality = 2, IsRed = true},
		{EnchantId = 3045, ItemId = 30546, Name = "Sovereign Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3046, ItemId = 30547, Name = "Luminous Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3047, ItemId = 30548, Name = "Polished Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3048, ItemId = 30549, Name = "Shifting Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3049, ItemId = 30550, Name = "Sundered Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3050, ItemId = 30551, Name = "Infused Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3051, ItemId = 30552, Name = "Blessed Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3052, ItemId = 30553, Name = "Pristine Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3053, ItemId = 30554, Name = "Stalwart Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3054, ItemId = 30555, Name = "Glowing Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3055, ItemId = 30556, Name = "Glinting Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3056, ItemId = 30558, Name = "Glimmering Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3057, ItemId = 30559, Name = "Etched Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3058, ItemId = 30560, Name = "Rune Covered Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3060, ItemId = 30563, Name = "Regal Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3061, ItemId = 30564, Name = "Shining Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3062, ItemId = 30565, Name = "Assassin's Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3063, ItemId = 30566, Name = "Defender's Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3064, ItemId = 30572, Name = "Imperial Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3065, ItemId = 30571, Name = "Don Rodrigo's Heart", Quality = 3, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3066, ItemId = 30573, Name = "Mysterious Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3067, ItemId = 30574, Name = "Brutal Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3068, ItemId = 30575, Name = "Nimble Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3069, ItemId = 30581, Name = "Durable Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3070, ItemId = 30582, Name = "Deadly Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3071, ItemId = 30583, Name = "Timeless Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3072, ItemId = 30584, Name = "Enscribed Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3073, ItemId = 30585, Name = "Glistening Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3074, ItemId = 30586, Name = "Seer's Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3075, ItemId = 30587, Name = "Champion's Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3076, ItemId = 30588, Name = "Potent Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3077, ItemId = 30589, Name = "Dazzling Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3078, ItemId = 30590, Name = "Enduring Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3079, ItemId = 30591, Name = "Empowered Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3080, ItemId = 30592, Name = "Steady Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3081, ItemId = 30593, Name = "Iridescent Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3082, ItemId = 30594, Name = "Effulgent Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3083, ItemId = 30600, Name = "Fluorescent Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3084, ItemId = 30601, Name = "Beaming Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3085, ItemId = 30602, Name = "Jagged Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3086, ItemId = 30603, Name = "Royal Tanzanite", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3087, ItemId = 30604, Name = "Resplendent Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3088, ItemId = 30605, Name = "Vivid Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3089, ItemId = 30606, Name = "Lambent Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3090, ItemId = 30607, Name = "Splendid Fire Opal", Quality = 4, IsRed = true, IsYellow = true, IsBindOnPickup = true},
		{EnchantId = 3091, ItemId = 30608, Name = "Radiant Chrysoprase", Quality = 4, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3099, ItemId = 31116, Name = "Infused Amethyst", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3100, ItemId = 31117, Name = "Soothing Amethyst", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3101, ItemId = 31118, Name = "Pulsing Amethyst", Quality = 4, IsRed = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3103, ItemId = 30598, Name = "Don Amancio's Heart", Quality = 3, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3104, ItemId = 31860, Name = "Great Golden Draenite", Quality = 2, IsYellow = true},
		{EnchantId = 3105, ItemId = 31861, Name = "Great Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 3106, ItemId = 31862, Name = "Balanced Shadow Draenite", Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 3107, ItemId = 31863, Name = "Balanced Nightseye", Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 3108, ItemId = 31864, Name = "Infused Shadow Draenite", Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 3109, ItemId = 31865, Name = "Infused Nightseye", Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 3110, ItemId = 31866, Name = "Veiled Flame Spessarite", Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 3111, ItemId = 31867, Name = "Veiled Noble Topaz", Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 3112, ItemId = 31868, Name = "Wicked Noble Topaz", Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 3113, ItemId = 31869, Name = "Wicked Flame Spessarite", Quality = 2, IsRed = true, IsYellow = true},
		{EnchantId = 3115, ItemId = 32193, Name = "Bold Crimson Spinel", Quality = 4, IsRed = true},
		{EnchantId = 3116, ItemId = 32194, Name = "Delicate Crimson Spinel", Quality = 4, IsRed = true},
		{EnchantId = 3117, ItemId = 32195, Name = "Teardrop Crimson Spinel", Quality = 4, IsRed = true},
		{EnchantId = 3118, ItemId = 32196, Name = "Runed Crimson Spinel", Quality = 4, IsRed = true},
		{EnchantId = 3119, ItemId = 32197, Name = "Bright Crimson Spinel", Quality = 4, IsRed = true},
		{EnchantId = 3120, ItemId = 32198, Name = "Subtle Crimson Spinel", Quality = 4, IsRed = true},
		{EnchantId = 3121, ItemId = 32199, Name = "Flashing Crimson Spinel", Quality = 4, IsRed = true},
		{EnchantId = 3122, ItemId = 32200, Name = "Solid Empyrean Sapphire", Quality = 4, IsBlue = true},
		{EnchantId = 3123, ItemId = 32201, Name = "Sparkling Empyrean Sapphire", Quality = 4, IsBlue = true},
		{EnchantId = 3124, ItemId = 32202, Name = "Lustrous Empyrean Sapphire", Quality = 4, IsBlue = true},
		{EnchantId = 3125, ItemId = 32203, Name = "Stormy Empyrean Sapphire", Quality = 4, IsBlue = true},
		{EnchantId = 3126, ItemId = 32204, Name = "Brilliant Lionseye", Quality = 4, IsYellow = true},
		{EnchantId = 3127, ItemId = 32205, Name = "Smooth Lionseye", Quality = 4, IsYellow = true},
		{EnchantId = 3128, ItemId = 32206, Name = "Rigid Lionseye", Quality = 4, IsYellow = true},
		{EnchantId = 3129, ItemId = 32207, Name = "Gleaming Lionseye", Quality = 4, IsYellow = true},
		{EnchantId = 3130, ItemId = 32208, Name = "Thick Lionseye", Quality = 4, IsYellow = true},
		{EnchantId = 3131, ItemId = 32209, Name = "Mystic Lionseye", Quality = 4, IsYellow = true},
		{EnchantId = 3132, ItemId = 32210, Name = "Great Lionseye", Quality = 4, IsYellow = true},
		{EnchantId = 3133, ItemId = 32211, Name = "Sovereign Shadowsong Amethyst", Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3134, ItemId = 32212, Name = "Shifting Shadowsong Amethyst", Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3135, ItemId = 32213, Name = "Balanced Shadowsong Amethyst", Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3136, ItemId = 32214, Name = "Infused Shadowsong Amethyst", Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3137, ItemId = 32215, Name = "Glowing Shadowsong Amethyst", Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3138, ItemId = 32216, Name = "Royal Shadowsong Amethyst", Quality = 4, IsRed = true, IsBlue = true},
		{EnchantId = 3139, ItemId = 32217, Name = "Inscribed Pyrestone", Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3140, ItemId = 32218, Name = "Potent Pyrestone", Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3141, ItemId = 32219, Name = "Luminous Pyrestone", Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3142, ItemId = 32220, Name = "Glinting Pyrestone", Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3143, ItemId = 32221, Name = "Veiled Pyrestone", Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3144, ItemId = 32222, Name = "Wicked Pyrestone", Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3145, ItemId = 32223, Name = "Enduring Seaspray Emerald", Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3146, ItemId = 32224, Name = "Radiant Seaspray Emerald", Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3147, ItemId = 32225, Name = "Dazzling Seaspray Emerald", Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3148, ItemId = 32226, Name = "Jagged Seaspray Emerald", Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3154, ItemId = 32409, Name = "Relentless Earthstorm Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 3155, ItemId = 32410, Name = "Thundering Skyfire Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 3156, ItemId = 32634, Name = "Unstable Amethyst", Quality = 3, IsRed = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3157, ItemId = 32635, Name = "Unstable Peridot", Quality = 3, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3158, ItemId = 32636, Name = "Unstable Sapphire", Quality = 3, IsRed = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3159, ItemId = 32637, Name = "Unstable Citrine", Quality = 3, IsRed = true, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3160, ItemId = 32638, Name = "Unstable Topaz", Quality = 3, IsRed = true, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3161, ItemId = 32639, Name = "Unstable Talasite", Quality = 3, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3162, ItemId = 32640, Name = "Potent Unstable Diamond", Quality = 3, IsMeta = true, IsBindOnPickup = true},
		{EnchantId = 3163, ItemId = 32641, Name = "Imbued Unstable Diamond", Quality = 3, IsMeta = true, IsBindOnPickup = true},
		--{EnchantId = 3197, ItemId = 32735, Name = "Radiant Spencerite", Quality = 4, IsYellow = true, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3201, ItemId = 32833, Name = "Purified Jaggal Pearl", Quality = 2, IsRed = true, IsBlue = true},
		{EnchantId = 3202, ItemId = 32836, Name = "Purified Shadow Pearl", Quality = 3, IsRed = true, IsBlue = true},
		--{EnchantId = 3206, ItemId = 33060, Name = "Soulbound Test Gem", Quality = 3, IsRed = true, IsYellow = true, IsBlue = true, IsBindOnPickup = true},
		{EnchantId = 3208, ItemId = 33131, Name = "Crimson Sun", Quality = 4, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3209, ItemId = 33132, Name = "Delicate Fire Ruby", Quality = 4, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3210, ItemId = 33133, Name = "Don Julio's Heart", Quality = 4, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3211, ItemId = 33134, Name = "Kailee's Rose", Quality = 4, IsRed = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3212, ItemId = 33135, Name = "Falling Star", Quality = 4, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3214, ItemId = 33137, Name = "Sparkling Falling Star", Quality = 4, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3215, ItemId = 33138, Name = "Mystic Bladestone", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3216, ItemId = 33139, Name = "Brilliant Bladestone", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3217, ItemId = 33140, Name = "Blood of Amber", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3218, ItemId = 33141, Name = "Great Bladestone", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3219, ItemId = 33142, Name = "Rigid Bladestone", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3220, ItemId = 33143, Name = "Stone of Blades", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3221, ItemId = 33144, Name = "Facet of Eternity", Quality = 4, IsYellow = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3226, ItemId = 33782, Name = "Steady Talasite", Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 3261, ItemId = 34220, Name = "Chaotic Skyfire Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 3262, ItemId = 34256, Name = "Charmed Amani Jewel", Quality = 4, IsBlue = true, IsUnique = true, IsBindOnPickup = true},
		{EnchantId = 3264, ItemId = 34627, Name = "Heavy Tonk Armor", Quality = 3},
		{EnchantId = 3268, ItemId = 34831, Name = "Eye of the Sea", Quality = 3, IsBlue = true, IsUnique = true},
		{EnchantId = 3270, ItemId = 35315, Name = "Quick Dawnstone", Quality = 3, IsYellow = true},
		{EnchantId = 3271, ItemId = 35316, Name = "Reckless Noble Topaz", Quality = 3, IsRed = true, IsYellow = true},
		{EnchantId = 3272, ItemId = 35318, Name = "Forceful Talasite", Quality = 3, IsYellow = true, IsBlue = true},
		{EnchantId = 3274, ItemId = 35501, Name = "Eternal Earthstorm Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 3275, ItemId = 35503, Name = "Ember Skyfire Diamond", Quality = 3, IsMeta = true},
		{EnchantId = 3280, ItemId = 35707, Name = "Regal Nightseye", Quality = 3, IsRed = true, IsBlue = true},
		{EnchantId = 3281, ItemId = 35487, Name = "Bright Crimson Spinel", Quality = 4, IsRed = true, IsBindOnPickup = true},
		{EnchantId = 3282, ItemId = 35488, Name = "Runed Crimson Spinel", Quality = 4, IsRed = true, IsBindOnPickup = true},
		{EnchantId = 3283, ItemId = 35489, Name = "Teardrop Crimson Spinel", Quality = 4, IsRed = true, IsBindOnPickup = true},
		{EnchantId = 3284, ItemId = 35758, Name = "Steady Seaspray Emerald", Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3285, ItemId = 35759, Name = "Forceful Seaspray Emerald", Quality = 4, IsYellow = true, IsBlue = true},
		{EnchantId = 3286, ItemId = 35760, Name = "Reckless Pyrestone", Quality = 4, IsRed = true, IsYellow = true},
		{EnchantId = 3287, ItemId = 35761, Name = "Quick Lionseye", Quality = 4, IsYellow = true},
	}
end

function ItemValue:LoadJewels()
	local JewelByEnchantId = {}
	local JewelByName = {}
	
	for _, Jewel in pairs(Jewels) do
		JewelByEnchantId[Jewel.EnchantId] = Jewel
		JewelByName[Jewel.Name] = Jewel
	end
	
	for i=#ItemValue.db.profile.Jewels,1,-1 do
		local Jewel = ItemValue.db.profile.Jewels[i]
		if JewelByName[Jewel.Name] then
			table.remove(ItemValue.db.profile.Jewels, i)
		else
			JewelByEnchantId[Jewel.EnchantId] = Jewel
			JewelByName[Jewel.Name] = Jewel
		end
	end
	
	return JewelByName, JewelByEnchantId
end

function ItemValue:LoadJewelFilters()
	local EnabledJewels = ItemValue.db.profile.EnabledJewels
	local Jewels = ItemValue.JewelByName
	
	local JewelFilters = {
		order	= 8,
		type	= "group",
		childGroups = "tab",
		name	= L["Jewel Filters"],
		desc	= L["Which Jewels should be used."],
		args = {
			disable = {
				order = 1,
				type = "group",
				--inline = true,
				name = L["Disable"],
				desc = L["Disable Jewels"],
				args = {
					All = {
						order = 1,
						type = "execute",
						name = L["All"],
						desc = L["Disable All"],
						func = function()
							for JewelName in pairs(Jewels) do
								EnabledJewels[JewelName] = false
							end
						end,
					},
					Quality = {
						order = 2,
						type = "select",
						name = L["Quality"],
						desc = L["Disable Quality"],
						values = {"Common", "Uncommon", "Rare", "Epic"},
						get = false,
						set = function(info, v)
							for JewelName, Jewel in pairs(Jewels) do
								if Jewel.Quality == v then EnabledJewels[JewelName] = false end
							end
						end,
					},
					Unique = {
						order = 3,
						type = "execute",
						name = L["Unique"],
						desc = L["Disables all unique gems."],
						func = function()
							for JewelName, Jewel in pairs(Jewels) do
								if Jewel.IsUnique then EnabledJewels[JewelName] = false end
							end
						end,
					},
					BOP = {
						order = 4,
						type = "execute",
						name = L["Bind On Pickup"],
						desc = L["Disables all bind on pickup gems."],
						func = function()
							for JewelName, Jewel in pairs(Jewels) do
								if Jewel.IsBindOnPickup then EnabledJewels[JewelName] = false end
							end
						end,
					},
					Name = {
						order = 5,
						type = "input",
						name = L["Name"],
						desc = L["Disables a Jewel if it contains a certain string."],
						validate = function(i, v) return (v and string.len(v) ~= 0) end,
						usage = "<Part of Name>",
						get = false,
						set = function(i, v)
							for JewelName in pairs(Jewels) do
								if string.find(string.lower(JewelName), string.lower(v)) then EnabledJewels[JewelName] = false end
							end
						end,
					},
				},
			},
			Enable = {
				order = 2,
				type = "group",
				--inline = true,
				name = L["Enable"],
				desc = L["Enable Jewels"],
				args = {
					All = {
						order = 1,
						type = "execute",
						name = L["All"],
						desc = L["Enable All"],
						func = function()
							for JewelName in pairs(Jewels) do
								EnabledJewels[JewelName] = true
							end
						end,
					},
					Quality = {
						order = 2,
						type = "select",
						name = L["Quality"],
						desc = L["Enable Quality"],
						values = {"Common", "Uncommon", "Rare", "Epic"},
						get = false,
						set = function(info, v)
							for JewelName, Jewel in pairs(Jewels) do
								if Jewel.Quality == v then EnabledJewels[JewelName] = true end
							end
						end,
					},
					Unique = {
						order = 3,
						type = "execute",
						name = L["Unique"],
						desc = L["Enables all unique gems."],
						func = function()
							for JewelName, Jewel in pairs(Jewels) do
								if Jewel.IsUnique then EnabledJewels[JewelName] = true end
							end
						end,
					},
					BOP = {
						order = 4,
						type = "execute",
						name = L["Bind On Pickup"],
						desc = L["Enables all bind on pickup gems."],
						func = function()
							for JewelName, Jewel in pairs(Jewels) do
								if Jewel.IsBindOnPickup then EnabledJewels[JewelName] = true end
							end
						end,
					},
					Name = {
						order = 5,
						type = "input",
						name = L["Name"],
						desc = L["Enables a Jewel if it contains a certain string."],
						validate = function(i, v) return (v and string.len(v) ~= 0) end,
						usage = "<Part of Name>",
						get = false,
						set = function(i, v)
							for JewelName in pairs(Jewels) do
								if string.find(string.lower(JewelName), string.lower(v)) then EnabledJewels[JewelName] = true end
							end
						end,
					},
				},
			},
			Jewels = {
				order = 3,
				type = "group",
				--inline = true,
				name = L["Jewels"],
				desc = L["Jewels"],
				args = {},
			},
		},
	}
	
	for JewelName, Jewel in pairs(ItemValue.JewelByName) do
		JewelFilters.args.Jewels.args[tostring(Jewel.EnchantId)] = {
			--order	= 1,
			type	= "toggle",
			name	= JewelName,
			desc	= JewelName,
			get		= function() return EnabledJewels[JewelName] end,
			set		= function(v) EnabledJewels[JewelName] = v ItemValue:ClearCache() end,
		}
	end
	
	return JewelFilters
end
