-- Name:  ItemLevelDKP
-- Developed by: Raut, DraenorEU

local MAJOR_VERSION = "0.0.7"

-- Addon initalization
ItemLevelDKP = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceHook-2.1", "AceDebug-2.0")
ItemLevelDKP.title = "ItemLevelDKP"
ItemLevelDKP.version = MAJOR_VERSION
ItemLevelDKP:SetDebugging(false)

-- Library initialization
local L = AceLibrary("AceLocale-2.2"):new("ItemLevelDKP")
L:RegisterTranslations("enUS", function() return {
				     ["ItemLevelDKP - calculate DKP prices to tooltips"] = true,
				     ["CHAT_COMMAND"] = { "/itemleveldkp" },
				  } end)

function ItemLevelDKP:OnInitialize()
   self.options = {
      desc = L["ItemLevelDKP - calculate DKP prices to tooltips"],
      type = "header",
      args = {
      },
   }
   self:RegisterChatCommand(L["CHAT_COMMAND"])
   self:HookTooltipMethods()
end

function ItemLevelDKP:OnEnable()
   self:RegisterEvent("Links_LinkOpened")
end

ItemLevelDKP.TooltipList = {
   ItemRefTooltip,
   GameTooltip,
   ShoppingTooltip1,
   ShoppingTooltip2,
   ComparisonTooltip1,
   ComparisonTooltip2,
}

ItemLevelDKP.MethodList = {
   "SetHyperlink",
   "SetBagItem",
   "SetInventoryItem",
   "SetAuctionItem",
   "SetAuctionSellItem",
   "SetLootItem",
   "SetLootRollItem",
   "SetTradeSkillItem",
   "SetTrainerService",
   "SetInboxItem",
   "SetSendMailItem",
   "SetQuestItem",
   "SetQuestLogItem",
   "SetTradePlayerItem",
   "SetTradeTargetItem",
   "SetMerchantItem",
   "SetHyperlinkCompareItem",
   "SetBuybackItem",
}

function ItemLevelDKP:HookTooltipMethods()
   for _, tooltip in ipairs(self.TooltipList) do
      if tooltip then
	 for _, methodName in ipairs(self.MethodList) do
	    hooksecurefunc(tooltip, methodName, self.ProcessTooltip)
	 end
      end
   end
end

function ItemLevelDKP:Links_LinkOpened(link, frame)
   self:Debug(frame:GetName())
   self.ProcessTooltip(frame, link)
end

function ItemLevelDKP.ProcessTooltip(tooltip, a, b)
   -- if not ItemLevelDKP:IsActive() then return end
   -- fontString = getglobal(tooltip:GetName().."TextLeft1")

   _,item = tooltip:GetItem()
   itemLevel,itemCost = ilvlDKP(item)
   if (itemLevel == -1000) then return end

   str_price = string.format("%.2f", itemCost)
   if (itemLevel == -1) then
      tooltip:AddLine("Fixed price from file", 0.5, 0.5, 1.0)
      tooltip:Show()
   else
      tooltip:AddDoubleLine("Item level: ", itemLevel, 0.5, 0.5, 1.0, 0.2, 0.2, 1.0)
      tooltip:Show()
   end
   tooltip:AddDoubleLine("DKP price: ", str_price, 1.0, 0.5, 0.5, 1.0, 0.2, 0.2)
   tooltip:Show()
end
   
function ilvlDKP(item)
   if not item then return -1000,0 end
   name,_,itemRarity,itemLevel,_,itemType,itemSubType,_,itemEquipLoc = GetItemInfo(item)
   if ItemLevelDKP_List[name] then
      return -1,ItemLevelDKP_List[name]
   else  
	if (not (itemRarity > 2 and  itemRarity < 6)) then
	 return -1000,0
      end
      -- Set DKP base cost
      dkp_base = 0
      if (itemRarity == 3) then
	 dkp_base = (itemLevel - 1.84) / 1.6
      elseif (itemRarity == 4) then
	 dkp_base = (itemLevel - 1.3) / 1.3
      elseif (itemRarity == 5) then
	 dkp_base = itemLevel
      end
	 
      -- Set slot modifier
      dkp_slot = 0
      if     (itemEquipLoc == "INVTYPE_HEAD") then
	 dkp_slot = 1
      elseif (itemEquipLoc == "INVTYPE_NECK") then
	 dkp_slot =  0.54
      elseif (itemEquipLoc == "INVTYPE_SHOULDER") then
	 dkp_slot = 0.74
      elseif (itemEquipLoc == "INVTYPE_CHEST") then
	 dkp_slot = 1
      elseif (itemEquipLoc == "INVTYPE_ROBE") then
	 dkp_slot = 1
      elseif (itemEquipLoc == "INVTYPE_WAIST") then
	 dkp_slot = 0.74
      elseif (itemEquipLoc == "INVTYPE_LEGS") then
	 dkp_slot = 1
      elseif (itemEquipLoc == "INVTYPE_FEET") then
	 dkp_slot = 0.74
      elseif (itemEquipLoc == "INVTYPE_WRIST") then
	 dkp_slot = 0.54
      elseif (itemEquipLoc == "INVTYPE_HAND") then
	 dkp_slot = 0.74
      elseif (itemEquipLoc == "INVTYPE_FINGER") then
	 dkp_slot = 0.54
      elseif (itemEquipLoc == "INVTYPE_TRINKET") then
	 dkp_slot = 0.68
      elseif (itemEquipLoc == "INVTYPE_CLOAK") then
	 dkp_slot = 0.54
      elseif (itemEquipLoc == "INVTYPE_WEAPON") then
	 dkp_slot = 1
      elseif (itemEquipLoc == "INVTYPE_SHIELD") then
	 dkp_slot = 0.65
      elseif (itemEquipLoc == "INVTYPE_2HWEAPON") then
	 dkp_slot = 1.5
      elseif (itemEquipLoc == "INVTYPE_WEAPONMAINHAND") then
	 dkp_slot = 1
      elseif (itemEquipLoc == "INVTYPE_WEAPONOFFHAND") then
	 dkp_slot = 1
      elseif (itemEquipLoc == "INVTYPE_HOLDABLE") then
	 dkp_slot = 0.52
      elseif (itemEquipLoc == "INVTYPE_RANGED" or itemEquipLoc == "INVTYPE_RANGEDRIGHT" or itemEquipLoc == "INVTYPE_THROWN") then
	 if (itemSubType == "Guns" or itemSubType == "Bows" or itemSubType == "Crossbows") then
	    dkp_slot = 1.5
	 else
	    dkp_slot = 0.50
	 end
      elseif (itemEquipLoc == "INVTYPE_RELIC") then
	 dkp_slot = 0.30
      else
	 dkp_slot = 0
      end

      if (dkp_base == 0 or dkp_slot == 0) then 
	 return -1000,0
      else
	 return itemLevel,dkp_base * dkp_slot
      end 
   end
end



 
