--[[
ItemInfo
by Nathanmx
]]--

--[[
ENCHANTS:

2665	35 spirit
2666	30 int
2667	savagery
2668	20 str
2669	40 spell damage
2670	35 agil
2671	Sunfire
2672	Soulfrost
2673	Mongoose
2674	Spellsurge
2675	Battlemaster
2676	superior mana oil

2937	20 spell damage to gloves
2322	35 healing




 
suffix list (lvl 70)
of the Invoker
1110573088
-39

of the Owl
738656288
-9

of Agility
2137915434
-18

1458241578
-18

of Intellect
1563492408
-19

of Fire Protection
460652586
-32

of the Whale
840761400
-8

of the Eagle
433258520
-6
]]--


---------------------------------------------------------------------------
-- GLOBALS
---------------------------------------------------------------------------
ItemInfoSettings = {
	links = ""; -- saved links
	safe = 1; -- safe mode checked
	adv = 0; -- adv mode checked
	verb = 0; -- verbose info checked
	id = 0; -- item id
	color = 0; -- item color (itemRarity number 1-6)
	name = 0; -- item name
	suffix = 0; -- suffix id
	unique = 0; -- unique id
	enchant = 0; -- enchant id
	gem1 = 0; -- gem1 id
	gem2 = 0; -- gem2 id
	gem3 = 0; -- gem3 id
	gem4 = 0; -- gem4 id
	hex = 0; -- item hex color
}

---------------------------------------------------------------------------
-- FUNCTIONS
---------------------------------------------------------------------------

-- load item data into variables
function ItemInfo_LoadItem(link)
	if( not link ) then return false end
	_,_,ItemInfoSettings.color,ItemInfoSettings.id,ItemInfoSettings.enchant,ItemInfoSettings.gem1,ItemInfoSettings.gem2,ItemInfoSettings.gem3,ItemInfoSettings.gem4,ItemInfoSettings.suffix,ItemInfoSettings.unique,ItemInfoSettings.name = string.find(link, "|cff(%x+)|Hitem:(%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)|h%[([^]]+)%]|h|r")
	if( ItemInfoSettings.color == nil ) then
		_,_,ItemInfoSettings.id,ItemInfoSettings.enchant,ItemInfoSettings.gem1,ItemInfoSettings.gem2,ItemInfoSettings.gem3,ItemInfoSettings.gem4,ItemInfoSettings.suffix,ItemInfoSettings.unique = string.find(link, "item:(%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)")
		if( ItemInfoSettings.id and ItemInfoSettings.enchant and ItemInfoSettings.suffix and ItemInfoSettings.unique and ItemInfoSettings.gem1 and ItemInfoSettings.gem2 and ItemInfoSettings.gem3 and ItemInfoSettings.gem4 ) then
			local itemName, _, itemRarity = GetItemInfo(ItemInfoSettings.id)
			if( not itemName ) then
				return false
			end
			ItemInfoSettings.name = itemName
			ItemInfoSettings.color = itemRarity -- string.find(ItemInfoSettings.hex, "|cff(%x+)")
			_, _, _, ItemInfoSettings.hex = GetItemQualityColor(itemRarity)
		else
			IFMSG("Load failed! Invalid link: " .. SpliceLink(link))
			return false
		end
	end
--	if( ItemInfoSettings.id == nil ) then
--		_,_,itemlink = string.find(itemlink, "^|%x+|H(.+)|h%[.+%]")
--		_,_,ItemInfoSettings.id,ItemInfoSettings.enchant,ItemInfoSettings.gem1,ItemInfoSettings.gem2,ItemInfoSettings.gem3,ItemInfoSettings.gem4,ItemInfoSettings.suffix,ItemInfoSettings.unique = string.find(itemlink, "^item:(%d+):(%d+):(%d+):(%d+):(%d+):(%d+):(%-?%d+):(%-?%d+)")
--		if( ItemInfoSettings.id == nil ) then
--			IFMSG("Load failed.")
--			return false
--		end
--	end
--	IFMSG(link .. " loaded.")
	return true
end

-- function that finds which id to use
function ItemInfo_GetId()
	if( ItemInfoSettings.id == nil ) then -- if id is not entered, try to get it from the gui
		if( ItemInfoMain:IsVisible() and tonumber(ItemInfoMainEdit:GetText()) ) then
			ItemInfoSettings.id = tonumber(ItemInfoMainEdit:GetText())
		elseif( ItemInfoMini:IsVisible() and tonumber(ItemInfoMiniEdit:GetText()) ) then
			ItemInfoSettings.id = tonumber(ItemInfoMiniEdit:GetText())
		else
			return false
		end
	end
	return true
end

-- set the item data information in the GUI
function ItemInfo_SetItemData(link,doshow)
	if( ItemInfo_GetId() == false ) then
		IFMSG("You need to enter an item id!")
		return -- if no item id is found, abort
	end
	ItemInfoMainEdit:SetText(ItemInfoSettings.id)
	ItemInfoMiniEdit:SetText(ItemInfoSettings.id)
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo( ItemInfoSettings.id ) -- GetItemInfo() works only for cached items, otherwise it returns nil
	if( ItemInfoChatVerbose:GetChecked() and itemName ) then -- spit it all to chat frame if option is checked
		IFMSG("Link: |cffFFFFFF" .. SpliceLink(itemLink) .. "|r")
		IFMSG("Name: |cffFFFFFF" .. itemName .. "|r")
		IFMSG("Item ID: |cffFFFFFF" .. ItemInfoSettings.id .. "|r")
		IFMSG("Enchant ID: |cffFFFFFF" .. ItemInfoSettings.enchant .. "|r")
		IFMSG("Gems: |cffFFFFFF" .. ItemInfoSettings.gem1.. "|r-|cffFFFFFF" .. ItemInfoSettings.gem2 .. "|r-|cffFFFFFF".. ItemInfoSettings.gem3 .. "|r-|cffFFFFFF" .. ItemInfoSettings.gem4)
		IFMSG("Suffix ID: |cffFFFFFF" .. ItemInfoSettings.suffix .. "|r")
		IFMSG("Unique ID: |cffFFFFFF" .. ItemInfoSettings.unique .. "|r")
		IFMSG("Hex color: |cffFFFFFF" .. ItemInfoSettings.color .. "|r")
		IFMSG("Rarity: |cffFFFFFF" .. itemRarity .. "|r")
		IFMSG("Item Level: |cffFFFFFF" .. itemLevel .. "|r")
		IFMSG("MinLevel: |cffFFFFFF" .. itemMinLevel .. "|r")
		IFMSG("Type: |cffFFFFFF" .. itemType .. "|r")
		IFMSG("SubType: |cffFFFFFF" .. itemSubType .. "|r")
		IFMSG("StackCount: |cffFFFFFF" .. itemStackCount .. "|r")
		IFMSG("EquipLoc: |cffFFFFFF" .. itemEquipLoc .. "|r")
		IFMSG("Texture: |cffFFFFFF" .. itemTexture .. "|r")
	end
	if( itemName ) then
		if( not link and ItemInfoCheckVars() ) then
			link = "item:" ..  ItemInfoSettings.id .. ":" .. ItemInfoSettings.enchant .. ":" .. ItemInfoSettings.gem1 .. ":" .. ItemInfoSettings.gem2 .. ":" .. ItemInfoSettings.gem3 .. ":" .. ItemInfoSettings.gem4 .. ":" .. ItemInfoSettings.suffix .. ":" .. ItemInfoSettings.unique
		elseif( link == "increment" ) then
			link = itemLink
		end
		if( not ItemInfo_LoadItem(link) ) then -- we need to load the new item data into the vars so we don't set the wrong info to the GUI
			IFMSG("ItemInfo_LoadItem(link) returned false... aborting.")
			return false
		end
	--	getglobal("ItemInfoButton_NormalTexture"):SetTexture(itemTexture) -- don't need to change this texture
	--	local ir, ig, ib, _ = GetItemQualityColor(itemRarity)
	--	ItemInfoButton_Text:SetTextColor(ir,ig,ib)
		ItemInfoButton_IconTexture:SetTexture(itemTexture)
		ItemInfoButton_Text:SetText(itemName)
		ItemInfoButton_Text:SetVertexColor(ITEM_QUALITY_COLORS[itemRarity].r, ITEM_QUALITY_COLORS[itemRarity].g, ITEM_QUALITY_COLORS[itemRarity].b) -- SetVertexColor > SetTextColor
		ItemInfoMiniButton_IconTexture:SetTexture(itemTexture)
		ItemInfoMiniButton_Text:SetText(itemName)
		ItemInfoMiniButton_Text:SetVertexColor(ITEM_QUALITY_COLORS[itemRarity].r, ITEM_QUALITY_COLORS[itemRarity].g, ITEM_QUALITY_COLORS[itemRarity].b)
		ItemInfoEnchantText:SetText("Enchant:  |cffFFFFFF" .. ItemInfoSettings.enchant .. "|r")
		ItemInfoSuffixText:SetText("Suffix: |cffFFFFFF" .. ItemInfoSettings.suffix .. "|r")
		ItemInfoLevelText:SetText("Item Lvl:  |cffFFFFFF" .. itemLevel .."|r    Min Lvl:  |cffFFFFFF" .. itemMinLevel .. "|r")
		if itemStackCount == 1 then
			ItemInfoButton_Count:Hide()
			ItemInfoMiniButton_Count:Hide()
		else
			ItemInfoButton_Count:SetText(itemStackCount)
			ItemInfoButton_Count:Show()
			ItemInfoMiniButton_Count:SetText(itemStackCount)
			ItemInfoMiniButton_Count:Show()
		end
		if( itemType == itemSubType or itemType == "Weapon" ) then -- don't need to display stuff like "Consumable Consumable" or "Two-handed Axes Weapon"
			ItemInfoTypeText:SetText("Type: |cffFFFFFF" .. itemSubType .. "|r")
		else
			ItemInfoTypeText:SetText("Type: |cffFFFFFF" .. itemSubType .. " " .. itemType .. "|r")
		end
		ItemInfoGem1Text:SetText("Gem1: |cffFFFFFF" .. ItemInfoSettings.gem1 .. "|r")
		ItemInfoGem2Text:SetText("Gem2: |cffFFFFFF" .. ItemInfoSettings.gem2 .. "|r")
		ItemInfoGem3Text:SetText("Gem3: |cffFFFFFF" .. ItemInfoSettings.gem3 .. "|r")
		ItemInfoGem4Text:SetText("Gem4: |cffFFFFFF" .. ItemInfoSettings.gem4 .. "|r")
		if( not ItemInfoMini:IsVisible() and not doshow ) then -- show the GUI incase the user is using slash commands, but only if the mini frame isn't showing
			ItemInfoMain:Show()
		end
	else
	--	IFMSG("Data retrieval failed, link not found in local cache.")
	--	ItemInfoButton_IconTexture:SetTexture("Interface\Icons\INV_Misc_QuestionMark") -- doesn't work for some reason
		ItemInfoButton_IconTexture:SetTexture("")
		ItemInfoButton_Text:SetText("Unknown Item")
	--	ItemInfoMiniButton_IconTexture:SetTexture("Interface\Icons\INV_Misc_QuestionMark") -- doesn't work for some reason
		ItemInfoMiniButton_IconTexture:SetTexture("")
		ItemInfoMiniButton_Text:SetText("Unknown Item")
	--	local ir, ig, ib = GetItemQualityColor(6)
	--	ItemInfoButton_Text:SetTextColor(ir,ig,ib)
		ItemInfoButton_Text:SetVertexColor(ITEM_QUALITY_COLORS[6].r, ITEM_QUALITY_COLORS[6].g, ITEM_QUALITY_COLORS[6].b)
		ItemInfoMiniButton_Text:SetVertexColor(ITEM_QUALITY_COLORS[6].r, ITEM_QUALITY_COLORS[6].g, ITEM_QUALITY_COLORS[6].b)
		ItemInfoEnchantText:SetText("Enchant:  |cffFFFFFF??|r")
		ItemInfoSuffixText:SetText("Suffix: |cffFFFFFF??|r")
		ItemInfoLevelText:SetText("Item Lvl:  |cffFFFFFF??|r    Min Lvl:  |cffFFFFFF??|r")
		ItemInfoButton_Count:Hide()
		ItemInfoMiniButton_Count:Hide()
		ItemInfoTypeText:SetText("Type: |cffFFFFFF??|r")
		ItemInfoGem1Text:SetText("Gem1: |cffFFFFFF??|r")
		ItemInfoGem2Text:SetText("Gem2: |cffFFFFFF??|r")
		ItemInfoGem3Text:SetText("Gem3: |cffFFFFFF??|r")
		ItemInfoGem4Text:SetText("Gem4: |cffFFFFFF??|r")
	end
end

-- mouseover the item icon in the GUI
function ItemInfoButton_OnEnter()
	if( ItemInfo_GetId() == false ) then
		return
	end
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo( ItemInfoSettings.id )
	ShowUIPanel(ItemRefTooltip)
	ItemRefTooltip:SetOwner(this, "ANCHOR_LEFT")
	if( not ItemRefTooltip:IsVisible() ) then
		ItemRefTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE")
	end
	if( itemTexture == nil ) then
		ItemRefTooltip:SetText("Tooltip disabled! (item not cached)")
	else
		ItemRefTooltip:SetHyperlink("item:" ..  ItemInfoSettings.id .. ":" .. ItemInfoSettings.enchant .. ":" .. ItemInfoSettings.gem1 .. ":" .. ItemInfoSettings.gem2 .. ":" .. ItemInfoSettings.gem3 .. ":" .. ItemInfoSettings.gem4 .. ":" .. ItemInfoSettings.suffix .. ":" .. ItemInfoSettings.unique)
	end
	ItemRefCloseButton:Hide()
	ItemRefTooltip:Show()
	CursorUpdate()
end

-- mouseout
function ItemInfoButton_OnLeave()
	ItemRefTooltip:Hide()
	ItemRefCloseButton:Show()
	ResetCursor()
end

-- onclick
function ItemInfoButton_OnClick()
	if( IsShiftKeyDown() and ConstructLink_Advanced() ) then
		ChatFrameEditBox:Show()
		local curtxt = ChatFrameEditBox:GetText()
		ChatFrameEditBox:SetText(curtxt .. ConstructLink_Advanced())
		ChatFrameEditBox:SetFocus()
	else
		if( ConstructLink_Basic() ) then
			DressUpItemLink(ConstructLink_Basic())
		end
	end
end

-- show the item info tooltip
function ShowItemInfoTooltip()
	if( ItemInfoTooltip:IsVisible() ) then
		ItemInfoTooltip:Hide()
	else
		if( ItemInfo_GetId() == false ) then
			IFMSG("You need to enter an item id!")
			return
		end
		local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo( ItemInfoSettings.id )
		if( ItemInfoSafeMode:GetChecked() and itemTexture == nil ) then
			ItemInfoTooltip:SetText("Tooltip disabled! (Safe Mode)")
		else
			if( ItemInfoCheckVars() ) then
				SetItemInfoRef("item:" ..  ItemInfoSettings.id .. ":" .. ItemInfoSettings.enchant .. ":" .. ItemInfoSettings.gem1 .. ":" .. ItemInfoSettings.gem2 .. ":" .. ItemInfoSettings.gem3 .. ":" .. ItemInfoSettings.gem4 .. ":" .. ItemInfoSettings.suffix .. ":" .. ItemInfoSettings.unique)
			else
				SetItemInfoRef("item:" .. ItemInfoSettings.id ..":0:0:0:0:0:0:0")
			end
		end
	end
end

-- set ItemInfoTooltip contents
function SetItemInfoRef(link)
	if( not ItemRefTooltip:IsVisible() ) then
		ItemInfoTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE")
	end
	if( not ItemInfoTooltipCloseButton:IsVisible() ) then
		ItemInfoTooltipCloseButton:Show()
	end
	ItemInfoTooltip:SetHyperlink(link)
	--ShowUIPanel(ItemInfoTooltip)
	ItemInfoTooltip:Show()
end

-- construct a link with just the item id
function ConstructLink_Basic(ignorestuff)
	if( ItemInfo_GetId() == false ) then
		IFMSG("You need to enter an item id!")
		return false
	end
	ItemInfoMainEdit:SetText(tostring(ItemInfoSettings.id))
	ItemInfoMiniEdit:SetText(tostring(ItemInfoSettings.id))
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo( ItemInfoSettings.id )
	if( itemLink ) then
		_, _, _, ItemInfoSettings.hex = GetItemQualityColor(itemRarity);
		_, _, ItemInfoSettings.color = string.find(ItemInfoSettings.hex, "|cff(%x+)");
		_, _, ItemInfoSettings.id = string.find(itemLink, "item:(%d+)")
		ItemInfoSettings.id = tonumber(ItemInfoSettings.id)
		ItemInfoSettings.name = itemName
		ItemInfoSettings.enchant = "0"
		ItemInfoSettings.suffix = "0"
		ItemInfoSettings.unique = "0"
		ItemInfoSettings.gem1 = "0"
		ItemInfoSettings.gem2 = "0"
		ItemInfoSettings.gem3 = "0"
		ItemInfoSettings.gem4 = "0"
		local linky = ItemInfoSettings.hex .. "|Hitem:" ..  tostring(ItemInfoSettings.id) .. ":0:0:0:0:0:0:0|h[" .. ItemInfoSettings.name .. "]|h|r"
		return linky
	else
		if( ItemInfoSafeMode:GetChecked() ) then
			local iid
			if( ItemInfoMain:IsVisible() ) then
				iid = ItemInfoMainEdit:GetText()
			else
				iid = ItemInfoMiniEdit:GetText()
			end
		--	IFMSG("<Safe Mode> ID \"" .. iid .. "\" not found in local cache. Will not attempt to query server.")
			return false
		else
		--	IFMSG("ItemID " .. ItemInfoSettings.id .. " - not found in local cache. Querying Server...")
			ItemInfoTooltip:SetHyperlink("item:" .. ItemInfoSettings.id ..":0:0:0:0:0:0:0") -- this is the function that causes disconnects
		--	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo( ItemInfoSettings.id )
			ItemInfo_LoadItem("item:" .. ItemInfoSettings.id ..":0:0:0:0:0:0:0")
			if( not ignorestuff ) then
				IFMSG("Click \"Create\" once more to construct your new link!") -- i guess it just takes a second to work so you have to wait a sec and click create again to get the link
			--	if ( ChatFrameEditBox:IsVisible() ) then
			--		ChatFrameEditBox:Insert(ErrorOnPurpose);
			--	end
				return ConstructLink_Finish()
			end
			return true
		end
	end
end

function ConstructLink_Finish()
	local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo( ItemInfoSettings.id )
	if( itemLink ) then
		_, _, _, ItemInfoSettings.hex = GetItemQualityColor(itemRarity);
		_, _, ItemInfoSettings.color = string.find(ItemInfoSettings.hex, "|cff(%x+)");
		_, _, ItemInfoSettings.id = string.find(itemLink, "item:(%d+)")
		ItemInfoSettings.id = tonumber(ItemInfoSettings.id)
		ItemInfoSettings.name = itemName
		ItemInfoSettings.enchant = "0"
		ItemInfoSettings.suffix = "0"
		ItemInfoSettings.unique = "0"
		ItemInfoSettings.gem1 = "0"
		ItemInfoSettings.gem2 = "0"
		ItemInfoSettings.gem3 = "0"
		ItemInfoSettings.gem4 = "0"
		local linky = ItemInfoSettings.hex .. "|Hitem:" ..  tostring(ItemInfoSettings.id) .. ":0:0:0:0:0:0:0|h[" .. ItemInfoSettings.name .. "]|h|r"
		return linky
	else
	--	IFMSG("failed!!!")
		return false
	end
end

-- construct a link with the entered variable data
function ConstructLink_Advanced()
	if( ItemInfoCheckVars() ) then
		ItemInfoSetColor()
		local linky = ItemInfoSettings.hex .. "|Hitem:" ..  ItemInfoSettings.id .. ":" .. ItemInfoSettings.enchant .. ":" .. ItemInfoSettings.gem1 .. ":" .. ItemInfoSettings.gem2 .. ":" .. ItemInfoSettings.gem3 .. ":" .. ItemInfoSettings.gem4 .. ":" .. ItemInfoSettings.suffix .. ":" .. ItemInfoSettings.unique .. "|h[" .. ItemInfoSettings.name .. "]|h|r";
		return linky
	else
		IFMSG("Advanced Creation FAILED because not all item data is present.");
		return false
	end
end

-- /iinfo slash command handler
function ItemInfoGetInfo(msg)
	if( tonumber(msg) ) then
		ItemInfoMainEdit:SetText(msg)
		ItemInfoMiniEdit:SetText(msg)
		ItemInfoSettings.id = msg
		if( ConstructLink_Basic(1) ) then
			IFMSG("Constructed Link: " .. tostring(ConstructLink_Basic()) .. "   [ ID " .. ItemInfoSettings.id .. " ]" )
		end
		ItemInfo_LoadItem("item:" .. msg ..":0:0:0:0:0:0:0")
		ItemInfo_SetItemData("item:" .. msg ..":0:0:0:0:0:0:0")
	elseif( type(msg) == "string" and msg ~= "" ) then
		ItemInfo_LoadItem(msg)
		ItemInfo_SetItemData(msg)
	else
		if( ItemInfoMain:IsVisible() ) then
			ItemInfoMain:Hide()
		else
			ItemInfoMain:Show()
		end
	end
end

-- check if all the necessary item creation variables have data, returns true or false
function ItemInfoCheckVars()
	if( ItemInfoSettings.id and ItemInfoSettings.color and ItemInfoSettings.name and ItemInfoSettings.suffix and ItemInfoSettings.enchant and ItemInfoSettings.unique and ItemInfoSettings.gem1 and ItemInfoSettings.gem2 and ItemInfoSettings.gem3 and ItemInfoSettings.gem4 ) then
		return true;
	else
		return false;
	end
end

-- sets color and hex variables with proper values in case the user entered words rather than actual hex values
function ItemInfoSetColor()
	if( ItemInfoSettings.color == "gold" or ItemInfoSettings.color == "purple" or ItemInfoSettings.color == "blue" or ItemInfoSettings.color == "green" or ItemInfoSettings.color == "white" or ItemInfoSettings.color == "gray" or ItemInfoSettings.color == "artifact" or ItemInfoSettings.color == "legendary" or ItemInfoSettings.color == "epic" or ItemInfoSettings.color == "superior" or ItemInfoSettings.color == "rare" or ItemInfoSettings.color == "uncommon" or ItemInfoSettings.color == "common" or ItemInfoSettings.color == "poor" ) then
		if( ItemInfoSettings.color == "artifact" or ItemInfoSettings.color == "red" ) then
			ItemInfoSettings.color = 6;
		elseif( ItemInfoSettings.color == "legendary" or ItemInfoSettings.color == "gold" ) then
			ItemInfoSettings.color = 5;
		elseif( ItemInfoSettings.color == "epic" or ItemInfoSettings.color == "purple" ) then
			ItemInfoSettings.color = 4;
		elseif( ItemInfoSettings.color == "superior" or ItemInfoSettings.color == "rare" or ItemInfoSettings.color == "blue" ) then
			ItemInfoSettings.color = 3;
		elseif( ItemInfoSettings.color == "uncommon" or ItemInfoSettings.color == "green" ) then
			ItemInfoSettings.color = 2;
		elseif( ItemInfoSettings.color == "common" or ItemInfoSettings.color == "white" ) then
			ItemInfoSettings.color = 1;
		elseif( ItemInfoSettings.color == "poor" or ItemInfoSettings.color == "gray" ) then
			ItemInfoSettings.color = 0;
		end
		_, _, _, ItemInfoSettings.hex = GetItemQualityColor(ItemInfoSettings.color);
	elseif( type(ItemInfoSettings.color) == "number" ) then
		_, _, _, ItemInfoSettings.hex = GetItemQualityColor(ItemInfoSettings.color);
	else
		ItemInfoSettings.hex = "|cff" .. ItemInfoSettings.color;
	end
end

-- item:itemId:enchantId:jewelId1:jewelId2:jewelId3:jewelId4:suffixId:uniqueId
-- i'm not even fully sure what this function does or if it works... lol ill fix it later :P
function FindEnchants(n)
	if( ItemInfoSettings.id and ItemInfoSettings.name and ItemInfoSettings.enchant and ItemInfoSettings.gem1) then
		ItemRefTooltip:Hide()
		SetItemRef("item:" .. ItemInfoSettings.id .. ":" .. ItemInfoSettings.enchant .. ":" .. ItemInfoSettings.gem1 .. ":0:0:0:0:0","|Hitem:" .. ItemInfoSettings.id ..":" .. ItemInfoSettings.enchant .. ":0:0:0:0:0:0|h[".. ItemInfoSettings.name .. "]|h|r")
		ItemRefTooltip:AddLine("Gem ID: " .. ItemInfoSettings.gem1, .9, .2, .2)
		ItemRefTooltip:AddLine("Enchant ID: " .. ItemInfoSettings.enchant, .9, .2, .2)
		ItemRefTooltip:Show()
		if( n == 1 ) then
			ItemInfoSettings.gem1 = tostring(tonumber(ItemInfoSettings.gem1) + 1)
		else
			ItemInfoSettings.gem1 = tostring(tonumber(ItemInfoSettings.gem1) - 1)
		end
		IFMSG("Gem ID: " .. tostring(ItemInfoSettings.gem1))
	else
		IFMSG("Error: not enough data.")
	end
end

-- someday
function FindSuffixes(t,n)

end

-- ditto
function FindGems(n,x)
	if( ItemInfoSettings.id and ItemInfoSettings.name and ItemInfoSettings.gem1) then
		ItemRefTooltip:Hide()
		SetItemRef("item:" .. ItemInfoSettings.id .. ":0:" .. ItemInfoSettings.gem1 .. ":0:0:0:0:0","|Hitem:" .. ItemInfoSettings.id ..":0:" .. ItemInfoSettings.gem1 .. ":0:0:0:0:0|h[".. ItemInfoSettings.name .. "]|h|r")
		ItemRefTooltip:AddLine("Gem ID: " .. ItemInfoSettings.gem1, .9, .2, .2)
		ItemRefTooltip:Show()
		if( not x ) then
			IFMSG(ConstructLink_Advanced() .. " - " .. SpliceLink(ConstructLink_Advanced()) )
		end
		if( n == 1 ) then
			ItemInfoSettings.gem1 = tostring(tonumber(ItemInfoSettings.gem1) + 1)
		else
			ItemInfoSettings.gem1 = tostring(tonumber(ItemInfoSettings.gem1) - 1)
		end
	else
		IFMSG("Error: not enough data.")
	end
end

function GetSuffixFactor(itemString)
	local suffixFactor = 0
	--local linkType, itemId, enchantId,
	--jewelId1, jewelId2, jewelId3, jewelId4,
	--suffixId, uniqueId = strsplit(":", itemString)
	--suffixId = tonumber(suffixId)
	--uniqueId = tonumber(uniqueId)
	--if (linkType == 'item') then
		if ( tonumber(ItemInfoSettings.suffix) < 0) then
			suffixFactor = bit.band(tonumber(ItemInfoSettings.unique), 65535)
		end
	--end
	return suffixFactor
end

-- random item colors craziness
function GetItemColors()
	local BITEM_QUALITY_COLORS = { };
	for i = -1, 6 do
		BITEM_QUALITY_COLORS[i] = { }
		BITEM_QUALITY_COLORS[i].r, BITEM_QUALITY_COLORS[i].g, BITEM_QUALITY_COLORS[i].b, BITEM_QUALITY_COLORS[i].hex = GetItemQualityColor(i)
		IFMSG("ItemQuality["..i.."] = \"" .. string.upper(string.gsub(BITEM_QUALITY_COLORS[i].hex, "\124cff", "")) .. "\".")
	end
end

-- lame inspect function
function ItemInfo_Inspect()
	HideUIPanel(InspectFrame);
	ClearInspectPlayer();
	if( UnitName("target") and UnitName("target") ~= "Unknown" ) then
		NotifyInspect("target");
		InspectUnit("target");
	else
		NotifyInspect("mouseover");
		InspectUnit("mouseover");
	end
end

-- increment / decrement function
function ItemInfoIncrement(msg)
	if( ItemInfo_GetId() == false ) then
		IFMSG("Increment failed - couldn't find item id!")
		return
	end
	if(msg) then 
		ItemInfoSettings.id = ItemInfoSettings.id - 1
	else
		ItemInfoSettings.id = ItemInfoSettings.id + 1
	end
	ItemInfoMainEdit:SetText(tostring(ItemInfoSettings.id))
	ItemInfoMiniEdit:SetText(tostring(ItemInfoSettings.id))
	ItemInfo_SetItemData("increment")
end


-- toggle function
function ItemInfo_Toggle()
	if ItemInfoMain:IsVisible() then
		ItemInfoMain:Hide()
    else
		ItemInfoMini:Hide()
		ItemInfoMain:Show()
    end
end

-- save gui settings (called whenever a change is made)
function ItemInfo_SaveSettings()
	if( ItemInfoSafeMode:GetChecked() ) then
		ItemInfoSettings.safe = 1
	else
		ItemInfoSettings.safe = 0
	end
	if( ItemInfoAdvMode:GetChecked() ) then
		ItemInfoSettings.adv = 1
	else
		ItemInfoSettings.adv = 0
	end
	if( ItemInfoChatVerbose:GetChecked() ) then
		ItemInfoSettings.verb = 1
	else
		ItemInfoSettings.verb = 0
	end
end

-- load gui settings (called on load)
function ItemInfo_LoadSettings()
	if( ItemInfoSettings.safe == 1 ) then
		ItemInfoSafeMode:SetChecked(1)
	end
	if( ItemInfoSettings.adv == 1 ) then
		ItemInfoAdvMode:SetChecked(1)
	end
	ItemInfo_SetItemData(nil,1) -- set this before setting verbose option to avoid onload spam
	if( ItemInfoSettings.verb == 1 ) then
		ItemInfoChatVerbose:SetChecked(1)
	end
	if( ItemInfoSettings.id ) then
		ItemInfoMainEdit:SetText(ItemInfoSettings.id)
		ItemInfoMiniEdit:SetText(ItemInfoSettings.id)
	end
end

-- cut up links so they can be read in the chat frame (prevents parsing by the chat frame)
function SpliceLink(msg)
	return string.gsub(msg, "\124", "\124\124")
end

-- report the contents of variables
function ReportDataContents()
	IFMSG("Reporting variable contents...")
	IFMSG("name: " .. ItemInfoSettings.name)
	IFMSG("id: " .. ItemInfoSettings.id)
	IFMSG("hex: " .. ItemInfoSettings.hex)
	IFMSG("color: " .. ItemInfoSettings.color)
	IFMSG("suffix: " .. ItemInfoSettings.suffix)
	IFMSG("unique: " .. ItemInfoSettings.unique)
	IFMSG("enchant: " .. ItemInfoSettings.enchant)
	IFMSG("gem1: " .. ItemInfoSettings.gem1)
	IFMSG("gem2: " .. ItemInfoSettings.gem2)
	IFMSG("gem3: " .. ItemInfoSettings.gem3)
	IFMSG("gem4: " .. ItemInfoSettings.gem4)
end

-- resets variable contents (does not entirely /clear/ them as they are not "nil")
function ClearDataContents()
	ItemInfoSettings.safe = 1
	ItemInfoSettings.adv = 0
	ItemInfoSettings.verb = 0
	ItemInfoSettings.id = 0
	ItemInfoSettings.color = 0
	ItemInfoSettings.name = 0
	ItemInfoSettings.hex = 0
	ItemInfoSettings.suffix = 0
	ItemInfoSettings.unique = 0
	ItemInfoSettings.enchant = 0
	ItemInfoSettings.gem1 = 0
	ItemInfoSettings.gem2 = 0
	ItemInfoSettings.gem3 = 0
	ItemInfoSettings.gem4 = 0
	ItemInfoSafeMode:SetChecked(1) -- enable safe mode so user doesn't disconnect mousing over the item by accident
	ItemInfo_SetItemData()
	IFMSG("Variable data reset.")
end

-- OnLoad function
function ItemInfo_OnLoad()
	this:RegisterEvent("VARIABLES_LOADED") -- register event so the GUI settings can be applied
	SLASH_ITEMSPLICE1 = "/splice"
	SLASH_SPLICECOPY1 = "/copylink"
	SLASH_ITEMINFO1 = "/iinfo"
	SLASH_ITEMINFO2 = "/iteminfo"
	SLASH_ITEMLINK1 = "/ilink"
	SLASH_ITEMLINK2 = "/itemlink"
	SLASH_ITEM1 = "/item"
	SLASH_SAVELINK1 = "/slink"
	SLASH_LOADLINK1 = "/iload"
	SlashCmdList["ITEMSPLICE"] = function(msg)
		ItemSplice_SlashCommandHandler(msg)
	end
	SlashCmdList["SPLICECOPY"] = function(msg)
		SpliceCopy_SlashCommandHandler(msg)
	end
	SlashCmdList["ITEMINFO"] = function(msg)
		ItemInfoGetInfo(msg)
	end
	SlashCmdList["ITEMLINK"] = function(msg)
		ItemLink_SlashCommandHandler(msg)
	end
	SlashCmdList["ITEM"] = function(msg)
		Item_SlashCommandHandler(msg)
	end
	SlashCmdList["SAVELINK"] = function(msg)
		SaveLink_SlashCommandHandler(msg)
	end
	SlashCmdList["LOADLINK"] = function(msg)
		LoadLink_SlashCommandHandler(msg)
	end
	if(DEFAULT_CHAT_FRAME) then
		DEFAULT_CHAT_FRAME:AddMessage("|cffcba300Nathanmx's ItemInfo Loaded, v".. ITEMINFO_VERSION .. "|r")
		DEFAULT_CHAT_FRAME:AddMessage("|cffcba300See the readme file in the ItemInfo folder for help.|r")
	end
	itemName = nil
	itemLink = nil
	itemRarity = nil
	itemLevel = nil
	itemMinLevel = nil
	itemType = nil
	itemSubType = nil
	itemStackCount = nil
	itemEquipLoc = nil
	itemTexture = nil
end

-- OnEvent function to load GUI settings
function ItemInfo_OnEvent(event)
	if( event == "VARIABLES_LOADED" ) then
		ItemInfo_LoadSettings()
	end
end

-- main output function
function IFMSG(text)
	if( not text ) then return end
	if( DEFAULT_CHAT_FRAME ) then DEFAULT_CHAT_FRAME:AddMessage("|cffcba300[ItemInfo] " .. text .. "|r ", .5, .5, 1.0) end
end

ItemSplice_SlashCommandHandler = function (msg)
	IFMSG(SpliceLink(msg))
end

SpliceCopy_SlashCommandHandler = function (msg)
	ChatFrameEditBox:Show()
	ChatFrameEditBox:Insert(SpliceLink(ConstructLink_Advanced()))
end

-- /ilink command handler
function ItemLink_SlashCommandHandler(msg)
	if( string.find(msg,"clear") ) then
		ClearDataContents()
	elseif ( string.find(msg,"report") ) then
		ReportDataContents()
	elseif ( string.find(msg,"adv") ) then
		IFMSG("<Advanced Mode> Constructed Link: " .. ConstructLink_Advanced())
	else
		IFMSG("Constructed Link: " .. ConstructLink_Basic())
	end
end

-- /slink command handler
function SaveLink_SlashCommandHandler(msg)
	if(msg) then
		if( string.find(msg,"save") ) then
			msg = string.sub(msg,6)
			if( ItemInfoSettings.links == nil ) then ItemInfoSettings.links = "" end
			ItemInfoSettings.links = ItemInfoSettings.links .. msg
			IFMSG("\"" .. msg .. "\" - Links saved.")
		elseif ( string.find(msg,"clear") ) then
			ItemInfoSettings.links = ""
			IFMSG("Saved links cleared.")
		elseif ( string.find(msg,"show") ) then
			IFMSG("Showing Saved Links:")
			IFMSG(ItemInfoSettings.links)
		elseif ( string.find(msg,"edit") ) then
			msg = string.sub(msg,6)
			IFMSG("Removing: " .. msg)
			ItemInfoSettings.links = string.gsub(ItemInfoSettings.links, msg, "")
		else
			IFMSG("Invalid parameter.  Valid parameters to /slink: save,clear,show,edit")
		end
	else
		IFMSG("You need to type in a parameter to use /slink!")
	end
end

-- /item command handler
function Item_SlashCommandHandler(msg)
--	local _,_,cmd,param = string.find(msg, "(%S+)%s(.+)") -- why doesn't this work?! o.O
	local _,_,cmd = string.find(msg, "(%S+)")
	local _,_,param = string.find(msg, "%S+%s(.+)")
	if param == "-nil" then param = "" end
	if( cmd == "name" ) then
		ItemInfoSettings.name = param
		IFMSG("[Item Name] set to \"" .. ItemInfoSettings.name .. "\"")
	elseif( cmd == "color" ) then
		ItemInfoSettings.color = param
		IFMSG("[Item Color] set to \"" .. ItemInfoSettings.color .. "\"")
	elseif( cmd == "id" ) then
		ItemInfoSettings.id = param
		IFMSG("[Item Id] set to \"" .. ItemInfoSettings.id .. "\"")
	elseif( cmd == "unique" ) then
		ItemInfoSettings.unique = param
		IFMSG("[Item Unique] set to \"" .. ItemInfoSettings.unique .. "\"")
	elseif( cmd == "suffix" ) then
		ItemInfoSettings.suffix = param
		IFMSG("[Item Suffix] set to \"" .. ItemInfoSettings.suffix .. "\"")
	elseif( cmd == "enchant" ) then
		ItemInfoSettings.enchant = param
		IFMSG("[Item Enchant] set to \"" .. ItemInfoSettings.enchant .. "\"")
	elseif( cmd == "gem1" ) then
		ItemInfoSettings.gem1 = param
		IFMSG("[Item Gem1] set to \"" .. ItemInfoSettings.gem1 .. "\"")
	elseif( cmd == "gem2" ) then
		ItemInfoSettings.gem2 = param
		IFMSG("[Item Gem2] set to \"" .. ItemInfoSettings.gem2 .. "\"")
	elseif( cmd == "gem3" ) then
		ItemInfoSettings.gem3 = param
		IFMSG("[Item Gem3] set to \"" .. ItemInfoSettings.gem3 .. "\"")
	elseif( cmd == "gem4" ) then
		ItemInfoSettings.gem4 = param
		IFMSG("[Item Gem4] set to \"" .. ItemInfoSettings.gem4 .. "\"")
	else
		if( not cmd ) then cmd = "nil" end
		IFMSG("Invalid command [\"" .. cmd .. "\"]. Valid commands to /item: name,color,id,unique, suffix, enchant, gem1, gem2, gem3, gem4")
	end
end

-- /iload command handler
function LoadLink_SlashCommandHandler(msg)
	if (msg) then
		ItemInfo_LoadItem(msg)
		if( ItemInfoCheckVars() ) then
			IFMSG("Data loaded from \"" .. msg .. "\".")  -- note: just because it parsed properly doesn't mean it's a real item link!
		end
	else
		IFMSG("You need to enter a link to load!")
	end
end

-- function to get info about the IconTexture
function GetIconTextureInfo()
	IFMSG("Texture: " .. ItemInfoButton_IconTexture:GetTexture())
	IFMSG("IsDesaturated: " .. tostring(ItemInfoButton_IconTexture:IsDesaturated()))
	IFMSG("Vertex Color: " .. ItemInfoButton_IconTexture:GetVertexColor())
	IFMSG("Texture Coords: " .. ItemInfoButton_IconTexture:GetTexCoord())
	IFMSG("Texture Mod Coords: " .. tostring(ItemInfoButton_IconTexture:GetTexCoordModifiesRect()))
	IFMSG("BlendMode: " .. ItemInfoButton_IconTexture:GetBlendMode())
end

-- this function figures out where the command is coming from and how to process it
function ItemInfo_Create()
	if( ItemInfoAdvMode:GetChecked() and ConstructLink_Advanced() ) then
		IFMSG("<Advanced Mode> Constructed Link: " .. ConstructLink_Advanced())
	elseif( ConstructLink_Basic() ) then
		IFMSG("Constructed Link: " .. ConstructLink_Basic())
	else
	--	IFMSG("Unable to create link.")
		return false
	end
	ItemInfo_SetItemData()
end

--[[ 
ENCHANTS:

2665	35 spirit
2666	30 int
2667	savagery
2668	20 str
2669	40 spell damage
2670	35 agil
2671	Sunfire
2672	Soulfrost
2673	Mongoose
2674	Spellsurge
2675	Battlemaster
2676	superior mana oil

2937	20 spell damage to gloves
2322	35 healing


/item enchant 2668
/item gem3 2672
/item gem4 2674
/item gem1 2937
/item gem2 2322

|cff9d9d9d|Hitem:21226:2668:2937:2322:2672:2674:0:0|h[Runic Stone]|h|r

|cff9d9d9d|Hitem:21223:2668:2672:2674:2937:2322:0:0|h[Black Stone]|h|r

|cff1eff00|Hitem:22249:2668:2937:2322:2672:2674:0:0|h[Big Bag of Enchantment]|h|r

2689 = DISCONNECT

GEMS:
2830	+12 Critical Strike Rating & 5% Snare and Root Resist
2828	5% on spellcast - next spell cast in half time
2835	+12 Intellect & Chance to restore mana on spellcast
2832	+26 Healing Spells & 2% Reduced Threat
2831	+18 Stamina & 5% Stun Resist

2827	+14 Spell Crit Rating and 1% Spell Reflect
2828	5% on spellcast - next spell cast in half time
2829	+24 Attack Power and Minor Run Speed Increase
2830	+12 Critical Strike Rating & 5% Snare and Root Resist
2831	+18 Stamina & 5% Stun Resist
2832	+26 Healing Spells & 2% Reduced Threat
2833	+12 Defense Rating & Chance to Restore Health on hit
2834	+3 Melee Damage & Chance to Stun Target
2835	+12 Intellect & Chance to restore mana on spellcast

/item enchant 2830
/item gem1 2828
/item gem2 2835
/item gem3 2832
/item gem4 2831


|cff9d9d9d|Hitem:21223:2830:2828:2835:2832:2831:0:0|h[Black Stone]|h|r

|cff1eff00|Hitem:24270:2830:2828:2835:2832:2831:0:0|h[Bag of Jewels]|h|r

/script NathanTradeSelling("say")


]]--

NathanTradeSelling = function (where,who)
	local msg1 = "==== I cut and enchant for FREE (your mats) ===="
	local msg2 = " ENCHANTS: |cff9d9d9d|Hitem:21226:2668:2937:2322:2672:2674:0:0|h[Runic Stone]|h|r    GEMS: |cff9d9d9d|Hitem:21223:2830:2828:2835:2832:2831:0:0|h[Black Stone]|h|r"
	local msg3 = "                        Tips are welcome.  :)"
	local msg4 = "===== Nathon's Enchanting & Jewelcrafting ====="
	local msg5 = "////////////////////////////////////////////////////"
	if( where == "trade" ) then
		--SendChatMessage(msg5, "CHANNEL", "ORCISH", "2");
		SendChatMessage(msg4, "CHANNEL", "ORCISH", "2");
		SendChatMessage(msg2, "CHANNEL", "ORCISH", "2");
		--SendChatMessage(msg3, "CHANNEL", "ORCISH", "2");
		SendChatMessage(msg1, "CHANNEL", "ORCISH", "2");
		--SendChatMessage(msg5, "CHANNEL", "ORCISH", "2");
	elseif( where == "say" ) then
		--SendChatMessage(msg5, "SAY", "ORCISH");
		SendChatMessage(msg4, "SAY", "ORCISH");
		SendChatMessage(msg2, "SAY", "ORCISH");
		--SendChatMessage(msg3, "SAY", "ORCISH");
		SendChatMessage(msg1, "SAY", "ORCISH");
		--SendChatMessage(msg5, "SAY", "ORCISH");
	elseif( where == "yell" ) then
		--SendChatMessage(msg5, "YELL", "ORCISH");
		SendChatMessage(msg4, "YELL", "ORCISH");
		SendChatMessage(msg2, "YELL", "ORCISH");
		--SendChatMessage(msg3, "YELL", "ORCISH");
		SendChatMessage(msg1, "YELL", "ORCISH");
		--SendChatMessage(msg5, "YELL", "ORCISH");
	elseif( where == "whisper" and who ) then
		--SendChatMessage(msg5, "WHISPER", "ORCISH", who);
		SendChatMessage(msg4, "WHISPER", "ORCISH", who);
		SendChatMessage(msg2, "WHISPER", "ORCISH", who);
		--SendChatMessage(msg3, "WHISPER", "ORCISH", who);
		SendChatMessage(msg1, "WHISPER", "ORCISH", who);
		--SendChatMessage(msg5, "WHISPER", "ORCISH", who);
	end
end


-- local Original_SetItemRef = SetItemRef;
-- local Original_ChatEdit_InsertLink = ChatEdit_InsertLink;

--[[

SetInventoryItem("player", getglobal("CharacterHeadSlot"):GetID());


local hasCooldown, repairCost = GameTooltip:SetBagItem(getglobal("CharacterHeadSlot"):GetParent():GetID(),getglobal("CharacterHeadSlot"):GetID());


/script GameTooltip:SetInventoryItem(getglobal("CharacterHeadSlot"):GetParent():GetID(),getglobal("CharacterHeadSlot"):GetID());


function HasHeadGear()
 local headSlot = getglobal("CharacterHeadSlot");
 local hasItem, hasCooldown, repairCost =
  MyTooltip:SetInventoryItem("player", headSlot:GetID());
 if ((hasItem) and (repairCost) and (repairCost > 0)) then
  return true;
 else
  return false;
 end
end

]]--


---------------------------------------------------------------------------
-- Alt IInfo
---------------------------------------------------------------------------
-- if you are holding alt while clicking a link then it will /iinfo that link
-- broken code, it prevents the correct linking of items
--[[
local Original_ChatFrame_OnHyperlinkShow = ChatFrame_OnHyperlinkShow;
function ChatFrame_OnHyperlinkShow(link)
	if ( IsAltKeyDown() ) then
		ItemInfoGetInfo(link);
	elseif (IsShiftKeyDown() and ChatFrameEditBox:IsVisible()) then
		ChatFrameEditBox:Insert(link);
	elseif (IsControlKeyDown()) then
		DressUpItemLink(link);
	end
	return Original_ChatFrame_OnHyperlinkShow(link);
end
]]--

---------------------------------------------------------------------------
-- junky mcjunk
---------------------------------------------------------------------------
--[[
function ChatFrame_MessageEventHandler(event)
	local msg = arg1;
	--local player = arg2;
	--local channel = arg4;
	if( msg ) then
		ChatMsgParse(msg);
	end
	return Original_ChatFrame_MessageEventHandler(event);
end
]]--

--[[ ItemInfo string format (no spaces):
		|[ A:L1:R1:L2:R2:L3:R3:Ln:Rn... ]|
A: link name
B: link color
20 lines max

	- need function to make it so the link is actually clickable in chat frame
	- need function to paste link in edit box
	- need a function to parse when clicking the link to have it actually show
	- another  to change some lines colors (like Red when not of level, etc)

	local szMessage = arg1;
	local szPlayer = arg2;
	local szChannel = arg4;
	arg9 is the channel name without the number in front...
]]--

-- |cff(%x+)|Hitem:(%d+):(%d+):(%d+):(%d+)|h%[([^]]+)%]|h|r");

-- function ChatMsgParse(msg)
--	_,_,linkName,linkColor,linkData = string.find(msg, "|Hiinfo:(%w+):(%x+)|h(%w+)|h");
-- or
--	_,_,linkName,linkColor,linkData = string.find(msg, "|Hiinfo:([^]]+):(%x+)|h(%w+)|h");
--	if( linkname and linkcolor ) then
	-- replace linky
--	end
-- end


--[[

-- original SetItemRef
function SetItemRef(link, text, button)
	if ( strsub(link, 1, 6) == "player" ) then
		local name = strsub(link, 8);
		if ( name and (strlen(name) > 0) ) then
			name = gsub(name, "([^%s]*)%s+([^%s]*)%s+([^%s]*)", "%3");
			name = gsub(name, "([^%s]*)%s+([^%s]*)", "%2");
			if ( IsShiftKeyDown() ) then
				local staticPopup;
				staticPopup = StaticPopup_Visible("ADD_IGNORE");
				if ( staticPopup ) then
					-- If add ignore dialog is up then enter the name into the editbox
					getglobal(staticPopup.."EditBox"):SetText(name);
					return;
				end
				staticPopup = StaticPopup_Visible("ADD_FRIEND");
				if ( staticPopup ) then
					-- If add ignore dialog is up then enter the name into the editbox
					getglobal(staticPopup.."EditBox"):SetText(name);
					return;
				end
				staticPopup = StaticPopup_Visible("ADD_GUILDMEMBER");
				if ( staticPopup ) then
					-- If add ignore dialog is up then enter the name into the editbox
					getglobal(staticPopup.."EditBox"):SetText(name);
					return;
				end
				staticPopup = StaticPopup_Visible("ADD_RAIDMEMBER");
				if ( staticPopup ) then
					-- If add ignore dialog is up then enter the name into the editbox
					getglobal(staticPopup.."EditBox"):SetText(name);
					return;
				end
				if ( ChatFrameEditBox:IsVisible() ) then
					ChatFrameEditBox:Insert(name);
				else
					SendWho("n-"..name);					
				end
				
			elseif ( button == "RightButton" ) then
				FriendsFrame_ShowDropdown(name, 1);
			else
				ChatFrame_SendTell(name);
			end
		end
		return;
	end

	if ( IsControlKeyDown() ) then
		DressUpItemLink(text);
	elseif ( IsShiftKeyDown() ) then
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:Insert(text);
		end
	else
		ShowUIPanel(ItemRefTooltip);
		if ( not ItemRefTooltip:IsVisible() ) then
			ItemRefTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE");
		end
		ItemRefTooltip:SetHyperlink(link);
	end
end

-- hyperlink format
-- |H%s|h%s|h

function ItemInfo_ShowCustomLink(link, text, button)
	if ( IsShiftKeyDown() ) then
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:Insert(text);
		end
	else
		ShowUIPanel(ItemRefTooltip);
		if ( not ItemRefTooltip:IsVisible() ) then
			ItemRefTooltip:SetOwner(UIParent, "ANCHOR_PRESERVE");
		end
	--	ItemRefTooltip:SetHyperlink(link);
	end
end


function SetItemRef(link, text, button)
	if ( strsub(link, 1, 5) == "iinfo" ) then
		ItemInfo_ShowCustomLink(link, text, button);
	else
		return Original_SetItemRef(link, text, button);
	end
end

]]--

--[[

function ChatEdit_InsertLink(text)
	if ( strsub(text, 1, 5) == "iinfo" ) then
		IFMSG("text1",text);
		local link = "|cffff8000|Hiinfo:111:2333322:333:444:555:666:777:888|h[Item of God]|h|r"
		ChatFrameEditBox:Insert(text);
	else
		IFMSG("text2",text);
		return Original_ChatEdit_InsertLink(text);
	end
end

function ItemInfoFakeLink()
	local link = "|cffff8000|Hiinfo:111:222:333:444:555:666:777:888|h[Item of God]|h|r"
	IFMSG("fake",link);
end

]]--

--[[
-- way to view items not in cache and without querying server
ItemInfoStoredItem = {};

ItemInfoStoredItem["12345"]["<data>"]
<data>
rarity
name
suffix
enchant
gem1
gem2
gem3
gem4
line1-20

]]--