--[[
	ItemID v1.6.20400
]]

local ItemID_Version = "1.6";
local WoW_Version = "20400";

local ItemID_Output = {
	ITEMID_CHAN_PARTY,
	ITEMID_CHAN_GUILD,
	ITEMID_CHAN_SAY,
	ITEMID_CHAN_YELL,
	ITEMID_CHAN_RAID,
}

local ItemID_Mode = {
	ITEMID_MODE_FULL,
	ITEMID_MODE_STRING,
	ITEMID_MODE_LINK,
	ITEMID_MODE_IMAGE,
}

function ItemID_load()
	-- Slash Commands
	SLASH_ItemID1 = "/itemid";
	SlashCmdList["ItemID"] = ItemID_commandline;

	ItemID_Msg(ITEMID_VERSION.." "..ItemID_Version.." "..ITEMID_NOWLOADED);
end

-- Message Output
function ItemID_Msg(msg, channel)
	if (msg == nil) then
		return;
	end
	if (channel == ITEMID_CHAN_PARTY) then
		SendChatMessage(msg,"PARTY");
	elseif (channel == ITEMID_CHAN_GUILD) then
		SendChatMessage(msg,"Guild");
	elseif (channel == ITEMID_CHAN_SAY) then
		SendChatMessage(msg,"SAY");
	elseif (channel == ITEMID_CHAN_YELL) then
		SendChatMessage(msg,"YELL");
	elseif (channel == ITEMID_CHAN_RAID) then
		SendChatMessage(msg,"RAID");
	elseif (channel == "Error") then
		DEFAULT_CHAT_FRAME:AddMessage(RED_FONT_COLOR_CODE..ITEMID_TITLE.." "..ITEMID_ERROR..": |r"..msg);
	else
		DEFAULT_CHAT_FRAME:AddMessage(GREEN_FONT_COLOR_CODE..ITEMID_TITLE..": |r"..msg);
	end
end

--== Universal Functions ==--
-- The Error input is for error message overrides. Any input to Error will suppress error message output.

-- mode 0 = base item ID, anything else = Full item ID
function ItemID_GetItemID(itemlink,mode,error)
	if (strfind(itemlink,":") == nil) then
		if (error == nil) then
			ItemID_Msg(ITEMID_IDINVALID,"Error");
		end
		return;
	end

	local justItemId = string.gsub(itemlink,".-\124H([^\124]*)\124h.*", "%1");
	local type, itemid, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId = strsplit(":",justItemId);

	if (mode == "0") then
		finallink = itemid;
	else
		if uniqueId ~= nil then
			finallink = strjoin(":",type, itemid, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId)
		else
			finallink = itemid;
		end
	end

	return tostring(gsub(finallink, "\124", "\124\124")), type;
end

function ItemID_ID2Itemlink(itemid,error)
	local Item_Name, Item_Link, _, _, _, _, _, _, _, _ = GetItemInfo(itemid);
	if (Item_Link == Nil) then
		if (error == nil) then
			ItemID_Msg(ITEMID_IDINVALID,"Error");
		end
		return;
	end
	return Item_Link;
end

function ItemID_GetImage(itemlink,error)
	local itemid, type = ItemID_GetItemID(itemlink,0,1);

	if (type == "enchant") then
		if (error == nil) then
			ItemID_Msg(ITEMID_NOENCHANTIMAGE,"Error");
		end
		return;
	end

	if (itemid == nil) then
		if (error == nil) then
			ItemID_Msg(ITEMID_LINKINVALID,"Error");
		end
		return;
	end

	local _, ItemLink, _, _, _, _, _, _, _, itemTexture = GetItemInfo(itemid);
	local _, _, SpIcon = GetSpellInfo(itemid);
	local image = itemTexture;

	if (itemTexture == nil) then
		image = SpIcon;
	end
	
	if (image == nil) then
		if (error == nil) then
			ItemID_Msg(ITEMID_LINKINVALID,"Error");
		end
		return;
	end

	return image;
end

function ItemID_String(itemlink,error)
	local Item_Name, Item_Link, _, _, _, _, _, _, _, _ = GetItemInfo(itemlink);
	local Output = Item_Link,nil;

	if (Item_Link == nil) then
		local itemid = ItemID_GetItemID(itemlink,0,1);
		if (itemid == nil) then
			if (error == nil) then
				ItemID_Msg(ITEMID_LINKINVALID,"Error");
			end
			return;
		end
		Output = GetSpellLink(itemid);
	end

	if (Output == nil) then
		if (error == nil) then
			ItemID_Msg(ITEMID_LINKINVALID,"Error");
		end
		return;
	end
	Item_Link2 = gsub(Output, "\124", "\124\124");
	return Item_Link2;
end

-- Itemid-Only Functions
local function ItemID_Cmd_Mode(cmd,mode,channel)
	if (cmd == nil) then
		ItemID_Msg(ITEMID_CMDINVALID,"Error");
		return;
	end
	local result, start;
	if (mode == ITEMID_MODE_FULL) then
		local node, type = ItemID_GetItemID(cmd,"1",1);
		local MsgF;
		if node == nil then
			ItemID_Msg(ITEMID_LINKINVALID,"Error");
			return;
		end
		if (type == "spell") then
			MsgF = ITEMID_SPELLID;
		elseif (type == "enchant") then
			MsgF = ITEMID_ENCHANTID;
		else
			MsgF = ITEMID_ITEMIDFULL;
		end
		result = MsgF..tostring(cmd)..ITEMID_IS..node;
	elseif (mode == ITEMID_MODE_STRING) then
		local node, type = ItemID_String(cmd);
		local MsgF;
		if node == nil then
			return;
		end
		if (type == "spell") then
			MsgF = ITEMID_SPELLID;
		elseif (type == "enchant") then
			MsgF = ITEMID_ENCHANTID;
		else
			MsgF = ITEMID_ITEMIDSTRING;
		end
		result = MsgF..tostring(cmd)..ITEMID_IS..node;
	elseif (mode == ITEMID_MODE_LINK) then
		local node = ItemID_ID2Itemlink(cmd,1);
		if node == nil then
			ItemID_Msg(ITEMID_IDINVALID,"Error");
			return;
		end
		result = ITEMID_ITEMLINK..node;
	elseif (mode == ITEMID_MODE_IMAGE) then
		local node = ItemID_GetImage(cmd);
		if node == nil then
			return;
		end
		result = ITEMID_IMAGE..tostring(cmd)..ITEMID_IS..node;
	else
		local node, type = ItemID_GetItemID(cmd,"0",1);
		local MsgF;
		if node == nil then
			ItemID_Msg(ITEMID_LINKINVALID,"Error");
			return;
		end
		if (type == "spell") then
			MsgF = ITEMID_SPELLID;
		elseif (type == "enchant") then
			MsgF = ITEMID_ENCHANTID;
		else
			MsgF = ITEMID_ITEMID;
		end
		result = MsgF..tostring(cmd)..ITEMID_IS..node;
	end
	ItemID_Msg(result, channel);
end

local function ItemID_Cmd_Parse(cmd)
	local mode, output, outcmd, result;
	outcmd = cmd;
	for i=1, getn(ItemID_Mode) do
		local a = ItemID_Mode[i];
		if a == nil then a = ""; end
		if string.find(cmd,a) then
			local input = string.find(cmd,a);
			mode = strsub(cmd,input,input+strlen(a));
			outcmd = strtrim(string.gsub(outcmd,mode,""));
		end
	end
	for k=1, getn(ItemID_Output) do
		local a = ItemID_Output[k];
		if a == nil then a = ""; end
		if string.find(outcmd,a) then
			local input = string.find(outcmd,a);
			output = strsub(outcmd,input,input+strlen(a));
			outcmd = string.gsub(outcmd,output,"");
		end
	end

	if mode == nil then
		mode = "";
	end
	if output == nil then
		output = "";
	end

	-- Used for Debuging purposes.
	-- ItemID_Msg("OutCmd: \""..strtrim(outcmd).."\", Mode: "..strtrim(tostring(mode))..", Output: "..strtrim(tostring(output)));

	ItemID_Cmd_Mode(strtrim(outcmd),strtrim(mode),strtrim(output));
end

-- Command Line handler
function ItemID_commandline(cmd)
	if (cmd == ITEMID_HELP) or (cmd == "") then
		ItemID_Msg(ITEMID_HELP1)
		ItemID_Msg(ITEMID_HELP2);
		ItemID_Msg(ITEMID_HELP3);
		ItemID_Msg(ITEMID_HELP4);
		ItemID_Msg(ITEMID_HELP5);
		ItemID_Msg(ITEMID_HELP6);
	else
		ItemID_Cmd_Parse(cmd);
	end
end