--[[****************************************************************
	ItemAge v0.03

	Author: Evil Duck
	****************************************************************

	Plug-in for World of Warcraft

	****************************************************************]]


-- 0.03 Added function for retrieving age for use by other addons 
-- 0.02 Release with age in tooltip
-- 0.01 Beta version


BINDING_HEADER_ITEMAGE = "ItemAge bindings";
BINDING_NAME_TOGGLEITEMAGE = "Toggle ItemAge display";
ITEMAGE_VERSIONTEXT = "ItemAge v0.03";
SLASH_ITEMAGE1 = "/itemage";
SLASH_ITEMAGE2 = "/age";
SLASH_ITEMAGE3 = "/ia";


ItemAge_Items={};
ItemAge_Info={};
local ItemAge_Tooltip=nil;
local ItemAge_TooltipText1=nil;
local ItemAge_Hook={ TT={} };



-- Set up for handling
function ItemAge_OnLoad()
	this:RegisterEvent("BANKFRAME_OPENED");
	this:RegisterEvent("PLAYERBANKSLOTS_CHANGED");
	this:RegisterEvent("BAG_UPDATE");
	this:RegisterEvent("GUILDBANKBAGSLOTS_CHANGED");
	this:RegisterEvent("GUILDBANKFRAME_OPENED");
	this:RegisterEvent("VARIABLES_LOADED");

	SlashCmdList["ITEMAGE"]=function(msg) ItemAge_Slasher(msg) end;
end


-- An event has been received
function ItemAge_OnEvent(event)
	if (event=="BANKFRAME_OPENED") then ItemAge_BankOpen=true;
	elseif (event=="BANKFRAME_CLOSED") then ItemAge_BankOpen=nil; return; end

	if (event=="BAG_UPDATE" or event=="PLAYERBANKSLOTS_CHANGED" or event=="BANKFRAME_OPENED") then
		ItemAge_ReadStuff();
		return; 
	end

	if (event=="GUILDBANKBAGSLOTS_CHANGED" or event=="GUILDBANKFRAME_OPENED") then
		ItemAge_ReadGuildBank();
		return;
	end

	if (event=="VARIABLES_LOADED") then
		ItemAge_Hook.TT.SetBagItem=GameTooltip.SetBagItem; GameTooltip.SetBagItem=ItemAge_Hook.SetBagItem;
		ItemAge_Hook.TT.SetGuildBankItem=GameTooltip.SetGuildBankItem; GameTooltip.SetGuildBankItem=ItemAge_Hook.SetGuildBankItem;
		ItemAge_Hook.TT.SetHyperlink=GameTooltip.SetHyperlink; GameTooltip.SetHyperlink=ItemAge_Hook.SetHyperlink;
		ItemAge_Hook.TT.SetInboxItem=GameTooltip.SetInboxItem; GameTooltip.SetInboxItem=ItemAge_Hook.SetInboxItem;
		ItemAge_Hook.TT.SetInventoryItem=GameTooltip.SetInventoryItem; GameTooltip.SetInventoryItem=ItemAge_Hook.SetInventoryItem;
		if (not ItemAge_Hook.TT.SetBagItem) then ItemAge_Chat("Hook is zero"); end
		if (not ItemAge_Info.Init) then ItemAge_Info={ Init=true, Bags=true, Bank=true, GBank=true }; end
		local now=time();
		UpdateAddOnMemoryUsage();
		local usage=GetAddOnMemoryUsage("ItemAge");
		ItemAge_Chat(string.format("%.0fKB",usage));
		if (usage>200) then
			local count=5;
			while (count>0) do
				local faintest=nil;
				for uid,val in pairs(ItemAge_Items) do
					if (val.Bag) then
						if (not faintest) then faintest=uid;
						elseif (itemAge_Items[uid].Last<ItemAge_Items[faintest].Last) then faintest=uid; end
					end
				end
				if (faintest) then itemAge_Items[faintest]=nil;
				else count=1; end
				count=count-1;
			end
		end
		return;
	end
end


function ItemAge_Hook:SetInventoryItem(unit,slot,nameOnly)
	local hasItem,hasCooldown,repairCost=ItemAge_Hook.TT.SetInventoryItem(self,unit,slot,nameOnly);
	if (not ItemAge_Info.NoTooltip) then ItemAge_SetTooltipAge(); end
	return hasItem,hasCooldown,repairCost;
end
function ItemAge_Hook:SetInboxItem(index)
	ItemAge_Hook.TT.SetInboxItem(self,index);
	if (not ItemAge_Info.NoTooltip) then ItemAge_SetTooltipAge(); end
end
function ItemAge_Hook:SetHyperlink(link)
	ItemAge_Hook.TT.SetHyperlink(self,link);
	if (not ItemAge_Info.NoTooltip) then ItemAge_SetTooltipAge(); end
end
function ItemAge_Hook:SetGuildBankItem(tab,id)
	ItemAge_Hook.TT.SetGuildBankItem(self,tab,id);
	if (not ItemAge_Info.NoTooltip) then ItemAge_SetTooltipAge(); end
end
function ItemAge_Hook:SetBagItem(bag,slot)
	local hasCooldown,repairCost=ItemAge_Hook.TT.SetBagItem(self,bag,slot);
	if (not ItemAge_Info.NoTooltip) then ItemAge_SetTooltipAge(); end
	return hasCooldown,repairCost;
end


function ItemAge_ToggleHidden()
	if (ItemAge_Info.Hidden) then ItemAge_Info.Hidden=nil; else ItemAge_Info.Hidden=true; end
	ItemAge_ReadStuff();
end


function ItemAge_ReadGuildBank()
	local thistab=GetCurrentGuildBankTab();
	local now=time();

	local column=1;
	local slot;
	local index=1;

	local button,link;
	while(column<=7) do
		slot=1;
		while(slot<=14) do
			local bname="GuildBankColumn"..column.."Button"..slot;
			button=getglobal(bname);
			if (not button) then return; end
			if (not button.ItemAge) then button.ItemAge=CreateFrame("Frame",button:GetName().."_Info",button,"ItemAge_AgeTemplate"); end
			link=GetGuildBankItemLink(thistab,index);
			if (link) then ItemAge_HandleUID(nil,link,button,now,ItemAge_Info.GBank);
			elseif (button.ItemAge) then button.ItemAge:Hide(); end
			slot=slot+1;
			index=index+1;
		end
		column=column+1;
	end
end


function ItemAge_ReadStuff()
	local link,bagslots;
	local now=time();

	-- Do all bank slots
	for item=1,28 do
		link=GetContainerItemLink(BANK_CONTAINER,item);
		local button=getglobal("BankFrameItem"..item);
		if (not button.ItemAge) then button.ItemAge=CreateFrame("Frame",button:GetName().."_Info",button,"ItemAge_AgeTemplate"); end
		if (link) then ItemAge_HandleUID(nil,link,button,now,ItemAge_Info.Bank);
		elseif (button.ItemAge) then button.ItemAge:Hide(); end
	end

	-- Each banker bag
	for num=5,11 do
		bagslots=GetContainerNumSlots(num);
		-- Each slot in said bag
		link=nil;
		for item=1,bagslots do
			local button=getglobal("ContainerFrame".. num+1 .."Item".. bagslots-(item-1));
			if (not button.ItemAge) then button.ItemAge=CreateFrame("Frame",button:GetName().."_Info",button,"ItemAge_AgeTemplate"); end
			link=GetContainerItemLink(num,item);
			if (link) then ItemAge_HandleUID(nil,link,button,now,ItemAge_Info.Bank);
			elseif (button.ItemAge) then button.ItemAge:Hide(); end
		end
	end

-- REGULAR BAGS --
-- ContainerFrameXItemY
-- X = Right-to-left 1->5
-- Y = Bottom-right to top-left 1->

-- THE BANK --
-- BankFrameItemY
-- Y = Top-left to bottom-right 1-> (so "correct"...)

-- ContainerFrameXItemY
-- X = Right-to-left 6->
-- Y = Bottom-right to top-left 1->

-- THE GUILD BANK
-- GuildBankColumnXButtonY
-- X = Left-to-right 1->7
-- y = Top-left (down) 1->14

--	<FontString name="$parent_AgeTL" inherits="NumberFontNormalYellow" outline="NORMAL" justifyH="LEFT" hidden="false">
--	<FontString name="$parent_AgeBL" inherits="NumberFontNormalYellow" outline="NORMAL" justifyH="LEFT" hidden="false">
--	<FontString name="$parent_AgeBR" inherits="NumberFontNormalYellow" outline="NORMAL" justifyH="RIGHT" hidden="false">

	-- Save bags
	for num=0,4 do
		local bagslots=GetContainerNumSlots(num);
		link=nil;
		for item=1,bagslots do
			local button=getglobal("ContainerFrame".. num+1 .."Item".. bagslots-(item-1));
			if (not button.ItemAge) then button.ItemAge=CreateFrame("Frame",button:GetName().."_Info",button,"ItemAge_AgeTemplate"); end
			link=GetContainerItemLink(num,item);
			if (link) then ItemAge_HandleUID(true,link,button,now,ItemAge_Info.Bags);
			elseif (button.ItemAge) then button.ItemAge:Hide(); end
		end
	end
end


function ItemAge_HandleUID(bags,link,button,now,showit)
	if (not showit or ItemAge_Info.Hidden) then button.ItemAge:Hide(); return; end
	local UniqueID=ItemAge_GetUniqueID(link);
	if (UniqueID~=0 and not ItemAge_Items[UniqueID]) then
		ItemAge_Items[UniqueID]={ First=now, Last=now };
		getglobal(button.ItemAge:GetName().."_AgeTL"):SetText("New");
		button.ItemAge:Show();
	elseif (UniqueID~=0) then
		getglobal(button.ItemAge:GetName().."_AgeTL"):SetText(ItemAge_GetAgeText(now-ItemAge_Items[UniqueID].First,true));
		button.ItemAge:Show();
	else
		button.ItemAge:Hide();
	end
	if (ItemAge_Items[UniqueID]) then ItemAge_Items[UniqueID].Bag=bags; end
end


function ItemAge_GetAge(link)
	local UID=ItemAge_GetUniqueID(link);
	if (not UID) then return nil; end
	if (not ItemAge_Items[UID]) then return nil; end
	return time()-ItemAge_Items[UniqueID].First;
end


function ItemAge_GetAgeText(age,short)
	local text=string.format("%.0f",age); if (short) then text=text.."s"; else text=text.." seconds"; end
	if (age>=60) then
		age=age/60;
		text=string.format("%.0f",age); if (short) then text=text.."m"; else text=text.." minutes"; end
		if (age>=60) then
			age=age/60;
			text=string.format("%.0f",age); if (short) then text=text.."h"; else text=text.." hours"; end
			if (age>=24) then
				age=age/24;
				local formatstring="%.1f";
				if (age>7) then formatstring="%.0f"; end
				text=string.format(formatstring,age); if (short) then text=text.."d"; else text=text.." days"; end
			end
		end
	end
	return text;
end


function ItemAge_GetUniqueID(link)
	if (type(link)~="string") then
		if (type(link)~="number") then return 0; end
		_,link=GetItemInfo(link);
	end
	local itemID,ench,g1,g2,g3,g4,suff,uid=link:match("|Hitem:(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+)|h%[(.-)%]|h");
	if (not uid) then
		itemID,ench,g1,g2,g3,g4,suff,uid=link:match("item:(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+):(%p?%d+)");
	end
	if (not uid) then return 0; end
	return tonumber(uid),uid;
end


function ItemAge_SetPosition()
	local scale,x,y=UIParent:GetScale(),GetCursorPosition();
	ItemAge_Frame:ClearAllPoints();
	ItemAge_Frame:SetPoint("TOPLEFT",UIParent,"BOTTOMLEFT",(x+16 -(ItemAge_Frame:GetWidth()/2))/scale,(y-15)/scale);
end


function ItemAge_OnUpdate(elapsed)
	if (ItemAge_Info.NoTooltip) then return; end
	if (GameTooltip) then
		if (GameTooltip:IsVisible()) then
			local _,ThisItem=GameTooltip:GetItem();
			if (ThisItem==ItemAge_Tooltip) then return; end
			if (ItemAge_Tooltip) then
				ItemAge_SetTooltipAge();
--			else
--				ItemAge_ClearTooltip();
			end
		else
			ItemAge_Tooltip=nil;
			ItemAge_TooltipText1=nil;
		end
	end
end


function ItemAge_SetTooltipAge()
	local _,ThisItem=GameTooltip:GetItem();
	ItemAge_Tooltip=ThisItem;
	if (ItemAge_Tooltip) then
		local UniqueID=ItemAge_GetUniqueID(ItemAge_Tooltip);
		if (not UniqueID) then
--			ItemAge_ClearTooltip();
			return; end
		if (not ItemAge_Items[UniqueID]) then
--			ItemAge_ClearTooltip();
			return; end
		GameTooltip:AddDoubleLine("ItemAge: "..ItemAge_GetAgeText(time()-ItemAge_Items[UniqueID].First),"",.3,.3,1,1,1,1);
		GameTooltip:Show();
--	else
--		ItemAge_ClearTooltip();
	end
end


--function ItemAge_ClearTooltip()
--	ItemAge_TooltipText1=nil;
--end


-- Generic chat-pane stuff
function ItemAge_Chat(msg,r,g,b)
	if (DEFAULT_CHAT_FRAME) then
		if (not r and not g and not b) then r=1; g=1; b=1; end;
		if (not r) then r=0; end; if (not g) then g=0; end; if (not b) then b=0; end;
		DEFAULT_CHAT_FRAME:AddMessage("IA: "..msg,r,g,b);
	end
end


-- There's slashing to be done
function ItemAge_Slasher(msg)
	if (not msg) then msg=""; end
	if (strlen(msg)>0) then msg=strlower(msg); end

	if (msg=="bags") then if (ItemAge_Info.Bags) then ItemAge_Info.Bags=nil; else ItemAge_Info.Bags=true; end ItemAge_ReadStuff(); return; end
	if (msg=="bank") then if (ItemAge_Info.Bank) then ItemAge_Info.Bank=nil; else ItemAge_Info.Bank=true; end ItemAge_ReadStuff(); return; end
	if (msg=="gbank") then if (ItemAge_Info.GBank) then ItemAge_Info.GBank=nil; else ItemAge_Info.GBank=true; end ItemAge_ReadGuildBank(); return; end
	if (msg=="tooltip") then if (ItemAge_Info.NoTooltip) then ItemAge_Info.NoTooltip=nil; else ItemAge_Info.NoTooltip=true; end return; end

	ItemAge_Chat(ITEMAGE_VERSIONTEXT);
	ItemAge_Chat(" -> "..SLASH_ITEMAGE2.." tooltip => Toggle diplay of item age in tooltips.");
	ItemAge_Chat("Toggle display of item ages in your:");
	ItemAge_Chat(" -> "..SLASH_ITEMAGE2.." bags => bags");
	ItemAge_Chat(" -> "..SLASH_ITEMAGE2.." bank => bank");
	ItemAge_Chat(" -> "..SLASH_ITEMAGE2.." gbank => guild bank");
	ItemAge_Chat("PLEASE NOTE: The WoW guild bank does too often not report correct info for items, resulting in no age shown for these items.");
end
