IOP_UI_TABLE_ROWS = 25;
IOP_UI_TABLE_ROW_PIXEL_HEIGHT = 16;

IOP_UI_TEXT_COLOUR = {};
IOP_UI_TEXT_COLOUR.LAST_SEEN = {};
IOP_UI_TEXT_COLOUR.LAST_SEEN.WITHIN_24HRS = {r = 0.25, g = 1.00, b = 0.25};
IOP_UI_TEXT_COLOUR.LAST_SEEN.OVER_24HRS = {r = 1.00, g = 0.82, b = 0};
IOP_UI_TEXT_COLOUR.PLAYER_NAME = {};
IOP_UI_TEXT_COLOUR.PLAYER_NAME.CURRENT = {r = 0.25, g = 1.00, b = 0.25};
IOP_UI_TEXT_COLOUR.PLAYER_NAME.HOSTILE = {r = 1.00, g = 0, b = 0};
IOP_UI_TEXT_COLOUR.PLAYER_NAME.OTHER = {r = 1.00, g = 0.82, b = 0};
IOP_UI_TEXT_COLOUR.SCORE = {};
IOP_UI_TEXT_COLOUR.SCORE.BELOW_PAR = {r = 0.61, g = 0.61, b = 0.61, name = colourGrey}; -- grey
IOP_UI_TEXT_COLOUR.SCORE.ON_PAR = {r = 0.12, g = 1.00, b = 0, name = colourGreen}; -- green
IOP_UI_TEXT_COLOUR.SCORE.ABOVE_PAR = {r = 1, g = 1, b = 0, name = colourYellow}; -- yellow
IOP_UI_TEXT_COLOUR.SCORE.WELL_ABOVE_PAR = {r = 1, g = 0.5, b = 0.0, name = colourOrange}; -- orange
IOP_UI_TEXT_COLOUR.SCORE.SIGNIFICANTLY_ABOVE_PAR = {r = 1.00, g = 0, b = 0, name = colourRed}; -- red
IOP_UI_TEXT_COLOUR.SCORE.WOW = {r = 0.64, g = 0.21, b = 0.93, name = colourPurple}; -- purple
IOP_UI_TEXT_COLOUR.SCORE.OMG = {r = 0.90, g = 0.80, b = 0.50, name = colourGold}; -- gold

function IOP_UI_OnLoad()
	IOP_UI_SetInitialized(false);
end

function IOP_UI_RowOnLoad()
	this:RegisterForClicks("LeftButtonUp","RightButtonUp");
end

function IOP_UI_OnShow()
	PlaySound("igMainMenuOption");
	IOP_UI_Initialize();
	InventoryOnParOption.Close();
end

function IOP_UI_OpenOptionMenu()
	ShowUIPanel(InventoryOnParOptionFrame);
end

function IOP_UI_Close()
	HideUIPanel(this:GetParent());
	IOP_PaperDollFrame:Hide();
	InventoryOnParFrame:Hide();
end

function IOP_UI_RowClicked(button)
	rowID = this:GetID();
	local lineOffset = FauxScrollFrame_GetOffset(InventoryOnParUIFrameTableScrollFrame);
	local playerName = IOPDisplayTable[lineOffset + rowID];
	if (button == "RightButton") then
		IOP_UI_DeletePlayerRecord(playerName);
	else
		IOP_UI_ShowTooltip(playerName);
	end
end

function IOP_UI_ShowTooltip(playerName)
	local playerInfo = IOP_GetPlayerRecord(playerName);
	if (playerInfo) then
		InventoryOnParText:SetJustifyH("LEFT");
		InventoryOnParText:SetJustifyV("MIDDLE");
		InventoryOnParText:SetText(playerName.."\n"..playerInfo.tooltipText);
--		InventoryOnParFrame:Show();
		IOP_ShowDoll(playerInfo);
	else
		InventoryOnParFrame:Hide();
	end
end

function IOP_UI_SetInitialized(initFlag)
	IOP_UI_initialized = initFlag;
end

function IOP_UI_SortPlayers(sortType)
	if (IOP_UI_tableSort == sortType) then
		if (IOP_UI_tableSortOrder == "asc") then
			IOP_UI_tableSortOrder = "desc";
		else
			IOP_UI_tableSortOrder = "asc";
		end
	else
		IOP_UI_tableSort = sortType;
		IOP_UI_tableSortOrder = "asc";
	end
	IOP_UI_BuildTableIndex();
end

function IOP_UI_Initialize()
	IOP_UI_tableSort = "playerName";
	IOP_UI_tableSortOrder = "asc";
	IOP.Options.ownGuildOnly = 0;
	IOP.Options.ownPartyOnly = 0;
	InventoryOnParUICheckButtonGuildOnly:SetChecked(0);
	InventoryOnParUICheckButtonPartyOnly:SetChecked(0);
	IOP_UI_SetTableTitle(0,0);
	IOP_AddCurrentPlayer();
	IOP_UI_BuildTableIndex();
	IOP_UI_initialized = true;
	InventoryOnParFrame:Hide();
end

function IOP_UI_ResetTable()
	IOP_UI_ClearTable();
	IOP_UI_UpdateTable();
	FauxScrollFrame_Update(InventoryOnParUIFrameTableScrollFrame, table.getn(IOP_UI_tableIndex), IOP_UI_TABLE_ROWS, IOP_UI_TABLE_ROW_PIXEL_HEIGHT);
end

function IOP_UI_BuildTableIndex()
	local playerList = IOP_GetPlayers();
	local numberOfPlayers = 0;
	
	IOP_UI_tableIndex = {};
	IOPDisplayTable = {};
	local currentIndex = nil;
	local nextIndex = nil;
	
	for playerName, playerInfo in pairs(playerList) do
		numberOfPlayers = numberOfPlayers + 1;
		IOP_UI_InsertPlayerInTableIndex(playerName);
	end
	IOP_UI_ResetTable();
end

function IOP_UI_SortPlayerName(playerName, indexedPlayerName)
	if (type(playerName) == "string" and type(indexedPlayerName) == "string") then
		if ((IOP_UI_tableSortOrder == "desc" and playerName >= indexedPlayerName) or (IOP_UI_tableSortOrder == "asc" and playerName <= indexedPlayerName)) then
			return true
		end
	end
	return false
end

function IOP_UI_ComparePlayers(field, player1, player2)
	local player1Value;
	local player2Value;
	if (field =="guild") then
		player1Value = player1.guild;
		player2Value = player2.guild;
	elseif (field =="class") then
		player1Value = player1.class;
		player2Value = player2.class;
	elseif(field == "level") then
		player1Value = player1.playerLevel;
		player2Value = player2.playerLevel;
	elseif(field == "date") then
		player1Value = player1.recordedTime;
		player2Value = player2.recordedTime;
	end
	if(player1Value < player2Value) then
		return -1;
	elseif(player1Value > player2Value) then
		return 1;
	else
		if(IOP.Options.pvpValues == 1) then
			return player2.pvpScore - player1.pvpScore;
		else
			return player2.IOP_Score - player1.IOP_Score;
		end
	end
end	

function IOP_UI_DeletePlayerRecord(deleteName)
	if (deleteName ~= nil) then
		local displayTable = {};
		for playerName, playerInfo in pairs(IOP.Data[IOP.thisRealm]) do
			if(playerName == deleteName) then
				DEFAULT_CHAT_FRAME:AddMessage("\nInventory On Par : Player "..deleteName.." removed from database");
			else
				displayTable[playerName] = {};
				displayTable[playerName] = playerInfo;
			end
		end
		IOP.Data[IOP.thisRealm] = displayTable;
		IOP_UI_BuildTableIndex();
	end
end

function IOP_UI_CleanUpData()
	local displayTable = {};
	local recordCount = 0;
	for playerName, playerInfo in pairs(IOP.Data[IOP.thisRealm]) do
		if(time()-playerInfo.recordedTime >= IOP.Options.CleanupTime) then
			recordCount = recordCount +1;
			DEFAULT_CHAT_FRAME:AddMessage("Inventory On Par : Player "..playerInfo.playerName.." recorded on "..date(IOP.Options.dateFormat,playerInfo.recordedTime).." removed from database.");
		else
			displayTable[playerName] = {};
			displayTable[playerName] = playerInfo;
		end
	end
	if(recordCount == 0) then
		DEFAULT_CHAT_FRAME:AddMessage("\nInventory On Par : No records over expiry time.");
	else
		IOP.Data[IOP.thisRealm] = displayTable;	
		IOP_UI_BuildTableIndex();
	end
end

function IOP_UI_SortField(field, playerName, indexedPlayerName)
	if (type(playerName) == "string" and type(indexedPlayerName) == "string") then
		local playerInfo = IOP_GetPlayerRecord(playerName);
		local indexedPlayerInfo = IOP_GetPlayerRecord(indexedPlayerName);
		if (playerInfo and indexedPlayerInfo) then
			if (IOP_UI_tableSortOrder == "desc" and IOP_UI_ComparePlayers(field, playerInfo, indexedPlayerInfo) >=0) then
				return true;
			end
			if (IOP_UI_tableSortOrder == "asc" and IOP_UI_ComparePlayers(field, playerInfo, indexedPlayerInfo) <=0) then
				return true
			end
		end
	end
	return false
end

function IOP_UI_SortByField(playerName, indexedPlayerName)
	local playerInfo = IOP_GetPlayerRecord(playerName);
	local indexedPlayerInfo = IOP_GetPlayerRecord(indexedPlayerName);
	
	if (playerInfo and indexedPlayerInfo and type(playerInfo[IOP_UI_tableSort]) == "number" and type(indexedPlayerInfo[IOP_UI_tableSort]) == "number") then
		value = playerInfo[IOP_UI_tableSort];
		indexedValue = indexedPlayerInfo[IOP_UI_tableSort];
		if ((IOP_UI_tableSortOrder == "desc" and value >= indexedValue) or (IOP_UI_tableSortOrder == "asc" and value <= indexedValue)) then
			return true
		end
	end
	return false
end

function IOP_UI_InsertPlayerInTableIndex(playerName)
	local rowInserted = false;
	for rowID, indexedPlayerName in pairs(IOP_UI_tableIndex) do
		local insertRow = false;
		if (IOP_UI_tableSort == "playerName") then
			if (IOP_UI_SortPlayerName(playerName, indexedPlayerName)) then
				insertRow = true;
			end
		elseif (IOP_UI_tableSort == "playerClass") then
			if (IOP_UI_SortField("class", playerName, indexedPlayerName))then
				insertRow = true;
			end
		elseif (IOP_UI_tableSort == "playerGuild") then
			if (IOP_UI_SortField("guild", playerName, indexedPlayerName))then
				insertRow = true;
			end
		elseif (IOP_UI_tableSort == "playerLevel") then
			if (IOP_UI_SortField("level", playerName, indexedPlayerName))then
				insertRow = true;
			end
		elseif (IOP_UI_tableSort == "recordedTime") then
			if (IOP_UI_SortField("date", playerName, indexedPlayerName))then
				insertRow = true;
			end
		else
			if (IOP_UI_SortByField(playerName, indexedPlayerName)) then
				insertRow = true;
			end
		end
		if (insertRow) then
			table.insert(IOP_UI_tableIndex, rowID, playerName);
			rowInserted = true;
			break;
		end
	end
	if (not rowInserted) then
		table.insert(IOP_UI_tableIndex, playerName);
	end
end

function IOP_UI_SetTableTitle(averageScore,guildAverageTopLvl)
	local tableTitle = getglobal("InventoryOnParUIFrameTableTitle");
	local realmName = GetRealmName();
	if(averageScore == nil or guildAverageTopLvl == nil) then
		-- catch all incase of nils
		tableTitle:SetText("Inventory On Par Scores for "..realmName);
	else
		if(averageScore == 0 and guildAverageTopLvl == 0) then
			-- showing all details no averages
			tableTitle:SetText("Inventory On Par Scores for "..realmName);
		elseif (guildAverageTopLvl == -999) then
			-- showing party only 
			local avScoreColour = IOP_UI_getTotalScoreColour(averageScore);
			tableTitle:SetText("Inventory On Par Scores for "..realmName.."  -  Av.Group Score : |c"..avScoreColour.name..format("%.2f", averageScore));
		else
			-- showing guild only
			local avScoreColour = IOP_UI_getTotalScoreColour(averageScore);
			if (guildAverageTopLvl == 0) then
				tableTitle:SetText("Inventory On Par Scores for "..realmName.."  -  Av.Guild Score : |c"..avScoreColour.name..format("%.2f", averageScore));
			else
				local avTopLvlScoreColour = IOP_UI_getTotalScoreColour(guildAverageTopLvl);
				tableTitle:SetText("IOP Scores for "..realmName.."  -  Av.Guild Score : |c"..avScoreColour.name..format("%.2f", averageScore).."|cffffffff  lvl"..IOP_MAX_LEVEL.."s : |c"..avTopLvlScoreColour.name..format("%.2f", guildAverageTopLvl));
			end
		end
	end
	if(IOP.Options.pvpValues == 1) then
		getglobal("InventoryOnParUIFrameTableHeaderIOPScoreText"):SetText("PvP Score");
	else
		getglobal("InventoryOnParUIFrameTableHeaderIOPScoreText"):SetText("Par Score");
	end
end

function IOP_UI_SetTableStatus(status)
	local tableStatus = getglobal("InventoryOnParUIFrameTableStatus");
	tableStatus:SetText(status);
	tableStatus:SetWidth(tableStatus:GetStringWidth());
end

function IOP_UI_ClearTable()
	local lineNumber = 0;
	while (lineNumber < IOP_UI_TABLE_ROWS) do
		lineNumber = lineNumber + 1;
		IOP_UI_ClearRow(lineNumber);
	end
	FauxScrollFrame_Update(InventoryOnParUIFrameTableScrollFrame, 0, IOP_UI_TABLE_ROWS, IOP_UI_TABLE_ROW_PIXEL_HEIGHT);
end

function IOP_UI_ClearRow(lineNumber)
	getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber):Hide();
	getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerName"):SetText("");
	getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerLevel"):SetText("");
	getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerClass"):SetText("");
	getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerGuild"):SetText("");
	getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."LastSeen"):SetText("");
	getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."IOPScore"):SetText("");
end

function IOP_UI_UpdateTable()
	local numberOfPlayers = 0;
	local lineOffset = FauxScrollFrame_GetOffset(InventoryOnParUIFrameTableScrollFrame);
	local averageScore = 0;
	
	IOPDisplayTable = {};
	local playerGuild = GetGuildInfo("player");
	if (playerGuild == nil) then 
		playerGuild = "-No Guild Recorded-";
	end
	if (IOP.Options.ownGuildOnly == 1) then 
		IOPDisplayTable = IOP_UI_FilterGuildOnly(playerGuild);
		averageScore, guildAverageTopLvl = IOP_UI_GetGuildAverageScore(IOPDisplayTable);
		IOP_UI_SetTableTitle(averageScore,guildAverageTopLvl);
	else
		IOPDisplayTable = IOP_UI_tableIndex;
	end
	if (IOP.Options.ownPartyOnly == 1) then 
		IOPDisplayTable = IOP_UI_FilterPartyOnly(IOPDisplayTable);
		averageScore = IOP_UI_GetAverageGroupScore(IOPDisplayTable);
		IOP_UI_SetTableTitle(averageScore,-999);
	end
	local lineNumber = 0;
	while ((lineNumber < IOP_UI_TABLE_ROWS) and (lineNumber + lineOffset < table.getn(IOPDisplayTable))) do
		lineNumber = lineNumber + 1;
		
		local playerName = IOPDisplayTable[lineNumber + lineOffset];
		local playerInfo = IOP_GetPlayerRecord(playerName);
		
		if (playerInfo ~= nil) then
			if (playerInfo.friendly == nil) then
				playerInfo.friendly = true;
			end
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber):Show();
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerName"):SetText(playerName);
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerLevel"):SetText(playerInfo.playerLevel);
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerClass"):SetText(playerInfo.class);
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerGuild"):SetText(playerInfo.guild);
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."LastSeen"):SetText(date(IOP.Options.dateFormat, playerInfo.recordedTime));
			local scoreTextColour = nil;			
			if(IOP.Options.pvpValues == 1) then
				getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."IOPScore"):SetText(format("%.2f", playerInfo.pvpScore));
				scoreTextColour = IOP_UI_getTotalScoreColour(playerInfo.pvpScore);
			else
				getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."IOPScore"):SetText(format("%.2f", playerInfo.IOP_Score));
				scoreTextColour = IOP_UI_getTotalScoreColour(playerInfo.IOP_Score);
			end
			local playerTextColour = nil;
			if (playerName == UnitName("player")) then
				playerTextColour = IOP_UI_TEXT_COLOUR.PLAYER_NAME.CURRENT;
			elseif (playerInfo.friendly == false) then
				playerTextColour = IOP_UI_TEXT_COLOUR.PLAYER_NAME.HOSTILE;
			else
				playerTextColour = IOP_UI_TEXT_COLOUR.PLAYER_NAME.OTHER;
			end
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerName"):SetTextColor(playerTextColour.r, playerTextColour.g, playerTextColour.b);
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerLevel"):SetTextColor(playerTextColour.r, playerTextColour.g, playerTextColour.b);
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."PlayerClass"):SetTextColor(playerTextColour.r, playerTextColour.g, playerTextColour.b);
			getglobal("InventoryOnParUIFrameTableRowButton"..lineNumber.."IOPScore"):SetTextColor(scoreTextColour.r, scoreTextColour.g, scoreTextColour.b);
		end
	end
	
	for lineNumber = lineNumber + 1, IOP_UI_TABLE_ROWS, 1 do
		IOP_UI_ClearRow(lineNumber);
	end
end

function IOP_UI_getTotalScoreColour(score)
	local scoreTextColour = colourWhite;
	if (score < 0) then
		scoreTextColour = IOP_UI_TEXT_COLOUR.SCORE.BELOW_PAR; 
	elseif (score < 100) then
		scoreTextColour = IOP_UI_TEXT_COLOUR.SCORE.ON_PAR; -- score 0 to 99
	elseif (score < 250) then
		scoreTextColour = IOP_UI_TEXT_COLOUR.SCORE.ABOVE_PAR; -- score 100 - 249
	elseif (score < 500) then
		scoreTextColour = IOP_UI_TEXT_COLOUR.SCORE.WELL_ABOVE_PAR; -- score 250 - 499
	elseif (score < 750) then
		scoreTextColour = IOP_UI_TEXT_COLOUR.SCORE.SIGNIFICANTLY_ABOVE_PAR; -- score 500 - 749
	elseif (score <1000) then
		scoreTextColour = IOP_UI_TEXT_COLOUR.SCORE.WOW; -- score 750+
	else
		scoreTextColour = IOP_UI_TEXT_COLOUR.SCORE.OMG; -- score 1000+
	end
	return scoreTextColour;
end

function IOP_UI_FilterPartyOnly(currentTable)
	local displayTable = {};
	local linenumber = 0;
	local records = 0;
	local raidMembers = GetNumRaidMembers();
	local partyMembers = GetNumPartyMembers();
	for temp in pairs(currentTable) do
		linenumber = linenumber + 1;
		local playerName = currentTable[linenumber];
		local playerInfo = IOP_GetPlayerRecord(playerName);
		if (raidMembers ~= 0) then
			-- in a raid so limit to raid members 
			for raidIndex = 1, raidMembers, 1 do
				if (playerName == GetRaidRosterInfo(raidIndex)) then
					records = records + 1;
					displayTable[records] = {};
					displayTable[records] = playerName;
				end
			end
		else
			if(partyMembers ~= 0) then
				if(UnitInParty(playerName)) then
					records = records + 1;
					displayTable[records] = {};
					displayTable[records] = playerName;
				end
			else
				if(playerName == UnitName("player")) then
					records = records + 1;
					displayTable[records] = {};
					displayTable[records] = playerName;
				end
			end
		end
	end
	return displayTable;
end

function IOP_UI_GetAverageGroupScore(scoreTable)
	local records = 0;
	local recordsTopLvl = 0;
	local totalIOP = 0;
	local totalIOP_TopLvl = 0;
	local groupAverage = 0;
	for temp in pairs(scoreTable) do
		records = records + 1;
		local playerName = scoreTable[records];
		local playerInfo = IOP_GetPlayerRecord(playerName);
		if(IOP.Options.pvpValues == 1) then
			totalIOP = totalIOP + playerInfo.pvpScore;
		else
			totalIOP = totalIOP + playerInfo.IOP_Score;
		end
	end
	if	(records > 0) then
		groupAverage = totalIOP / records;
	else
		groupAverage = 0;
	end
	return groupAverage;
end

function IOP_UI_FilterGuildOnly(playerGuild)
	local displayTable = {};
	local linenumber = 0;
	local records = 0;
	for temp in pairs(IOP_UI_tableIndex) do
		linenumber = linenumber + 1;
		local playerName = IOP_UI_tableIndex[linenumber];
		local playerInfo = IOP_GetPlayerRecord(playerName);
		if (playerInfo.guild == playerGuild) then
			records = records + 1;
			displayTable[records] = {};
			displayTable[records] = playerName;
		end
	end
	return displayTable;
end

function IOP_UI_GetGuildAverageScore(scoreTable)
	local records = 0;
	local recordsTopLvl = 0;
	local totalIOP = 0;
	local totalIOP_TopLvl = 0;
	local guildAverage = 0;
	local guildAverageTopLvl = 0;
	for temp in pairs(scoreTable) do
		records = records + 1;
		local playerName = scoreTable[records];
		local playerInfo = IOP_GetPlayerRecord(playerName);
		if(IOP.Options.pvpValues == 1) then
			totalIOP = totalIOP + playerInfo.pvpScore;
		else
			totalIOP = totalIOP + playerInfo.IOP_Score;
		end
		if (playerInfo.playerLevel == IOP_MAX_LEVEL) then
			recordsTopLvl = recordsTopLvl + 1;
			if(IOP.Options.pvpValues == 1) then
				totalIOP_TopLvl = totalIOP_TopLvl + playerInfo.pvpScore;
			else
				totalIOP_TopLvl = totalIOP_TopLvl + playerInfo.IOP_Score;
			end
		end
	end
	if	(records > 0) then
		guildAverage = totalIOP / records;
	else
		guildAverage = 0;
	end
	if	(recordsTopLvl > 0) then
		guildAverageTopLvl = totalIOP_TopLvl / recordsTopLvl;
	else
		guildAverageTopLvl = 0;
	end
	return guildAverage, guildAverageTopLvl;
end

IOP_UI_GuildOnly = {};

function IOP_UI_GuildOnly.OnShow()
	InventoryOnParUICheckButtonGuildOnlyLabel:SetText("Guild");
	local playerGuild = GetGuildInfo("player");
	if (playerGuild == nil) then
		IOP.Options.ownGuildOnly = 0;
		InventoryOnParUICheckButtonGuildOnly:SetChecked(0);
	end
	if(IOP.Options.ownGuildOnly == 1) then
		InventoryOnParUICheckButtonGuildOnly:SetChecked(1);
		IOP_UI_tableSort = "IOP_Score";
		IOP_UI_tableSortOrder = "desc";
	end
end

function IOP_UI_GuildOnly.OnClick()
	if (InventoryOnParUICheckButtonGuildOnly:GetChecked()) then
		IOP.Options.ownGuildOnly = 1;
		IOP_UI_tableSort = "IOP_Score";
		IOP_UI_tableSortOrder = "desc";
		-- Turn off Party filter since Guild selected
		InventoryOnParUICheckButtonPartyOnly:SetChecked(0); 
		IOP.Options.ownPartyOnly = 0;
	else
		IOP.Options.ownGuildOnly = 0;
		IOP_UI_tableSort = "playerName";
		IOP_UI_tableSortOrder = "asc";
		IOP_UI_SetTableTitle(0,0);
	end
	IOP_UI_BuildTableIndex();
end

IOP_UI_PartyOnly = {};

function IOP_UI_PartyOnly.OnShow()
	InventoryOnParUICheckButtonPartyOnlyLabel:SetText("Party/Raid");
	if(IOP.Options.ownPartyOnly == 1) then
		InventoryOnParUICheckButtonPartyOnly:SetChecked(1);
		IOP_UI_tableSort = "IOP_Score";
		IOP_UI_tableSortOrder = "desc";
	end
end

function IOP_UI_PartyOnly.OnClick()
	if (InventoryOnParUICheckButtonPartyOnly:GetChecked()) then
		IOP.Options.ownPartyOnly = 1;
		IOP_UI_tableSort = "IOP_Score";
		IOP_UI_tableSortOrder = "desc";
		 -- Turn off Guild Filter since Party selected
		InventoryOnParUICheckButtonGuildOnly:SetChecked(0);
		IOP.Options.ownGuildOnly = 0;
	else
		IOP.Options.ownPartyOnly = 0;
		IOP_UI_tableSort = "playerName";
		IOP_UI_tableSortOrder = "asc";
		IOP_UI_SetTableTitle(0,0);
	end
	IOP_UI_BuildTableIndex();
end

function IOP_UI_GetLastSeenTextColor(aTime)
	local textColor = nil;
	local currentTime = time();
	
	textColor = IOP_UI_TEXT_COLOUR.LAST_SEEN.OVER_24HRS;
	if (atime) then 
		if (currentTime-atime <= 60*60*24) then
			textColor = IOP_UI_TEXT_COLOUR.LAST_SEEN.WITHIN_24HRS;
		end
	end
	
	return textColor;
end

function IOP_UI_SetWidth(width, frame)
	if ( not frame ) then
		frame = this;
	end
	frame:SetWidth(width);
	getglobal(frame:GetName().."Middle"):SetWidth(width - 9);
end
