local _G = getfenv(0);

IOP_PaperDollData = {
	Tooltip = CreateFrame("GameTooltip","IOPDollTip",nil,"GameTooltipTemplate"),

	Slots = {
		"HeadSlot",
		"NeckSlot",
		"ShoulderSlot",
		"BackSlot",
		"ChestSlot",
		"ShirtSlot",
		"TabardSlot",
		"WristSlot",
		"HandsSlot",
		"WaistSlot",
		"LegsSlot",
		"FeetSlot",
		"Finger0Slot",
		"Finger1Slot",
		"Trinket0Slot",
		"Trinket1Slot",
		"MainHandSlot",
		"SecondaryHandSlot",
		"RangedSlot",
	},
};

IOP_PaperDollData.Tooltip:SetOwner(UIParent,"ANCHOR_NONE");

function IOP_ItemSlots_OnLoad(self)
	local buttonName = self:GetName();
	local slotId;
	self.slotName = buttonName:sub(25);
	slotId, self.backgroundTextureName = GetInventorySlotInfo(self.slotName);
	_G[buttonName.."IconTexture"]:SetTexture(self.backgroundTextureName);
	self:SetID(slotId);
end

function IOP_ItemSlots_OnEnter(self)
	GameTooltip:SetOwner(self,"ANCHOR_RIGHT");
	if (self.link) then
		if (GetItemInfo(self.link)) then
			GameTooltip:SetHyperlink(self.link);  -- if item slot button has link show it in tooltip 
		else
			GameTooltip:SetText("|c"..colourRed.."Potentially unsafe link|c"..colourYellow.." - you may shift right click to view|nWARNING this may disconnect you from the server!");
		end
	else
		GameTooltip:SetText(_G[self.slotName:upper()]); -- otherwise just show slot name
	end
end

function IOP_ItemSlots_OnLeave(self)
	ResetCursor();
	GameTooltip:Hide();
end

function IOP_ItemSlots_OnClick(self,button)
	if( button == "LeftButton" ) then
		if( IsShiftKeyDown() ) then
			if( ChatFrameEditBox:IsVisible() ) then
				ChatFrameEditBox:Insert(self.link);
			else
				ChatEdit_InsertLink(self.link);
			end
		elseif( IsControlKeyDown() ) then
			DressUpItemLink(self.link);
		end
	elseif ( button == "RightButton" ) then
		if( IsShiftKeyDown() ) then
			GameTooltip:SetHyperlink(self.link);
		end
	end
end

function IOP_ShowPlayerDoll()
	if(not InCombatLockdown()) then
		IOP_RequestTargetScore("player",1); -- force update of player data only if out of combat
		local playerName = UnitName("player");
		local playerInfo = IOP_GetPlayerRecord(playerName);
		IOP_ShowDoll(playerInfo);
	end
end

function IOP_ShowDoll(playerInfo) 
	if (playerInfo ~= nil) then
		local button,textfield,levelColour,textstring;
		IOP_PaperDollFrameTitle:SetText(playerInfo.playerName);
		IOP_PaperDollFrameDetails:SetText("Level "..playerInfo.playerLevel.." "..playerInfo.class);
		IOP_PaperDollFrameGuild:SetText(playerInfo.guild);
		SetPortraitTexture(IOP_PaperDollFramePortrait, "player");
		for _, slotName in ipairs(IOP_PaperDollData.Slots) do
			button = _G["IOP_PaperDoll_ItemButton"..slotName];
			textfield = _G["IOP_PaperDoll_ItemScore"..slotName];
			textstring = "";
			levelColour = colourNone;
			if(playerInfo.itemList and playerInfo.itemList[slotName]) then
				button.link = playerInfo.itemList[slotName].slotLink;
				levelColour = playerInfo.itemList[slotName].levelColour;
				local itemRarity = playerInfo.itemList[slotName].itemRarity;
				if(ITEM_RARITY[itemRarity].colour) then
					textstring=" |c"..ITEM_RARITY[itemRarity].colour;
				end
				textstring = textstring..format("%.2f", playerInfo.itemList[slotName].itemScore).."";
			else
				button.link = nil;
				textstring = "|c"..colourWhite.." No data";
			end
			textfield:SetText(textstring);
			IOP_ItemSlots_UpdateItemSlot(button,levelColour);
			button:Show();
		end
		local displayScore= 0;
		if(IOP.Options.pvpValues == 1) then
			displayScore = playerInfo.pvpScore;
		else
			displayScore = playerInfo.IOP_Score;
		end
		local playerScoreColour = IOP_UI_getTotalScoreColour(displayScore);
		IOP_PaperDoll_ScoreText:SetText("Kit Score");
		IOP_PaperDoll_TotalScore:SetText("|c"..playerScoreColour.name..format("%.2f", displayScore));
		ShowUIPanel(InventoryOnParUIFrame);
		ShowUIPanel(IOP_PaperDollFrame);
	end
end

function IOP_ItemSlots_UpdateItemSlot(button,levelColour)
	local border = _G[button:GetName().."BorderTexture"];
	if (button.link) then
		-- Only scan the item if it's in the users local cache, to avoid DC's
		if (GetItemInfo(button.link)) then
			local _, _, _, _, _, _, _, _, _, itemTexture = GetItemInfo(button.link);
			-- Set Texture
			SetItemButtonTexture(button,itemTexture or button.backgroundTextureName);
			-- Set IOP Border Color
			if (levelColour == colourBlue) then
				border:SetVertexColor(0.125,0.8125,1,1);
			elseif(levelColour == colourGrey) then
				border:SetVertexColor(0.9,0.9,0.9,1);
			elseif(levelColour == colourWhite) then
				border:SetVertexColor(1,1,1,1);
			elseif(levelColour == colourYellow) then
				border:SetVertexColor(1,1,0,1);
			elseif(levelColour == colourRed) then
				border:SetVertexColor(1,0,0,1);
			elseif(levelColour == colourGreen) then
				border:SetVertexColor(0.117,1,0,1);
			elseif(levelColour == colourDarkBlue) then
				border:SetVertexColor(0,0.4375,0.863,1);
			elseif(levelColour == colourPurple) then
				border:SetVertexColor(0.637,0.207,0.93,1);
			elseif(levelColour == colourOrange) then
				border:SetVertexColor(1,0.5,0,1);
			elseif(levelColour == colourGold) then
				border:SetVertexColor(0.898,0.797,0.5,1);
			else
				border:SetVertexColor(0.5,0.5,0.5,1);
			end
			border:Show();
		else
			-- Cannot find link in local cache so potentially unsafe therefore border blue
			SetItemButtonTexture(button,button.backgroundTextureName);
			border:SetVertexColor(0.125,0.8125,1,1);
			border:Show();
		end
	else
		SetItemButtonTexture(button,button.backgroundTextureName);
		border:Hide();
	end
end
