local L = AceLibrary("AceLocale-2.2"):new("Innervator")

-- setup options
Innervator.options = { 
	type='group',
	args = {
		checkcombat = {
			type = 'toggle',
			name = L["opt_name_checkcombat"],
			desc = L["opt_desc_checkcombat"],
			get = "IsCheckCombat",
			set = "ToggleCheckCombat",
			order = 7,
		},
		flashframe = {
			type = 'toggle',
			name = L["opt_name_flashframe"],
			desc = L["opt_desc_flashframe"],
			get = "IsFlashFrame",
			set = "ToggleFlashFrame",
			order = 6,
		},
		audio = {
			type = 'toggle',
			name = L["opt_name_audio"],
			desc = L["opt_desc_audio"],
			get = "IsAudio",
			set = "ToggleAudio",
			order = 8,
		},
		weaponswap = {
			type = 'toggle',
			name = L["opt_name_weaponswap"],
			desc = L["opt_desc_weaponswap"],
			disabled = function () return Innervator.isEvocation end,
			get = "IsWeaponSwap",
			set = "ToggleWeaponSwap",
			order = 9,
		},
		infosound = {
			type = 'group',
			name = L["opt_name_infosound"],
			desc = L["opt_desc_infosound"],
			disabled = function() return not Innervator.db.profile.isAudio end,
			args = {
					
			},
			order = 11,
		},
		mana_anticipation_static = {
			type = 'range',
			name = L["opt_name_mana_anticipation_static"],
			desc = L["opt_desc_mana_anticipation_static"],
			min = 0,
			max = 5000,
			step = 100,
			get = function() return Innervator.db.profile.mana_anticipation_static end,
			set = function(ma) Innervator.db.profile.mana_anticipation_static = ma end,
			order = 2,
		},
		spirit_anticipation_static = {
			type = 'range',
			name = L["opt_name_spirit_anticipation_static"],
			desc = L["opt_desc_spirit_anticipation_static"],
			min = 0,
			max = 250,
			step = 1,
			get = function() return Innervator.db.profile.spirit_anticipation_static end,
			set = function(ma) Innervator.db.profile.spirit_anticipation_static = ma end,
			order = 4,
		},
		head1 = {
				order = 1,
				type = "header",
		},
		head2 = {
				order = 3,
				type = "header",
		},
		head3 = {
				order = 5,
				type = "header",
		},
		head4 = {
				order = 10,
				type = "header",
		},
	},
}

--setup FuBar-2.0
Innervator.hasIcon                = true
Innervator.defaultMinimapPosition = 340
Innervator.cannotDetachTooltip    = true
Innervator.independentProfile     = true
Innervator.defaultPosition        = "LEFT"
Innervator.hideWithoutStandby     = true
Innervator.hasNoColor             = true
Innervator.hasIcon                = "Interface\\Icons\\Spell_Nature_Lightning"

--Get SinkLib OutPut options
Innervator.options.args.output       = AceLibrary("Sink-1.0"):GetAceOptionsDataTable(Innervator).output
Innervator.options.args.output.name  = L["opt_name_output_sink"]
Innervator.options.args.output.order = 11

