local MINOR_VERSION = tonumber(("$Revision: 76094 $"):match("%d+"))

local L = AceLibrary("AceLocale-2.2"):new("Innervator")
local tablet = AceLibrary("Tablet-2.0")
Innervator = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0", "Sink-1.0")

Innervator.TOCversion = GetAddOnMetadata("Innervator", "Version")
Innervator.version = Innervator.TOCversion.." - Build "..MINOR_VERSION
Innervator.revision = MINOR_VERSION


function Innervator:OnInitialize()
	--register defaults
	self:RegisterDB("InnervatorDB", "InnervatorDBPC")
	self:RegisterDefaults("profile", {
				
		--options
		isAudio                    = true,
		isCheckCombat              = true,
		isFlashFrame               = true,
		isWeaponSwap               = true,
		alertsound                 = "Sound\\Spells\\PVPFlagTaken.wav",
		spirit_anticipation_static = 0,
		mana_anticipation_static   = 1000,
		
	} )
	
	--is this addon for you?
	_, self.playerclass	= UnitClass("player")
	if (self.playerclass == "DRUID") then
		self.isDruid = true
	else
		self.isDruid = false
	end
	
	--check for Evocation2
	if (IsAddOnLoaded("Evocation2")) then 
		self.isEvocation=true
		DEFAULT_CHAT_FRAME:AddMessage("Innervator: "..L["Evocation_Message"])
	end
		
	--register slashcommand
	self:RegisterChatCommand(L["Slash-Commands"], self.options)
	
	--set additional variables
	self.opt                      = self.db.profile
	self.OnMenuRequest            = self.options
		
	self.alertflag                = false
	self.isInnervate              = false
	self.isInnervateTicking       = false
	
	self.mana_innervate_begin     = 0
	self.mana_innervate_end       = 0
	
	self.FlashingFrame            = FlashFrameStandardTexture1
		
	-- set to true for debugging messages
	self.isDebug                  = false
	
	-- Add Sounds to Options  (taken from beql)
	self.sounds = {}
	self.sounds["FlagCaptured1"]   = "Sound\\Interface\\PVPFlagCapturedmono.wav"
	self.sounds["FlagCaptured2"]   = "Sound\\Interface\\PVPFlagCapturedHordemono.wav"
	self.sounds["LevelUp"]         = "Sound\\Interface\\LevelUp.wav"
	self.sounds["Cow"]             = "Sound\\Creature\\Cow\\CowDeath.wav"
	self.sounds["SimonGame"]       = "Sound\\Spells\\SimonGame_Visual_GameStart.wav"
	self.sounds["Reindeer"]        = "Sound\\Spells\\SummonReindeer.wav"
	self.sounds["FlagTaken"]       = "Sound\\Spells\\PVPFlagTaken.wav"

	local i = 0
	for k, v in pairs (self.sounds) do 
		i = i +1
		Innervator.options.args.infosound.args[i] = {
			type = 'toggle',
			name = k,
			desc = k,
			get = function() if Innervator.db.profile.alertsound == v then return true else return false end end,
			set = function(newval) if newval then Innervator.db.profile.alertsound = v end PlaySoundFile(v) end,
		}
	end
end


function Innervator:OnProfileEnable()
	self.opt = self.db.profile
end


function Innervator:OnEnable()
	self:RegisterEvent("UNIT_MANA")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_AURAS_CHANGED")
end


function Innervator:OnTooltipUpdate()
	tablet:SetHint(L["Tooltip"])
	Innervator:getStats()
		
	local cat = tablet:AddCategory(
       'text', L["Statistics"],
       'columns', 2,
       'child_textR', 1,
       'child_textG', 1,
       'child_textB', 0,
       'child_textR2', 1,
       'child_textG2', 1,
       'child_textB2', 1
    )
	cat:AddLine(
       'text', L["Manareg_Spiritbased_Tooltip"],
       'text2', floor(self.mana_regen_spirit * 5)
    )
    cat:AddLine(
       'text', L["Manareg_Nonspirit_Tooltip"],
       'text2', floor(self.mana_regen_nonspirit * 5)
    )
    cat:AddLine(
       'text', " "
    )
    cat:AddLine(
       'text', L["Estimated_Innervate_Tooltip"],
       'text2', floor(self.mana_innervate)
    )
    cat:AddLine(
       'text', L["Estimated_Innervate_wCasting_Tooltip"],
       'text2', floor(self.mana_innervate_wcasting)
    )
    cat:AddLine(
       'text', " "
    )
    cat:AddLine(
       'text', L["Mana_Restore_Tooltip"],
       'text2', self.mana_diff
    )
end


function Innervator:PLAYER_REGEN_ENABLED()
	Innervator:dbg("PLAYER_REGEN_ENABLED")
	
	self.isCombat  = false
	self.alertflag = false
end


function Innervator:PLAYER_REGEN_DISABLED()
	Innervator:dbg("PLAYER_REGEN_DISABLED")

	self.isCombat  = true
	self.alertflag = false
end


function Innervator:UNIT_MANA()
	Innervator:getStats()
	
	if not (self.db.profile.isCheckCombat) then
		self.isCombat = true
	end
	
	if (self.mana_threshold < self.mana_current) and not (self.isInnervateTicking) then
		self.alertflag = false
	end
	
	if (self.mana_threshold > self.mana_current) and (self.isDruid) and (self.isCombat) and not (self.alertflag) and not (UnitIsDead("player")) then
		local start, duration = GetSpellCooldown(L["Innervate"])
		
		if (start == 0 and duration == 0) then
			Innervator:giveAlert()
		end
	end
end

function Innervator:PLAYER_AURAS_CHANGED()
	Innervator:dbg("PLAYER_AURAS_CHANGED")
	
	self.isInnervate = false

    local i = 1;
    while (UnitBuff("player",i) ~= nil) do
      if (UnitBuff("player",i) == L["Innervate"]) then		  
        self.isInnervate = true
      end
      i = i +1;
    end;
		
    if (self.isInnervate) and not (self.isInnervateTicking) then
      self.isInnervateTicking   = true
	  self.alertflag            = true
	  self.mana_innervate_begin = UnitMana("player")
	  
	  --Weapon swap (code taken from evocation2 by Neanor, [EU] Theradras)
	  if not self.isEvocation and self.db.profile.isWeaponSwap then
		
		-- save current items so we can restore them
		Innervator.NormalGear = Innervator:GetEquippedItems();

		-- find the best spirit items in bags
		Innervator.SpiritGear = Innervator:FindSpiritGear();
		table.foreach(Innervator.SpiritGear, function(i,v)
			Innervator:FindAndUseBagItem(v);
		end);
	  end
	end
	
    if not (self.isInnervate) and (self.isInnervateTicking) then
      self.isInnervateTicking   = false
	  self.alertflag            = false
	  self.mana_innervate_end   = UnitMana("player")
	  
	  --Weapon swapback
	  if not self.isEvocation and self.db.profile.isWeaponSwap then
		table.foreach(Innervator.NormalGear, function(i,v)
			Innervator:FindAndUseBagItem(v);
		end);
	  end
	end
end


function Innervator:getStats()
	self.mana_current            = UnitMana("player")
	self.mana_max                = UnitManaMax("player")
	self.mana_regen_spirit       = floor(GetUnitManaRegenRateFromSpirit("player"))
	self.mana_regen_all          = floor(GetManaRegen("player"))
	self.mana_regen_nonspirit    = self.mana_regen_all - self.mana_regen_spirit
	self.mana_nonspirit          = self.mana_regen_nonspirit * 20
	self.mana_spiritboost        = 0
	self.mana_diff               = self.mana_innervate_end - self.mana_innervate_begin
			
	if (self.db.profile.spirit_anticipation_static > 0) then
		self.mana_spiritboost    = floor(self.db.profile.spirit_anticipation_static / 4.5) * 10
	end
		
	self.mana_innervate          = (self.mana_regen_spirit * 100) + self.mana_nonspirit + self.mana_spiritboost
	
	self.mana_innervate_wcasting = self.mana_innervate - self.db.profile.mana_anticipation_static 
	
	if (self.mana_current < self.db.profile.mana_anticipation_static) then
		self.mana_threshold = self.db.profile.mana_anticipation_static
	else
		self.mana_threshold = self.mana_max - self.mana_innervate + self.db.profile.mana_anticipation_static
	end
end


function Innervator:giveAlert()
	self.alertflag = true
	
	--SinkLib
	Innervator:Pour(L["Remind_Message"],1,.0,.0)
	
	-- Audio
	if (self.db.profile.isAudio) then
		PlaySound("GAMEHIGHLIGHTFRIENDLYUNIT")
		PlaySoundFile(Innervator.db.profile.alertsound)
	end
	
	-- Flashing screen edges
	if (self.db.profile.isFlashFrame) then
			Innervator.FlashingFrame:Hide();
			UIFrameFlash(Innervator.FlashingFrame, 0.25, 0.75, 2.2, false, 0, 0.1)
	end
	
	Innervator:dbg(L["Remind_Message"])
end


function Innervator:dbg(msg)
	if ( self.isDebug ) then
		DEFAULT_CHAT_FRAME:AddMessage("Innervator: "..msg)
	end
end

function Innervator:FindAndUseBagItem(link)
	-- search all bags
	for bag=0,4 do
		-- check each slot
		for slot=1,GetContainerNumSlots(bag) do
			itemLink = GetContainerItemLink(bag,slot);
			if (itemLink and itemLink == link) then 
				PickupContainerItem(bag,slot);
				AutoEquipCursorItem();
				break;
			end
		end
	end
end


function Innervator:GetEquippedItems()
	-- get current equipped items
	result = {};
  
	mainhandLink, mainhandType = Innervator:GetSlotItemLinkAndType("MainHandSlot");
	if mainhandType == "INVTYPE_WEAPON" or mainhandType == "INVTYPE_WEAPONMAINHAND" or mainhandType == "INVTYPE_2HWEAPON" then
		table.insert(result, mainhandLink);
	end

	offhandLink, offhandType = Innervator:GetSlotItemLinkAndType("SecondaryHandSlot");
	if offhandType == "INVTYPE_HOLDABLE" then
		table.insert(result, offhandLink);
	end

	wandLink, wandType = Innervator:GetSlotItemLinkAndType("RangedSlot");
	if wandType == "INVTYPE_RANGEDRIGHT" then
		table.insert(result, wandLink);
	end
	return result;
end


function Innervator:FindSpiritGear()
	local onehand = {"", 0, 0, 0};
	local twohand = {"", 0, 0, 0};
	local offhand = {"", 0, 0, 0};
	local wand = {"", 0, 0, 0};

	-- Check all bags
	for bag=0,4 do
		-- Check each item in that bag
		for slot=1,GetContainerNumSlots(bag) do
			local itemLink = GetContainerItemLink(bag,slot);
			-- If this is an item, get amount of Spirit
			if (itemLink) then	
				local itemSpirit = Innervator:GetItemSpirit(bag,slot)
				-- If item has spirit ...
				if (itemSpirit > 0) then
					-- get all information about the item
					local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType , itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(itemLink);		  
					-- check if this is the best onehand 
					if (itemEquipLoc == "INVTYPE_WEAPON" or itemType == "INVTYPE_WEAPONMAINHAND") then
						if (itemSpirit > onehand[2]) then
							onehand = {itemLink, itemSpirit, bag, slot};
						end
					end
					-- check if this is the best twohand
					if (itemEquipLoc == "INVTYPE_2HWEAPON") then
						if (itemSpirit > twohand[2]) then
							twohand = {itemLink, itemSpirit, bag, slot};
						end
					end
					-- check if this is the best offhand
					if (itemEquipLoc == "INVTYPE_HOLDABLE") then
						if (itemSpirit > offhand[2]) then
							offhand = {itemLink, itemSpirit, bag, slot};
						end
					end
					-- check if this is the best wand
					if (itemEquipLoc == "INVTYPE_RANGEDRIGHT") then
						if (itemSpirit > wand[2]) then
							wand = {itemLink, itemSpirit, bag, slot};
						end
					end
				end
			end
		end 
	end
  
	-- find the best combo
	result = {}
	-- check weather to use onehand and offhand or twohand  
	if (onehand[2] + offhand[2] > twohand[2]) then
		table.insert(result, onehand[1]);
		table.insert(result, offhand[1]);
	elseif (twohand[2] > 0) then
		table.insert(result, twohand[1]);
	end
	-- check if wand makes sense
	if (wand[2] > 0) then
		table.insert(result, wand[1]);
	end
	
	-- we're done
	return result;
end


function Innervator:GetItemSpirit(bag, slot)
	InnervatorTooltip:SetBagItem(bag, slot);
    local itemSpirit = 0;

	for i=1,InnervatorTooltip:NumLines() do
	   local line = getglobal("InnervatorTooltipTextLeft" .. i):GetText();
		 --_, _, spirit = string.find(line, "(%d+) Spirit");
        _, _, spirit = string.find(line, "(%d+) " .. L["Spirit"]);
		 if spirit then
		   itemSpirit = itemSpirit + tonumber(spirit);
		end
	end	
	
	return itemSpirit;
end


function Innervator:GetSlotItemLinkAndType(slot)
	local slotID, link
  
	-- if slot exists get ID 
	if slot ~= nil then
		slotId = GetInventorySlotInfo(slot);
	end
  
	-- if slotID exists get item link
	if slotId then 
		link = GetInventoryItemLink("player", slotId);
	end
  
	-- if item links exists, get the data
	if link then
		local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType , itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(link);  
		return itemLink, itemEquipLoc;
	else
		return nil, nil;
	end 
end


function Innervator:showspiritgear()
	Innervator.SpiritGear = Innervator:FindSpiritGear();
	 
    -- display gear found
    local s = "Spirit gear found: "
    table.foreach(Innervator.SpiritGear, function(i,v)
		s = s .. v .. " ";
    end);
    ChatFrame1:AddMessage(s, 1.0, 1.0, 1.0);
end


--Options
function Innervator:IsAudio()
    return self.db.profile.isAudio
end

function Innervator:ToggleAudio()
    self.db.profile.isAudio = not self.db.profile.isAudio
end

function Innervator:IsCheckCombat()
    return self.db.profile.isCheckCombat
end

function Innervator:ToggleCheckCombat()
    self.db.profile.isCheckCombat = not self.db.profile.isCheckCombat
end

function Innervator:IsFlashFrame()
    return self.db.profile.isFlashFrame
end

function Innervator:ToggleFlashFrame()
    self.db.profile.isFlashFrame = not self.db.profile.isFlashFrame
end

function Innervator:IsWeaponSwap()
    return self.db.profile.isWeaponSwap
end

function Innervator:ToggleWeaponSwap()
    self.db.profile.isWeaponSwap = not self.db.profile.isWeaponSwap
end
