
-- InfoPanel Work Tip (for plugins to use)
CreateFrame("GameTooltip","IPWorkTip",nil,"GameTooltipTemplate");
IPWorkTip:SetOwner(UIParent,"ANCHOR_NONE");

--------------------------------------------------------------------------------------------------------
--                                          Shared Functions                                          --
--------------------------------------------------------------------------------------------------------

-- Format Copper String
function InfoPanel_FormatCopper(copper)
	local fmt = "|cFFD7844D"..mod(copper,100).."c|r";
	if (copper >= 100) then
		fmt = "|cFFAEAEAE"..floor(mod(copper,10000)/100).."s|r "..fmt;
	end
	if (copper >= 10000) then
		fmt = "|cFFF0E52B"..floor(copper/10000).."g|r "..fmt;
	end
	return fmt;
end

-- Format Time
function InfoPanel_FormatTime(time)
	local sec = mod(time,60);
	local min = mod(floor(time / 60),60);
	local hrs = mod(floor(time / 60 / 60),24);
	local day = floor(time / 60 / 60 / 24);
	return (day == 0 and "" or day.." days, ")..format("%.2d:%.2d:%.2d",hrs,min,sec);
end

function InfoPanel_FormatTime2(time)
	local fmt = format("%.2d sec",floor(mod(time,60)));
	if (time > 60) then
		time = floor(time / 60);
		fmt = format("%.2d min ",mod(time,60))..fmt;
		if (time > 60) then
			time = floor(time / 60);
			fmt = format("%.2d hrs ",mod(time,24))..fmt;
			if (time > 24) then
				time = floor(time / 24);
				fmt = format("%d days ",time)..fmt;
			end
		end
	end
	return fmt;
end