local f = InfoPanel_AddPlugin();
local UPDATE_INTERVAL = 0.8;
local nextUpdate = 0;
local zoneChange, lastZoneChange;

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Zone Info");

	GameTooltip:AddDoubleLine("Zone",GetZoneText(),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Real Zone",GetRealZoneText(),nil,nil,nil,1,1,1);
--	GameTooltip:AddDoubleLine("Sub Zone",GetSubZoneText(),nil,nil,nil,1,1,1); -- Az: Sometimes returns nothing
	GameTooltip:AddDoubleLine("Minimap Zone",GetMinimapZoneText(),nil,nil,nil,1,1,1);

	local pvpType, isFFA, faction = GetZonePVPInfo();
	if (pvpType) then
		GameTooltip:AddLine(" ");
		GameTooltip:AddDoubleLine("Zone PvP Type",pvpType,nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("Zone isFFA",tostring(isFFA),nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("Zone faction",tostring(faction),nil,nil,nil,1,1,1);
	end

	local inInstance, instanceType = IsInInstance();
	GameTooltip:AddLine(" ");
	GameTooltip:AddDoubleLine("In Instance",tostring(inInstance),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Instance Type",tostring(instanceType),nil,nil,nil,1,1,1);

	GameTooltip:AddLine(" ");
	GameTooltip:AddDoubleLine("Zone Timer",InfoPanel_FormatTime2(GetTime() - zoneChange),nil,nil,nil,1,1,1);
	if (lastZoneChange) then
		GameTooltip:AddDoubleLine("Previous Zone Timer",InfoPanel_FormatTime2(zoneChange - lastZoneChange),nil,nil,nil,1,1,1);
	end

	GameTooltip:Show();
end

-- Gather Info
local function OnUpdate(self,elapsed)
	nextUpdate = (nextUpdate - elapsed);
	if (nextUpdate <= 0) then
		if (IsInInstance()) then
			InfoPanel_SetText(f,GetZoneText());
		else
			local x, y = GetPlayerMapPosition("player");
			InfoPanel_SetText(f,"%.1f |cffffff00|||r %.1f",x * 100,y * 100);
		end
		nextUpdate = UPDATE_INTERVAL;
	end
end

-- OnEvent
local function OnEvent(self,event)
	lastZoneChange = zoneChange;
	zoneChange = GetTime();
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\Spell_Nature_Web");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnUpdate",OnUpdate);
f:SetScript("OnClick",function() ToggleWorldMap() end);
f:SetScript("OnEvent",OnEvent);
f:RegisterEvent("PLAYER_ENTERING_WORLD");
--f:RegisterEvent("ZONE_CHANGED_NEW_AREA");