if (UnitLevel("player") == 70) then
	return;
end

local f = InfoPanel_AddPlugin();
local sessionStart = GetTime();
local XP, maxXP, restXP;
local lastXP, lastMaxXP = 0;
local sessionXP, xpGain = 0

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Experience Info");

	GameTooltip:AddDoubleLine("Current XP",XP,nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Maximum XP",maxXP,nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("XP to Next Level",maxXP - XP,nil,nil,nil,1,1,1);
	if (restXP) then
		GameTooltip:AddDoubleLine("Rested XP",restXP,nil,nil,nil,1,1,1);
	end

	if (xpGain) then
		GameTooltip:AddLine(" ");
		GameTooltip:AddDoubleLine("Last XP Gain",xpGain,nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("Equal Gains to Level",format("%.2f",(maxXP - XP) / xpGain),nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("Gain Percentage",format("%.2f%%",xpGain / maxXP * 100),nil,nil,nil,1,1,1);
	end

	if (sessionXP > 0) then
		GameTooltip:AddLine(" ");
		GameTooltip:AddDoubleLine("XP Gain This Session",sessionXP,nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("XP Gain Per Hour",format("%.1f",sessionXP / ((GetTime() - sessionStart) / 3600)),nil,nil,nil,1,1,1);
	end

	GameTooltip:Show();
end

-- Gather Info
local function OnEvent(self,event)
	XP, maxXP, restXP = UnitXP("player"), UnitXPMax("player"), GetXPExhaustion();
	if (event == "PLAYER_XP_UPDATE") and (XP ~= lastXP) then
		xpGain = (XP > lastXP) and (XP - lastXP) or (XP + lastMaxXP - lastXP);
		sessionXP = (sessionXP + xpGain);
	end
	lastXP, lastMaxXP = XP, maxXP;
	InfoPanel_SetText(f,"%.2f%%",XP / maxXP * 100);
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\Spell_Fire_FelFlameRing");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnEvent",OnEvent);
f:RegisterEvent("PLAYER_LOGIN");
f:RegisterEvent("PLAYER_XP_UPDATE");