local f = InfoPanel_AddPlugin();
local UPDATE_INTERVAL = 1;
local nextUpdate = 0;
local startTime, pauseTime;

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Timer");
	GameTooltip:AddLine("<Left Click> to Start / Pause the timer");
	GameTooltip:AddLine("<Right Click> to reset the timer");
	GameTooltip:Show();
end

-- OnUpdate
local function OnUpdate(self,elapsed)
	nextUpdate = (nextUpdate - elapsed);
	if (nextUpdate <= 0) then
		if (pauseTime) then
			InfoPanel_SetText(f,InfoPanel_FormatTime(pauseTime - startTime));
		else
			InfoPanel_SetText(f,InfoPanel_FormatTime(GetTime() - startTime));
		end
		nextUpdate = UPDATE_INTERVAL;
	end
end

-- OnClick
local function OnClick(self,button)
	-- Right Click
	if (button == "RightButton") then
		f.text:SetTextColor(1,1,1);
		InfoPanel_SetText(f,"No Timer");
		f:SetScript("OnUpdate",nil);
		startTime = nil;
		pauseTime = nil;
	-- Left Click
	elseif (ChatFrameEditBox:IsShown()) then
		ChatFrameEditBox:Insert(f.text:GetText());
	else
		nextUpdate = 0;
		if (pauseTime) then
			f.text:SetTextColor(0,1,0);
			startTime = (GetTime() - (pauseTime - startTime));
			pauseTime = nil;
		elseif (startTime) then
			f.text:SetTextColor(1,0.5,0);
			pauseTime = GetTime();
		else
			f.text:SetTextColor(0,1,0);
			f:SetScript("OnUpdate",OnUpdate);
			startTime = GetTime();
		end
	end
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\Spell_Shadow_LastingAffliction");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnClick",OnClick);
InfoPanel_SetText(f,"No Timer");