if (select(2,UnitClass("player")) ~= "WARLOCK") then
	return;
end

local f = InfoPanel_AddPlugin();
local SHARD_ICON = "Interface\\Icons\\INV_Misc_Gem_Amethyst_02";
local shardCount;

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Shard Count");
	GameTooltip:Show();
end

-- Gather Info
local function CountShards()
	shardCount = 0;
	local _, texture, quality;
	for bag = 0, NUM_BAG_FRAMES do
		for slot = 1, GetContainerNumSlots(bag) do
			texture, _, _, quality = GetContainerItemInfo(bag,slot);
			if (texture == SHARD_ICON) and (quality == -1) then
				shardCount = (shardCount + 1);
			end
		end
	end
	InfoPanel_SetText(f,"%.2d",shardCount);
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture(SHARD_ICON);
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnEvent",CountShards);
f:RegisterEvent("BAG_UPDATE");
f:RegisterEvent("PLAYER_LOGIN");