local f = InfoPanel_AddPlugin();

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Raid Info");

	local numParty, numRaid = GetNumPartyMembers(), GetNumRaidMembers();
	local members = (numRaid > 0 and numRaid or numParty);
	if (members == 0) then
		GameTooltip:AddLine("Not in a Raid or Party");
	else
		-- locals
		local unit, unitHealth, unitMana;
		local raidHealth, raidMana, unitsWithMana, validMemebers = 0, 0, 0, 0;
		local deadCount, afkCount, offlineCount, outsideRange = 0, 0, 0, 0;
		local classes = {};
		local class, color;
		-- Function to Scan Units
		local function ScanUnit(unit)
			class = UnitClass(unit);
			-- Init class table
			if (not classes[class]) then
				color = RAID_CLASS_COLORS[select(2,UnitClass(unit))];
				classes[class] = { count = 0, validCount = 0, health = 0, mana = 0, color = ("|cff%.2x%.2x%.2x"):format(color.r*255,color.g*255,color.b*255) };
			end
			classes[class].count = (classes[class].count + 1);
			-- count misc
			if (UnitIsDead(unit) or UnitIsGhost(unit)) then
				deadCount = (deadCount + 1);
			end
			if (UnitIsAFK(unit)) then
				afkCount = (afkCount + 1);
			end
			if (not UnitIsConnected(unit)) then
				offlineCount = (offlineCount + 1);
			end
			if (not UnitIsVisible(unit)) then
				outsideRange = (outsideRange + 1);
			end
			-- Gather Health / Mana Info
			if (not UnitIsDead(unit)) and (not UnitIsGhost(unit)) and (UnitIsConnected(unit)) then
				validMemebers = (validMemebers + 1);
				classes[class].validCount = (classes[class].validCount + 1);

				unitHealth = (UnitHealth(unit) / UnitHealthMax(unit) * 100);
				raidHealth = (raidHealth + unitHealth);
				classes[class].health = (classes[class].health + unitHealth);

				if (UnitPowerType(unit) == 0) then
					unitMana = (UnitMana(unit) / UnitManaMax(unit) * 100);
					raidMana = (raidMana + unitMana);
					classes[class].mana = (classes[class].mana + unitMana);
					unitsWithMana = (unitsWithMana + 1);
				end
			end
		end
		-- Loop Members
		local unitPrefix = (numRaid > 0 and "raid" or "party");
		for i = 1, members do
			ScanUnit(unitPrefix..i);
		end
		if (unitPrefix == "party") then
			ScanUnit("player");
			members = (members + 1);
		end
		-- Add Tip Lines
		GameTooltip:AddDoubleLine("Members",members,nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("Dead or Ghost",deadCount,nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("AFKs",afkCount,nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("Offline",offlineCount,nil,nil,nil,1,1,1);
		GameTooltip:AddDoubleLine("Outside Range",outsideRange,nil,nil,nil,1,1,1);
		GameTooltip:AddLine(" ");
		GameTooltip:AddDoubleLine("Raid Health",(validMemebers > 0 and format("%.2f%%",raidHealth / validMemebers) or ""),nil,nil,nil,0,1,0);
		if (unitsWithMana > 0) then
			GameTooltip:AddDoubleLine("Raid Mana",format("%.2f%%",raidMana / unitsWithMana),nil,nil,nil,0.4,0.8,0.93);
		end
		GameTooltip:AddLine(" ");
		for class, table in pairs(classes) do
			if (table.mana == 0) then
				GameTooltip:AddDoubleLine(table.count..table.color.."  "..class,(table.validCount > 0 and format("%.2f%%",(table.health / table.validCount)) or ""),nil,nil,nil,0,1,0);
			else
				GameTooltip:AddDoubleLine(table.count..table.color.."  "..class,format("|cff68ccef%.2f%%|cffffffff |||r %.2f%%",(table.mana / table.validCount),(table.health / table.validCount)),nil,nil,nil,0,1,0);
			end
		end
	end

	GameTooltip:Show();
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\Spell_unused2");
f:SetScript("OnEnter",OnEnter);
InfoPanel_SetText(f,"Raid Info");