local f = InfoPanel_AddPlugin();
local UPDATE_INTERVAL = 1;
local ADDONS_SHOWN = 6;
local info, addons = {}, {};
local nextUpdate = 0;

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnUpdate
local function OnUpdate(self,elapsed)
	nextUpdate = (nextUpdate - elapsed);
	if (nextUpdate <= 0) then
		info.fps = GetFramerate();
		info.down, info.up, info.latency = GetNetStats();
		info.mem = gcinfo();

		InfoPanel_SetText(f,"|cff00ff00%.1f  |cffffd100%dms|r  %.2f Mb",info.fps,info.latency,info.mem / 1024);
		nextUpdate = UPDATE_INTERVAL;
	end
end

-- Mouse OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Performance Info");

	GameTooltip:AddDoubleLine("Frame Rate",format("%.2f",info.fps),nil,nil,nil,1,1,1);

	GameTooltip:AddLine(" ");
	GameTooltip:AddDoubleLine("Bandwidth Down",format("%.2f bytes/s",info.down * 1024),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Bandwidth Up",format("%.2f bytes/s",info.up * 1024),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Latency",format("%d ms",info.latency),nil,nil,nil,1,1,1);

	GameTooltip:AddLine(" ");
	GameTooltip:AddDoubleLine("UI Memory Usage",format("%d kb",info.mem),nil,nil,nil,1,1,1);

	for i = 1, ADDONS_SHOWN do
		if (not addons[i]) then
			addons[i] = {};
		end
		addons[i].mem = 0;
	end

	UpdateAddOnMemoryUsage();
	local memTotal, memCurrent = 0;
	for i = 1, GetNumAddOns() do
		memCurrent = GetAddOnMemoryUsage(i);
		memTotal = (memTotal + memCurrent);
		for n = 1, ADDONS_SHOWN do
			if (memCurrent > addons[n].mem) then
				addons[ADDONS_SHOWN].name = GetAddOnInfo(i);
				addons[ADDONS_SHOWN].mem = memCurrent;
				table.sort(addons,function(a,b) return a.mem > b.mem end);
				break;
			end
		end
	end

	GameTooltip:AddDoubleLine("Addon Memory Usage",format("%d kb",memTotal),nil,nil,nil,1,1,1);
	GameTooltip:AddLine(" ");
	for i = 1, ADDONS_SHOWN do
		if (addons[i].mem > 0) then
			GameTooltip:AddDoubleLine(addons[i].name,format("%.2f kb",addons[i].mem),nil,nil,nil,1,1,1);
		end
	end

	GameTooltip:Show();
end

-- Perform a GC
local function PerformGC()
	UpdateAddOnMemoryUsage();
	local memBefore = gcinfo();
	collectgarbage();
	UpdateAddOnMemoryUsage();
	local memAfter = gcinfo();
	AzMsg(("|2Performed GC|r Before: |1%d|r kb, After: |1%d|r kb, Reduction: |1%d|r kb."):format(memBefore,memAfter,memBefore-memAfter));
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\Ability_Hunter_Pathfinding");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnUpdate",OnUpdate);
f:SetScript("OnClick",PerformGC);