local f = InfoPanel_AddPlugin();
local sessionStart = GetTime();
local startMoney;

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Money Info");

	local money = GetMoney();
	GameTooltip:AddDoubleLine("Initial Money",InfoPanel_FormatCopper(startMoney));
	if (money ~= startMoney) then
		local text = (money > startMoney) and "Gained" or "Lost";
		local moneyPerHour = (money - startMoney) / ((GetTime() - sessionStart) / 60 / 60);
		GameTooltip:AddDoubleLine("Money "..text,InfoPanel_FormatCopper(abs(money - startMoney)));
		GameTooltip:AddDoubleLine("Money "..text.." / Hour",InfoPanel_FormatCopper(floor(abs(moneyPerHour))));
	end

	GameTooltip:Show();
end

-- Gather Info
local function OnEvent(self,event)
	InfoPanel_SetText(f,InfoPanel_FormatCopper(GetMoney()));
end

-- Login Only Event
local function Login(self,event)
	f:UnregisterAllEvents();
	f:RegisterEvent("PLAYER_MONEY");
	f:SetScript("OnEvent",OnEvent);
	startMoney = GetMoney();
	OnEvent();
	Login = nil;
end


-- OnClick
local function OnClick()
	if (ChatFrameEditBox:IsShown()) then
		ChatFrameEditBox:Insert(f.text:GetText():gsub("|c%x%x%x%x%x%x%x%x",""):gsub("|r",""));
	end
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\INV_Misc_Coin_01");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnEvent",Login);
f:SetScript("OnClick",OnClick);
f:RegisterEvent("PLAYER_LOGIN");