local f = InfoPanel_AddPlugin("right");
local UPDATE_INTERVAL = 1;
local nextUpdate = 0;
local sessionStart = GetTime();
local gameTimeOffset = mod(time(),60);
local gameTimeMin = select(2,GetGameTime());
local hrs, min;

--[[if (not InfoPanel_Config["Clock"]) then
	InfoPanel_Config["Clock"] = { showRealTime = true };
end
local cfg = InfoPanel_Config["Clock"];]]

-- Az: temp until I setup the settings properly
local cfg = { showRealTime = true };

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter - http://www.opengroup.org/onlinepubs/007908799/xsh/strftime.html
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Clock");

	hrs, min = GetGameTime();
	GameTooltip:AddDoubleLine("Game Time",format("%.2d:%.2d:%.2d",hrs,min,mod(time() - gameTimeOffset,60)),nil,nil,nil,1,1,1);
	GameTooltip:AddLine(" ");
	GameTooltip:AddDoubleLine("Real Time",date("%H:%M:%S"),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Date",date("%A, %B %d, %Y"),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Day of Year",tonumber(date("%j")),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Week of Year",(tonumber(date("%W")) + 1),nil,nil,nil,1,1,1);
	GameTooltip:AddLine(" ");
	GameTooltip:AddDoubleLine("Session Time",InfoPanel_FormatTime2(GetTime() - sessionStart),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("System Uptime",InfoPanel_FormatTime2(GetTime()),nil,nil,nil,1,1,1);

	GameTooltip:Show();
end

-- OnUpdate
local function OnUpdate(self,elapsed)
	nextUpdate = (nextUpdate - elapsed);
	if (nextUpdate <= 0) then
		-- Sync GameTime Seconds
		if (gameTimeMin) and (select(2,GetGameTime()) ~= gameTimeMin) then
			gameTimeOffset = mod(time(),60);
			gameTimeMin = nil;
		end
		-- Show Time
		if (cfg.showRealTime) then
			InfoPanel_SetText(f,date("%H:%M:%S"));
		else
			hrs, min = GetGameTime();
			InfoPanel_SetText(f,"%.2d:%.2d:%.2d",hrs,min,mod(time() - gameTimeOffset,60));
		end
		nextUpdate = UPDATE_INTERVAL;
	end
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\Ability_Hunter_Readiness");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnUpdate",OnUpdate);