local f = InfoPanel_AddPlugin();
--local lastUpdate = 0;
local info = {};

for i = 0, NUM_BAG_FRAMES do
	info[i] = {};
end

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Bag Info");

	for bag = 0, NUM_BAG_FRAMES do
		if (GetBagName(bag)) then
			GameTooltip:AddDoubleLine(GetBagName(bag),format("%.2d / %.2d",info[bag].slots - info[bag].used,info[bag].slots),nil,nil,nil,1,1,1);
		end
	end
	GameTooltip:AddLine(" ");

	GameTooltip:AddDoubleLine("Total Slots",info.maxTotal,nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Used Slots",info.usedTotal,nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Free Slots",info.maxTotal - info.usedTotal,nil,nil,nil,1,1,1);

	GameTooltip:Show();
end

-- OnEvent
local function OnEvent(self,event)
--	if (GetTime() < lastUpdate) then
--		return;
--	end
--	lastUpdate = (GetTime() + 1);

	local type;
	info.maxTotal = 0;
	info.usedTotal = 0;
	-- Loop
	for bag = 0, NUM_BAG_FRAMES do
		info[bag].slots = GetContainerNumSlots(bag);
		info[bag].used = 0;
		-- Bag Slots
		for slot = 1, info[bag].slots do
			if (GetContainerItemInfo(bag,slot)) then
				info[bag].used = (info[bag].used + 1);
			end
		end
		-- Get Bag Type
		if (bag > 0) and (IPWorkTip:SetInventoryItem("player",ContainerIDToInventoryID(bag))) then
			type = select(6,GetItemInfo(select(2,IPWorkTip:GetItem()) or ""));
		end
		-- Totals
		if (bag == 0) or (type ~= INVTYPE_QUIVER) then
			info.usedTotal = (info.usedTotal + info[bag].used);
			info.maxTotal = (info.maxTotal + info[bag].slots);
		end
	end
	InfoPanel_SetText(f,"%d / %d",info.maxTotal - info.usedTotal,info.maxTotal);
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\INV_Misc_Bag_EnchantedMageweave");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnClick",function() OpenAllBags() end);
f:SetScript("OnEvent",OnEvent);
f:RegisterEvent("BAG_UPDATE");
f:RegisterEvent("PLAYER_LOGIN");