do
	local class = select(2,UnitClass("player"));
	if (class == "MAGE" or class == "WARLOCK" or class == "PRIEST") then
		return;
	end
end

local f = InfoPanel_AddPlugin();
local attackSpeed, critChance, attackPower, hasBattleShout, attackPowerMax;
local GetAP, GetCrit, GetSpeed;

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Attack Power Info");

	GameTooltip:AddDoubleLine("Attack Speed",format("%.2f",attackSpeed),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Crit Chance",format("%.2f%%",critChance),nil,nil,nil,1,1,1);
	GameTooltip:AddDoubleLine("Attack Power",attackPower,nil,nil,nil,1,1,1);

	GameTooltip:AddLine(" ");
	GameTooltip:AddDoubleLine("Max Session AP",attackPowerMax,nil,nil,nil,1,1,1);

	GameTooltip:Show();
end

-- Gather Info
local function OnEvent(self,event)
	-- AP Change
	if (event == "UNIT_ATTACK_POWER" or event == "UNIT_RANGED_ATTACK_POWER") then
		local base, posBuff, negBuff = GetAP("player");
		attackPower = (base + posBuff + negBuff);
		if (attackPower > attackPowerMax) then
			attackPowerMax = attackPower;
		end
	-- Attack Speed Change (show main hand only)
	elseif (event == "UNIT_ATTACK_SPEED") then
		attackSpeed = GetSpeed("player");
	-- Damage Mods Change (crit chance etc)
	elseif (event == "PLAYER_DAMAGE_DONE_MODS") then
		critChance = GetCrit();
	-- BS Gain
	elseif (event == "CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS") and (arg1 == "You gain Battle Shout.") then
		hasBattleShout = 1;
	-- BS Fade or Player Dies
	elseif (event == "CHAT_MSG_SPELL_AURA_GONE_SELF" and arg1 == "Battle Shout fades from you.") or (event == "PLAYER_DEAD") then
		hasBattleShout = nil;
	end
	InfoPanel_SetText(f,format("|cffffffff%.2f  |cff80c0ff%.2f%%  %s%d",attackSpeed,critChance,(hasBattleShout and "|cff52ff52" or "|cffff5252"),attackPower));
end

-- Login Only Event
local function Login(self,event)
	if (select(2,UnitClass("player")) ~= "WARRIOR") then
		hasBattleShout = 1;
	else
		local buffName;
		for i = 1, 40 do
			buffName = UnitBuff("player",i);
			if (not buffName) then
				break;
			elseif (buffName == "Battle Shout") then
				hasBattleShout = 1;
				break;
			end
		end
	end

	local base, posBuff, negBuff = GetAP("player");
	attackPower = (base + posBuff + negBuff);
	critChance = GetCrit();
	attackSpeed = GetSpeed("player");

	attackPowerMax = attackPower;

	f:SetScript("OnEvent",OnEvent);
	Login = nil;
end

-- OnClick
local function OnClick(self,button)
	if (ChatFrameEditBox:IsShown()) then
		ChatFrameEditBox:Insert(format("%.2f%% Crit, %d AP",critChance,attackPower));
	end
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

do
	f.icon:SetTexture("Interface\\Icons\\Ability_Warrior_Battleshout");
	f:SetScript("OnEnter",OnEnter);
	f:SetScript("OnEvent",Login);
	f:SetScript("OnClick",OnClick);

	local class = select(2,UnitClass("player"));
	GetAP = (class == "HUNTER" and UnitRangedAttackPower or UnitAttackPower);
	GetCrit = (class == "HUNTER" and GetRangedCritChance or GetCritChance);
	GetSpeed = (class == "HUNTER" and UnitRangedDamage or UnitAttackSpeed);

	if (class == "WARRIOR") then
		f:RegisterEvent("CHAT_MSG_SPELL_AURA_GONE_SELF");
		f:RegisterEvent("CHAT_MSG_SPELL_PERIODIC_SELF_BUFFS");
		f:RegisterEvent("PLAYER_DEAD");
	end
	if (class == "HUNTER") then
		f:RegisterEvent("UNIT_RANGED_ATTACK_POWER");
	else
		f:RegisterEvent("UNIT_ATTACK_POWER");
	end
	f:RegisterEvent("PLAYER_AURAS_CHANGED");
	f:RegisterEvent("PLAYER_DAMAGE_DONE_MODS");
	f:RegisterEvent("UNIT_ATTACK_SPEED");
	f:RegisterEvent("PLAYER_LOGIN");
end