if (select(2,UnitClass("player")) ~= "HUNTER") then
	return;
end

local f = InfoPanel_AddPlugin();
local ammoCount, link;

--------------------------------------------------------------------------------------------------------
--                                             Functions                                              --
--------------------------------------------------------------------------------------------------------

-- OnEnter
local function OnEnter(self)
	InfoPanel_MakeTip(f,"Ammo Count");
	GameTooltip:Show();
end

-- OnEvent
local function CountAmmo(self,event)
	ammoCount = 0;
	for bag = 0, NUM_BAG_FRAMES do
		for slot = 1, GetContainerNumSlots(bag) do
			link = GetContainerItemLink(bag,slot);
			if (link) and (select(9,GetItemInfo(link)) == "INVTYPE_AMMO") then
				ammoCount = (ammoCount + select(2,GetContainerItemInfo(bag,slot)));
			end
		end
	end
	InfoPanel_SetText(f,"%.3d",ammoCount);
end

--------------------------------------------------------------------------------------------------------
--                                              Finalize                                              --
--------------------------------------------------------------------------------------------------------

f.icon:SetTexture("Interface\\Icons\\INV_Ammo_Arrow_02");
f:SetScript("OnEnter",OnEnter);
f:SetScript("OnEvent",CountAmmo);
f:RegisterEvent("BAG_UPDATE");
f:RegisterEvent("PLAYER_LOGIN");