local _G = getfenv(0);

-- Config
InfoPanel_Config = {};
local DefaultConfig = {
	topAnchor = false,
	defaultTip = false,
};

local lastPlugin;

-- Init Specific Mod Vars
local f = CreateFrame("Frame",nil,UIParent);
local modName = "InfoPanel";
local modVers = GetAddOnMetadata(modName,"Version");

--------------------------------------------------------------------------------------------------------
--                                           Misc Functions                                           --
--------------------------------------------------------------------------------------------------------

-- AdjustAnchors
local function AdjustAnchors()
	-- InfoPanel
	f:ClearAllPoints();
	if (InfoPanel_Config.topAnchor) then
		f:SetPoint("TOPLEFT",-1,1);
		f:SetPoint("TOPRIGHT",1,1);
	else
		f:SetPoint("BOTTOMLEFT",-1,-1);
		f:SetPoint("BOTTOMRIGHT",1,-1);
	end
	-- MainMenuBar
	if (MainMenuBar:IsShown()) then
		MainMenuBar:ClearAllPoints();
		if (InfoPanel_Config.topAnchor) then
			MainMenuBar:SetPoint("BOTTOM");
		else
			MainMenuBar:SetPoint("BOTTOM",f,"TOP");
		end
	end
end

-- OnEvent
local function OnEvent(self,event)
	-- Set Default Config
	if (event == "VARIABLES_LOADED") then
		for name, value in pairs(DefaultConfig) do
			if (InfoPanel_Config[name] == nil) then
				InfoPanel_Config[name] = value;
			end
		end
		AdjustAnchors();
	end
end

-- Setup the Main Frame
f:SetHeight(26);
f:SetToplevel(1);
f:SetBackdrop({ bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", tile = true, tileSize = 8, edgeSize = 8, insets = { left = 2, right = 2, top = 2, bottom = 2 } });
f:SetBackdropColor(0.1,0.22,0.35,1);
f:SetBackdropBorderColor(0.1,0.1,0.1,1);
f:Show();
f:SetScript("OnEvent",OnEvent);
f:RegisterEvent("VARIABLES_LOADED");

--------------------------------------------------------------------------------------------------------
--                                           Slash Handling                                           --
--------------------------------------------------------------------------------------------------------
_G["SLASH_"..modName.."1"] = "/ip";
SlashCmdList[modName] = function(cmd)
	-- Extract Paramters
	local param1, param2 = cmd:match("^([^%s]+)%s*(.*)$");
	param1 = (param1 and param1:lower() or cmd:lower());
	-- Show / Hide
	if (param1 == "show") then
		if (f:IsVisible()) then
			f:Hide();
		else
			f:Show();
		end
	-- Swap Anchor
	elseif (param1 == "anchor") then
		InfoPanel_Config.topAnchor = not InfoPanel_Config.topAnchor;
		AdjustAnchors();
	-- Tip
	elseif (param1 == "tip") then
		InfoPanel_Config.defaultTip = not InfoPanel_Config.defaultTip;
	-- Invalid or No Command
	else
		UpdateAddOnMemoryUsage();
		AzMsg("----- |2"..modName.."|r |1"..modVers.."|r ----- |1"..format("%.2f",GetAddOnMemoryUsage(modName)).." |2kb|r -----");
		AzMsg("The following |2paramters|r are valid:");
		AzMsg(" |2anchor|r = Swap anchor position between top and bottom");
		AzMsg(" |2tip|r = Toggles between plugin anchored tip or default anchored tip");
	end
end

--------------------------------------------------------------------------------------------------------
--                                Global Chat Message Function (Rev 3)                                --
--------------------------------------------------------------------------------------------------------
if (not AZMSG_REV or AZMSG_REV < 3) then
	AZMSG_REV = 3;
	function AzMsg(text)
		DEFAULT_CHAT_FRAME:AddMessage(tostring(text):gsub("|1","|cffffff80"):gsub("|2","|cffffffff"),128/255,192/255,255/255);
	end
end

--------------------------------------------------------------------------------------------------------
--                                       Plugin Helper Functions                                      --
--------------------------------------------------------------------------------------------------------

-- Standard OnLeave Function for Plugins
local function OnLeave()
	GameTooltip:Hide()
end

-- Add Plugin
function InfoPanel_AddPlugin(arg1)
	local frame = CreateFrame("Button",nil,f);
	frame:SetWidth(20);
	frame:SetHeight(f:GetHeight());
	frame.icon = frame:CreateTexture(nil,"OVERLAY");
	frame.icon:SetPoint("LEFT",4,0);
	frame.icon:SetWidth(18);
	frame.icon:SetHeight(18);
	frame.text = frame:CreateFontString(nil,"OVERLAY","GameFontHighlight");
	frame.text:SetPoint("LEFT",frame.icon,"RIGHT",4,0);
	frame:SetScript("OnLeave",OnLeave);
	frame:EnableMouse(1);
	frame:RegisterForClicks("LeftButtonUp","RightButtonUp");
	frame:Show();
	-- Anchor
	if (arg1 == "right") then
		frame.isRightAligned = 1;
		frame:SetPoint("RIGHT",-8,0);
	elseif (lastPlugin) then
		frame:SetPoint("LEFT",lastPlugin,"RIGHT",12,0);
	else
		frame:SetPoint("LEFT",2,0);
	end
	lastPlugin = frame;
	-- Return
	return frame;
end

-- Quick SetText for Plugins to use
function InfoPanel_SetText(f,text,...)
	local oldWidth = f.text:GetWidth();
	-- text
	if (select("#",...) > 0) then
		f.text:SetFormattedText(text,...);
	else
		f.text:SetText(text);
	end
	-- width
	if (abs(oldWidth - f.text:GetWidth()) > 3) then
		f:SetWidth(f.text:GetWidth() + 27);
	end
	-- tip
	if (GameTooltip:IsOwned(f)) and (f:GetScript("OnEnter")) then
		f:GetScript("OnEnter")(f);
	end
end

-- SetTextColor
function InfoPanel_SetTextColor(f,value,lowBoundry,highBoundry)
	if (value > highBoundry) then
		f.text:SetTextColor(0,1,0);
	elseif (value > lowBoundry) then
		f.text:SetTextColor(1,1,0);
	else
		f.text:SetTextColor(1,0,0);
	end
end

-- InitTip (Initializes the GTT for use)
function InfoPanel_MakeTip(frame,header,extra,...)
	-- Set Tip Anchor
	if (InfoPanel_Config.defaultTip) then
		GameTooltip_SetDefaultAnchor(GameTooltip,frame);
	elseif (frame.isRightAligned) then
		GameTooltip:SetOwner(frame,"ANCHOR_TOPRIGHT",4,0);
	else
		GameTooltip:SetOwner(frame,"ANCHOR_TOPLEFT");
	end
	-- Add Header
	if (not extra) then
		GameTooltip:AddLine(header,1,1,1,...);
	else
		GameTooltip:AddDoubleLine(header,extra,1,1,1,...);
	end
end