local L = AceLibrary("AceLocale-2.2"):new("Incubator")
local BZ = LibStub("LibBabble-Zone-3.0"):GetLookupTable()
local tablet = AceLibrary("Tablet-2.0")
local Incubator = Incubator
local FuBar = AceLibrary("FuBarPlugin-2.0")

IncubatorFuBar = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "FuBarPlugin-2.0")
IncubatorFuBar.hasIcon = "Interface\\AddOns\\Incubator\\Icons\\SyncON"
IncubatorFuBar.category = "Raid"
IncubatorFuBar.title = "Incubator"
IncubatorFuBar.hideMenuTitle = true
IncubatorFuBar.hideWithoutStandby = true
IncubatorFuBar.clickableTooltip = true
IncubatorFuBar.OnMenuRequest = Incubator.mainmenuopts

-- Still a hack.  Thanks Funkeh`.
local args = FuBar:GetAceOptionsDataTable(IncubatorFuBar)
if not IncubatorFuBar.OnMenuRequest.args[L["Menu"]] then
	IncubatorFuBar.OnMenuRequest.args[L["Menu"]] = {
		type = "group",
		name = L["Menu"],
		desc = L["Menu options."],
		args = args,
		order = 300,
	}
end

local IncubatorZoneList = {
	BZ["Karazhan"],
	BZ["Black Temple"],
	BZ["Gruul's Lair"],
	BZ["Magtheridon's Lair"],
	BZ["Serpentshrine Cavern"],
	BZ["Tempest Keep"],
	BZ["Zul'Aman"],
	BZ["Sunwell Plateau"],
	--BZ["Terokkar Forest"],
}

function IncubatorFuBar:OnInitialize()
	self:RegisterDB("IncubatorFubarDB")
end

function IncubatorFuBar:OnEnable()
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "ZoneChange")
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA", "ZoneChange")
	self:ChangeState()
	self.Ghost = nil
end

function IncubatorFuBar:ChangeState()
	if Incubator:IsActive() then
		self:SetIcon("Interface\\AddOns\\Incubator\\Icons\\SyncON")
		IncubatorFuBar.hint = L["hint"]
	else
		self:SetIcon("Interface\\AddOns\\Incubator\\Icons\\SyncOFF")
		IncubatorFuBar.hint = L["disabledhint"]
		self:SetText("")
	end
	self:Update()
end

function IncubatorFuBar:CheckZone()
	local currentzone = GetRealZoneText()
	for n, zone in pairs(IncubatorZoneList) do
		if zone == currentzone then 
			return true
		end
	end
	return false
end

function IncubatorFuBar:ZoneChange()
	if not UnitInRaid("player") and  Incubator:IsActive() then
		Incubator:ToggleActive(false)
		self:ChangeState()
		return
	end
	if UnitIsGhost("player") then self.Ghost = true return end
	if self.Ghost then self.Ghost = nil return end
	if self:CheckZone() then 
		if not Incubator:IsActive() then Incubator:ToggleActive(true) end
	elseif Incubator:IsActive() then Incubator:ToggleActive(false) 
	end
	self:ChangeState()
end

function IncubatorFuBar:OnClick()
	if Incubator:IsActive() then
		local Timers = Incubator:SortTimers()
		if Timers[1] then
			if IsShiftKeyDown() then
				Incubator:ClearTimer(Timers[1].name)
			elseif IsAltKeyDown() then
				for _,timer in pairs(Timers) do
					SendChatMessage(timer.name .. ": " .. Incubator:FormatTime(timer.time), "RAID")
				end
			else
				SendChatMessage(Timers[1].name .. ": " .. Incubator:FormatTime(Timers[1].time), "RAID")
			end
		end
	else 
		Incubator:ToggleActive(true)
		self:ChangeState()
	end
end

function IncubatorFuBar:OnTextUpdate()
    	if Incubator:IsActive() and Incubator.db.profile.futext then
    		local Timers = Incubator:SortTimers()
		local text
		if Timers[1] then
			if Timers[1].time < 600 then text = "|c00bb0000"
			elseif Timers[1].time < 1200 then text = "|c00ffff33"
			else text = "|c001eff00" end
			text = text .. SecondsToTime(Timers[1].time, Incubator.db.profile.precision) .. "|r"
			self:SetText(text)
		else self:SetText("") end
	end
end

function IncubatorFuBar:OnTooltipUpdate()
	tablet:SetHint(self.hint)
	if Incubator:IsActive() then
		local cat = tablet:AddCategory('columns', 2)
		local Timers = Incubator:SortTimers()
		local r,g,b
		for key, data in pairs(Timers) do
			if data.time < 600 then r,g,b = 1,0,0
			elseif data.time < 1200 then r,g,b = 1,1,0
			else r,g,b = 0,1,0 end
			cat:AddLine(
				'text', data.name,
				'textR', 1,
				'textG', 1,
				'textB', 1,
				'text2', SecondsToTime(data.time, Incubator.db.profile.precision),
				'text2R', r,
				'text2G', g,
				'text2B', b,
				'func', 'TimerClick',
				'arg1', self,
				'arg2', key		
			)
		end
	end
end

function IncubatorFuBar:TimerClick(key)
	local Timers = Incubator:SortTimers()
	if IsShiftKeyDown() then
		Incubator:ClearTimer(Timers[key].name)
	else 
		if UnitInRaid("player") == nil then
			SendChatMessage(Timers[key].name .. ": " ..  Incubator:FormatTime(Timers[key].time), "PARTY")
		else
			SendChatMessage(Timers[key].name .. ": " ..  Incubator:FormatTime(Timers[key].time), "RAID")
		end
	end
end