local L = AceLibrary("AceLocale-2.2"):new("Incubator")
local media = LibStub("LibSharedMedia-3.0")
local PC = AceLibrary("PaintChips-2.0")
local RunningTimers = { }
local CurrentCombat = { }
local Killcount = { }
local LastOOC = 0
local anchor = "Incubator Anchor"
local BarCount = 0
local Lastexp = 0
local NeedTimers = 0

local _G = getfenv(0)
local tostring = _G.tostring
local floor = _G.math.floor
local bitband = _G.bit.band
local pairs = _G.pairs

local IncubatorTable = {
	-- Localized name = Respawn time in seconds, minimum count to start a timer, is grouped with other mobs (not of the same type)

	-- Karazhan
	[15547]	= {1500, -1, true},	-- 15547 Spectral Charger
	[15548]	= {1500, -1, true},	-- 15548 Spectral Stallion
	[15551]	= {1500, -1, true},	-- 15551 Spectral Stable Hand

	[16406]	= {3600, -1, false},	-- 16406 Phantom Attendant
	[16408]	= {3600, -1, false},	-- 16408 Phantom Valet
	[16409]	= {3600,  8, false},	-- 16409 Phantom Guest
	[16415]	= {3600, -1, false},	-- 16415 Skeletal Waiter

	[16459]	= {3600, -1, true},	-- 16459 Wanton Hostess
	[16460]	= {3600, -1, true},	-- 16460 Night Mistress
	[16461]	= {3600, -1, true},	-- 16461 Concubine
	[16424]	= {3600,  2, false},	-- 16424 Spectral Sentry
	[16425]	= {3600,  2, false},	-- 16425 Phantom Guardsman

	[16471]	= {3600, -1, true},	-- 16471 Skeletal Usher
	[16472]	= {3600, -1, false},	-- 16472 Phantom Stagehand
	[16473]	= {3600,  2, false},	-- 16473 Spectral Performer

	[17533]	= {1,    99, true},	-- 17533 Enable killcount tracking of R&J
	[17534]	= {1,    99, true},	-- 17534 Killcount requirement of 99 should prevent bars from starting

	[16488]	= {3600, -1, true},	-- 16488 Arcane Anomaly
	[16492]	= {3600,  5, true},	-- 16492 Syphoner
	[16485]	= {3600,  2, false},	-- 16485 Arcane Watchman

	[16491]	= {7200,  3, true},	-- 16491 Mana Feeder
	[16489]	= {7200, -1, true},	-- 16489 Chaotic Sentience
	[16530]	= {7200,  2, true},	-- 16530 Mana Warp
	[16529]	= {7200, -1, true},	-- 16529 Magical Horror
	[16504]	= {7200, -1, false},	-- 16504 Arcane Protector

	[16539]	= {7200,  2, true},	-- 16539 Homunculus
	[16540]	= {7200, -1, true},	-- 16540 Shadow Pillager

	[16525]	= {7200, -1, true},	-- 16525 Spell Shade
	[16526]	= {7200, -1, true},	-- 16526 Sorcerous Shade
	[16544]	= {7200, -1, false},	-- 16544 Ethereal Thief
	[16545]	= {7200, -1, false},	-- 16545 Ethereal Spellfilcher

	[16595]	= {7200,  2, false},	-- 16595 Fleshbeast
	[16596]	= {7200, -1, true},	-- 16596 Greater Fleshbeast

	-- Gruul's Lair
	[19389]	= {3600, -1, true},	-- 19389 Lair Brute
	[21350]	= {3600, -1, true},	-- 21350 Gronn-Priest

	-- Magtheridon's Lair
	[18829]	= {7200, -1, true},	-- 18829 Hellfire Warder

	-- SSC
	[21251]	= {7200, -1, true},	-- 21251 Underbog Colossus
	[21339]	= {7200, -1, true},	-- 21339 Coilfang Hate-Screamer
	[21221]	= {7200, -1, true},	-- 21221 Coilfang Beast-Tamer	
	[21246]	= {7200, -1, true},	-- 21246 Serpentshrine Sporebat

	[21299] = {7200, -1, true},	-- 21299 Coilfang Fathom-Witch
	[21220]	= {7200, -1, true},	-- 21220 Coilfang Priestess
	[21298] = {7200, -1, true}, 	-- 21298 Coilfang Serpentguard
	[21301] = {7200, -1, true}, 	-- 21301 Coilfang Shatterer

	[21229] = {7200, -1, true},	-- 21229 Greyheart Tidecaller
	[21230] = {7200, -1, true},	-- 21230 Greyheart Nether-Mage
	[21232] = {7200, -1, true},	-- 21232 Greyheart Skulker
	[21263] = {7200, -1, true},	-- 21263 Greyheart Technician

	[21224] = {7200, -1, true},	-- 21224 Tidewalker Depth-Seer
	[21225] = {7200, -1, true},	-- 21225 Tidewalker Warrior
	[21226] = {7200, -1, true},	-- 21226 Tidewalker Shaman
	[21227] = {7200, -1, true},	-- 21227 Tidewalker Harpooner
	[21228] = {7200, -1, true},	-- 21228 Tidewalker Hydromancer

	-- TK
	[20031] = {7200, -1, true},	-- 20031 Bloodwarder Legionnaire
	[20032] = {7200, -1, true},	-- 20032 Bloodwarder Vindicator
	[20035] = {7200, -1, true},	-- 20035 Bloodwarder Marshal
	[20036] = {7200, -1, true},	-- 20036 Bloodwarder Squire

	[20043] = {7200, -1, true},	-- 20043 Apprentice Star Scryer
	[20034] = {7200, -1, true},	-- 20034 Star Scryer
	[20044] = {7200, -1, true},	-- 20044 Novice Astromancer
	[20033] = {7200, -1, true},	-- 20033 Astromancer
	[20045] = {7200, -1, true},	-- 20045 Nether Scryer
	 
	[20037] = {7200, -1, true},	-- 20037 Tempest Falconer
	[20038] = {7200, -1, true},	-- 20038 Phoenix-Hawk Hatchling
	[20039] = {7200, -1, true},	-- 20039 Phoenix-Hawk

	[20040] = {7200, -1, true},	-- 20040 Crystalcore Devastator
	[20041] = {7200, -1, true},	-- 20041 Crystalcore Sentinel
	[20042] = {7200, -1, true},	-- 20042 Tempest-Smith
	[20052] = {7200, -1, true},	-- 20052 Crystalcore Mechanic
	 
	[20047] = {7200, -1, true},	-- 20047 Crimson Hand Battle Mage
	[20049] = {7200, -1, true},	-- 20049 Crimson Hand Blood Knight
	[20048] = {7200, -1, true},	-- 20048 Crimson Hand Centurion
	[20050] = {7200, -1, true},	-- 20050 Crimson Hand Inquisitor
 
	-- BT
	[22878] = {7200, -1, true},	-- 22878 Aqueous Lord
	[22883] = {1200,   2, true},	 --22883 Aqueous Spawn
	
	[22873]	= {7200, -1, true},	-- 22873 Coilskar General
	[22874]	= {7200, -1, true},	-- 22874 Coilskar Harpooner
	[22875]	= {7200, -1, true},	-- 22875 Coilskar Sea-Caller
	[22876]	= {7200, -1, true},	-- 22876 Coilskar Soothsayer
	[22877]	= {7200, -1, true},	-- 22877 Coilskar Wrangler
	[22884] = {7200, -1, true},	-- 22884 Leviathan
	[22885] = {7200, -1, true},	-- 22885 Dragon Turtle

	[22855] = {7200, -1, true},	-- 22855 Illidari Nightlord
	[22869] = {7200, -1, true}, 	-- 22869 Illidari Boneslicer
	[23339] = {7200, -1, true}, 	-- 23339 Illidari Heartseeker
	[22853] = {7200, -1, true}, 	-- 22853 Illidari Defiler

	[23028] = {7200, -1, true}, 	-- 23028 Bonechewer  Taskmaster
	[22954] = {7200, -1, false}, 	-- 22954 Illidari  Fearbringer
	[22960] = {7200,   2, true}, 	-- 22960 Dragonmaw  Wyrmcaller
	
	[23196] = {7200, -1, true}, 	-- 23196 Bonechewer Behemoth
	[23239] = {7200, -1, true}, 	-- 23239 Bonechewer Combatant
	[23222] = {7200, -1, true}, 	-- 23222 Bonechewer Brawler
	[23223] = {7200, -1, true}, 	-- 23223 Bonechewer Spectator
	[23237] = {7200, -1, true},	-- 23237 Bonechewer Blood Fury
	[23232] = {7200, -1, true}, 	-- 23232 Mutant War Hound

	[22939] = {7200,  4, true},	-- 22939 Temple Concubine
	[22955] = {7200,  4, true},	-- 22955 Charming Courtesan
	[22959] = {7200, -1, true}, 	-- 22959 Spellbound Attendant
	[22965] = {7200, -1, true}, 	-- 22965 Enslaved Servant
	[22956] = {7200, -1, true}, 	-- 22956 Sister of Pain
	[22964] = {7200, -1, true},	-- 22964 Sister of Pleasure
	[22957] = {7200, -1, true}, 	-- 22957 Priestess of Dementia
	[22962] = {7200, -1, true}, 	-- 22962 Priestess of Delight

	[22880] = {7200, -1, true},	-- 22880 Shadowmoon Champion
	[23018] = {7200, -1, true},	-- 23018 Shadowmoon Houndmaster
	[23083] = {7200,  2, true}, 	-- 23083 Shadowmoon Riding Hound
	[23147] = {7200, -1, true},	-- 23147 Shadowmoon Grunt
	[22946] = {7200,  2, true}, 	-- 22946 Shadowmoon War Hound
	[22879] = {7200, -1, true},	-- 22879 Shadowmoon Reaver
	[22945] = {7200, -1, true},	-- 22945 Shadowmoon Blood Mage
	[22882] = {7200, -1, true},	-- 22882 Shadowmoon Deathshaper
	[23047] = {7200, -1, true},	-- 23047 Shadowmoon Soldier
	[23049] = {7200, -1, true},	-- 23049 Shadowmoon Weapon Master
	[23371] = {7200, -1, true},	-- 23371 Shadowmoon Fallen
	[22953] = {7200, -1, true},	-- 22953 Wrathbone Flayer
	[23172] = {7200, -1, true},	-- 23172 Hand of Gorefiend
	
	[23394] = {7200, -1, true}, 	-- 23394 Promenade Sentinel
	[23397] = {7200,  2, true},	-- 23397 Illidari Blood Lord
	
	-- Sunwell
	[25363] = {7200, -1, true},	-- 25363 Sunblade Cabalist
	[25367] = {7200, -1, true},	-- 25367 Sunblade Arch Mage
	[25368] = {7200, -1, true},	-- 25368 Sunblade Slayer
	[25369] = {7200, -1, true},	-- 25369 Sunblade Vindicator
	[25370] = {7200, -1, true},	-- 25370 Sunblade Dusk Priest
	[25371] = {7200, -1, true},	-- 25371 Sunblade Dawn Priest
	[25507] = {7200, -1, true},	-- 25507 Sunblade Protector

	[25484] = {7200, -1, false},	-- 25484 Shadowsword Assassin
	[25486] = {7200, -1, true},	-- 25486 Shadowsword Vanquisher
	[25373] = {7200, -1, true},	-- 25373 Shadowsword Soulbinder
	[25506] = {7200, -1, true},	-- 25506 Shadowsword Lifeshaper
	[25837] = {7200, 1, true},	-- 25837 Shadowsword Commander
	[25483] = {7200, -1, true},	-- 25483 Shadowsword Manafiend

	[25165] = {1,    99, true},	-- 25165 Lady Sacrolash
	[25166] = {1,    99, true},	-- 25166 Grand Warlock Alythess

	[25592] = {7200, -1, true},	-- 25592 Doomfire Destroyer
	[25597] = {7200, -1, true},	-- 25597 Oblivion Mage
	[25851] = {7200, 6, true},	-- 25851 Volatile Fiend
	[25595] = {7200, 1, false}, 	-- 25595 Chaos Gazer
	[25593] = {7200, 2, false},	-- 25593 Apacolypse Guard
	[25591] = {7200, 1, true},	-- 25591 Painbringer
	[25509] = {7200, 1, true},	-- 25509 Priestess of Torment
	[25599] = {7200, 1, true},	-- 25599 Cataclysm Hound
	[25508] = {7200, 1, true},	-- 25508 Shadowsword Guardian
	
	-- ZA
	[24179]	= {7200, -1, true},	-- 24179 Amani'shi Wind Walker
	[24549] = {1800, -1, true},	-- 24549 Amani'shi Tempest
	[23542]	= {7200, -1, true},	-- 23542 Amani'shi Axe Thrower
	[23582]	= {7200, -1, true},	-- 23582 Amani'shi Tribesman
	[23774]	= {7200, -1, true},	-- 23774 Amani'shi Trainer
	[24065]	= {7200, -1, true},	-- 24065 Amani'shi Handler
	[24059]	= {7200, -1, true},	-- 24059 Amani'shi Beast Tamer
	[24043]	= {7200,  4, false},	-- 24043 Amani Lynx
	[24530]	= {7200, -1, true},	-- 24530 Amani Elder Lynx
	
	-- Debug
	--[18468]	= {1200,   2,  true},	-- 18468 Teromoth debug
	--[18466]	= {7200, 1, true},	-- 18465  Dreadfang Lurker debug
}

local IncubatorBossShutoff = {
	-- Table of which spawn timers a boss kill should shut off. This prevents the mob from being tracked for the remainder of the current session.
	-- See Incubator:Bossdeath
	-- Boss UID = "remove" or "reset", mob1, mob2, mob3, etc
	 
	-- Karazhan
	[16152]	= {"remove", -- 16152 16152 Attumen the Huntsman
		15547, -- 15547 Spectral Charger
		15548, -- 15548 Spectral Stallion
		15551, -- 15551 Spectral Stable Hand
	},

	[15687]	= {"remove", -- 15687 Moroes
		16406, -- 16406 Phantom Attendant
		16408, -- 16408 Phantom Valet
		16409, -- 16409 Phantom Guest
		16415, -- 16415 Skeletal Waiter
	},

	[16457]	= {"remove", -- 16457 Maiden of Virtue
		16459, -- 16459 Wanton Hostess
		16460, -- 16460 Night Mistress
		16461, -- 16461 Concubine
		16424, -- 16424 Spectral Sentry
		16425, -- 16425 Phantom Guardsman
	},

	[17533]	= {"remove", -- 17533 Romulo
		16471, -- 16471 Skeletal Usher
		16472, -- 16472 Phantom Stagehand
		16473, -- 16473 Spectral Performer
	},

	[17521]	= {"remove", -- 17521 Big Bad Wolf
		16471, -- 16471 Skeletal Usher
		16472, -- 16472 Phantom Stagehand
		16473, -- 16473 Spectral Performer
	},

	[18168]	= {"remove", -- 18168 The Crone
		16471, -- 16471 Skeletal Usher
		16472, -- 16472 Phantom Stagehand
		16473, -- 16473 Spectral Performer
	},

	[15691]	= {"remove", -- 15691 The Curator
		16488, -- 16488 Arcane Anomaly
		16492, -- 16492 Syphoner
		16485, -- 16485 Arcane Watchman
	},

	[16524]	= {"remove", -- 16524 Shade of Aran
		16491, -- 16491 Mana Feeder
		16489, -- 16489 Chaotic Sentience
		16529, -- 16529 Magical Horror
		16530, -- 16530 Mana Warp
		16504, -- 16504 Arcane Protector
		16525, -- 16525 Spell Shade
		16485, -- 16485 Arcane Watchman
	},

	[15688]	= {"remove", -- 15688 Terestian Illhoof
		16539, -- 16539 Homunculus
		16540, -- 16540 Shadow Pillager
	},

	[15689]	= {"remove", -- 15689 Netherspite
		16525, -- 16525 Spell Shade
		16526, -- 16526 Sorcerous Shade
		16544, -- 16544 Ethereal Thief
		16545, -- 16545 Ethereal Spellfilcher
	},

	[15690]	= {"remove", -- 15690 Prince Malchezaar
		16595,	-- 16595 Fleshbeast
		16596,	-- 16596 Greater Fleshbeast
	},

	-- Gruul's Lair
	[18831]	= {"reset", -- 18831 High King Maulgar
		19389,	-- 19389 Lair Brute
		21350,	-- 21350 Gronn-Priest
	},

	[19044]	= {"remove", -- 19044 Gruul the Dragonkiller
		19389,	-- 19389 Lair Brute
		21350,	-- 21350 Gronn-Priest
	},

	-- Magtheridon's Lair
	[17257]	= {"remove", -- 17257 Magtheridon
		"18829" -- 18829 Hellfire Warder
	},

	-- SSC
	[21216]	= {"reset", -- 21216 Hydross the Unstable
		21221,	-- 21221 Coilfang Beast-Tamer	
		21246,	-- 21246 Serpentshrine Sporebat
		21251,	-- 21251 Underbog Colossus
		21339,	-- 21339 Coilfang Hate-Screamer
	},

	[21213] = {"remove", -- 21213 Moroogrim Tidewalker
		21224,	-- 21224 Tidewalker Depth-Seer
		21225,	-- 21225 Tidewalker Warrior
		21226,	-- 21226 Tidewalker Shaman
		21227,	-- 21227 Tidewalker Harpooner
		21228,	-- 21228 Tidewalker Hydromancer
	},

	[21217] = {"reset", -- 21217 The Lurker Below
		21301, -- 21301 Coilfang Shatterer
		21220, -- 21220 Coilfang Priestess
	},

	[21214] = {"reset", -- 21214 Fathom-Lord Karathress
		21251, -- 21251 Underbog Colossus
	},

	[21215] = {"reset", -- 21215 Leotheras the Blind
		21229, -- 21229 Greyheart Tidecaller
		21230, -- 21230 Greyheart Nether-Mage
		21232, -- 21232 Greyheart SKulker
		21263, -- 21263 Greyheart Technician
	},

	-- TK
	[19514]	= {"reset", -- 19514 Al'ar
		20031, -- 20031 Bloodwarder Legionnaire
		20032, -- 20032 Bloodwarder Vindicator
		20033, -- 20033 Astromancer
		20035, -- 20035 Bloodwarder Marshal
		20036, -- 20036 Bloodwarder Squire
		20037, -- 20037 Tempest Falconer
		20038, -- 20038 Phoenix-Hawk Hatchling
		20039, -- 20039 Phoenix-Hawk
	},

	[18805]	= {"reset", -- 18805 High Astromancer Solarian
		20031, -- 20031 Bloodwarder Legionnaire
		20033, -- 20033 Astromancer
		20034, -- 20034 Star Scryer
		20036, -- 20036 Bloodwarder Squire
		20041, -- 20041 Crystalcore Sentinel
		20043, -- 20043 Apprentice Star Scryer
		20044, -- 20044 Novice Astromancer
		20045, -- 20045 Nether Scryer
	},

	[19516]	= {"reset", -- 19516 Void Reaver
 		20040,	-- 20040 Crystalcore Devastator
 		20041,	-- 20041 Crystalcore Sentinel
 		20042,	-- 20042 Tempest-Smith
 		20052,	-- 20052 Crystalcore Mechanic
	},

	[19622]	= {"reset", -- 19622 Kael'thas Sunstrider, Lord of the Blood Elves,
		20035, -- 20035 Bloodwarder Marshal
		20047,-- 20047 Crimson Hand Battle Mage
		20048,-- 20048 Crimson Hand Centurion
		20049,-- 20049 Crimson Hand Blood Knight
		20050,-- 20050 Crimson Hand Inquisitor
	},
	
	-- BT
	[22887] = {"reset", -- 22887 High Warlord Naj'entus
		22878, -- 22878 Aqueous Lord
		22873, -- 22873 Coilskar General
		22874, -- 22874 Coilskar Harpooner
		22875, -- 22875 Coilskar Sea-Caller
		22876, -- 22876 Coilskar Soothsayer
		22877, -- 22877 Coilskar Wrangler
		22885, -- 22885 Dragon Turtle
		22884, --22884 Leviathan
	},

	[22898] = {"remove", -- 22898 Supremus
		23028, 	-- 23028 Bonechewer  Taskmaster
		22954, 	-- 22954 Illidari  Fearbringer
		22960, 	-- 22960 Dragonmaw  Wyrmcaller
	},
	
	[22841] = {"remove", -- 22841 Shade of Akama
		22855, -- 22855 Illidari Nightlord
		22869, -- 22869 Illidari Boneslicer
		23339, -- 23339 Illidari Heartseeker
		22853, -- 22853 Illidari Defiler
	},

	[22947] = {"remove",-- 22947 Mother Shahraz
		22939, -- 22939 Temple Concubine
		22955, -- 22955 Charming Courtesan
		22959, -- 22959 Spellbound Attendant
		22965, -- 22965 Enslaved Servant
		22956, -- 22956 Sister of Pain
		22964, -- 22964 Sister of Pleasure
		22957, -- 22957 Priestess of Dementia
		22962, -- 22962 Priestess of Delight
	},

	[22871] = {"remove",-- 22871 Teron Gorefiend
		22880, -- 22880 Shadowmoon Champion
		23018, -- 23018 Shadowmoon Houndmaster
		23083, -- 23083 Shadowmoon Riding Hound
		23147, -- 23147 Shadowmoon Grunt
		22946, -- 22946 Shadowmoon War Hound
		22879, -- 22879 Shadowmoon Reaver
		22945, -- 22945 Shadowmoon Blood Mage
		22882, -- 22882 Shadowmoon Deathshaper
		23047, -- 23047 Shadowmoon Soldier
		23049, -- 23049 Shadowmoon Weapon Master
		23371, -- 23371 Shadowmoon Fallen
		22953, -- 22953 Wrathbone Flayer
		23172, -- 23172 Hand of Gorefiend
	},

	[22948] = {"remove", -- 22948 Gurtogg Bloodboil
		23196, -- 23196 Bonechewer Behemoth
		23239, -- 23239 Bonechewer Combatant
		23222, -- 23222 Bonechewer Brawler
		23223, -- 23223 Bonechewer Spectator
		23237, -- 23237 Bonechewer Blood Fury
		23232, -- 23232 Mutant War Hound
	},

	[23426] = {"remove", -- 23426 The Illidari Council, Yes, there's a hidden fifth death event.
		23394, 	-- 23394 Promenade Sentinel
		23397,	-- 23397 Illidari Blood Lord
	},

	-- Zul'Aman
	[23576]	= {"remove", -- 23576 Nalorakk
		23542, -- 23542 Amani'shi Axe Thrower
	},

	[23574]	= {"remove", -- 23574 Akil'zon
		24549, -- 24549 Amani'shi Tempest
	},

	[23578]	= {"remove", -- 23578  Jan'alai
		23582, -- 23582 Amani'shi Tribesman
		23774, -- 23774 Amani'shi Trainer
		24059, -- 24059 Amani'shi Beast Tamer
	},

	[23577]	= {"remove", -- 23577 Halazzi
		24059, -- 24059 Amani'shi Beast Tamer
		24065, -- 24065 Amani'shi Handler
		24043, -- 24043 Amani Lynx
		24530, -- 24530 Amani Elder Lynx
		24065, -- 24065 Amani'shi Handler
	},

	[24239]	= {"remove", -- 24239 Hex Lord Malacrass
		24065, -- 24065 Amani'shi Handler
	},
	
	-- Sunwell
	[24892] = {"reset", -- 24892 Sathrovarr the Corruptor
		25363, -- 25363 Sunblade Cabalist
		25367, -- 25367 Sunblade Arch Mage
		25368, -- 25368 Sunblade Slayer
		25369, -- 25369 Sunblade Vindicator
		25370, -- 25370 Sunblade Dusk Priest
		25371, -- 25371 Sunblade Dawn Priest
		25507, -- 25507 Sunblade Protector
	},
	
	[24882] = {"remove", -- 24882 Brutallus
		25363, -- 25363 Sunblade Cabalist
		25367, -- 25367 Sunblade Arch Mage
		25368, -- 25368 Sunblade Slayer
		25369, -- 25369 Sunblade Vindicator
		25370, -- 25370 Sunblade Dusk Priest
		25371, -- 25371 Sunblade Dawn Priest
		25507, -- 25507 Sunblade Protector
	},
	
	[25165] = {"remove", -- 25165 Lady Sacrolash
		25484,	-- Shadowsword Assassin
		25486,	-- Shadowsword Vanquisher
		25373,	-- Shadowsword Soulbinder
		25506,	-- Shadowsword Lifeshaper
		25837,	-- Shadowsword Commander
		25483,	-- Shadowsword Manafiend
		25851,	--Volatile Fiend
	},

	[25166] = {"remove", -- 25166 Grand Warlock Alythess
		25484,	-- Shadowsword Assassin
		25486,	-- Shadowsword Vanquisher
		25373,	-- Shadowsword Soulbinder
		25506,	-- Shadowsword Lifeshaper
		25837,	-- Shadowsword Commander
		25483,	-- Shadowsword Manafiend
		25851,	--Volatile Fiend
	},

	[25840] = {"remove",--Entropius
		25851,	--Volatile Fiend
		25595,	--Chaos Gazer
		25593,	--Apacolypse Guard
		25591,	--Painbringer
		25509,	--Priestess of Torment
		25599, 	--Cataclysm Hound
		25592,	-- Doomfire Destroyer
	},
	
	[25608] = {"remove", -- Kil'Jadeen
		25508, -- Shadowsword Guardian
	},
		
	-- Debug
	--[18476] 	= {"reset", 18468},	-- 18476 Wolf for debug
}

local options = {
	type = 'group',
	args = {
		list = {
			type = 'execute',
			name = L["List running timers"],
			desc = L["Output all active timers to chat"],
			func = function()
				Incubator:ConsoleRunning()
			end,
		},
		clearall = {
			type = 'execute',
			name = L["Clear all running timers"],
			desc = L["Clears all running timers and bars"],
			func = function()
				Incubator:ClearAll()
			end,
		},
		maxshowtime = {
			type = 'range',
			name = L["Maximum time in minutes"],
			desc = L["Set the maximum time for a respawn bar to show"],
			get = function()
				return Incubator.db.profile.maxshowtime
			end,
			set = function(v)
				Incubator.db.profile.maxshowtime = v
			end,
			min = 0,
			max = 120,
			step = 1,
		},
		barcount = {
			type = 'range',
			name = L["Bar count"],
			desc = L["Maximum number of bars to show at one time"],
			get = function()
				return Incubator.db.profile.barcount
			end,
			set = function(v)
				Incubator.db.profile.barcount = v
			end,
			min = 0,
			max = 25,
			step = 1,
		},
		timebetween = {
			type = 'range',
			name = L["Time between bars"],
			desc = L["Only show bars that are further apart then this in minutes"],
			get = function()
				return Incubator.db.profile.timebetween
			end,
			set = function(v)
				Incubator.db.profile.timebetween = v
			end,
			min = 0,
			max = 30,
			step = 1,
		},
		developer = {
			type = 'toggle',
			name = L["Developer"],
			desc = L["Outputs debug information to chat"],
			get = function()
				return Incubator.db.profile.developer
			end,
			set = function(v)
				Incubator.db.profile.developer = v
			end,
			map = { [false] = L["Disabled"], [true] = L["Enabled"] },
		},
		futext = {
			type = 'toggle',
			name = L["showfutext"],
			desc = L["showfutextdesc"],
			get = function()
				return Incubator.db.profile.futext
			end,
			set = function(v)
				Incubator.db.profile.futext = v
			end,
		},
		showseconds = {
			type = 'toggle',
			name = L["useseconds"],
			desc = L["usesecondsdesc"],
			get = function()
				return Incubator.db.profile.precision
			end,
			set = function(v)
				Incubator.db.profile.precision = v
			end,
		},
		baroptions = {
			type = 'group',
			desc = 'bar options',
			name = L["Bar Options"],
			args = {
				enablemouse = {
					type = 'toggle',
					name = L["Enable Mouse"],
					desc = L["Enable mouse interaction on bars"],
					get = function()
						return Incubator.db.profile.baroptions.enablemouse
					end,
					set = function(v)
						Incubator.db.profile.baroptions.enablemouse = v
					end,
					map = { [false] = L["Disabled"], [true] = L["Enabled"] },
				},
				locked = {
					type = 'toggle',
					name = L["Locked"],
					desc = L["Lock the bars, preventing dragging"],
					get = function()
						return Incubator.db.profile.baroptions.locked
					end,
					set = function(v)
						Incubator.db.profile.baroptions.locked = v
						Incubator:ToggleLock()
					end,
					map = { [false] = L["Disabled"], [true] = L["Enabled"] },
				},
				growup = {
					type = 'toggle',
					name = L["Grow up"],
					desc = L["Grow bars upward from the anchor"],
					get = function()
						return Incubator.db.profile.baroptions.growup
					end,
					set = function(v)
						Incubator.db.profile.baroptions.growup = v
						Incubator:SetCandyBarGroupGrowth(anchor, v)
					end,
					map = { [false] = L["False"], [true] = L["True"] },
				},
				texture = {
						type = "text",
						name = L["Texture"],
						desc = L["Incubator bar texture"],
						get = function() 
							return Incubator.db.profile.baroptions.texture 
						end,
						set = function(v)
							Incubator.db.profile.baroptions.texture = v
						end,
						validate = media:List("statusbar"),
				},
				barwidth = {
					type = 'range',
					name = L["Bar width"],
					desc = L["Width of Incubator bars"],
					get = function()
						return Incubator.db.profile.baroptions.width
					end,
					set = function(v)
						Incubator.db.profile.baroptions.width = v
					end,
					min = 24,
					max = 512,
					step = 8,
				},
				barheight = {
					type = 'range',
					name = L["Bar height"],
					desc = L["Width of Incubator bars"],
					get = function()
						return Incubator.db.profile.baroptions.height
					end,
					set = function(v)
						Incubator.db.profile.baroptions.height = v
					end,
					min = 6,
					max = 64,
					step = 2,
				},
				barscale = {
					type = 'range',
					name = L["Bar scale"],
					desc = L["Scale of Incubator bars"],
					get = function()
						return Incubator.db.profile.baroptions.scale
					end,
					set = function(v)
						Incubator.db.profile.baroptions.scale = v
					end,
					min = 0.5,
					max = 1.5,
					step = 0.1,
				},
			},
		},
	},
}

Incubator = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "CandyBar-2.0")

Incubator.mainmenuopts = options

function Incubator:OnInitialize()
	self:RegisterDB("IncubatorDB")
	self:RegisterChatCommand(L["Slash-Commands"], options)
	self:RegisterDefaults("profile", {
		maxshowtime = 0,
		barcount = 10,
		timebetween = 0,
		developer = false,
		futext = true,
		x = 0,
		y = 0,
		relpoint = "CENTER",
		point = "CENTER",
		precision = nil,
		["baroptions"] = {
			["enablemouse"] = true,
			["locked"] = false,
			["growup"] = false,
			["colors"] = { "blue", "green", "red", },
			["width"] = 128,
			["height"] = 16,
			["scale"] = 1.0,
			["texture"] = "BantoBar",
		},
	} )
end

function Incubator:SortTimers()
	local Timers = {}
	local count = 1
	local currenttime = GetTime()
	for name, value in pairs(RunningTimers) do
		Timers[count] = {name = name, time = floor(value[1] - currenttime)}
		count = count + 1
	end
	table.sort(Timers, function(a,b) return a.time<b.time end)
	return Timers
end

function Incubator:SortTimers2()
	local Timers = {}
	local count = 1
	for name, value in pairs(RunningTimers) do
		Timers[count] = {name = name, time = value[1] , warn = value[2], bar = value[3], uid = value[4]}
		count = count + 1
	end
	table.sort(Timers, function(a,b) return a.time<b.time end)
	return Timers
end

function Incubator:CreateAnchor()
	if self.anchor then return end
	self.anchor = CreateFrame("Frame",anchor..tostring(floor(GetTime())),UIParent)
	self.anchor:ClearAllPoints();
	self.anchor:SetBackdrop( {
		bgFile = "Interface\\Tooltips\\UI-Tooltip-Background",
		edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
		tile = true, tileSize = 16, edgeSize = 16, insets = {
			left = 5, right = 5, top = 5, bottom = 5 },
	} );
	self.anchor:SetWidth(128)
	self.anchor:SetHeight(30)
	self.anchor:SetBackdropColor(0.1,0.1,0.3)
	self.anchor:EnableMouse(Incubator.db.profile.baroptions.enablemouse)
	self.anchor:SetPoint(Incubator.db.profile.point, "UIParent", Incubator.db.profile.relpoint, Incubator.db.profile.x, Incubator.db.profile.y)
	local msg = self.anchor:CreateFontString(nil,"overlay","GameFontNormal")
	msg:ClearAllPoints()
	msg:SetPoint("CENTER", self.anchor, "CENTER")
	msg:SetText(anchor)
	self.anchor:SetMovable(true)
	self.anchor:SetScript("OnDragStart", function() self.anchor:StartMoving(); GameTooltip:Hide() end)
	self.anchor:SetScript("OnDragStop", function() self.anchor:StopMovingOrSizing(); self:SavePosition() end)
	self.anchor:SetScript("OnMouseUp", function() self:OnAnchorClick() end)
	self.anchor:SetScript("OnEnter", function() self:ShowAnchorTooltip() end)
	self.anchor:SetScript("OnLeave", function() GameTooltip:Hide() end)
	self.anchor:RegisterForDrag("LeftButton")
	if self.db.profile.baroptions.locked then
		self.anchor:Hide()
	else
		self.anchor:Show()
	end
	self:RegisterCandyBarGroup(anchor)
	self:SetCandyBarGroupPoint(anchor, "TOP", self.anchor:GetName(), "BOTTOM", 0, 0)
	self:SetCandyBarGroupGrowth(anchor, self.db.profile.baroptions.growup)
end

	
function Incubator:LockAnchor()
	self.db.profile.baroptions.locked = true
	self.anchor:Hide()
end

function Incubator:UnlockAnchor()
	self.db.profile.baroptions.locked = false
	self.anchor:Show()
end

function Incubator:ToggleLock()
	if self.db.profile.baroptions.locked then
		self.anchor:Hide()
	else
		self.anchor:Show()
	end
end

function Incubator:ShowAnchorTooltip()
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT")
	GameTooltip:AddLine(L["Incubator Anchor"])
	GameTooltip:AddLine(L["Drag this to reposition Incubator bars"])
	GameTooltip:AddLine(L["Alt+Left Click will display or hide a test bar"])
	GameTooltip:AddLine(L["Shift+Left Click will lock and hide the anchor"])
	GameTooltip:Show()
end

function Incubator:OnAnchorClick()
	if IsAltKeyDown() then
		if self:IsCandyBarRegistered("Incubator Testbar") then
			self:StopTest()
			return
		end
		self:StartTest();
	end
	if IsShiftKeyDown() then
		if self:IsCandyBarRegistered("Incubator Testbar") then
			self:StopTest()
		end
		self:LockAnchor()
	end
end

function Incubator:StartTest()
	self:RegisterCandyBar("Incubator Testbar", 300, "Test bar", nil, unpack(self.db.profile.baroptions.colors) )
	self:RegisterCandyBarWithGroup("Incubator Testbar", anchor)
	self:SetCandyBarTexture("Incubator Testbar", media:Fetch("statusbar", self.db.profile.baroptions.texture))
	self:SetCandyBarWidth("Incubator Testbar", self.db.profile.baroptions.width)
	self:SetCandyBarHeight("Incubator Testbar", self.db.profile.baroptions.height)
	self:SetCandyBarScale("Incubator Testbar", self.db.profile.baroptions.scale)
	self:StartCandyBar("Incubator Testbar", true)
end

function Incubator:StopTest()
	self:StopCandyBar("Incubator Testbar")
end

function Incubator:SavePosition()
	local point, _, relpoint, pointx, pointy = self.anchor:GetPoint()
	self.db.profile.point = point
	self.db.profile.relpoint = relpoint
	self.db.profile.x = pointx
	self.db.profile.y = pointy
end

function Incubator:OnEnable()
	CurrentCombat = { }
	Killcount = { }
	LastOOC = 0
	BarCount = 0
	Lastexp = 0
	NeedTimers = 0
	
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:ScheduleRepeatingEvent("IncubatorPeriodicHandler", self.PeriodicHandler, 1, self )

	media:Register("statusbar", "Blizzard", "Interface\\TargetingFrame\\UI-StatusBar")
	media:Register("statusbar", "BantoBar", "Interface\\AddOns\\Incubator\\textures\\bantobar.tga")
	media:Register("statusbar", "Charcoal", "Interface\\AddOns\\Incubator\\textures\\charcoal.tga")
	media:Register("statusbar", "Otravi", "Interface\\AddOns\\Incubator\\textures\\otravi.tga")
	media:Register("statusbar", "Perl", "Interface\\AddOns\\Incubator\\textures\\perl.tga")
	media:Register("statusbar", "Smooth", "Interface\\AddOns\\Incubator\\textures\\smooth.tga")
	media:Register("statusbar", "Smudge", "Interface\\AddOns\\Incubator\\textures\\smudge.tga")
	media:Register("statusbar", "Striped", "Interface\\AddOns\\Incubator\\textures\\striped.tga")
	self:CreateAnchor()
	self:RestartTimers()
end

function Incubator:OnDisable()
	self:SaveTimers()
	if self:IsEventScheduled("IncubatorPeriodicHandler") then self:CancelScheduledEvent("IncubatorPeriodicHandler") end
	self:StopFutextUpdate()
	IncubatorFuBar:ChangeState()
end

function Incubator:RestartTimers()
	-- reset existing timers, etc
	if self.db.profile.developer then
		self:Print("Restart Timers...")
	end
	RunningTimers = {}
	local timestamp = self.db.profile.timestamp
	local diff =  self:TimeDiff(timestamp, date("%m/%d/%y %H:%M:%S"))
	if diff > 8000 then self:ClearAll() return end
	local currtime = GetTime()
	if self.db.profile.timers then
		for key, value in pairs(self.db.profile.timers) do
			RunningTimers[key] = {}
			RunningTimers[key][1] = value[1] + currtime - diff 
			RunningTimers[key][2] = true
			RunningTimers[key][3] = true
			RunningTimers[key][4] = value[4]
			if RunningTimers[key][1] < 0 then self:ClearTimer(key) end
		end
	end
	IncubatorFuBar:Update()
end

function Incubator:COMBAT_LOG_EVENT_UNFILTERED(timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, ...)
	local dstValid = (bitband(dstFlags, COMBATLOG_OBJECT_TYPE_NPC + COMBATLOG_OBJECT_REACTION_HOSTILE) ~= 0)  
	if not dstValid then return end
	if eventtype == "UNIT_DIED" then self:HostileDeath(dstName, dstGUID) end
end

function Incubator:HostileDeath(mobName, GUID)
	-- increment a death counter and start timers if needed
	local UID = self:GUIDToUID(GUID)
	if IncubatorTable[UID] then	-- The thing that died is on our list of stuff that can be tracked.
		if  IncubatorTable[UID][2] == -1 and  IncubatorTable[UID][3] == false then -- The thing that died is tracked as a solo mob
			self:StartTimer(mobName,  IncubatorTable[UID][1] + GetTime(), UID)
		else
			NeedTimers = 1
			CurrentCombat[UID] = mobName
			if Killcount[UID] == nil then
				Killcount[UID] = 1
			else
				Killcount[UID] = Killcount[UID] + 1
			end
			if self.db.profile.developer then
				self:Print(mobName, "found on list to be tracked.", Killcount[UID], "this combat.")
			end
		end
	end
	if IncubatorBossShutoff[UID] then self:BossDeath(UID) end	-- A boss died, so kill all the timers associated with that boss.
end

function Incubator:GUIDToUID(guid)
	local uid = tonumber(string.sub(guid, 6, 12), 16)
	if uid == 0 then
		return nil
	end
	return uid
end

function Incubator:PLAYER_REGEN_DISABLED()
	 LastOOC = 0
	self:StopOOCHandler()
end

function Incubator:StopOOCHandler()
	self:CancelScheduledEvent("IncubatorOOCHandler")
end

function Incubator:StartOOCHandler()
	if not self:IsEventScheduled("IncubatorOOCHandler") then
		self:ScheduleRepeatingEvent("IncubatorOOCHandler", self.OOCHandler, 1, self )
	end
end

function Incubator:BossDeath(UID, called)
	if UID == 17533 and not called then return end	-- R&J
	if UID == 25165 or UID == 25166 then -- 25165 Lady Sacrolash and 25166 Grand Warlock Alythess
		if Killcount[25165] ~= 1 or Killcount[25166] ~= 1 then return end
	end

	for tindex, mobID in pairs(IncubatorBossShutoff[UID]) do
		if mobID ~= "remove" and mobID ~= "reset" then
			for timername, timerlist in pairs (RunningTimers) do
				if timerlist[4] == mobID then
					if timerlist[3] == false then-- candybar was started on this one
						if self:IsCandyBarRegistered("Incubator-"..timername)  then
							self:StopCandyBar("Incubator-"..timername)
							BarCount = BarCount - 1
						end
					end
					RunningTimers[timername] = nil
				end
			end
			if IncubatorBossShutoff[UID][1] == "remove" then
				IncubatorTable[mobID] = nil -- Prevent new bars from being started on this mob
			end
		end
	end

	if UID == 15691 then    --Curator
		IncubatorTable[16485] = {7200, 2, false,}       --Arcane Watchman
	end
	
	if UID == 16524 then    --Shade
		IncubatorTable[16525] = {7200, -1, true}        --Spell Shade
	end
	if self.db.profile.developer then
		self:Print("Boss died..."..UID)
	end
	self:StopFutextUpdate()
	self:SaveTimers()
end

function Incubator:PLAYER_REGEN_ENABLED()
		LastOOC = GetTime()
		if self.db.profile.developer == true then
			self:Print("Starting OOC checking")
		end
		if NeedTimers == 1 then
			self:StartOOCHandler()
		end
end

function Incubator:StartTimer(name, duration, UID)
	local counter = 1
	local expiration = duration + LastOOC
	local title = name .. tostring(counter)

	while RunningTimers[title] ~= nil do
		counter = counter + 1
		title = name .. tostring(counter)
	end
	
	
	RunningTimers[title] = { expiration, true, true, UID}
	if self.db.profile.developer == true then
		self:Print("Starting timer named", title, (SecondsToTime(duration - GetTime())))
	end
	local Timers = self:SortTimers2()
	if self.db.profile.barcount > 0  and #Timers > 1 then
		local match = nil
		if self.db.profile.barcount == 1 then
			if Timers[1].bar and not Timers[2].bar then match = true end
		else
			for num = 1, #Timers - 1 do
				if num < self.db.profile.barcount and (not Timers[num+1].bar and  Timers[num].bar)  then
					match = true
					break
				end
			end
		end
		if match then
			for index, data in pairs(Timers) do
				if not data.bar then 
					self:StopCandyBar("Incubator-"..data.name) 
					Timers[index].bar = true
					RunningTimers[data.name][3] = true
				end
			end
			BarCount = 0
			Lastexp = 0
		end
	end
	self:SaveTimers()
end

function Incubator:TimerHandler()
	-- handles all the timers that need to be started and clearing out the current combat list
	if self.db.profile.developer == true then
		self:Print("Processing Timers")
	end
	local StartedNonHomogeneous = false -- Flag to indicate that we already started a timer on a pack
	for key, value in pairs(CurrentCombat) do
		if Killcount[key] ~= nil and IncubatorTable[key] ~= nil then
			if value  then
				if Killcount[key] >= IncubatorTable[key][2] then
					if IncubatorTable[key][3] == true and not StartedNonHomogeneous then
						StartedNonHomogeneous = true
						-- Start a timer on this particular mob. We only want to start the timer on this one instead of 2+ mobs with the same timer.
						self:StartTimer(value, IncubatorTable[key][1], key)
					end
					if IncubatorTable[key][3] == false then
					-- Start a timer on that mob, enough of them died. These are solo so we don't care about other deaths.
						self:StartTimer(value, IncubatorTable[key][1], key)
					end
					Killcount[key] = nil
				else
					if (key == 17533 or key == 17534) and  Killcount[17533]  and  Killcount[17534] then	-- R&J
						if Killcount[17533]  >  1 and  Killcount[17534]  >  1 and Killcount[17533]  ==  Killcount[17534] then self:BossDeath(17533, true) end
					end
					if self.db.profile.developer == true then
						self:Print("Discarding info on", key, "(Got", Killcount[key], "needed", IncubatorTable[key][2], ")")
					end
					Killcount[key] = nil
				end
			end
		end
		CurrentCombat[key] = nil
	end
	NeedTimers = 0
end

function Incubator:PeriodicHandler()
	local threshold = self.db.profile.barcount
	local ttime = GetTime()
	if BarCount < 0 then BarCount = 0 end
	local showthreshold = self.db.profile.maxshowtime
	if showthreshold == 0 then
		showthreshold = 999
	end
	local Timers = self:SortTimers2()
	for _, timerdata in pairs(Timers) do
		local name = timerdata.name
		local expiry = timerdata.time
		local warn = timerdata.warn
		local bar = timerdata.bar
		--[[ RunningTimers format is 
			RunningTimers[Timername]
				[1] = expiration time
				[2] = Warning needs to be given
				[3] = Bar needs to be started
				[4] = Unit ID
		]]-- 
		if ttime + 600 > expiry and warn and self.db.profile.developer then
			local remaining = floor(expiry - ttime)
			self:Print(name, "respawns in", remaining)
			RunningTimers[name][2] = false
		end
		if ttime + (60 * showthreshold) > expiry and bar and BarCount < threshold and (expiry - Lastexp) > (self.db.profile.timebetween * 60)  then
			self:RegisterCandyBar("Incubator-"..name, floor(expiry-ttime), name, nil, unpack(self.db.profile.baroptions.colors))
			self:RegisterCandyBarWithGroup("Incubator-"..name, anchor)
			self:SetCandyBarTexture("Incubator-"..name, media:Fetch("statusbar", Incubator.db.profile.baroptions.texture))
			self:SetCandyBarWidth("Incubator-"..name, Incubator.db.profile.baroptions.width)
			self:SetCandyBarHeight("Incubator-"..name, Incubator.db.profile.baroptions.height)
			self:SetCandyBarScale("Incubator-"..name, Incubator.db.profile.baroptions.scale)
			self:SetCandyBarOnClick("Incubator-"..name, function()
				self:OnBarClick(name)
			end)
			self:StartCandyBar("Incubator-"..name, true)
			RunningTimers[name][3] = false
			if self.db.profile.developer then
				self:Print(name, "is being flagged as starting a timer")
			end
			BarCount = BarCount + 1
			if Lastexp < expiry or Lastexp == 0 then Lastexp = expiry end
		end
		
		if ttime > expiry then self:ClearTimer(name) end
	end
	if not self:IsEventScheduled("IncubatorFubarUpdate") and self.db.profile.futext and Timers[1]  then  self:ScheduleRepeatingEvent("IncubatorFubarUpdate", IncubatorFuBar.UpdateText, 1, IncubatorFuBar) end
end

function Incubator:ConsoleRunning()
	for key, value in pairs(RunningTimers) do
		self:Print(key, (SecondsToTime(floor(value[1] - GetTime()))))
	end
end

function Incubator:OnBarClick(name)
	if self.db.profile.developer then
		self:Print("Caught mouseclick on", name)
	end
	if IsShiftKeyDown() then
		self:Print("Clearing timer", name)
		self:ClearTimer(name)
	else
		if UnitInRaid("player") == nil then
			SendChatMessage(name .. ": " .. self:FormatTime(floor(RunningTimers[name][1] - GetTime())), "PARTY")
		else
			SendChatMessage(name .. ": " .. self:FormatTime(floor(RunningTimers[name][1] - GetTime())), "RAID")
		end
	end
end

function Incubator:FormatTime(time)
	local STT =  string.gsub(SecondsToTime(time, Incubator.db.profile.precision), "|4", "")
	STT = string.gsub(STT, ":Hrs", "")
	STT = string.gsub(STT, ":Mins", "")
	STT = string.gsub(STT, ":Secs", "")
	STT = string.gsub(STT, ";", "")
	return STT
end

function Incubator:ClearTimer(name)
	if self.db.profile.developer then
		self:Print("Clear timer "..name)
	end
	if RunningTimers[name][1] == Lastexp then
		Lastexp = 0
	end
	RunningTimers[name] = nil
	if self:IsCandyBarRegistered("Incubator-"..name) then 
		self:StopCandyBar("Incubator-"..name) 
		BarCount = BarCount - 1
	end
	self:StopFutextUpdate()
	self:SaveTimers()
end

function Incubator:InCombat()
	if UnitAffectingCombat("player") == nil then
		if UnitInRaid("player") == nil then
			local n = GetNumPartyMembers()
			if n == 0 then
				return false
			else
				for i = 1, n do
					if UnitAffectingCombat("party" .. i) == 1 then
						return true
					end
				end
				return false
			end
		else
			local n = GetNumRaidMembers()
			for i = 1, n do
				if UnitAffectingCombat("raid" .. i) == 1 then
					return true
				end
			end
			return false
		end
	else
		return true
	end
end

function Incubator:IsRaidAlive()
	local count = 0
	if UnitInRaid("player") == nil then
		local n = GetNumPartyMembers()
		if UnitIsDeadOrGhost("player") == true then
			count = count + 1
		end
		if n ~= 0 then
			for i = 1, n do
				if UnitIsDeadOrGhost("party" .. i) == true or UnitIsConnected("party" .. i) ~= 1 then
					count = count + 1
				end
			end
		end
		if count == n + 1 then
			return false -- everyone is dead!
		else
			return true
		end
	else
		local n = GetNumRaidMembers()
		for i = 1, n do
			if UnitIsDeadOrGhost("raid" .. i) == true or UnitIsConnected("raid" .. i) ~= 1 then
				count = count + 1
			end
		end
		if count == n then
			return false
		else
			return true
		end
	end
end

function Incubator:OOCHandler()
	if not self:IsRaidAlive() then -- Boo wiping! Try harder!
		self:Print("Wipe detected, stopping processing")
		self:StopOOCHandler()
		self:EmptyCombatList()
	end
	if not Incubator:InCombat() and Incubator:IsRaidAlive() then
		if self.db.profile.developer then
			self:Print("The party/raid appears to be OOC")
		end
		LastOOC = GetTime()
		self:StopOOCHandler()
		self:TimerHandler()
	end
end

function Incubator:EmptyCombatList()
	if self.db.profile.developer then
		self:Print("Emptying Combat List")
	end
	for key, value in pairs(CurrentCombat) do
		CurrentCombat[key] = nil
	end
	for key, value in pairs(Killcount) do
		Killcount[key] = nil
	end
	NeedTimers = 0
end

function Incubator:ClearAll()
	if self.db.profile.developer then
		self:Print("Clear All timers")
	end
	for timername, timerlist in pairs (RunningTimers) do
		if timerlist[3] == false  then -- candybar was started on this one
			if self:IsCandyBarRegistered("Incubator-"..timername)  then
				self:StopCandyBar("Incubator-"..timername)
			end
		end
		RunningTimers[timername] = nil
	end
	BarCount = 0
	Lastexp = 0
	self:SaveTimers()
	self:StopFutextUpdate()
end

function Incubator:StopFutextUpdate()
	local istimer = self:SortTimers()
	if istimer[1] then return end
	if self.db.profile.futext then 
		 IncubatorFuBar:SetText("")
	 	 IncubatorFuBar:Update()
	 	 if self:IsEventScheduled("IncubatorFubarUpdate") then self:CancelScheduledEvent("IncubatorFubarUpdate") end
	end
end

function Incubator:TimeDiff(time1, time2) -- time1 is saved time, time2 is current time
	local hours1, hours2, min1, min2, sec1, sec2, day1, day2, total1, total2, timediff
   
	if time1 and time2 then
		local _, _,  day1, hours1, min1, sec1 = string.find(time1, "%d+/(%d+)/%d+ (%d+):(%d+):(%d+)")
		local _, _,  day2, hours2, min2, sec2 = string.find(time2, "%d+/(%d+)/%d+ (%d+):(%d+):(%d+)")
		--DEFAULT_CHAT_FRAME:AddMessage("d"..day1.."h"..hours1.."m"..min1.."s"..sec1)
		total1 = ((( hours1 * 60 ) + min1) *60) + sec1
		total2 = ((( hours2 * 60 ) + min2) *60) + sec2
		if day2 ~= day1 then
			if day2 > day1 then total2 = total2 + 86400 
			else total1 = total1 + 86400 end
		end
    		timediff = total2 - total1
    		if self.db.profile.developer then
			self:Print("Time difference = "..(timediff or "nil"))
		end
		return timediff
    	end
    	return 0
end   

function Incubator:SaveTimers()
	local temp = {}
	local currtime = GetTime()
	for timername, timerlist in pairs (RunningTimers) do
		temp[timername] = {}
		temp[timername][1] =  timerlist[1]  - currtime
		temp[timername][4] = timerlist[4]
	end
	self.db.profile.timers = temp
	self.db.profile.timestamp =  date("%m/%d/%y %H:%M:%S")
end
