local Dewdrop = AceLibrary("Dewdrop-2.0")
local L = AceLibrary("AceLocale-2.2"):new("IncomingHeals")

IncomingHeals.options = {
	type = "group",
	args = {
		[L["users"]] = {
			type = "execute",
			name = L["Show known users"],
			desc = L["Shows who is using IncomingHealsLib and who is not"],
			func = function() IncomingHeals:ShowKnownUsers() end,
		},
		[L["reset"]] = {
			type = "execute",
			name = L["Reset visuals"],
			desc = L["Resets everything in case something messed up"],
			func = function()
				local IHL = AceLibrary("IncomingHealsLib-1.0")
				IHL:Reset()
				IncomingHeals:ResetVisuals()
			end,
		},
		[L["checkheals"]] = {
			type = "toggle",
			name = L["Check heals"],
			desc = L["Shows heal as calculated by IncomingHealsLib when you cast a spell"],
			get = function() return IncomingHeals.db.profile.checkheals end,
			set = function(v)
				IncomingHeals.db.profile.checkheals = v
				local IHL = AceLibrary("IncomingHealsLib-1.0")
				IHL.checkheals = v
			end,
		},
		[L["newgraph"]] = {
			type = "execute",
			name = L["Create new graph"],
			desc = L["Creates a new graph"],
			func = function()
				IncomingHeals.Graph:new()
			end,
		},
	}
}

IncomingHeals.Graph.options = {
	type = "group",
	args = {
		unit = {
			name = L["Target"],
			desc = L["Target"],
			type = "group",
			order = 1,
			args = {
				target = {
					type = "toggle",
					name = L["My target"],
					desc = L["Shows heals incoming to your target."],
					order = 1,
					get = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType == "target"
					end,
					set = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						frame.graph:SetTargetType("target")
					end,
				},
				heal = {
					type = "toggle",
					name = L["My heal's target"],
					desc = L["Shows heals incoming to your heal's target."],
					order = 2,
					get = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType == "heal"
					end,
					set = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						frame.graph:SetTargetType("heal")
					end
				},
				targetting = {
					name = "  "..L["Target-control"],
					desc = L["When not casting a heal..."],
					type = "group",
					order = 3,
					disabled = function()
						-- Why do we check this each time? :-S
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType ~= "heal"
					end,
					args = {
						keepnewtarget = {
							type = "toggle",
							name = L["Keep"],
							desc = L["Keep your last target."],
							order = 1,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return not frame.graph.db.targetting
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph.db.targetting = nil
							end,
						},
						restoretarget = {
							type = "toggle",
							name = L["Restore"],
							desc = L["Change back to your current target."],
							order = 2,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetting == "restore"
							end,
							set = function(v)
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph.db.targetting = v and "restore"
							end,
						},
						followmouseover = {
							type = "toggle",
							name = L["Follow mouseover"],
							desc = L["Follow the target you mouseover."],
							order = 3,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetting == "mouseover"
							end,
							set = function(v)
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph.db.targetting = v and "mouseover"
								if v then frame.graph:SetTargetType("heal") end
							end,
						},
					},
				},
				byname = {
					type = "toggle",
					name = L["Fix to my current target"],
					desc = L["Will always show heals for the same target, until you change it."],
					order = 3,
					get = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType == "fixed"
					end,
					set = function(v)
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						frame.graph:SetTargetByName(UnitName("target"))
					end
				},
				unitid = {
					type = "text",
					name = L["Unit ID"],
					desc = L["Shows heals for the unit with this ID."],
					usage = "a valid unit ID",
					order = 4,
					get = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType
					end,
					set = function(v)
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						frame.graph:SetTargetType(v)
					end
				},
				player = {
					type = "toggle",
					name = L["Player"],
					desc = L["Shows heals incoming to you."],
					order = 5,
					get = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType == "player"
					end,
					set = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						frame.graph:SetTargetType("player")
					end,
				},
				pet = {
					type = "toggle",
					name = L["Pet"],
					desc = L["Shows heals incoming to your pet."],
					order = 6,
					get = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType == "pet"
					end,
					set = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						frame.graph:SetTargetType("pet")
					end,
				},
				focus = {
					type = "toggle",
					name = L["My focus"],
					desc = L["Shows heals incoming to your focus."],
					order = 7,
					get = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						return frame.graph.db.targetType == "focus"
					end,
					set = function()
						local frame = Dewdrop:GetOpenedParent()
						if not frame then return false end
						frame.graph:SetTargetType("focus")
					end
				},
				party = {
					name = L["Party"],
					desc = L["Party"],
					type = "group",
					order = 8,
					args = {
						party1 = {
							type = "toggle",
							name = L["Party"].." 1",
							desc = L["Shows heals incoming to party member"].." 1.",
							order = 1,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "party1"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("party1")
							end,
						},
						party2 = {
							type = "toggle",
							name = L["Party"].." 2",
							desc = L["Shows heals incoming to party member"].." 2.",
							order = 2,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "party2"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("party2")
							end,
						},
						party3 = {
							type = "toggle",
							name = L["Party"].." 3",
							desc = L["Shows heals incoming to party member"].." 3.",
							order = 3,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "party3"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("party3")
							end,
						},
						party4 = {
							type = "toggle",
							name = L["Party"].." 4",
							desc = L["Shows heals incoming to party member"].." 4.",
							order = 4,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "party4"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("party4")
							end,
						},
						partypet1 = {
							type = "toggle",
							name = L["Party Pet"].." 1",
							desc = L["Shows heals incoming to the pet of party member"].." 1.",
							order = 5,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "partypet1"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("partypet1")
							end,
						},
						partypet2 = {
							type = "toggle",
							name = L["Party Pet"].." 2",
							desc = L["Shows heals incoming to the pet of party member"].." 2.",
							order = 6,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "partypet2"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("partypet2")
							end,
						},
						partypet3 = {
							type = "toggle",
							name = L["Party Pet"].." 3",
							desc = L["Shows heals incoming to the pet of party member"].." 3.",
							order = 7,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "partypet3"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("partypet3")
							end,
						},
						partypet4 = {
							type = "toggle",
							name = L["Party Pet"].." 4",
							desc = L["Shows heals incoming to the pet of party member"].." 4.",
							order = 8,
							get = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								return frame.graph.db.targetType == "partypet4"
							end,
							set = function()
								local frame = Dewdrop:GetOpenedParent()
								if not frame then return false end
								frame.graph:SetTargetType("partypet4")
							end,
						},
					}
				},
			}
		},
		hide = {
			type = "toggle",
			name = L["Hide when no target"],
			desc = L["Hides when you don't have a target/focus or the fixed target cannot be found."],
			order = 2,
			get = function()
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				return frame.graph.db.hide
			end,
			set = function(v)
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				frame.graph:SetHide(v)
			end,
		},
		hidesolo = {
			type = "toggle",
			name = L["Hide out of group"],
			desc = L["Hides when you are not in a party or raid or battlegroup"],
			order = 3,
			get = function()
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				return frame.graph.db.hidesolo
			end,
			set = function(v)
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				frame.graph:SetHideSolo(v)
			end,
		},
		hidenumbers = {
			type = "toggle",
			name = L["Hide numbers"],
			desc = L["Hides the numbers showing missing life and missing life + incoming heals."],
			order = 3,
			get = function()
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				return frame.graph.db.hidenumbers
			end,
			set = function(v)
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				frame.graph:SetHideNumbers(v)
			end,
		},
		hidename = {
			type = "toggle",
			name = L["Hide name"],
			desc = L["Hides the name of the unit."],
			order = 3,
			get = function()
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				return frame.graph.db.hidename
			end,
			set = function(v)
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				frame.graph:SetHideName(v)
			end,
		},
		remove = {
			type = "execute",
			name = L["Remove this graph"],
			desc = L["Removes this graph from existence."],
			order = 4,
			func = function()
				local frame = Dewdrop:GetOpenedParent()
				if not frame then return false end
				frame.graph:Remove()
			end,
		},
	}
}