local AceOO = AceLibrary("AceOO-2.0")
local Dewdrop = AceLibrary("Dewdrop-2.0")
local IHL = AceLibrary("IncomingHealsLib-1.0")
local PLAYERNAME = UnitName("player")





local GRAPH_MINWIDTH = 60
local GRAPH_MINHEIGHT = 40
local BAR_MAXHEAL = 6000
local BAR_WIDTH = 5
local BAR_MAXHOT = 6000

local IsCasting
local Castingtarget

local colors = IncomingHeals.COLORS
local pairs = pairs

-- Doing this for now 'cos healing/casting data isn't available yet from IncomingHealsLib on UNIT_SPELLCAST_SENT
local directHealsCache = {
	["Flash Heal"] = 1,
	["Heal"] = 1,
	["Greater Heal"] = 1,
	["Prayer of Healing"] = 1,
	["Binding Heal"] = 1,
	["Regrowth"] = 1,
	["Healing Touch"] = 1,
	["Tranquility"] = 1,
	["Holy Light"] = 1,
	["Flash of Light"] = 1,
	["Lesser Healing Wave"] = 1,
	["Healing Wave"] = 1,
	["Chain Heal"] = 1,
}

local events = {
	target = {
		{"PLAYER_TARGET_CHANGED", "Update"},
		enabled = false,
	},
	focus = {
		{"PLAYER_FOCUS_CHANGED", "Update"},
		enabled = false,
	},
	heal = {
		"UNIT_SPELLCAST_SENT",
		"UNIT_SPELLCAST_STOP",
		{"UNIT_SPELLCAST_START", "Update"},
		{"UNIT_SPELLCAST_FAILED", "UNIT_SPELLCAST_STOP"},
		{"UNIT_SPELLCAST_INTERRUPTED", "UNIT_SPELLCAST_STOP"},
		enabled = false,
	},
	mouseover = {
		{"PLAYER_REGEN_ENABLED", "ScheduleRepeatingEventSlow"},
		{"PLAYER_REGEN_DISABLED", "ScheduleRepeatingEventFast"},
		"ScheduleRepeatingEvent",
		enabled = false,
	},
	party = {
		{"PARTY_MEMBERS_CHANGED", "Update"},
		enabled = false,
	},
	raid = {
		{"RAID_ROSTER_UPDATE", "Update"},
		enabled = false,
	},
	hidesolo = {
		{"PARTY_MEMBERS_CHANGED", "Update"},
		{"RAID_ROSTER_UPDATE", "Update"},
		enabled = false,
	},
}






------------------------------
--      Initialization      --
------------------------------

local Graph = AceOO.Class("AceEvent-2.0")
Graph.graphs = { }
Graph.nextid = 1

function Graph.Initialize()
  local graphsdata = IncomingHeals.db.profile.graphs

	local maxid = 1
	for id, _ in pairs(graphsdata) do
	  maxid = max(maxid, id)
		Graph:new(id)
	end
	Graph.nextid = maxid + 1

	setmetatable(graphsdata, { __index = function(self, key)
		local t = {
			left = 200,
			bottom = 400,
			width = 120,
			height = 80,
			targetType = "target",
			targetName = 0,
			hide = false,
			hidesolo = false,
			hidename = false,
			hidenumbers = false,
		}
		self[key] = t
		return t
	end})
end

function Graph.prototype:init(id)
	Graph.super.prototype.init(self)

	if not id then
		id = Graph.nextid
		Graph.nextid = Graph.nextid + 1
	end
	self.id = id
	Graph.graphs[id] = self

	self.db = IncomingHeals.db.profile.graphs[id]

	self.lastupdate = 0
	self.barsByName = { }
	self.unusedBars = { }

	local f = CreateFrame("Frame", "IH_Graph"..self.id, UIParent)
	self.frame = f
	f.graph = self

	f:SetMovable(true)
	f:SetResizable(true)
	f:SetMinResize(GRAPH_MINWIDTH, GRAPH_MINHEIGHT)
	f:SetClampedToScreen(true)
	f:SetFrameStrata("BACKGROUND")

	f:EnableMouse(true)
	f:SetScript("OnMouseUp", Graph.FrameOnMouseUp)
	f:SetScript("OnMouseDown", Graph.FrameOnMouseDown)
	f:SetScript("OnHide", Graph.FrameOnHide)
	f:SetScript("OnUpdate", Graph.FrameOnUpdate)
	f:SetBackdrop(BackdropEmptyBlack)
	f:SetBackdropColor(0, 0, 0, 0.90)

	f.name = f:CreateFontString(nil, "OVERLAY")
	f.name:SetFontObject(GameFontNormal)
	f.name:SetJustifyH("CENTER")
	f.name:SetJustifyV("TOP")
	f.name:SetPoint("TOP", f, "TOP", 0, 0);
	f.name:SetText("Playername")
	f.name:SetHeight(15)

	f.missingBefore = f:CreateFontString(nil, "OVERLAY")
	f.missingBefore:SetFontObject(GameFontNormal)
	f.missingBefore:SetJustifyH("RIGHT")
	f.missingBefore:SetJustifyV("TOP")
	f.missingBefore:SetPoint("TOPLEFT", f, "TOPLEFT", -5, 0);
	f.missingBefore:SetWidth(40)
	f.missingBefore:SetText("-5700")

	f.missingAfter = f:CreateFontString(nil, "OVERLAY")
	f.missingAfter:SetFontObject(GameFontNormal)
	f.missingAfter:SetJustifyH("RIGHT")
	f.missingAfter:SetJustifyV("TOP")
	f.missingAfter:SetPoint("TOPRIGHT", f, "TOPRIGHT", -2, 0);
	f.missingAfter:SetWidth(40)
	f.missingAfter:SetText("-1600")
	f:Show()

	f.hot = CreateFrame("Frame", nil, f)
	f.hot:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", 0, 0)
	f.hot:SetPoint("RIGHT", f, "RIGHT", 0, 0)
	f.hot:SetBackdrop(BackdropEmptyBlack)
	f.hot:SetBackdropColor(0, 0, 0, 1)
	f.hot:SetFrameStrata("BACKGROUND")


	self:RestorePosition()

	Dewdrop:Register(f, "children", Graph.options, "dontHook", true, "cursorX", true, "cursorY", true, "point", "TOPLEFT")

	if self.db.targetType == "fixed" then
		self:SetTargetByName(self.db.targetName)
	else
		self:SetTargetType(self.db.targetType)
	end

	self:SetHideSolo(self.db.hidesolo)
	self:SetHideNumbers(self.db.hidenumbers)
	self:SetHideName(self.db.hidename)
	self:SetHide(self.db.hide)
end

-- Dunno if this actually made the code any cleaner...
function Graph.prototype:EventRegistering(key, action)
	key = key:sub(1, 5) == "party" and "party" or key:sub(1, 4) == "raid" and "raid" or key

	-- This'll look a bit backwards...
	if action and events[key]["enabled"] then
		action = "UnregisterEvent"
	elseif not action and not events[key]["enabled"] then
		action = "RegisterEvent"
	else
		return
	end

	for _, v in pairs(events[key]) do
		if v ==  "ScheduleRepeatingEvent" then
			if action == "UnregisterEvent" and self:IsEventScheduled("IHGraphMouseOver") then
				self:CancelScheduledEvent("IHGraphMouseOver")
			else
				self:ScheduleRepeatingEventSlow()
			end
		elseif type(v) ~= "boolean" then
				self[action](self, v[1] and v[1] or v, v[2] and action == "RegisterEvent" and v[2] or nil)
		end
	end
	if key == "heal" and self.db.targetting == "mouseover" then
		self:EventRegistering("mouseover", action == "Register" or false)
	end
	events[key]["enabled"] = action == "Register" or false
end

function Graph.prototype:UNIT_SPELLCAST_SENT(from, spell, rank, to)
	if from == "player" and directHealsCache[spell] then
		IsCasting = true
		Castingtarget = to
		self:Update()
	end
end

function Graph.prototype:UNIT_SPELLCAST_STOP(from)
	if from == "player" and IsCasting then
		IsCasting = false
	end
end

-- Figure out a prettier way
function Graph.prototype:ScheduleRepeatingEventFast()
	self:ScheduleRepeatingEvent("IHGraphMouseOver", self.MouseOverOnUpdate, 0.2, self)
end

function Graph.prototype:ScheduleRepeatingEventSlow()
	self:ScheduleRepeatingEvent("IHGraphMouseOver", self.MouseOverOnUpdate, 1, self)
end

do
	local frame, frameName, currentFrame, unit, unitName
	local GetMouseFocus = GetMouseFocus

	function Graph.prototype:MouseOverOnUpdate()
		if IsCasting then return end

		frame = GetMouseFocus()
		frameName = frame and frame:GetName() or nil

		if not frame or frame:GetName() == "WorldFrame" then return end

		-- Special case where ToT needs to be checked
		if (unit and unit == "targettarget" and unitName and unitName ~= UnitName(unit)) or frameName ~= currentFrame then
		else return end

		currentFrame = frameName
		unit = frame:GetAttribute("unit")
		if unit ~= nil then
			unitName = UnitName(unit)
			self.unitid = unit
			self:Update()
		end
	end
end



















------------------------------
--      Setting target      --
------------------------------

function Graph.prototype:SetTargetType(target)
	local oldTarget = self.db.targetType
	self.db.targetType = target
	self.db.targetName = nil

	self:EventRegistering(oldTarget, true)
	self:EventRegistering(target)

	self:Update()
end

function Graph.prototype:SetTargetByName(unitname)
	if unitname then
		self.db.targetName = unitname
		self.db.targetType = "fixed"
		self:Update()
	end
end

function Graph.prototype:GetCurrentUnit()
	if self.db.targetType == "fixed" then
		return self.db.targetName
	elseif self.db.targetType == "heal" then
		if self.db.targetting == "mouseover" and not IsCasting then
			return self.unitid and UnitName(self.unitid) or self.unitname
		end
		local cs = IHL:GetCastingInfo(PLAYERNAME)
		if cs then
			if cs.spell.target == "party" then
				if self.unitname and cs.targets[self.unitname] then
					return self.unitname
				elseif UnitName("target") and cs.targets[UnitName("target")] then
					return UnitName("target")
				else
					return self.unitname
				end
			else
				return cs.target
			end
		elseif IsCasting and Castingtarget then
			return Castingtarget
		else
			if self.db.targetting == "restore" then
				return UnitName("target")
			else
				return self.unitname
			end
		end
	else
		return UnitName(self.db.targetType)
	end
end
























------------------------------
--      Visuals             --
------------------------------

do
	local class, color, unitname, unitid, r, g, b

	function Graph.prototype:Update()
		unitname = self:GetCurrentUnit()
		unitid = IHL:GetUnitIDFromName(unitname)
		self.unitname = unitname
		self.unitid = unitid
	
		if self.frame:IsShown() and self.db.hide or (self.db.hidesolo and GetNumPartyMembers() == 0 and GetNumRaidMembers() == 0) then
			self.frame:Hide()
			self:EventRegistering(self.db.targetType, true)
		elseif not self.frame:IsShown() then
			self.frame:Show()
			self:EventRegistering(self.db.targetType)
		end


		self:UpdateBars(true)

		-- unit name
		self.frame.name:SetText(unitname)
		self.frame.name:SetWidth(self.frame:GetWidth() - 75)


		if unitid then
			-- class color
			class = select(2, UnitClass(unitid))
			color = RAID_CLASS_COLORS[class]
			if not color then color = colors.white end
			self.frame.name:SetTextColor(color.r, color.g, color.b)
			
			-- text on the left
			r, g, b = IncomingHeals:MixColors(colors.red, colors.green, UnitHealth(unitid) / UnitHealthMax(unitid))
			self.frame.missingBefore:SetText(UnitHealth(unitid) - UnitHealthMax(unitid))
			self.frame.missingBefore:SetTextColor(r, g, b, 1)
			
			-- text on the right
			if UnitHealthMax(unitid) == 100 then
				self.frame.missingAfter:SetText(floor(self.amount))
				self.frame.missingAfter:SetTextColor(colors.white.r, colors.white.g, colors.white.b, 1)
			else
				r, g, b = IncomingHeals:MixColors(colors.red, colors.green, (UnitHealth(unitid) + self.amount) / UnitHealthMax(unitid))
				self.frame.missingAfter:SetText(floor(UnitHealth(unitid) + self.amount - UnitHealthMax(unitid)))
				self.frame.missingAfter:SetTextColor(r, g, b, 1)
			end
		else
			self.frame.name:SetTextColor(1, 1, 1)
			self.frame.missingBefore:SetText("")
			if unitname then
				self.frame.missingAfter:SetText(floor(self.amount))
				self.frame.missingAfter:SetTextColor(colors.white.r, colors.white.g, colors.white.b, 1)
			else
				self.frame.name:SetText("<none>")
				self.frame.missingAfter:SetText("")
			end
		end

		-- Background color
		if self.myamount > 0 then
			r, g, b = IncomingHeals:MixColors(colors.black, colors.myoverheal, self.myoverheal / self.myamount / 4)
		elseif self.myres then
			if self.myoverres then
				color = colors.myoverres
			else
				color = colors.myres
			end
			r, g, b = color.r, color.g, color.b
		else
			color = colors.black
			r, g, b = color.r, color.g, color.b
		end

		self.frame:SetBackdropColor(r, g, b, 0.80)

		-- HoTs
		local hottick, myhottick = IHL:GetTargetRunningHotInfo(unitname)
		if hottick == 0 then
			self.frame.hot:Hide()
		else
			if myhottick > 0 then
				r, g, b = IncomingHeals:MixColors(colors.black, colors.myhot, 0.25)
			else
				r, g, b = IncomingHeals:MixColors(colors.black, colors.hot, 0.25)
			end
			self.frame.hot:SetHeight(min(hottick, BAR_MAXHOT) / BAR_MAXHOT * (self.frame:GetHeight() - 10))
			self.frame.hot:SetBackdropColor(r, g, b, 1)
			self.frame.hot:Show()
		end
	end
end

do
	local unitname, unitid, amount, overheal, myamount, myoverheal

	function Graph.prototype:UpdateBars(force)
		if self.lastupdate + 0.01 > GetTime() and not force then return end
		self.lastupdate = GetTime()

		unitname, unitid = self.unitname, self.unitid
		amount, overheal, myamount, myoverheal = IHL:GetTargetIncomingHealInfo(unitname)

		self.amount = amount
		self.overheal = overheal
		self.myamount = myamount
		self.myoverheal = myoverheal

		for _, bar in pairs(self.barsByName) do
			bar:Hide()
		end

		local r, g, b = 1, 1, 1
		local barmaxtime = 3

		if unitid and (UnitIsDeadOrGhost(unitid) or not UnitIsConnected(unitid)) then
			barmaxtime = 10
		end

		-- Heals
		for source, ch in pairs(IHL.castingHeals) do
			if ch.targets[unitname] and ch.endtime > GetTime() then
				if ch.spell.type ~= "channel" then
					if source == PLAYERNAME then
						r, g, b = IncomingHeals:MixColors(colors.myheal, colors.myoverheal, myoverheal / myamount)
					else
						local color = colors.heal
						r, g, b = color.r, color.g, color.b
					end
	
				self:AddBar(source, min(BAR_MAXHEAL, ch.amount) / BAR_MAXHEAL, (ch.endtime - GetTime()) / barmaxtime, r, g, b)
				end
			end
		end

		-- Resses
		local incresses, myres, myoverres = IHL:GetTargetIncomingResInfo(unitname)
		for source, cr in pairs(IHL.castingResses) do
			if cr.target == unitname and cr.endtime > GetTime() then
				local color = colors.res
				if source == PLAYERNAME then
					if myoverres then barcolor = colors.myoverres
					else barcolor = colors.myres end
				end
	
				self:AddBar(source, 0.5, (cr.endtime - GetTime()) / barmaxtime, color.r, color.g, color.b)
			end
		end

		-- Put unused bars in the dustbin
		for _, bar in pairs(self.barsByName) do
			if not bar:IsVisible() and not bar.industbin then
				table.insert(self.unusedBars, bar)
				if self.barsByName[bar.source] == bar then -- should not be possible, but I prefer an if over an assert :)
					self.barsByName[bar.source] = nil
				end
			end
		end
	end
end

function Graph.prototype:AddBar(source, height, bartime, r, g, b)
	-- Find a usable bar (or create one)
	local bar = self.barsByName[source]
	if not bar then
		bar = table.remove(self.unusedBars)
		if not bar then
			bar = CreateFrame("Frame", nil, self.frame)
			bar:SetWidth(BAR_WIDTH)
			bar:SetBackdrop(BackdropEmptyBlack)
			bar:SetFrameStrata("LOW")
		end
		bar.industbin = false
		bar.source = source
		self.barsByName[source] = bar
	end

	-- Set bar height, position, color
	bar:ClearAllPoints()
	bar:SetPoint("BOTTOMLEFT", self.frame, "BOTTOMLEFT", bartime * self.frame:GetWidth(), 0)
	bar:SetHeight(height * (self.frame:GetHeight() - 10))
	bar:SetBackdropColor(r, g, b, 1)
	bar:Show()
end



























------------------------------
--     Moving, Resizing     --
------------------------------

function Graph.FrameOnUpdate(f)
	f.graph:UpdateBars()
end

function Graph.FrameOnMouseUp(f)
	if f.isMoving or f.isSizing then
		f:StopMovingOrSizing()
		f.isMoving = false
		f.isSizing = false
		f.graph:Update()
		f.graph:SavePosition()
	end
end

function Graph.FrameOnMouseDown(f, button)
	if not f.isLocked and button == "LeftButton" and IsControlKeyDown() then
		f:StartMoving()
		f.isMoving = true
	end
	if not f.isLocked and button == "RightButton" and IsControlKeyDown() then
		f:StartSizing()
		f.isSizing = true
	end
	if not IsControlKeyDown() and button == "RightButton" then
		Dewdrop:Open(f)
	end
end

function Graph.FrameOnHide(f)
	if f.isMoving or f.isSizing then
		f:StopMovingOrSizing()
		f.isMoving = false
		f.isSizing = false
	end
end

function Graph.prototype:SavePosition()
	self.db.left = self.frame:GetLeft()
	self.db.bottom = self.frame:GetBottom()
	self.db.width = self.frame:GetWidth()
	self.db.height = self.frame:GetHeight()
end

function Graph.prototype:RestorePosition()
	self.frame:ClearAllPoints()
	self.frame:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", self.db.left, self.db.bottom)
	self.frame:SetWidth(self.db.width)
	self.frame:SetHeight(self.db.height)
end

function Graph.prototype:SetHide(v)
	self.db.hide = v
	self:Update()
end

function Graph.prototype:SetHideSolo(v)
	self.db.hidesolo = v
	self:EventRegistering("hidesolo", not v)
	self:Update()
end

function Graph.prototype:SetHideNumbers(v)
	self.db.hidenumbers = v
	if v then
		self.frame.missingBefore:Hide()
		self.frame.missingAfter:Hide()
	else
		self.frame.missingBefore:Show()
		self.frame.missingAfter:Show()
	end
	self:Update()
end

function Graph.prototype:SetHideName(v)
	self.db.hidename = v
	if v then
		self.frame.name:Hide()
	else
		self.frame.name:Show()
	end
	self:Update()
end

function Graph.prototype:Remove()
	local graphsdata = IncomingHeals.db.profile.graphs
	rawset(graphsdata, self.id, nil)
	Graph.graphs[self.id] = nil
	Dewdrop:Close()
	self.frame:SetScript("OnMouseUp", nil)
	self.frame:SetScript("OnMouseDown", nil)
	self.frame:SetScript("OnHide", nil)
	self.frame:SetScript("OnUpdate", nil)
	self.frame:Hide() -- not bothering recycling these, won't be loaded on UI reload anyway
	self:UnregisterAllEvents()
end



IncomingHeals.Graph = Graph