
--------------------------
--     REPORT FRAME     --
--------------------------


-- Create module table
InTheBuff.Report = { };
local Report = InTheBuff.Report;

-- Color constants
Report.colors = { };
Report.colors.GREY	= "888888";
Report.colors.GREEN	= "00FF00";
Report.colors.YELLOW	= "FFFF00";
Report.colors.RED	= "FF0000";

-- Icon constants
Report.icons = { };
Report.icons["?"] = "Interface\\Icons\\INV_Misc_QuestionMark";
Report.icons["Hybrid"] = "Interface\\Icons\\Spell_Nature_ElementalAbsorption";
Report.icons["B"] = "Interface\\Icons\\Spell_Holy_WordFortitude";
Report.icons["D"] = "Interface\\Icons\\Ability_Warrior_Sunder";

-- Initialize the report frame
function Report:InitializeFrame()

	-- Create the frame, store local reference
	local f = GameFontNormal:GetFont();
	local frame = CreateFrame("Frame", "InTheBuffReportFrame", UIParent);
	tinsert(UISpecialFrames, "InTheBuffReportFrame");
	self.frame = frame;

	local FrameWidth = 520;
	
	-- Set the frame up
	frame:Hide();
	frame:SetWidth(FrameWidth);
	frame:SetHeight(460);
	frame:EnableMouse(true);
	frame:SetMovable(true);
	frame:RegisterForDrag("LeftButton");
	frame:SetScript("OnDragStart", function() this:StartMoving() end);
	frame:SetScript("OnDragStop", function() this:StopMovingOrSizing() end);
	frame:SetBackdrop({
		bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background", tile = true, tileSize = 16,
		edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,
		insets = {left = 4, right = 4, top = 4, bottom = 4},
	});
	frame:SetBackdropBorderColor(.5, .5, .5);
	frame:SetBackdropColor(0, 0, 0);
	frame:ClearAllPoints();
	frame:SetPoint("CENTER", UIParent, "CENTER", 0, 0);
	
	-- Gradient background
	local rfade = frame:CreateTexture(nil, "BORDER");
	rfade:SetWidth(514);
	rfade:SetHeight(25);
	rfade:SetTexture("Interface\\ChatFrame\\ChatFrameBackground");
	rfade:SetPoint("TOP", frame, "TOP", 0, -4);
	rfade:SetBlendMode("ADD");
	rfade:SetGradientAlpha("VERTICAL", .1, .1, .1, 0, .25, .25, .25, 1);
	
	-- Title
	local header = frame:CreateFontString(nil,"OVERLAY");
	header:SetFont(f, 14);
	header:SetWidth(FrameWidth);
	header:SetText("InTheBuff");
	header:SetTextColor(1, .8, 0);
	header:ClearAllPoints();
	header:SetPoint("TOP", frame, "TOP", 0, -10);
	frame.header = header;
	
	-- Create individual report frames
	frame.effects = nil;
	frame.effects = { };
	
	local function CreateEffectReportFrame(id, textstring, size, icontype)

	        if not size then
		   size = 12;
		end

		local effect = CreateFrame("Frame", frame:GetName().."Effect"..id, frame);
		--effect:Hide();
		effect:SetWidth(220);
		effect:SetHeight(16);
		effect:EnableMouse(true);
		effect:SetScript("OnEnter", function () Report:ReportEffectTooltip(id, textstring); end);
		effect:SetScript("OnLeave", function () GameTooltip:Hide(); end);
		effect:ClearAllPoints();

		if icontype then		
		   local icon = effect:CreateTexture();
		   icon:SetWidth(16);
		   icon:SetHeight(16);
		   icon:SetPoint("LEFT", effect, "LEFT");
		   icon:SetTexture(self.icons["?"]);
		   effect.typeicon = icon;
		end
		
		local text = effect:CreateFontString(nil, "OVERLAY");
		text:SetFont(f, size);
		text:SetWidth(200);
		text:SetHeight(14);
		text:SetJustifyV("CENTER");
		text:SetJustifyH("LEFT");

		-- if we don't have an icon, flush left
		if not icontype then
		   text:SetPoint("LEFT", effect, "LEFT");
		else
		   text:SetPoint("LEFT", effect.typeicon, "RIGHT", 5, 0);
		end

		text:SetText(textstring);
		effect.text = text;
		
		frame.effects[id] = effect;
		
		return effect;
		
	end

	local results = InTheBuff.results;
	local buffs = InTheBuff.buffcategories;

	local id = 1;
	local output = { };

	-- ------------
	-- First column

	CreateEffectReportFrame(1, "Physical", 16, nil):SetPoint("TOPLEFT", frame, "TOPLEFT", 30, -30);
	-- hardcoded for now; generate number dynamically later
	for id = 2, 9 do
	    CreateEffectReportFrame(id, "effect"..id, 12,  "?"):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -1);
	end

	id = 10;    
	CreateEffectReportFrame(id, "Stats", 16, nil):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -10);
	-- hardcoded for now; generate number dynamically later
	for id = 11, 19 do
	    CreateEffectReportFrame(id, "effect"..id, 12,  "?"):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -1);
	end

	-- ------------
	-- Second column

	id = 20;
	CreateEffectReportFrame(id, "Magical", 16, nil):SetPoint("TOPLEFT", frame.effects[1], "TOPRIGHT", 10, 0);
	-- hardcoded for now; generate number dynamically later
	for id = 21, 26 do
	    CreateEffectReportFrame(id, "effect"..id, 12,  "?"):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -1);
	end

	id = 27;
	CreateEffectReportFrame(id, "All Roles", 16, nil):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -10);
	-- hardcoded for now; generate number dynamically later
	for id = 28, 31 do
	    CreateEffectReportFrame(id, "effect"..id, 12,  "?"):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -1);
	end

	id = 32;
	CreateEffectReportFrame(id, "Mob Debuff", 16, nil):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -10);
	-- hardcoded for now; generate number dynamically later
	for id = 33, 38 do
	    CreateEffectReportFrame(id, "effect"..id, 12,  "?"):SetPoint("TOPLEFT", frame.effects[id-1], "BOTTOMLEFT", 0, -1);
	end

	-- Totals summary information

	local totalsframe = CreateFrame("Frame", frame:GetName().."Totals", frame);
	totalsframe:SetWidth(FrameWidth);
	totalsframe:SetHeight(32);
	totalsframe:EnableMouse(true);
	totalsframe:SetScript("OnEnter", function () Report:ReportTooltip(totalsframe); end);
	totalsframe:SetScript("OnLeave", function () GameTooltip:Hide(); end);
	totalsframe:ClearAllPoints();
	totalsframe:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 0, 50);

	local totalstext = totalsframe:CreateFontString(nil, "OVERLAY");
	totalstext:SetFont(f, 14);
	totalstext:SetWidth(FrameWidth);
	totalstext:SetHeight(30);
	totalstext:SetJustifyV("CENTER");
	totalstext:SetJustifyH("CENTER");
	totalstext:SetPoint("LEFT", totalsframe, "LEFT");
	totalstext:SetText("Totals");

	totalsframe.text = totalstext;
	frame.totalsframe = totalsframe;


	-- Close button
	local closebutton = CreateFrame("Button", nil, frame);
	closebutton.owner = self;
	closebutton:SetWidth(125);
	closebutton:SetHeight(32);
	closebutton:SetPoint("BOTTOM", frame, "BOTTOM", 0, 10);
	frame.closebutton = closebutton;
	
	local t = closebutton:CreateTexture();
	t:SetWidth(125);
	t:SetHeight(32);
	t:SetPoint("CENTER", closebutton, "CENTER");
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Up");
	t:SetTexCoord(0, 0.625, 0, 0.6875);
	closebutton:SetNormalTexture(t);
	
	t = closebutton:CreateTexture(nil, "BACKGROUND");
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Down");
	t:SetTexCoord(0, 0.625, 0, 0.6875);
	t:SetAllPoints(closebutton);
	closebutton:SetPushedTexture(t);
	
	t = closebutton:CreateTexture();
	t:SetTexture("Interface\\Buttons\\UI-Panel-Button-Highlight");
	t:SetTexCoord(0, 0.625, 0, 0.6875);
	t:SetAllPoints(closebutton);
	t:SetBlendMode("ADD");
	closebutton:SetHighlightTexture(t);
	
	local closebuttontext = closebutton:CreateFontString(nil,"OVERLAY");
	closebuttontext:SetFontObject(GameFontHighlight);
	closebuttontext:SetText("Close");
	closebuttontext:SetAllPoints(closebutton);
	
	frame.closebutton:SetScript("OnClick", function() frame:Hide(); end);
	
end

function Report:UpdateReport()

	-- abort if still scanning
	if InTheBuff.Scan.scanning then return; end

	local scan = InTheBuff.Scan;
        local results = InTheBuff.results;
        local buffs = InTheBuff.buffcategories;


	local function ExtractNames(buffs, results)
	      local output = { };
	      local textstring = "";
	      local poststring = "";

	      -- Iterate through all buffs
	      for _, catbuffs in pairs(buffs) do
	      	     poststring = "";
	      	  for _, details in ipairs(catbuffs) do
		      output[details.name] = output[details.name] or { };

		      -- header for our tooltip
		      textstring = details.name .. ":\n\n";

		      -- postscript for the tooltip
		      local classcolor;  -- temporary scaffolding for Live
		      if details.class == "DEATH KNIGHT" then
		      	 classcolor = "FF0000";
		      else
			 classcolor = format("%02X%02X%02X", 255*RAID_CLASS_COLORS[details.class].r, 255*RAID_CLASS_COLORS[details.class].g, 255*RAID_CLASS_COLORS[details.class].b);
		      end
		      poststring = poststring .. "|cFF" .. classcolor .. details.class .. "|r: |cFF" .. InTheBuff.colors[details.value] .. details.ability .. "|r (" .. details.tree .. ")\n";

		      -- Did we have someone able to provide a buff?
		      if results[details.name] then
	      	      	 for _, resultdetails in ipairs(results[details.name]) do

			     -- initialize if needed
			     output[details.name] = output[details.name] or { };
			     output[details.name]["players"] = output[details.name]["players"] or { };
			     output[details.name].value = output[details.name].value or 0;

			     output[details.name]["players"][resultdetails.player] = 1;

			     if resultdetails.value > output[details.name].value then
			     	output[details.name].value = resultdetails.value
			     end

		      	     local classcolor;  -- temporary scaffolding for Live
		      	     if details.class == "DEATH KNIGHT" then
		      	     	classcolor = "FF0000";
		      	     else
				classcolor = format("%02X%02X%02X", 255*RAID_CLASS_COLORS[resultdetails.class].r, 255*RAID_CLASS_COLORS[resultdetails.class].g, 255*RAID_CLASS_COLORS[resultdetails.class].b);
		      	     end

			     textstring = textstring .. "|cFF" .. classcolor .. resultdetails.player .. "|r: |cFF" .. InTheBuff.colors[resultdetails.value] .. resultdetails.ability .. "|r\n";
		         end
		      else
		         textstring = textstring .. "|cFF" .. InTheBuff.colors[InTheBuff.RED] .. "none|r\n";
		      end

		      output[details.name].icontype = details.type;
		      output[details.name].tooltip = textstring .. "\n" ..poststring;
	          end
	      end
	      return output;
	end

	local function DisplayNames(output, id)

	      -- would be nice to do this alphabetically
	      for name, details in pairs(output) do

	          local effect = self.frame.effects[id];
 	    	  textstring = name;

		  if (output[name].players) then
		     -- would be nice to do this alphabetically
	    	     for player, _ in pairs(output[name].players) do
	     	      	 textstring = "|cFF" .. InTheBuff.colors[output[name].value] .. textstring .. "|r";
	    	     end
		  else
		     textstring = "|cFF" .. InTheBuff.colors[InTheBuff.RED] .. textstring .. "|r";
		  end

		  effect.typeicon:SetTexture(self.icons[output[name].icontype]);

		  effect.text:SetText(textstring);
		  effect.tooltiptext = output[name].tooltip;

              	  id = id + 1;

	      end
	      return id;
	end

	output = ExtractNames(buffs["Physical"], results);
	id = DisplayNames(output, 2);

	output = ExtractNames(buffs["Stats"], results);
	id = id + 1;  -- skip the header
	id = DisplayNames(output, id);

	output = ExtractNames(buffs["Magical"], results);
	id = id + 1;  -- skip the header
	id = DisplayNames(output, id);

	output = ExtractNames(buffs["All Roles"], results);
	id = id + 1;  -- skip the header
	id = DisplayNames(output, id);

	output = ExtractNames(buffs["Mob Debuff"], results);
	id = id + 1;  -- skip the header
	id = DisplayNames(output, id);

	local totalstring = "Players Scanned: " .. scan.units_total .. "\n";
	totalstring = totalstring .. "OOR/Offline: " .. scan.units_OOR;
	self.frame.totalsframe.text:SetText(totalstring);

	-- only make a tooltip if we have people OOR
	if scan.units_OOR > 0 then

	   -- build the list of people we couldn't scan
	   local tooltiptext = "Unable to scan:\n\n";
	   for _, name in ipairs(scan.units_OOR_list) do
	       tooltiptext = tooltiptext .. name .. "\n";
	   end

	   self.frame.totalsframe.tooltiptext = tooltiptext;
        else
	   self.frame.totalsframe.tooltiptext = "";
	end
end


-- Show the report
function Report:Show()

	if not self.frame then self:InitializeFrame(); end
	self:UpdateReport();
	self.frame:Show();
	
end


-- Hide the report
function Report:Hide() if self.frame then self.frame:Hide(); end end


-- Show an effect's tooltip
function Report:ReportEffectTooltip(id)

	-- get local references
	local effect = InTheBuff.Report.frame.effects[id];
	local tooltip = GameTooltip;
	local tooltiptext = effect.tooltiptext;

	-- set up tooltip
	tooltip:SetOwner(effect, "ANCHOR_CURSOR");

	tooltip:AddLine(tooltiptext);
	tooltip:Show();
	return;

end

-- Generic tooltip
function Report:ReportTooltip(frame)

	local text = frame.tooltiptext;

	-- get local references
	local tooltip = GameTooltip;
	local tooltiptext = text;

	-- set up tooltip
	tooltip:SetOwner(frame, "ANCHOR_CURSOR");

	tooltip:AddLine(text);
	tooltip:Show();
	return;

end

