-- Much thanks to Slake for letting me swipe portions of his Scrub code

-- Set up addon
InTheBuff = LibStub("AceAddon-3.0"):NewAddon("InTheBuff", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0");
local InTheBuff = InTheBuff;

-- Command options
local options = {
	name = "InTheBuff",
	handler = InTheBuff,
	type = "group",
	args = {
		target = {
			name = "Target",
			desc = "Scan and display target buff/debuff skill status",
			type = "execute",
			func = "InitiateTargetScan",
		},
		party = {
			name = "Party",
			desc = "Scan and display party buff/debuff skill status",
			type = "execute",
			func = "InitiatePartyScan",
		},
		raid = {
			name = "Raid",
			desc = "Scan and display 25-man raid buff/debuff skill status",
			type = "execute",
			func = "InitiateRaidScan25",
		},
		raid10 = {
			name = "Raid",
			desc = "Scan and display 10-man raid buff/debuff skill status",
			type = "execute",
			func = "InitiateRaidScan10",
		},
		raid25 = {
			name = "Raid",
			desc = "Scan and display 25-man raid buff/debuff skill status",
			type = "execute",
			func = "InitiateRaidScan25",
		},
		raid40 = {
			name = "Raid",
			desc = "Scan and display 40-man raid buff/debuff skill status",
			type = "execute",
			func = "InitiateRaidScan40",
		},
		groups12 = {
			name = "Raid",
			desc = "Scan and display groups 1 and 2 raid buff/debuff skill status",
			type = "execute",
			func = "InitiateGroupScan10",
		},
		groups34 = {
			name = "Raid",
			desc = "Scan and display groups 3 and 4 for raid buff/debuff skill status",
			type = "execute",
			func = "InitiateGroupScan34",
		},
		groups56 = {
			name = "Raid",
			desc = "Scan and display groups 5 and 6 for raid buff/debuff skill status",
			type = "execute",
			func = "InitiateGroupScan56",
		},
		groups78 = {
			name = "Raid",
			desc = "Scan and display groups 7 and 8 for raid buff/debuff skill status",
			type = "execute",
			func = "InitiateGroupScan78",
		},
	}
};

InTheBuff.buffs          = { };
InTheBuff.buffcategories = { };
InTheBuff.results        = { };
InTheBuff.colors         = { };

InTheBuff.UNKNOWN = 0;
InTheBuff.GREEN   = 3;
InTheBuff.YELLOW  = 2;
InTheBuff.RED     = 1

InTheBuff.colors[InTheBuff.UNKNOWN] = "888888";
InTheBuff.colors[InTheBuff.GREEN] = "00FF00";
InTheBuff.colors[InTheBuff.YELLOW] = "FFFF00";
InTheBuff.colors[InTheBuff.RED] = "FF0000";


-- Initialize the addon
function InTheBuff:OnInitialize()

	-- Set up chat command
	LibStub("AceConfig-3.0"):RegisterOptionsTable("InTheBuff", options, "itb");
	LibStub("AceConfig-3.0"):RegisterOptionsTable("InTheBuff", options, "inthebuff");
	
	-- Initialize database
	self.db = LibStub("AceDB-3.0"):New("InTheBuffDB", defaults, "global");

	-- Create the buff datastructure
	self:InitializeBuffs();

end


-- -------
-- Remove these functions before release

function table.val_to_str ( v )
  if "string" == type( v ) then
    v = string.gsub( v, "\n", "\\n" )
    if string.match( string.gsub(v,"[^'\"]",""), '^"+$' ) then
      return "'" .. v .. "'"
    end
    return '"' .. string.gsub(v,'"', '\\"' ) .. '"'
  else
    return "table" == type( v ) and table.tostring( v ) or
      tostring( v )
  end
end

function table.key_to_str ( k )
  if "string" == type( k ) and string.match( k, "^[_%a][_%a%d]*$" ) then
    return k
  else
    return "[" .. table.val_to_str( k ) .. "]"
  end
end

function table.tostring( tbl )
  local result, done = {}, {}
  for k, v in ipairs( tbl ) do
    table.insert( result, table.val_to_str( v ) )
    done[ k ] = true
  end
  for k, v in pairs( tbl ) do
    if not done[ k ] then
      table.insert( result,
        table.key_to_str( k ) .. "=" .. table.val_to_str( v ) )
    end
  end
  return "{" .. table.concat( result, "," ) .. "}"
end


