
-----------------------------
--       BUFFS MODULE      --
-----------------------------

-- buff = {
--		name = name for this set of effects
--		type = "B" for buff or "D" for debuff; used to determine the icon
--		category = InTheBuff's category for displaying; hardcoded to mesh with the categories in ReportFrame.lua
--		
--		class = class that can provide the ability
--		ability = Ability/spell name that provides the effect in 'name'
--		tree = What tree has the ability (innate = trained)
--		value = how valuable is it (YELLOW = subpar; GREEN = best)
--
--		check = function (talent) to call to determine if the unit can provide this effect
-- }
--
-- buffcategories is the same structure, except its primary key is the category, to make it easier to sort for displaying
--

local function buff(name, type, category, class, ability, tree, value, check)
      InTheBuff.buffs[class] = InTheBuff.buffs[class] or { };
      tinsert(InTheBuff.buffs[class], {name=name, type=type, category=category, class=class, ability=ability, tree=tree, value=value, check=check});

      InTheBuff.buffcategories[category] = InTheBuff.buffcategories[category] or { };
      InTheBuff.buffcategories[category][name] = InTheBuff.buffcategories[category][name] or { };
      tinsert(InTheBuff.buffcategories[category][name], {name=name, type=type, category=category, class=class, ability=ability, value=value, tree=tree, check=check});
end

function InTheBuff:InitializeBuffs()

  -- Armor Debuff (Major): Acid Spit (exotic Hunter pet), Expose Armor, Sunder Armor
  buff("Armor Major",                  "D", "Physical",   "ROGUE",        "Expose Armor",            "Combat",        self.GREEN,  function (t) return t[1][8] > 0; end);
  buff("Armor Major",                  "D", "Physical",   "WARRIOR",      "Sunder Armor",            "Innate",        self.GREEN,  function (t) return 1; end);

  -- Armor Debuff (Minor): Faerie Fire, Sting (Hunter pet), Curse of Recklessness
  buff("Armor Minor",                  "D", "Physical",   "DRUID",        "Faerie Fire",             "Innate",        self.GREEN,  function (t) return 1; end);
  buff("Armor Minor",                  "D", "Physical",   "WARLOCK",      "Curse of Recklessness",   "Affliction",    self.GREEN,  function (t) return t[1][4] > 0; end);
  buff("Armor Minor",                  "D", "Physical",   "WARLOCK",      "Curse of Recklessness",   "Innate",        self.YELLOW, function (t) return t[1][4] == 0; end);

  -- Physical Vulnerability Debuff: Blood Frenzy, (2nd Talent Spec TBA)
  buff("Physical Vulnerability",       "D", "Physical",   "WARRIOR",      "Blood Frenzy",            "Arms",          self.GREEN,  function (t) return t[1][28] > 0; end);
  buff("Physical Vulnerability",       "D", "Physical",   "ROGUE",        "Savage Combat",           "Combat",        self.GREEN,  function (t) return t[2][26] > 0; end);


  -- Melee Haste Buff: Improved Icy Talons, Windfury Totem
  buff("Melee Haste",                  "B", "Physical",   "DEATH KNIGHT", "Improved Icy Talons",     "Frost",         self.YELLOW, function (t) return t[2][15] > 0; end);
  buff("Melee Haste",                  "B", "Physical",   "SHAMAN",       "Windfury Totem",          "Enhancement",   self.GREEN,  function (t) return t[2][13] > 0; end);
  buff("Melee Haste",                  "B", "Physical",   "SHAMAN",       "Windfury Totem",          "Innate",        self.YELLOW, function (t) return t[2][13] == 0; end);

  -- Melee Critical Strike Chance Buff: Leader of the Pack, Rampage
  buff("Melee Critical Strike",        "B", "Physical",   "DRUID",        "Leader of the Pack",      "Feral",         self.GREEN,  function (t) return t[2][19] > 0; end);
  buff("Melee Critical Strike",        "B", "Physical",   "WARRIOR",      "Rampage",                 "Fury",          self.YELLOW, function (t) return t[2][24] > 0; end);

  -- Attack Power Buff (Flat Add): Battle Shout, Blessing of Might
  buff("Attack Power (Add)",           "B", "Physical",   "WARRIOR",      "Battle Shout",            "Innate",        self.YELLOW, function (t) return t[2][2] == 0; end);
  buff("Attack Power (Add)",           "B", "Physical",   "WARRIOR",      "Battle Shout",            "Fury",          self.GREEN,  function (t) return t[2][2] > 0; end);
  buff("Attack Power (Add)",           "B", "Physical",   "PALADIN",      "Blessing of Might",       "Innate",        self.YELLOW, function (t) return t[3][5] == 0; end);
  buff("Attack Power (Add)",           "B", "Physical",   "PALADIN",      "Blessing of Might",       "Retribution",   self.GREEN,  function (t) return t[3][5] > 0; end);

  -- Attack Power Buff (Multiplier): Abomination's Might, Trueshot Aura, Unleashed Rage
  buff("Attack Power (Mult.)",         "B", "Physical",   "DEATH KNIGHT", "Abomination's Might",     "Blood",         self.YELLOW, function (t) return t[1][17] > 0; end);
  buff("Attack Power (Mult.)",         "B", "Physical",   "HUNTER",       "Trueshot Aura",           "Marksmanship",  self.GREEN,  function (t) return t[2][20] > 0; end);
  buff("Attack Power (Mult.)",         "B", "Physical",   "SHAMAN",       "Unleashed Rage",          "Enhancement",   self.YELLOW, function (t) return t[2][16] > 0; end);

  -- Bleed Damage Increase Debuff: Mangle, Trauma
  buff("Bleed Damage",                 "D", "Physical",   "DRUID",        "Mangle",                  "Feral",         self.GREEN,  function (t) return t[2][26] > 0; end);
  buff("Bleed Damage",                 "D", "Physical",   "WARRIOR",      "Trauma",                  "Arms",          self.GREEN,  function (t) return t[1][19] > 0; end);

  -- Spell Haste Buff: Wrath of Air Totem
  buff("Spell Haste",                  "B", "Magical",    "SHAMAN",       "Wrath of Air Totem",      "Innate",        self.GREEN,  function (t) return t[2][16] == 0; end);

  -- Spell Critical Strike Chance Buff: Moonkin Aura, Elemental Oath
  buff("Spell Critical Strike Buff",   "B", "Magical",    "DRUID",        "Moonkin Aura",            "Balance",       self.YELLOW, function (t) return t[1][18] > 0; end);
  buff("Spell Critical Strike Buff",   "B", "Magical",    "SHAMAN",       "Elemental Oath",          "Elemental",     self.GREEN,  function (t) return t[1][18] > 0; end);

  -- Spell Critical Strike Chance Debuff: Improved Scorch, Winter's Chill
  buff("Spell Critical Strike Debuff", "D", "Magical",    "MAGE",         "Winter's Chill",          "Frost",         self.GREEN,  function (t) return t[3][18] > 0; end);
  buff("Spell Critical Strike Debuff", "D", "Magical",    "MAGE",         "Scorch",                  "Fire",          self.GREEN,  function (t) return t[2][11] > 0; end);

  -- Increased Spell Damage Taken Debuff: Ebon Plaguebringer, Earth and Moon, Curse of the Elements
  buff("Magical Vulnerability",        "D", "Magical",    "DEATH KNIGHT", "Ebon Plaguebringer",      "Unholy",        self.GREEN,  function (t) return t[3][27] > 0; end);
  buff("Magical Vulnerability",        "D", "Magical",    "DRUID",        "Earth and Moon",          "Moonkin",       self.GREEN,  function (t) return t[1][27] > 0; end);
  buff("Magical Vulnerability",        "D", "Magical",    "WARLOCK",      "Curse of Elements",       "Innate",        self.YELLOW, function (t) return 1; end); 
  buff("Magical Vulnerability",        "D", "Magical",    "WARLOCK",      "Curse of Elements",       "Affliction",    self.GREEN,  function (t) return t[1][23] > 0; end);

  -- Increased Spell Power Buff: Focus Magic, Improved Divine Spirit, Flametongue Totem, Totem of Wrath, Demonic Pact
  buff("Spell Power",                  "B", "Magical",    "PRIEST",       "Improved Divine Spirit",  "Discipline",    self.YELLOW, function (t) return t[1][15] > 0; end);
  buff("Spell Power",                  "B", "Magical",    "SHAMAN",       "Flametongue Totem",       "Innate",        self.YELLOW, function (t) return 1; end);
  buff("Spell Power",                  "B", "Magical",    "SHAMAN",       "Flametongue Totem",       "Enhancement",   self.YELLOW, function (t) return t[2][1] > 0; end);
  buff("Spell Power",                  "B", "Magical",    "SHAMAN",       "Totem of Wrath",          "Elemental",     self.GREEN,  function (t) return t[1][21] > 0; end);
  buff("Spell Power",                  "B", "Magical",    "WARLOCK",      "Demonic Pact",            "Demonology",    self.YELLOW, function (t) return t[2][26] > 0; end);

  -- Increased Spell Hit Chance Taken Debuff: Improved Faerie Fire, Misery
  buff("Spell Hit",                    "D",  "Magical",   "DRUID",        "Improved Faerie Fire",    "Balance",       self.GREEN,  function (t) return t[3][22] > 0; end);
  buff("Spell Hit",                    "D",  "Magical",   "PRIEST",       "Misery",                  "Shadow",        self.GREEN,  function (t) return t[1][15] > 0; end);

  -- Percentage Haste Increase (All Types): Improved Moonkin Aura, Swift Retribution
  buff("Percentage Haste Increase",    "B", "All Roles",  "DRUID",        "Improved Moonkin Aura",   "Balance",       self.GREEN,  function (t) return t[1][19] > 0; end);
  buff("Percentage Haste Increase",    "B", "All Roles",  "PALADIN",      "Swift Retribution",       "Retribution",   self.GREEN,  function (t) return t[3][23] > 0; end);

  -- Percentage Damage Increase: Ferocious Inspiration, Sanctified Retribution
  buff("Percentage Damage Increase",   "B", "All Roles",  "HUNTER",       "Ferocious Inspiration",   "Beast Mastery", self.GREEN,  function (t) return t[1][17] > 0; end);
  buff("Percentage Damage Increase",   "B", "All Roles",  "PALADIN",      "Sanctified Retribution",  "Retribution",   self.YELLOW, function (t) return t[3][14] > 0; end);

  -- Critical Strike Chance Debuff (All types): Heart of the Crusader, Totem of Wrath
  buff("Critical Strike Increase",     "B", "All Roles",  "PALADIN",      "Heart of the Crusader",   "Retribution",   self.GREEN,  function (t) return t[3][4] > 0; end);
  buff("Critical Strike Increase",     "B", "All Roles",  "SHAMAN",       "Totem of Wrath",          "Elemental",     self.GREEN,  function (t) return t[1][21] > 0; end);

  -- Bloodlust/Heroism
  buff("Bloodlust/Heroism",            "B", "All Roles",  "SHAMAN",       "Bloodlust/Heroism",       "Innate",        self.GREEN,  function (t) return 1; end);

  -- Melee Attack Speed Slow Debuff: Icy Touch, Infected Wounds, Judgements of the Just, Thunderclap
  buff("Melee Attack Speed",           "D", "Mob Debuff", "DEATH KNIGHT", "Icy Touch",               "Innate",        self.YELLOW, function (t) return 1; end);
  buff("Melee Attack Speed",           "D", "Mob Debuff", "DEATH KNIGHT", "Improved Icy Touch",      "Frost",         self.GREEN,  function (t) return t[2][1] > 0; end);
  buff("Melee Attack Speed",           "D", "Mob Debuff", "DRUID",        "Infected Wounds",         "Feral",         self.GREEN,  function (t) return t[2][24] > 0; end);
  buff("Melee Attack Speed",           "D", "Mob Debuff", "DRUID",        "Judgements of the Just",  "Protection",    self.GREEN,  function (t) return t[2][24] > 0; end);
  buff("Melee Attack Speed",           "D", "Mob Debuff", "WARRIOR",      "Thunderclap",             "Innate",        self.YELLOW, function (t) return 1; end);
  buff("Melee Attack Speed",           "D", "Mob Debuff", "WARRIOR",      "Improved Thunderclap",    "Protection",    self.GREEN,  function (t) return t[2][3] > 0; end);

  -- Melee Hit Chance Reduction Debuff: Insect Swarm, Scorpid Sting
  buff("Melee Hit Chance",             "D", "Mob Debuff", "DRUID",        "Insect Swarm",            "Balance",       self.GREEN,  function (t) return t[1][13] > 0; end);
  buff("Melee Hit Chance",             "D", "Mob Debuff", "HUNTER",       "Scorpid Sting",           "Innate",        self.GREEN,  function (t) return 1; end);
    	 
  -- Healing Debuff: Wound Poison, Aimed Shot, Mortal Strike, Furious Attacks
  buff("Healing Reduction",            "D", "Mob Debuff", "ROGUE",        "Wound Poison",            "Innate",        self.GREEN,  function (t) return t[1][13] > 0; end);
  buff("Healing Reduction",            "D", "Mob Debuff", "HUNTER",       "Aimed Shot",              "Marksmanship",  self.GREEN,  function (t) return t[2][9] > 0; end);
  buff("Healing Reduction",            "D", "Mob Debuff", "WARRIOR",      "Mortal Strike",           "Arms",          self.GREEN,  function (t) return t[1][21] > 0; end);

  -- Attack Power Debuff: Demoralizing Roar, Curse of Weakness, Demoralizing Shout
  buff("Mob Attack Power",             "D", "Mob Debuff", "WARRIOR",      "Demoralizing Shout",      "Innate",        self.YELLOW, function (t) return 1; end);
  buff("Mob Attack Power",             "D", "Mob Debuff", "WARRIOR",      "Demoralizing Shout",      "Fury",          self.GREEN,  function (t) return t[2][2] > 0; end);
  buff("Mob Attack Power",             "D", "Mob Debuff", "DRUID",        "Demoralizing Roar",       "Innate",        self.GREEN,  function (t) return 1; end);
  buff("Mob Attack Power",             "D", "Mob Debuff", "WARLOCK",      "Curse of Weakness",       "Innate",        self.GREEN,  function (t) return 1; end);

  -- Stat Multiplier Buff: Blessing of Kings
  buff("Stat Multiplier",              "B", "Stats",      "PALADIN",      "Blessing of Kings",       "Protection",    self.GREEN,  function (t) return t[2][2] > 0; end);

  -- Stat Add Buff: Mark of the Wild
  buff("Stat Add",                     "B", "Stats",      "DRUID",        "Mark of the Wild",        "Innate",         self.YELLOW, function (t) return 1; end);
  buff("Stat Add",                     "B", "Stats",      "DRUID",        "Mark of the Wild",        "Restoration",    self.GREEN,  function (t) return t[3][1] > 0; end);

  -- Agility and Strength Buff: Strength of Earth Totem, Horn of Winter
  buff("Agility and Strength",         "B", "Stats",      "SHAMAN",       "Strength of Earth Totem", "Innate",         self.YELLOW, function (t) return 1; end);
  buff("Agility and Strength",         "B", "Stats",      "SHAMAN",       "Strength of Earth Totem", "Enhancement",    self.GREEN,  function (t) return t[2][1] > 0; end);
  buff("Agility and Strength",         "B", "Stats",      "DEATH KNIGHT", "Horn of Winter",          "Innate",         self.YELLOW, function (t) return 1; end);

  -- Stamina Buff: Power Word: Fortitude
  buff("Stamina",                      "B", "Stats",      "PRIEST",       "Power Word: Fortitude",   "Innate",         self.YELLOW, function (t) return 1; end);
  buff("Stamina",                      "B", "Stats",      "PRIEST",       "Power Word: Fortitude",   "Discipline",     self.GREEN,  function (t) return t[1][4] > 0; end);

  -- Health Buff: Commanding Shout, Blood Pact
  buff("Health",                        "B", "Stats",      "WARRIOR",      "Commanding Shout",        "Innate",         self.YELLOW, function (t) return 1; end);
  buff("Health",                        "B", "Stats",      "WARRIOR",      "Commanding Shout",        "Fury",           self.GREEN,  function (t) return t[2][2] > 0; end);
  buff("Health",                        "B", "Stats",      "WARLOCK",      "Blood Pact",              "Destruction",    self.YELLOW, function (t) return t[3][20] > 0; end);

  -- Intellect Buff: Arcane Intellect, Fel Intelligence
  buff("Intellect",                     "B", "Stats",      "MAGE",         "Arcane Intellect",        "Innate",         self.GREEN,  function (t) return 1; end);
  buff("Intellect",                     "B", "Stats",      "WARLOCK",      "Fel Intelligence",        "Innate",         self.YELLOW, function (t) return t[1][25] > 0; end);
  buff("Intellect",                     "B", "Stats",      "WARLOCK",      "Fel Intelligence",        "Affliction",     self.GREEN,  function (t) return t[1][17] > 0; end);

  -- Spirit Buff: Divine Spirit, Fel Intelligence
  buff("Spirit",                        "B", "Stats",      "WARLOCK",      "Fel Intelligence",        "Innate",         self.YELLOW, function (t) return t[1][25] > 0; end);
  buff("Spirit",                        "B", "Stats",      "WARLOCK",      "Fel Intelligence",        "Affliction",     self.GREEN,  function (t) return t[1][17] > 0; end);
  buff("Spirit",                        "B", "Stats",      "PRIEST",       "Divine Spirit",           "Discipline",     self.GREEN,  function (t) return t[1][14] > 0; end);

  -- Cast Speed Slow: Curse of Tongues, Slow, Mind-numbing Poison. 
  buff("Cast Speed Slow",               "D", "Mob Debuff", "WARLOCK",      "Curse of Tongues",        "Innate",         self.GREEN,  function (t) return 1; end);
  buff("Cast Speed Slow",               "D", "Mob Debuff", "ROGUE",        "Mind-numbing Poison",     "Innate",         self.GREEN,  function (t) return 1; end);
  buff("Cast Speed Slow",               "D", "Mob Debuff", "MAGE",         "Slow",                    "Arcane",         self.GREEN,  function (t) return t[1][26] > 0; end);

  -- Replenishment
  buff("Replenishment",                 "B", "Stats",      "PRIEST",       "Vampiric Touch",          "Shadow",         self.GREEN,  function (t) return t[3][21] > 0; end);
  buff("Replenishment",                 "B", "Stats",      "PALADIN",      "Judgements of the Wise",  "Retribution",    self.GREEN,  function (t) return t[3][20] > 0; end);
  buff("Replenishment",                 "B", "Stats",      "HUNTER",       "Hunting Party",           "Survival",       self.GREEN,  function (t) return t[3][27] > 0; end);

  -- mp5
  buff("Mana per 5",                    "B", "Stats",      "PALADIN",      "Blessing of Wisdom",      "Innate",         self.YELLOW, function (t) return 1; end);
  buff("Mana per 5",                    "B", "Stats",      "PALADIN",      "Blessing of Wisdom",      "Holy",           self.GREEN,  function (t) return t[1][10] > 0; end);

  -- tank damage reduction (buff, not proc)
  buff("Tank Damage Reduction",         "B", "Mob Debuff", "PALADIN",      "Blessing of Sanctuary",   "Protection",     self.GREEN,  function (t) return t[2][12] > 0; end);

  
  -- -----------------
  -- Buffs/debuffs we're not recording
	 
  -- Damage Reduction Percentage Buff: Grace, Blessing of Sanctuary
  -- Percentage Increase Healing Received Buff: Tree of Life, Improved Devotion Aura
  -- Armor Increase Percentage Buff: Inspiration, Ancestral Healing
  -- Ranged Attack Power Buff: Hunter's Mark (only Hunters benefit, so no need to exclude against other class abilities)

end