-- this file is optional, you can delete it after initial load

-- Azeroth flight times
--------------------------------
function InFlight:LoadDefaults()
--------------------------------
	ChatFrame1:AddMessage("InFlight: default data loaded.")
		
	-- LOCALIZATION
	local localization
	local locale = GetLocale()
	if locale == "zhTW" then 
		localization = {
			-- Alliance
			["Marshal's Refuge"] = "馬紹爾營地",
			["Light's Hope Chapel"] = "聖光之願禮拜堂",
			["Blood Watch"] = "血紅守望",
			["Ratchet"] = "棘齒城",
			["Hellfire Peninsula"] = "地獄火半島",
			["Talrendis Point"] = "塔倫迪斯營地",
			["Cosmowrench"] = "扭曲太空",
			["Chillwind Camp"] = "冰風崗",
			["Nijel's Point"] = "尼耶爾前哨站",
			["Ironforge"] = "鐵爐堡",
			["Moonglade"] = "月光林地",
			["Gadgetzan"] = "加基森",
			["Thelsamar"] = "塞爾薩瑪",
			["Morgan's Vigil"] = "摩根的崗哨",
			["Altar of Sha'tar"] = "薩塔祭壇",
			["Astranaar"] = "阿斯特蘭納",
			["Southshore"] = "南海鎮",
			["Allerian Stronghold"] = "艾蘭里堡壘",
			["Area 52"] = "52區",
			["Theramore"] = "塞拉摩",
			["Wildhammer Stronghold"] = "蠻錘要塞",
			["Thalanaar"] = "薩蘭納爾",
			["Plaguewood"] = "病木林",
			["Feathermoon"] = "羽月要塞",
			["Sanctum of the Stars"] = "星光聖所",
			["Evergrove"] = "永恆樹林",
			["Expedition Point"] = "遠征隊哨塔",
			["Booty Bay"] = "藏寶海灣",
			["Refuge Pointe"] = "避難谷地",
			["Temple of Telhamat"] = "特爾哈曼神廟",
			["Thorium Point"] = "瑟銀哨塔",
			["Auberdine"] = "奧伯丁",
			["Aerie Peak"] = "鷹巢山",
			["Sylvanaar"] = "希爾瓦納",
			["Lakeshire"] = "湖畔鎮",
			["Telaar"] = "泰拉",
			["Menethil Harbor"] = "米奈希爾港",
			["Toshley's Station"] = "托斯利基地",
			["Nighthaven"] = "永夜港",
			["The Stormspire"] = "風暴之尖",
			["Rut'theran Village"] = "魯瑟蘭村",
			["Darkshire"] = "夜色鎮",
			["Shatter Point"] = "破碎崗哨",
			["Shattrath"] = "撒塔斯",
			["The Exodar"] = "艾克索達",
			["Nethergarde Keep"] = "守望堡",
			["Honor Point"] = "榮譽崗哨",
			["Everlook"] = "永望鎮",
			["Stonetalon Peak"] = "石爪峰",
			["Emerald Sanctuary"] = "翡翠聖地",
			["Stormwind"] = "暴風城",
			["Telredor"] = "泰倫多爾",
			["Sentinel Hill"] = "哨兵嶺",
			["Talonbranch Glade"] = "刺枝林地",
			["Cenarion Hold"] = "塞納里奧城堡",
			["Honor Hold"] = "榮譽堡",
			["Orebor Harborage"] = "奧雷伯爾港",

		    -- Horde
			["Marshal's Refuge"] = "馬紹爾營地",
			["Cenarion Hold"] = "塞納里奧城堡",
			["Crossroads"] = "十字路口",
			["Kargath"] = "卡加斯",
			["Bloodvenom Post"] = "血毒崗哨",
			["Light's Hope Chapel"] = "聖光之願禮拜堂",
			["Shadowprey Village"] = "葬影村",
			["Thorium Point"] = "瑟銀哨塔",
			["Ratchet"] = "棘齒城",
			["Brackenwall Village"] = "蕨牆村",
			["Revantusk Village"] = "惡齒村",
			["Hammerfall"] = "落錘鎮",
			["Everlook"] = "永望鎮",
			["Flame Crest"] = "烈焰峰",
			["Orgrimmar"] = "奧格瑪",
			["Freewind Post"] = "亂風崗",
			["Undercity"] = "幽暗城",
			["Gadgetzan"] = "加基森",
			["Booty Bay"] = "藏寶海灣",
			["Camp Taurajo"] = "陶拉祖營地",
			["Stonard"] = "斯通納德",
			["Tarren Mill"] = "塔倫米爾",
			["Grom'gol"] = "格羅姆高",
			["Valormok"] = "瓦羅莫克",
			["The Sepulcher"] = "瑟伯切爾",
			["Sun Rock Retreat"] = "烈日石居",
			["Moonglade"] = "月光林地",
			["Thunder Bluff"] = "雷霆崖",
			["Zoram'gar Outpost"] = "左拉姆加前哨站",
			["Splintertree Post"] = "碎木崗哨",
			["Camp Mojache"] = "莫沙徹營地",
			["Zabra'jin"] = "薩布拉金",
			["Thrallmar"] = "索爾瑪",
			["Tranquillien"] = "安寧地",
			["Spinebreaker Ridge"] = "斷脊山脈",
			["Silvermoon City"] = "銀月城",
			["Swamprat Post"] = "斯溫派特崗哨",
			["Stonebreaker Hold"] = "碎石堡",
			["Shattrath"] = "撒塔斯",
			["Falcon Watch"] = "獵鷹哨站",
			["Evergrove"] = "永恆樹林",
			["Area 52"] = "52區",
			["The Stormspire"] = "風暴之尖",
			["Thunderlord Stronghold"] = "雷霆王村",
			["Garadar"] = "卡拉達爾",
			["Mok'Nathal Village"] = "摩克納薩爾村",
			["Cosmowrench"] = "扭曲太空",
			["Hellfire Peninsula"] = "地獄火半島", 
		}
	elseif locale == "deDE" then 
		localization = {
			-- Alliance
			["Marshal's Refuge"] = "Marshalls Zuflucht",
			["Light's Hope Chapel"] = "Kapelle des hoffnungsvollen Lichts",
			["Blood Watch"] = "Blutwacht",
			["Ratchet"] = "Ratschet",
			["Hellfire Peninsula"] = "H\195\182llenfeuerhalbinsel, das Dunkle Portal",
			["Talrendis Point"] = "Talrendisspitze",
			["Cosmowrench"] = "Kosmozang",
			["Chillwind Camp"] = "Zugwindlager",
			["Nijel's Point"] = "Nijelspitze",
			["Ironforge"] = "Eisenschmiede",
			["Moonglade"] = "Mondlichtung",
			["Gadgetzan"] = "Gadgetzan",
			["Thelsamar"] = "Thelsamar",
			["Morgan's Vigil"] = "Morgans Wache",
			["Altar of Sha'tar"] = "Altart der Sha'tar",
			["Astranaar"] = "Astranaar",
			["Southshore"] = "S\195\188derstade",
			["Allerian Stronghold"] = "Allerias Feste",
			["Area 52"] = "Area 52",
			["Theramore"] = "Insel Theramore",
			["Wildhammer Stronghold"] = "Wildhammerfeste",
			["Thalanaar"] = "Thalanaar",
			["Plaguewood"] = "Der Pestwald",
			["Feathermoon"] = "Mondfederfeste",
			["Sanctum of the Stars"] = "Heiligtum der Sterne",
			["Evergrove"] = "Der ewige Hain",
			["Expedition Point"] = "Expeditionsr\195\188stlager",
			["Booty Bay"] = "Beutebucht",
			["Refuge Pointe"] = "Die Zuflucht",
			["Temple of Telhamat"] = "Tempel von Telhamat",
			["Thorium Point"] = "Thoriumspitze",
			["Auberdine"] = "Auberdine",
			["Aerie Peak"] = "Nistgipfel",
			["Sylvanaar"] = "Sylvanaar",
			["Lakeshire"] = "Seenhain",
			["Telaar"] = "Telaar",
			["Menethil Harbor"] = "Hafen von Menethil",
			["Toshley's Station"] = "Toshleys Station",
			["Nighthaven"] = "Nachthafen",
			["The Stormspire"] = "Die Sturms\195\164ule",
			["Rut'theran Village"] = "Rut'theran",
			["Darkshire"] = "Dunkelhain",
			["Shatter Point"] = "Tr\195\188mmerposten",
			["Shattrath"] = "Shattrath",
			["The Exodar"] = "Exodar",
			["Nethergarde Keep"] = "Burg Nethergarde",
			["Honor Point"] = "Ehrenpunkt",
			["Everlook"] = "Ewige Warte",
			["Stonetalon Peak"] = "Steinkrallengipfel",
			["Emerald Sanctuary"] = "Smaragdrefugium",
			["Stormwind"] = "Sturmwind",
			["Telredor"] = "Telredor",
			["Sentinel Hill"] = "Sp\195\164herkuppe",
			["Talonbranch Glade"] = "Nachtlaublichtung",
			["Cenarion Hold"] = "Burg Cenarius",
			["Honor Hold"] = "Ehrenfeste",
			["Orebor Harborage"] = "Oreborzuflucht",
			
			--Horde
			["Marshal's Refuge"] = "Marshalls Zuflucht",
			["Cenarion Hold"] = "Burg Cenarius",
			["Crossroads"] = "Das Wegekreuz",
			["Kargath"] = "Kargath",
		--	["Bloodvenom Post"] = "",
			["Light's Hope Chapel"] = "Kapelle des hoffnungsvollen Lichts",
			["Shadowprey Village"] = "Schattenflucht",
			["Thorium Point"] = "Thoriumspitze",
			["Ratchet"] = "Ratschet",
			["Brackenwall Village"] = "Brackenwall",
			["Revantusk Village"] = "Dorf der Bruchhauer",
			["Hammerfall"] = "Hammerfall",
			["Everlook"] = "Ewige Warte",
			["Flame Crest"] = "Flammenkamm",
			["Orgrimmar"] = "Orgrimmar",
			["Freewind Post"] = "Freiwindposten",
			["Undercity"] = "Unterstadt",
			["Gadgetzan"] = "Gadgetzan",
			["Booty Bay"] = "Beutebucht",
			["Camp Taurajo"] = "Camp Taurajo",
			["Stonard"] = "Steinard",
			["Tarren Mill"] = "Tarrens M?hle",
			["Grom'gol"] = "Grom'gol",
		--	["Valormok"] = "",
			["The Sepulcher"] = "Das Grabmahl",
			["Sun Rock Retreat"] = "Sonnenfels",
			["Moonglade"] = "Mondlichtung",
			["Thunder Bluff"] = "Donnerfels",
			["Zoram'gar Outpost"] = "Au?enposten von Zoram'gar",
			["Splintertree Post"] = "Splitterholzposten",
			["Camp Mojache"] = "Camp Mojache",
			["Zabra'jin"] = "Zabra'jin",
			["Thrallmar"] = "Thrallmar",
			["Tranquillien"] = "Tristessa",
		--	["Spinebreaker Ridge"] = "",
			["Silvermoon City"] = "Silbermond",
			["Swamprat Post"] = "Sumpfrattenposten",
			["Stonebreaker Hold"] = "Steinbrecherfeste",
			["Shattrath"] = "Shattrath",
			["Falcon Watch"] = "Falkenwacht",
			["Evergrove"] = "Der ewige Hain",
			["Area 52"] = "Area 52",
			["The Stormspire"] = "Die Sturms\195\164ule",
			["Thunderlord Stronghold"] = "Donnerfeste",
			["Garadar"] = "Garadar",
			["Mok'Nathal Village"] = "Dorf der Mok'Nathal",
			["Cosmowrench"] = "Kosmozang",
			["Hellfire Peninsula"] = "H\195\182llenfeuerhalbinsel, das Dunkle Portal", 
		}
	-- Translated by StingerSoft (Эритнулл ака Шептун)
	elseif locale == "ruRU" then 
		localization = {
			-- Alliance
			["Marshal's Refuge"] = "Укрытие Маршалла",
			["Light's Hope Chapel"] = "Часовня Последней Надежды",
			["Blood Watch"] = "Кровавая застава",
			["Ratchet"] = "Кабестан",
			["Hellfire Peninsula"] = "Полуостров Адского Пламени",
			["Talrendis Point"] = "Застава Талрендис",
			["Cosmowrench"] = "Космоворот",
			["Chillwind Camp"] = "Лагерь Промозглого Ветра",
			["Nijel's Point"] = "Высота Найджела",
			["Ironforge"] = "Стальгорн",
			["Moonglade"] = "Лунная поляна",
			["Gadgetzan"] = "Прибамбасск",
			["Thelsamar"] = "Телcамар",
			["Morgan's Vigil"] = "Дозор Моргана",
			["Altar of Sha'tar"] = "Алтарь Ша'тара",
			["Astranaar"] = "Астранаар",
			["Southshore"] = "Южнобережье",
			["Allerian Stronghold"] = "Бастион Аллерии",
			["Area 52"] = "Зона 52",
			["Theramore"] = "Остров Терамор",
			["Wildhammer Stronghold"] = "Цитадель Громового Молота",
			["Thalanaar"] = "Таланаар",
			["Plaguewood"] = "Проклятый лес",
			["Feathermoon"] = "Крепость Оперенной Луны",
			["Sanctum of the Stars"] = "Святилище Звезд",
			["Evergrove"] = "Вечная роща",
			["Expedition Point"] = "Лагерь экспедиции",
			["Booty Bay"] = "Пиратская бухта",
			["Refuge Pointe"] = "Опорный пункт",
			["Temple of Telhamat"] = "Храм Телхамата",
			["Thorium Point"] = "Лагерь Братства Тория",
			["Auberdine"] = "Аубердин",
			["Aerie Peak"] = "Заоблачный Пик",
			["Sylvanaar"] = "Сильванаар",
			["Lakeshire"] = "Приозерье",
			["Telaar"] = "Телаар",
			["Menethil Harbor"] = "Гавань Менетил",
			["Toshley's Station"] = "Станция Тошли",
			["Nighthaven"] = "Ночная Гавань",
			["The Stormspire"] = "Штормовая Вершина",
			["Rut'theran Village"] = "Деревня Рут'теран",
			["Darkshire"] = "Темнолесьеn",
			["Shatter Point"] = "Парящая застава",
			["Shattrath"] = "Шаттрат",
			["The Exodar"] = "Экзодар",
			["Nethergarde Keep"] = "Крепость Стражей Пустоты",
			["Honor Point"] = "Парящая застава",
			["Everlook"] = "Круговзор",
			["Stonetalon Peak"] = "Пик Каменного Когтя",
			["Emerald Sanctuary"] = "Изумрудное святилище",
			["Stormwind"] = "Штормград",
			["Telredor"] = "Телредор",
			["Sentinel Hill"] = "Сторожевой холм",
			["Talonbranch Glade"] = "Поляна Когтистых Ветвей",
			["Cenarion Hold"] = "Крепость Ценариона",
			["Honor Hold"] = "Оплот Чести",
			["Orebor Harborage"] = "Прибежище Оребор",
			
			--Horde
			["Marshal's Refuge"] = "Укрытие Маршалла",
			["Cenarion Hold"] = "Крепость Ценариона",
			["Crossroads"] = "Перекресток",
			["Kargath"] = "Каргат",
			["Bloodvenom Post"] = "Застава Отравленной Крови",
			["Light's Hope Chapel"] = "Часовня Последней Надежды",
			["Shadowprey Village"] = "Деревня Ночных Охотников",
			["Thorium Point"] = "Лагерь Братства Тория",
			["Ratchet"] = "Кабестан",
			["Brackenwall Village"] = "Деревня Гиблотопь",
			["Revantusk Village"] = "Деревня Сломанного Клыка",
			["Hammerfall"] = "Павший Молот",
			["Everlook"] = "Круговзор",
			["Flame Crest"] = "Пламенеющий Стяг",
			["Orgrimmar"] = "Оргриммар",
			["Freewind Post"] = "Застава Вольного Ветра",
			["Undercity"] = "Подгород",
			["Gadgetzan"] = "Прибамбасск",
			["Booty Bay"] = "Пиратская бухта",
			["Camp Taurajo"] = "Лагерь Таурахо",
			["Stonard"] = "Каменор",
			["Tarren Mill"] = "Мельница Таррен",
			["Grom'gol"] = "Лагерь Гром'гол",
			["Valormok"] = "Храбростан",
			["The Sepulcher"] = "Гробница",
			["Sun Rock Retreat"] = "Приют у Солнечного Камня",
			["Moonglade"] = "Лунная поляна",
			["Thunder Bluff"] = "Громовой Утес",
			["Zoram'gar Outpost"] = "Форт Зорам'гар",
			["Splintertree Post"] = "Застава Расщепленного Дерева",
			["Camp Mojache"] = "Лагерь Мохаче",
			["Zabra'jin"] = "Забра'джин",
			["Thrallmar"] = "Траллмар",
			["Tranquillien"] = "Транквиллион",
			["Spinebreaker Ridge"] = "Гребень Хребтолома",
			["Silvermoon City"] = "Луносвет",
			["Swamprat Post"] = "Застава Болотной Крысы",
			["Stonebreaker Hold"] = "Форт Камнеломов",
			["Shattrath"] = "Шаттрат",
			["Falcon Watch"] = "Соколиный Дозор",
			["Evergrove"] = "Вечная роща",
			["Area 52"] = "Зона 52",
			["The Stormspire"] = "Штормовая Вершина",
			["Thunderlord Stronghold"] = "Оплот Громоборцев",
			["Garadar"] = "Гарадар",
			["Mok'Nathal Village"] = "Деревня Мок'Натал",
			["Cosmowrench"] = "Космоворот",
			["Hellfire Peninsula"] = "Полуостров Адского Пламени", 
		}
	end

	-- localization helpers, please keep the table like this since it's easier to copy and paste new data
	local data = {
		["Horde"] = {
			["Marshal's Refuge"] = {
				["Thunder Bluff"] = 417,
				["Gadgetzan"] = 114,
				["Ratchet"] = 354,
				["Brackenwall Village"] = 294,
			},
			["Kargath"] = {
				["Undercity"] = 498,
				["Light's Hope Chapel"] = 490,
				["Stonard"] = 225,
				["Tarren Mill"] = 376,
				["Grom'gol"] = 239,
				["Revantusk Village"] = 350,
				["Hammerfall"] = 264,
				["Booty Bay"] = 298,
				["Flame Crest"] = 89,
				["Thorium Point"] = 57,
			},
			["Bloodvenom Post"] = {
				["Crossroads"] = 270,
				["Moonglade"] = 166,
				["Shadowprey Village"] = 604,
				["Camp Mojache"] = 524,
				["Camp Taurajo"] = 361,
				["Zoram'gar Outpost"] = 501,
				["Emerald Sanctuary"] = 69,
				["Sun Rock Retreat"] = 413,
				["Freewind Post"] = 458,
				["Valormok"] = 242,
				["Everlook"] = 194,
				["Thunder Bluff"] = 443,
				["Brackenwall Village"] = 433,
				["Orgrimmar"] = 259,
			},
			["Moonglade"] = {
				["Crossroads"] = 430,
				["Emerald Sanctuary"] = 186,
				["Bloodvenom Post"] = 159,
				["Sun Rock Retreat"] = 574,
				["Everlook"] = 147,
				["Freewind Post"] = 619,
				["Camp Taurajo"] = 522,
				["Camp Mojache"] = 605,
			},
			["Ratchet"] = {
				["Crossroads"] = 69,
				["Gadgetzan"] = 242,
				["Sun Rock Retreat"] = 219,
				["Camp Taurajo"] = 141,
				["Brackenwall Village"] = 231,
				["Orgrimmar"] = 185,
				["Freewind Post"] = 204,
				["Everlook"] = 360,
				["Thunder Bluff"] = 175,
				["Cenarion Hold"] = 452,
				["Emerald Sanctuary"] = 309,
				["Camp Mojache"] = 317,
			},
			["Hellfire Peninsula"] = {
				["Falcon Watch"] = 124,
				["Thrallmar"] = 60,
			},
			["Revantusk Village"] = {
				["Undercity"] = 285,
				["Hammerfall"] = 93,
				["Light's Hope Chapel"] = 140,
				["Booty Bay"] = 648,
				["Kargath"] = 352,
				["Tarren Mill"] = 159,
				["Grom'gol"] = 589,
			},
			["Hammerfall"] = {
				["Undercity"] = 260,
				["Light's Hope Chapel"] = 229,
				["Stonard"] = 483,
				["Tarren Mill"] = 118,
				["Grom'gol"] = 497,
				["Revantusk Village"] = 91,
				["Booty Bay"] = 696,
				["Thorium Point"] = 318,
				["Kargath"] = 261,
			},
			["Freewind Post"] = {
				["Crossroads"] = 196,
				["Orgrimmar"] = 339,
				["Bloodvenom Post"] = 431,
				["Moonglade"] = 592,
				["Shadowprey Village"] = 327,
				["Gadgetzan"] = 94,
				["Camp Taurajo"] = 138,
				["Zoram'gar Outpost"] = 419,
				["Brackenwall Village"] = 317,
				["Everlook"] = 491,
				["Thunder Bluff"] = 223,
				["Sun Rock Retreat"] = 342,
				["Valormok"] = 359,
				["Cenarion Hold"] = 256,
				["Splintertree Post"] = 349,
				["Camp Mojache"] = 125,
			},
			["Cosmowrench"] = {
				["The Stormspire"] = 62,
				["Shadowmoon Village"] = 420,
			},
			["Flame Crest"] = {
				["Kargath"] = 89,
				["Light's Hope Chapel"] = 591,
				["Stonard"] = 200,
				["Tarren Mill"] = 466,
				["Grom'gol"] = 390,
				["Revantusk Village"] = 440,
				["Hammerfall"] = 348,
				["Booty Bay"] = 461,
				["Thorium Point"] = 73,
				["Undercity"] = 589,
			},
			["Orgrimmar"] = {
				["Marshal's Refuge"] = 492,
				["Bloodvenom Post"] = 253,
				["Sun Rock Retreat"] = 258,
				["Shadowprey Village"] = 374,
				["Ratchet"] = 159,
				["Brackenwall Village"] = 230,
				["Everlook"] = 240,
				["Gadgetzan"] = 418,
				["Moonglade"] = 377,
				["Camp Taurajo"] = 181,
				["Zoram'gar Outpost"] = 261,
				["Emerald Sanctuary"] = 168,
				["Crossroads"] = 108,
				["Freewind Post"] = 293,
				["Thunder Bluff"] = 226,
				["Valormok"] = 96,
				["Cenarion Hold"] = 504,
				["Splintertree Post"] = 90,
				["Camp Mojache"] = 360,
			},
			["Undercity"] = {
				["Kargath"] = 489,
				["Light's Hope Chapel"] = 263,
				["Stonard"] = 773,
				["Tarren Mill"] = 141,
				["Grom'gol"] = 802,
				["Revantusk Village"] = 286,
				["Hammerfall"] = 302,
				["Booty Bay"] = 926,
				["The Sepulcher"] = 107,
				["Flame Crest"] = 580,
				["Thorium Point"] = 544,
			},
			["Gadgetzan"] = {
				["Crossroads"] = 307,
				["Bloodvenom Post"] = 520,
				["Sun Rock Retreat"] = 421,
				["Shadowprey Village"] = 416,
				["Ratchet"] = 243,
				["Brackenwall Village"] = 223,
				["Freewind Post"] = 89,
				["Orgrimmar"] = 351,
				["Camp Taurajo"] = 226,
				["Zoram'gar Outpost"] = 508,
				["Marshal's Refuge"] = 108,
				["Moonglade"] = 681,
				["Everlook"] = 571,
				["Thunder Bluff"] = 305,
				["Valormok"] = 448,
				["Cenarion Hold"] = 242,
				["Splintertree Post"] = 438,
				["Camp Mojache"] = 200,
			},
			["Stonard"] = {
				["Kargath"] = 231,
				["Undercity"] = 728,
				["Hammerfall"] = 493,
				["Tarren Mill"] = 664,
				["Booty Bay"] = 230,
				["Thorium Point"] = 270,
				["Flame Crest"] = 199,
				["Grom'gol"] = 179,
			},
			["Tarren Mill"] = {
				["Undercity"] = 140,
				["Thorium Point"] = 435,
				["Grom'gol"] = 690,
				["Revantusk Village"] = 207,
				["Hammerfall"] = 119,
				["Kargath"] = 377,
				["Booty Bay"] = 813,
				["The Sepulcher"] = 101,
				["Flame Crest"] = 466,
				["Stonard"] = 661,
			},
			["Grom'gol"] = {
				["Kargath"] = 247,
				["Stonard"] = 174,
				["Tarren Mill"] = 705,
				["Revantusk Village"] = 0,
				["Hammerfall"] = 509,
				["Booty Bay"] = 78,
				["Thorium Point"] = 384,
				["Flame Crest"] = 415,
				["Undercity"] = 815,
			},
			["InFlight"] = {
				["InFlight"] = 130,
			},
			["Mudsprocket"] = {
				["Brackenwall Village"] = 63,
			},
			["Mok'Nathal Village"] = {
				["Evergrove"] = 88,
				["Shattrath"] = 160,
				["Thunderlord Stronghold"] = 63,
			},
			["Splintertree Post"] = {
				["Crossroads"] = 161,
				["Gadgetzan"] = 508,
				["Sun Rock Retreat"] = 309,
				["Shadowprey Village"] = 477,
				["Ratchet"] = 212,
				["Zoram'gar Outpost"] = 166,
				["Brackenwall Village"] = 320,
				["Camp Mojache"] = 420,
				["Emerald Sanctuary"] = 85,
				["Valormok"] = 92,
				["Thunder Bluff"] = 267,
				["Freewind Post"] = 345,
				["Camp Taurajo"] = 234,
				["Orgrimmar"] = 96,
			},
			["Sanctum of the Stars"] = {
				["Shadowmoon Village"] = 61,
				["Shattrath"] = 186,
				["Area 52"] = 391,
			},
			["Crossroads"] = {
				["Marshal's Refuge"] = 385,
				["Bloodvenom Post"] = 244,
				["Sun Rock Retreat"] = 151,
				["Shadowprey Village"] = 336,
				["Ratchet"] = 53,
				["Brackenwall Village"] = 163,
				["Freewind Post"] = 189,
				["Orgrimmar"] = 118,
				["Gadgetzan"] = 311,
				["Camp Taurajo"] = 74,
				["Zoram'gar Outpost"] = 231,
				["Everlook"] = 303,
				["Moonglade"] = 404,
				["Thunder Bluff"] = 107,
				["Valormok"] = 171,
				["Cenarion Hold"] = 387,
				["Splintertree Post"] = 163,
				["Camp Mojache"] = 255,
			},
			["Garadar"] = {
				["Swamprat Post"] = 157,
				["Stonebreaker Hold"] = 146,
				["Zabra'jin"] = 68,
				["Shattrath"] = 77,
			},
			["Shadowmoon Village"] = {
				["Garadar"] = 208,
				["Shattrath"] = 126,
				["Area 52"] = 331,
				["Swamprat Post"] = 206,
				["Sanctum of the Stars"] = 65,
			},
			["Sun Rock Retreat"] = {
				["Crossroads"] = 150,
				["Bloodvenom Post"] = 396,
				["Moonglade"] = 556,
				["Shadowprey Village"] = 196,
				["Ratchet"] = 206,
				["Zoram'gar Outpost"] = 384,
				["Brackenwall Village"] = 316,
				["Orgrimmar"] = 266,
				["Camp Taurajo"] = 241,
				["Thunder Bluff"] = 176,
				["Freewind Post"] = 341,
				["Valormok"] = 323,
				["Splintertree Post"] = 312,
				["Camp Mojache"] = 404,
			},
			["Shadowprey Village"] = {
				["Crossroads"] = 337,
				["Gadgetzan"] = 408,
				["Sun Rock Retreat"] = 201,
				["Orgrimmar"] = 386,
				["Moonglade"] = 757,
				["Camp Taurajo"] = 261,
				["Zoram'gar Outpost"] = 584,
				["Brackenwall Village"] = 414,
				["Bloodvenom Post"] = 596,
				["Freewind Post"] = 314,
				["Thunder Bluff"] = 173,
				["Valormok"] = 431,
				["Cenarion Hold"] = 337,
				["Splintertree Post"] = 514,
				["Camp Mojache"] = 205,
			},
			["Thorium Point"] = {
				["Undercity"] = 558,
				["Light's Hope Chapel"] = 561,
				["Stonard"] = 278,
				["Tarren Mill"] = 435,
				["Grom'gol"] = 374,
				["Revantusk Village"] = 421,
				["Hammerfall"] = 317,
				["Booty Bay"] = 366,
				["Flame Crest"] = 78,
				["Kargath"] = 59,
			},
			["Light's Hope Chapel"] = {
				["Undercity"] = 262,
				["Revantusk Village"] = 143,
				["Thorium Point"] = 467,
				["Booty Bay"] = 835,
				["The Sepulcher"] = 367,
				["Stonard"] = 717,
				["Kargath"] = 494,
			},
			["Thunder Bluff"] = {
				["Crossroads"] = 103,
				["Camp Mojache"] = 253,
				["Gadgetzan"] = 292,
				["Sun Rock Retreat"] = 182,
				["Shadowprey Village"] = 159,
				["Bloodvenom Post"] = 356,
				["Ratchet"] = 154,
				["Zoram'gar Outpost"] = 390,
				["Brackenwall Village"] = 240,
				["Camp Taurajo"] = 87,
				["Freewind Post"] = 204,
				["Valormok"] = 252,
				["Everlook"] = 380,
				["Cenarion Hold"] = 385,
				["Splintertree Post"] = 265,
				["Orgrimmar"] = 208,
			},
			["Brackenwall Village"] = {
				["Crossroads"] = 162,
				["Gadgetzan"] = 223,
				["Sun Rock Retreat"] = 308,
				["Shadowprey Village"] = 392,
				["Camp Taurajo"] = 50,
				["Zoram'gar Outpost"] = 396,
				["Ratchet"] = 89,
				["Bloodvenom Post"] = 408,
				["Moonglade"] = 568,
				["Thunder Bluff"] = 231,
				["Valormok"] = 335,
				["Everlook"] = 467,
				["Splintertree Post"] = 325,
				["Orgrimmar"] = 217,
			},
			["Evergrove"] = {
				["Garadar"] = 262,
				["Shattrath"] = 238,
				["Thunderlord Stronghold"] = 36,
				["Mok'Nathal Village"] = 91,
				["Area 52"] = 78,
			},
			["Zoram'gar Outpost"] = {
				["Crossroads"] = 235,
				["Bloodvenom Post"] = 473,
				["Sun Rock Retreat"] = 374,
				["Shadowprey Village"] = 565,
				["Camp Taurajo"] = 326,
				["Brackenwall Village"] = 394,
				["Camp Mojache"] = 485,
				["Thunder Bluff"] = 404,
				["Freewind Post"] = 419,
				["Splintertree Post"] = 173,
				["Orgrimmar"] = 259,
			},
			["Thunderlord Stronghold"] = {
				["Evergrove"] = 27,
				["Mok'Nathal Village"] = 56,
				["Shattrath"] = 203,
			},
			["Booty Bay"] = {
				["Kargath"] = 315,
				["Refuge Pointe"] = 740,
				["Stonard"] = 240,
				["Grom'gol"] = 76,
				["Revantusk Village"] = 666,
				["Hammerfall"] = 577,
				["Thorium Point"] = 481,
				["Light's Hope Chapel"] = 773,
				["Chillwind Camp"] = 773,
				["Southshore"] = 753,
			},
			["The Sepulcher"] = {
				["Undercity"] = 112,
				["Tarren Mill"] = 96,
				["Light's Hope Chapel"] = 380,
			},
			["Falcon Watch"] = {
				["Stonebreaker Hold"] = 139,
				["Shattrath"] = 71,
				["Spinebreaker Ridge"] = 139,
				["Swamprat Post"] = 69,
				["Zabra'jin"] = 150,
				["Thrallmar"] = 73,
			},
			["The Stormspire"] = {
				["Shattrath"] = 277,
				["Area 52"] = 54,
			},
			["Everlook"] = {
				["Auberdine"] = 280,
				["Bloodvenom Post"] = 197,
				["Moonglade"] = 134,
				["Valormok"] = 136,
				["Cenarion Hold"] = 798,
				["Feathermoon"] = 755,
				["Orgrimmar"] = 244,
			},
			["Stonebreaker Hold"] = {
				["Shadowmoon Village"] = 68,
				["Garadar"] = 138,
				["Zabra'jin"] = 193,
				["Shattrath"] = 57,
			},
			["Shattrath"] = {
				["Evergrove"] = 211,
				["Garadar"] = 82,
				["Spinebreaker Ridge"] = 215,
				["Swamprat Post"] = 80,
				["Area 52"] = 205,
				["Hellfire Peninsula"] = 220,
				["Falcon Watch"] = 78,
				["Shadowmoon Village"] = 133,
				["Stonebreaker Hold"] = 69,
				["Thrallmar"] = 150,
				["Thunderlord Stronghold"] = 185,
				["Mok'Nathal Village"] = 150,
				["Zabra'jin"] = 137,
				["The Stormspire"] = 332,
			},
			["Spinebreaker Ridge"] = {
				["Shattrath"] = 200,
				["Swamprat Post"] = 198,
				["Falcon Watch"] = 130,
				["Thrallmar"] = 63,
			},
			["Silvermoon City"] = {
				["Tranquillien"] = 66,
			},
			["Swamprat Post"] = {
				["Garadar"] = 168,
				["Shattrath"] = 87,
				["Thrallmar"] = 136,
				["Zabra'jin"] = 111,
				["Falcon Watch"] = 63,
			},
			["Camp Taurajo"] = {
				["Crossroads"] = 79,
				["Bloodvenom Post"] = 328,
				["Sun Rock Retreat"] = 229,
				["Shadowprey Village"] = 276,
				["Ratchet"] = 131,
				["Brackenwall Village"] = 60,
				["Everlook"] = 387,
				["Orgrimmar"] = 222,
				["Gadgetzan"] = 222,
				["Zoram'gar Outpost"] = 315,
				["Freewind Post"] = 127,
				["Moonglade"] = 488,
				["Valormok"] = 255,
				["Thunder Bluff"] = 114,
				["Cenarion Hold"] = 384,
				["Splintertree Post"] = 242,
				["Camp Mojache"] = 248,
			},
			["Area 52"] = {
				["Stonebreaker Hold"] = 372,
				["Shattrath"] = 224,
				["Thunderlord Stronghold"] = 108,
				["Cosmowrench"] = 67,
				["Shadowmoon Village"] = 357,
				["The Stormspire"] = 49,
				["Swamprat Post"] = 137,
			},
			["Emerald Sanctuary"] = {
				["Bloodvenom Post"] = 80,
				["Moonglade"] = 204,
				["Gadgetzan"] = 514,
				["Ratchet"] = 289,
				["Splintertree Post"] = 84,
				["Orgrimmar"] = 173,
			},
			["Plaguewood"] = {
				["Eastwall Tower"] = 65,
			},
			["Tranquillien"] = {
				["Silvermoon City"] = 74,
			},
			["Thrallmar"] = {
				["Shattrath"] = 138,
				["Spinebreaker Ridge"] = 66,
				["Falcon Watch"] = 67,
				["Swamprat Post"] = 136,
				["Zabra'jin"] = 217,
				["Hellfire Peninsula"] = 70,
			},
			["Valormok"] = {
				["Crossroads"] = 251,
				["Bloodvenom Post"] = 233,
				["Sun Rock Retreat"] = 395,
				["Camp Taurajo"] = 342,
				["Brackenwall Village"] = 352,
				["Camp Mojache"] = 505,
				["Moonglade"] = 277,
				["Gadgetzan"] = 540,
				["Everlook"] = 132,
				["Freewind Post"] = 440,
				["Splintertree Post"] = 94,
				["Orgrimmar"] = 101,
			},
			["Cenarion Hold"] = {
				["Gadgetzan"] = 247,
				["Marshal's Refuge"] = 97,
			},
			["Zabra'jin"] = {
				["Swamprat Post"] = 112,
				["Garadar"] = 82,
				["Shattrath"] = 152,
				["Falcon Watch"] = 148,
			},
			["Camp Mojache"] = {
				["Crossroads"] = 269,
				["Gadgetzan"] = 201,
				["Sun Rock Retreat"] = 403,
				["Shadowprey Village"] = 201,
				["Moonglade"] = 673,
				["Bloodvenom Post"] = 512,
				["Zoram'gar Outpost"] = 500,
				["Brackenwall Village"] = 433,
				["Everlook"] = 572,
				["Thunder Bluff"] = 260,
				["Freewind Post"] = 109,
				["Valormok"] = 429,
				["Cenarion Hold"] = 131,
				["Splintertree Post"] = 430,
				["Orgrimmar"] = 381,
			},
			["Shattered Sun Staging Area"] = {
				["The Sin'loren"] = 60,
				["Shattered Sun Staging Area"] = 255,
			},
			["The Sin'loren"] = {
				["Shattered Sun Staging Area"] = 12,
			},
		},
		["Alliance"] = {
			["Marshal's Refuge"] = {
				["Gadgetzan"] = 107,
				["Feathermoon"] = 276,
				["Cenarion Hold"] = 98,
				["Auberdine"] = 746,
				["Rut'theran Village"] = 833,
			},
			["Moonglade"] = {
				["Marshal's Refuge"] = 873,
				["Gadgetzan"] = 718,
				["Nijel's Point"] = 429,
				["Theramore"] = 558,
				["Auberdine"] = 144,
				["Everlook"] = 133,
				["Thalanaar"] = 724,
				["Talonbranch Glade"] = 64,
				["Talrendis Point"] = 312,
				["Astranaar"] = 323,
				["Cenarion Hold"] = 786,
				["Feathermoon"] = 620,
				["Rut'theran Village"] = 230,
			},
			["Ratchet"] = {
				["Theramore"] = 108,
			},
			["Hellfire Peninsula"] = {
				["Temple of Telhamat"] = 142,
				["Honor Hold"] = 69,
				["Telredor"] = 222,
			},
			["Talrendis Point"] = {
				["Everlook"] = 181,
				["Theramore"] = 245,
				["Gadgetzan"] = 407,
				["Astranaar"] = 486,
				["Thalanaar"] = 411,
				["Cenarion Hold"] = 619,
				["Auberdine"] = 306,
				["Rut'theran Village"] = 393,
			},
			["Cosmowrench"] = {
				["The Stormspire"] = 61,
				["Area 52"] = 65,
			},
			["Chillwind Camp"] = {
				["Thelsamar"] = 411,
				["Refuge Pointe"] = 237,
				["Morgan's Vigil"] = 454,
				["Nethergarde Keep"] = 667,
				["Thorium Point"] = 355,
				["Light's Hope Chapel"] = 153,
				["Aerie Peak"] = 162,
				["Booty Bay"] = 723,
				["Lakeshire"] = 723,
				["Sentinel Hill"] = 558,
				["Menethil Harbor"] = 201,
				["Ironforge"] = 262,
				["Stormwind"] = 475,
				["Darkshire"] = 794,
				["Southshore"] = 87,
			},
			["Nijel's Point"] = {
				["Gadgetzan"] = 469,
				["Everlook"] = 601,
				["Talonbranch Glade"] = 477,
				["Auberdine"] = 284,
				["Theramore"] = 309,
				["Rut'theran Village"] = 369,
			},
			["Gadgetzan"] = {
				["Marshal's Refuge"] = 107,
				["Ratchet"] = 278,
				["Feathermoon"] = 351,
				["Thalanaar"] = 181,
				["Cenarion Hold"] = 200,
				["Theramore"] = 157,
				["Nijel's Point"] = 495,
			},
			["Thelsamar"] = {
				["Refuge Pointe"] = 165,
				["Darkshire"] = 450,
				["Light's Hope Chapel"] = 412,
				["Nethergarde Keep"] = 563,
				["Thorium Point"] = 207,
				["Morgan's Vigil"] = 311,
				["Aerie Peak"] = 238,
				["Booty Bay"] = 576,
				["Lakeshire"] = 447,
				["Sentinel Hill"] = 411,
				["Menethil Harbor"] = 156,
				["Ironforge"] = 117,
				["Stormwind"] = 331,
				["Chillwind Camp"] = 407,
				["Southshore"] = 288,
			},
			["Allerian Stronghold"] = {
				["Shattrath"] = 77,
				["Honor Hold"] = 97,
				["Telaar"] = 150,
				["Wildhammer Stronghold"] = 80,
			},
			["Orebor Harborage"] = {
				["Telredor"] = 55,
				["Sylvanaar"] = 66,
			},
			["Auberdine"] = {
				["Moonglade"] = 153,
				["Nijel's Point"] = 285,
				["Theramore"] = 694,
				["Astranaar"] = 179,
				["Talrendis Point"] = 305,
				["Talonbranch Glade"] = 193,
				["Thalanaar"] = 646,
				["Stonetalon Peak"] = 182,
				["Everlook"] = 286,
				["Cenarion Hold"] = 642,
				["Feathermoon"] = 476,
				["Rut'theran Village"] = 85,
			},
			["Wildhammer Stronghold"] = {
				["Allerian Stronghold"] = 101,
				["Shattrath"] = 175,
				["Telaar"] = 250,
			},
			["Thalanaar"] = {
				["Auberdine"] = 786,
				["Theramore"] = 164,
				["Gadgetzan"] = 174,
				["Talrendis Point"] = 403,
				["Astranaar"] = 967,
				["Cenarion Hold"] = 375,
				["Feathermoon"] = 170,
				["Rut'theran Village"] = 874,
			},
			["Thorium Point"] = {
				["Light's Hope Chapel"] = 449,
				["Darkshire"] = 439,
				["Refuge Pointe"] = 344,
				["Nethergarde Keep"] = 312,
				["Morgan's Vigil"] = 99,
				["Booty Bay"] = 612,
				["Aerie Peak"] = 398,
				["Sentinel Hill"] = 505,
				["Lakeshire"] = 368,
				["Thelsamar"] = 200,
				["Menethil Harbor"] = 229,
				["Ironforge"] = 96,
				["Stormwind"] = 253,
				["Chillwind Camp"] = 393,
				["Southshore"] = 338,
			},
			["Feathermoon"] = {
				["Everlook"] = 788,
				["Auberdine"] = 470,
				["Gadgetzan"] = 344,
				["Talonbranch Glade"] = 663,
				["Thalanaar"] = 170,
				["Cenarion Hold"] = 167,
				["Theramore"] = 334,
				["Rut'theran Village"] = 557,
			},
			["Southshore"] = {
				["Darkshire"] = 744,
				["Light's Hope Chapel"] = 243,
				["Refuge Pointe"] = 75,
				["Nethergarde Keep"] = 617,
				["Thorium Point"] = 245,
				["Morgan's Vigil"] = 404,
				["Aerie Peak"] = 74,
				["Booty Bay"] = 667,
				["Lakeshire"] = 673,
				["Sentinel Hill"] = 499,
				["Menethil Harbor"] = 114,
				["Ironforge"] = 210,
				["Stormwind"] = 418,
				["Chillwind Camp"] = 85,
				["Thelsamar"] = 249,
			},
			["Evergrove"] = {
				["Sylvanaar"] = 54,
				["Area 52"] = 73,
			},
			["Telredor"] = {
				["Telaar"] = 125,
				["Shattrath"] = 98,
				["Sylvanaar"] = 92,
				["Temple of Telhamat"] = 82,
				["Orebor Harborage"] = 56,
				["Honor Hold"] = 169,
				["Hellfire Peninsula"] = 230,
			},
			["Expedition Point"] = {
				["Shatter Point"] = 57,
			},
			["Refuge Pointe"] = {
				["Light's Hope Chapel"] = 242,
				["Darkshire"] = 748,
				["Morgan's Vigil"] = 408,
				["Nethergarde Keep"] = 621,
				["Thorium Point"] = 309,
				["Thelsamar"] = 173,
				["Aerie Peak"] = 73,
				["Ironforge"] = 274,
				["Lakeshire"] = 677,
				["Sentinel Hill"] = 515,
				["Menethil Harbor"] = 131,
				["Booty Bay"] = 683,
				["Stormwind"] = 434,
				["Chillwind Camp"] = 130,
				["Southshore"] = 91,
			},
			["Temple of Telhamat"] = {
				["Shattrath"] = 179,
				["Sylvanaar"] = 172,
				["Honor Hold"] = 89,
				["Telredor"] = 81,
				["Hellfire Peninsula"] = 149,
			},
			["Area 52"] = {
				["Evergrove"] = 78,
				["Sylvanaar"] = 127,
				["Toshley's Station"] = 93,
				["Cosmowrench"] = 67,
				["The Stormspire"] = 49,
			},
			["Theramore"] = {
				["Marshal's Refuge"] = 267,
				["Gadgetzan"] = 160,
				["Auberdine"] = 622,
				["Ratchet"] = 120,
				["Thalanaar"] = 166,
				["Talrendis Point"] = 238,
				["Cenarion Hold"] = 357,
				["Feathermoon"] = 336,
				["Nijel's Point"] = 337,
			},
			["Aerie Peak"] = {
				["Light's Hope Chapel"] = 169,
				["Darkshire"] = 793,
				["Refuge Pointe"] = 75,
				["Nethergarde Keep"] = 666,
				["Thorium Point"] = 354,
				["Morgan's Vigil"] = 453,
				["Ironforge"] = 262,
				["Sentinel Hill"] = 557,
				["Lakeshire"] = 723,
				["Thelsamar"] = 249,
				["Menethil Harbor"] = 203,
				["Booty Bay"] = 722,
				["Stormwind"] = 475,
				["Chillwind Camp"] = 57,
				["Southshore"] = 68,
			},
			["Everlook"] = {
				["Orgrimmar"] = 298,
				["Gadgetzan"] = 584,
				["Moonglade"] = 123,
				["Bloodvenom Post"] = 197,
				["Theramore"] = 424,
				["Auberdine"] = 280,
				["Valormok"] = 136,
				["Astranaar"] = 665,
				["Thalanaar"] = 590,
				["Talonbranch Glade"] = 125,
				["Nijel's Point"] = 565,
				["Talrendis Point"] = 179,
				["Cenarion Hold"] = 798,
				["Feathermoon"] = 755,
				["Rut'theran Village"] = 365,
			},
			["Lakeshire"] = {
				["Darkshire"] = 71,
				["Refuge Pointe"] = 633,
				["Light's Hope Chapel"] = 729,
				["Thorium Point"] = 374,
				["Morgan's Vigil"] = 266,
				["Aerie Peak"] = 690,
				["Booty Bay"] = 244,
				["Stormwind"] = 115,
				["Sentinel Hill"] = 136,
				["Menethil Harbor"] = 509,
				["Ironforge"] = 376,
				["Thelsamar"] = 480,
				["Chillwind Camp"] = 666,
				["Southshore"] = 645,
			},
			["Telaar"] = {
				["Allerian Stronghold"] = 122,
				["Shattrath"] = 89,
				["Telredor"] = 127,
			},
			["Stonetalon Peak"] = {
				["Astranaar"] = 155,
			},
			["Ironforge"] = {
				["Refuge Pointe"] = 257,
				["Darkshire"] = 529,
				["Morgan's Vigil"] = 189,
				["Nethergarde Keep"] = 402,
				["Thorium Point"] = 89,
				["Light's Hope Chapel"] = 353,
				["Aerie Peak"] = 302,
				["Lakeshire"] = 458,
				["Stormwind"] = 214,
				["Sentinel Hill"] = 294,
				["Menethil Harbor"] = 132,
				["Booty Bay"] = 462,
				["Thelsamar"] = 104,
				["Chillwind Camp"] = 297,
				["Southshore"] = 268,
			},
			["Toshley's Station"] = {
				["Area 52"] = 85,
				["Shattrath"] = 238,
				["Sylvanaar"] = 60,
			},
			["The Stormspire"] = {
				["Cosmowrench"] = 69,
				["Area 52"] = 59,
				["Sylvanaar"] = 167,
			},
			["Rut'theran Village"] = {
				["Moonglade"] = 241,
				["Auberdine"] = 86,
				["Astranaar"] = 264,
				["Talonbranch Glade"] = 281,
				["Thalanaar"] = 733,
				["Everlook"] = 374,
				["Cenarion Hold"] = 730,
				["Feathermoon"] = 563,
				["Nijel's Point"] = 373,
			},
			["Sylvanaar"] = {
				["Evergrove"] = 55,
				["Orebor Harborage"] = 66,
				["Shattrath"] = 181,
				["Honor Hold"] = 251,
				["Toshley's Station"] = 58,
				["Area 52"] = 120,
				["The Stormspire"] = 170,
				["Telredor"] = 82,
			},
			["Shatter Point"] = {
				["Temple of Telhamat"] = 133,
				["Honor Point"] = 41,
				["Honor Hold"] = 57,
				["Hellfire Peninsula"] = 33,
			},
			["Shattrath"] = {
				["Allerian Stronghold"] = 76,
				["Shatter Point"] = 225,
				["Telaar"] = 89,
				["Wildhammer Stronghold"] = 154,
				["Telredor"] = 86,
				["Sylvanaar"] = 175,
			},
			["Darkshire"] = {
				["Refuge Pointe"] = 791,
				["Thelsamar"] = 637,
				["Light's Hope Chapel"] = 885,
				["Aerie Peak"] = 836,
				["Sentinel Hill"] = 98,
				["Lakeshire"] = 64,
				["Ironforge"] = 534,
				["Menethil Harbor"] = 667,
				["Booty Bay"] = 173,
				["Stormwind"] = 90,
				["Chillwind Camp"] = 843,
				["Southshore"] = 802,
			},
			["Nethergarde Keep"] = {
				["Light's Hope Chapel"] = 794,
				["Darkshire"] = 93,
				["Refuge Pointe"] = 699,
				["Morgan's Vigil"] = 239,
				["Thorium Point"] = 305,
				["Ironforge"] = 443,
				["Aerie Peak"] = 752,
				["Sentinel Hill"] = 191,
				["Lakeshire"] = 157,
				["Thelsamar"] = 546,
				["Menethil Harbor"] = 576,
				["Booty Bay"] = 266,
				["Stormwind"] = 198,
				["Chillwind Camp"] = 741,
				["Southshore"] = 710,
			},
			["Honor Point"] = {
				["Shatter Point"] = 31,
			},
			["Morgan's Vigil"] = {
				["Refuge Pointe"] = 460,
				["Thelsamar"] = 307,
				["Light's Hope Chapel"] = 560,
				["Nethergarde Keep"] = 213,
				["Thorium Point"] = 107,
				["Darkshire"] = 124,
				["Aerie Peak"] = 505,
				["Ironforge"] = 204,
				["Lakeshire"] = 270,
				["Sentinel Hill"] = 234,
				["Menethil Harbor"] = 339,
				["Booty Bay"] = 513,
				["Stormwind"] = 154,
				["Chillwind Camp"] = 501,
				["Southshore"] = 472,
			},
			["Astranaar"] = {
				["Auberdine"] = 149,
			},
			["Menethil Harbor"] = {
				["Morgan's Vigil"] = 290,
				["Darkshire"] = 630,
				["Refuge Pointe"] = 116,
				["Nethergarde Keep"] = 503,
				["Thorium Point"] = 191,
				["Light's Hope Chapel"] = 343,
				["Aerie Peak"] = 184,
				["Booty Bay"] = 553,
				["Lakeshire"] = 559,
				["Thelsamar"] = 166,
				["Sentinel Hill"] = 386,
				["Ironforge"] = 91,
				["Stormwind"] = 263,
				["Chillwind Camp"] = 198,
				["Southshore"] = 110,
			},
			["Stormwind"] = {
				["Light's Hope Chapel"] = 569,
				["Thelsamar"] = 367,
				["Refuge Pointe"] = 512,
				["Nethergarde Keep"] = 179,
				["Thorium Point"] = 252,
				["Morgan's Vigil"] = 160,
				["Aerie Peak"] = 565,
				["Ironforge"] = 263,
				["Lakeshire"] = 116,
				["Sentinel Hill"] = 81,
				["Menethil Harbor"] = 348,
				["Booty Bay"] = 249,
				["Darkshire"] = 119,
				["Chillwind Camp"] = 510,
				["Southshore"] = 506,
			},
			["Booty Bay"] = {
				["Kargath"] = 395,
				["Darkshire"] = 176,
				["Refuge Pointe"] = 740,
				["Stonard"] = 252,
				["Thorium Point"] = 481,
				["Grom'gol"] = 103,
				["Aerie Peak"] = 791,
				["Morgan's Vigil"] = 374,
				["Stormwind"] = 222,
				["Light's Hope Chapel"] = 773,
				["Menethil Harbor"] = 618,
				["Ironforge"] = 484,
				["Thelsamar"] = 587,
				["Chillwind Camp"] = 773,
				["Southshore"] = 753,
			},
			["Sentinel Hill"] = {
				["Morgan's Vigil"] = 248,
				["Darkshire"] = 100,
				["Light's Hope Chapel"] = 700,
				["Nethergarde Keep"] = 193,
				["Thorium Point"] = 355,
				["Refuge Pointe"] = 605,
				["Aerie Peak"] = 659,
				["Ironforge"] = 349,
				["Lakeshire"] = 132,
				["Thelsamar"] = 452,
				["Menethil Harbor"] = 482,
				["Booty Bay"] = 187,
				["Stormwind"] = 89,
				["Chillwind Camp"] = 647,
				["Southshore"] = 617,
			},
			["Talonbranch Glade"] = {
				["Marshal's Refuge"] = 809,
				["Gadgetzan"] = 702,
				["Moonglade"] = 69,
				["Theramore"] = 542,
				["Nijel's Point"] = 473,
				["Auberdine"] = 188,
				["Everlook"] = 124,
				["Talrendis Point"] = 297,
				["Thalanaar"] = 708,
				["Astranaar"] = 366,
				["Cenarion Hold"] = 830,
				["Feathermoon"] = 663,
				["Rut'theran Village"] = 275,
			},
			["Cenarion Hold"] = {
				["Crossroads"] = 401,
				["Bloodvenom Post"] = 644,
				["Moonglade"] = 801,
				["Shadowprey Village"] = 334,
				["Theramore"] = 349,
				["Brackenwall Village"] = 470,
				["Talrendis Point"] = 587,
				["Rut'theran Village"] = 734,
				["Orgrimmar"] = 536,
				["Splintertree Post"] = 562,
				["Sun Rock Retreat"] = 535,
				["Gadgetzan"] = 191,
				["Valormok"] = 572,
				["Everlook"] = 768,
				["Freewind Post"] = 241,
				["Camp Taurajo"] = 379,
				["Zoram'gar Outpost"] = 632,
				["Thunder Bluff"] = 393,
				["Ratchet"] = 469,
				["Thalanaar"] = 373,
				["Astranaar"] = 1155,
				["Talonbranch Glade"] = 841,
				["Auberdine"] = 648,
				["Feathermoon"] = 178,
				["Camp Mojache"] = 132,
			},
			["Honor Hold"] = {
				["Allerian Stronghold"] = 118,
				["Shatter Point"] = 57,
				["Shattrath"] = 121,
				["Temple of Telhamat"] = 76,
				["Telredor"] = 157,
				["Hellfire Peninsula"] = 65,
			},
			["Light's Hope Chapel"] = {
				["Refuge Pointe"] = 250,
				["Darkshire"] = 906,
				["Morgan's Vigil"] = 566,
				["Nethergarde Keep"] = 779,
				["Thorium Point"] = 467,
				["Thelsamar"] = 424,
				["Aerie Peak"] = 175,
				["Ironforge"] = 374,
				["Lakeshire"] = 835,
				["Sentinel Hill"] = 670,
				["Menethil Harbor"] = 378,
				["Booty Bay"] = 835,
				["Stormwind"] = 588,
				["Chillwind Camp"] = 154,
				["Southshore"] = 243,
			},
			["Mudsprocket"] = {
				["Theramore"] = 53,
				["Thalanaar"] = 106,
			},
			["Shattered Sun Staging Area"] = {
				["The Sin'loren"] = 60,
				["Shattered Sun Staging Area"] = 255,
			},
			["The Sin'loren"] = {
				["Shattered Sun Staging Area"] = 12,
			},
		},
	}
	
	if localization then
		local temp = {}
		for faction, t in pairs(data) do
			temp[faction] = {}
			for source, dt in pairs(t) do
				local sl = localization[source]
				if sl then
					temp[faction][sl] = {}
					for destination, time in pairs(dt) do
						local dl = localization[destination]
						if dl then
							temp[faction][sl][dl] = time
						end
					end
				end
			end
		end
		return temp
	end
	return data
end

