--[[
	Author: Elsia
	InCombatIndicator, based on Nudge.
--]]

local Default = {
	profile = 
	{
		background = false,
		ooc = false,
		font = 
		{ textSize	= 18,
	      textfont = "Friz Quadrata TT",
		},
		pos	= {},
		locked = false
	}
}

local Colors = {
	outofcombat = { r=0.06, g=0.98, b=0, a=1 },
	incombat = { r=0.94, g=0, b=0.14, a=1 }
}

InCombatIndicator = LibStub("AceAddon-3.0"):NewAddon("InCombatIndicator","AceEvent-3.0", "AceTimer-3.0", "AceConsole-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("InCombatIndicator")
local SML = LibStub:GetLibrary("LibSharedMedia-3.0", true)

if not deepcopy then
function deepcopy(object)
	local lookup_table = {}
	local function _copy(object)
		if type(object) ~= "table" then
			return object
		elseif lookup_table[object] then
			return lookup_table[object]
		end
		local new_table = {}
		lookup_table[object] = new_table
		for index, value in pairs(object) do
			new_table[_copy(index)] = _copy(value)
		end
		return setmetatable(new_table, getmetatable(object))
	end
	return _copy(object)
end
end

function InCombatIndicator:OnInitialize()

	local Options = {
		name = "InCombatIndicator",
		type = "group",
		args = {
	        lock = {
	            name = "Lock",
	            type = "toggle",
	            desc = "Lock/Unlock the button.",
	            get = function() return self.db.profile.locked end,
	            set = function( _,v ) self.db.profile.locked = v end,
				order = 20,
            },
			ooc = {
				name = "OOC", type = "toggle",
				desc = "Enable/Disable OOC display.",
				order = 140,
	            get = function() return self.db.profile.ooc end,
	            set = function(_, v ) self.db.profile.ooc = v end,
			}
		}
	}

	local Options2= deepcopy(Options) -- This is needed because ace3 folks won't handle inserting into blizz ui nicely.
--	local Options2 = Options
	
	Options2.args.font = {
				name = "Font", type = 'group',
				desc = "Set the font size of different elements.",
				args = {
					text = {
						name = "Font size", type = 'range', min = 6, max = 32, step = 1,
						desc = "Set the font size on the button.",
						order = 80,
						get = function() return self.db.profile.font.textSize end,
						set = function(_, v )
							self.db.profile.font.textSize = v
							self:Layout()
						end
					}
				}
	}
	
	if SML then
		Options2.args.font.args.textfont = {
			name = "Font face",
			desc = "Typeface to use for the text.",
			type = "select", 
			values = SML:List("font"),
			get = function()
				for k, v in pairs(SML:List("font")) do
					if self.db.profile.font.textfont == v then
						return k
					end
				end
				return k
			end,
			set = function(_,v )
				self.db.profile.font.textfont = SML:List("font")[v]
				self:Layout()
			end,
			order = 210
		}
	end

	local acedb = LibStub:GetLibrary("AceDB-3.0")
	self.db = acedb:New("InCombatIndicatorDB", Default)
	self.db.RegisterCallback( self, "OnNewProfile", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileReset", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileChanged", "HandleProfileChanges" )
	self.db.RegisterCallback( self, "OnProfileCopied", "HandleProfileChanges" )

	Options2.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	LibStub("AceConfig-3.0"):RegisterOptionsTable("InCombatIndicator", Options2, "ici") -- 4 registrations instead of 1 to avoid bloat :P
	--LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("InCombatIndicator Blizz", Options)
	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("InCombatIndicator Font",Options2.args.font)
 	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("InCombatIndicator Blizz", Options)

	LibStub("AceConfigRegistry-3.0"):RegisterOptionsTable("InCombatIndicator Profile", Options2.args.profile)
	
	AceConfigDialog:AddToBlizOptions("InCombatIndicator Blizz", "InCombatIndicator") -- 3 adds instead of one to avoid bloat, and a table duplication :P
	AceConfigDialog:AddToBlizOptions("InCombatIndicator Profile", "Profile", "InCombatIndicator")
	AceConfigDialog:AddToBlizOptions("InCombatIndicator Font", "Font", "InCombatIndicator")
end

function InCombatIndicator:CleanInsertBlizOptions(v2)
	local 	groupfreeoptions = {}
	
	for k,v in pairs(v2) do
		if type(v)~="table" then
			groupfreeoptions[k]=v
		end
	end
	return groupfreeoptions
end

function InCombatIndicator:HandleProfileChanges()
	InCombatIndicator:Layout()
	InCombatIndicator:TargetChanged()
end

function InCombatIndicator:UpdateMedia()
	InCombatIndicator:Layout()
end

function InCombatIndicator:OnEnable()

	self:CreateFrameWork()
	
	self:ScheduleRepeatingTimer("OnUpdate", 0.1)
	self.master:Show()
end

function InCombatIndicator:SavePosition()

	local x, y = self.master:GetLeft(), self.master:GetTop()
	local s = self.master:GetEffectiveScale()
	
	self.db.profile.pos.x = x * s
	self.db.profile.pos.y = y * s

end

function InCombatIndicator:SetPosition()

	if self.db.profile.pos.x then
		local x = self.db.profile.pos.x
		local y = self.db.profile.pos.y

		local s = self.master:GetEffectiveScale()

		self.master:ClearAllPoints()
		self.master:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", x / s, y / s)
	else
		self.master:ClearAllPoints()
		self.master:SetPoint("CENTER", UIParent, "CENTER", 0, 0)
	end

end

function InCombatIndicator:CreateFrameWork()	

	self.master = CreateFrame("Frame", "InCombatIndicatorFrame", UIParent)
	self.master:Hide()
	
	self.master:SetMovable(true)

	if not self.db.profile.locked then
		self.master:EnableMouse(true)
	else
		self.master:EnableMouse(false)
	end
		
	self.master:RegisterForDrag("LeftButton")
	self.master:SetScript("OnDragStart", function() if not self.db.profile.locked then self["master"]:StartMoving() end end)
	self.master:SetScript("OnDragStop", function() self["master"]:StopMovingOrSizing() self:SavePosition() end)
		
	self.master.Range = self.master:CreateFontString(nil, "ARTWORK")
	self.master.Range:SetFontObject(TextStatusBarText)
    
    self:Layout()
	
end

function InCombatIndicator:Layout()

	if not self.master or not self.master.Range then return end

	local textfont = SML and SML:Fetch("font", self.db.profile.font.textfont) or "Fonts\\FRIZQT__.ttf"
	
	self.master:SetWidth( 135 )
	self.master:SetHeight( 35 )

	
	self.master.Range:SetJustifyH("CENTER")
	local gameFont, _, oflags = self.master.Range:GetFont()
	if SML then
	  gameFont = textfont
	end
	self.master.Range:SetFont( gameFont, self.db.profile.font.textSize, "OUTLINE") --[, oflags )--]

	self.master.Range:ClearAllPoints()
	self.master.Range:SetPoint("CENTER", self.master, "CENTER",0,0)
	self.master.Range:SetTextColor( TOOLTIP_DEFAULT_BACKGROUND_COLOR.r, TOOLTIP_DEFAULT_BACKGROUND_COLOR.g, TOOLTIP_DEFAULT_BACKGROUND_COLOR.b )
	
	self:SetPosition()
	
end

function InCombatIndicator:OnUpdate()
	
	local text

	if not self.db.profile.locked then
		self.master:EnableMouse(true)
	else
		self.master:EnableMouse(false)
	end

	if (InCombatLockdown()) then
			text = L["In Combat"]
			InCombatIndicator.index = "incombat"
	else
			text = L["Out of Combat"]
			InCombatIndicator.index = "outofcombat"
	end

	if(self.db.profile.background) then
		InCombatIndicator.master:SetBackdropColor( 
			Colors[InCombatIndicator.index].r,
			Colors[InCombatIndicator.index].g,
			Colors[InCombatIndicator.index].b,
			Colors[InCombatIndicator.index].a
		)
			
		InCombatIndicator.master:SetBackdropBorderColor( 
			Colors[InCombatIndicator.index].r,
			Colors[InCombatIndicator.index].g,
			Colors[InCombatIndicator.index].b,
			Colors[InCombatIndicator.index].a
		)

		InCombatIndicator.master:SetBackdropBorderColor( 
			1,
			1,
			1,
			1
		)
	else
		InCombatIndicator.master:SetBackdropColor( 
			0,
			0,
			0,
			0
		)
			
		InCombatIndicator.master:SetBackdropBorderColor( 
			0,
			0,
			0,
			0
		)
	
		if (self.db.profile.ooc or InCombatIndicator.index == "incombat") then
			InCombatIndicator.master.Range:SetTextColor( 
				Colors[InCombatIndicator.index].r,
				Colors[InCombatIndicator.index].g,
				Colors[InCombatIndicator.index].b,
				Colors[InCombatIndicator.index].a
			)
		else
			InCombatIndicator.master.Range:SetTextColor( 
				0,
				0,
				0,
				0
			)
		end
	end
	
	InCombatIndicator.master.Range:SetText( text )

end