---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------Addon Constants and variables-------------
---------------------Addon Constants and variables-------------
---------------------Addon Constants and variables-------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



local Immortal_Version="1.0";


local Immortal_Events={
	"COMBAT_LOG_EVENT_UNFILTERED",
};


local Immortal_Combat_Events={
	["SPELL_AURA_APPLIED"]=1,
};


Immortal_Options = {
	["enable"] = 1,
	["scale"] = 1,
	["scalebar"] = 1,

};


local Immortal_eventNeeded = false;

local Immortal_TimeSinceLastUpdate=0;
local Immortal_UpdateInterval=0.2;


local Immortal_Activated=0;

local Immortal_Movetime=0;


local args = {};







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------On load and defaults----------------------
---------------------On load and defaults----------------------
---------------------On load and defaults----------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



function Immortal_OnLoad()

	SLASH_Immortal1 = "/immortal";
	SlashCmdList["Immortal"] = Immortal_SlashHandler;

	Immortal_Frame:RegisterEvent("VARIABLES_LOADED");


	if (DEFAULT_CHAT_FRAME) then
		Immortal_Print("Immortal version "..Immortal_Version.." loaded. Developed by SuperCommander");
		Immortal_Print("/immortal for options [on, off, move, scale, scalebar, reset]");
	end

end


function Immortal_Reset()

	Immortal_Options = {
		["enable"] = 1,
		["scale"] = 1,
		["scalebar"] = 1,

	};


	Immortal_Move_Frame:ClearAllPoints();
	Immortal_Timer_Move_Frame:ClearAllPoints();

	Immortal_Move_Frame:SetPoint("CENTER", "UIParent", "CENTER", 0, 0);
	Immortal_Timer_Move_Frame:SetPoint("CENTER", "UIParent", "CENTER", 0, -100);

	Immortal_Scale(1);
	Immortal_Scale_Bar(1);

	Immortal_Print("Restoring default settings");
	
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
-----------------Slashcommands and registering events----------
-----------------Slashcommands and registering events----------
-----------------Slashcommands and registering events----------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



--Slashcommands
function Immortal_SlashHandler(msg)

	if (string.lower(msg)=="off") then 
		Immortal_Print("Immortal is now disabled");
		Immortal_Unregister();
		Immortal_Options.enable=0;
		Immortal_Hide();

	elseif (string.lower(msg)=="on") then 
		Immortal_Print("Immortal is now enabled");
		Immortal_Register();
		Immortal_Options.enable=1;
		Immortal_OnEvent("VARIABLES_LOADED");

	elseif (string.lower(string.sub(msg,1,8)) == "scalebar") then
		Immortal_Scale_Bar(string.sub(msg,10));

	elseif (string.lower(string.sub(msg,1,5)) == "scale") then
		Immortal_Scale(string.sub(msg,7));

	elseif (string.lower(msg)=="move") then 
		Immortal_Print("You can now move the frames around by dragging them. They are visible for 10seconds.");
		Immortal_Move();

	elseif (string.lower(msg)=="reset") then 
		Immortal_Reset();

	else
		Immortal_Print("/immortal on/off/move/scale/scalebar/reset");
	end
end


--Register events(Enable mod)
function Immortal_Register()
	for index, value in pairs(Immortal_Events) do
		Immortal_Frame:RegisterEvent(value);
	end	
end


--Unregister events(Disable mod)
function Immortal_Unregister()
	for index, value in pairs(Immortal_Events) do
		Immortal_Frame:UnregisterEvent(value);
	end	
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------Report functions--------------------------
---------------------Report functions--------------------------
---------------------Report functions--------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



--Reporting messages
function Immortal_Print(msg)
	DEFAULT_CHAT_FRAME:AddMessage("[Immortal]: "..msg,0.48,0.48,0.48);
end


--Formatting timers
function Immortal_Time_Format(seconds)
	local time;
	local h,m,s;
	local text="";

	if (seconds==nil) then
		return text;
	end

	time=seconds;
	
	if( time <= 0 ) then
		return text;
	else
		h=floor(time/3600);
		time=time-h*3600;

		m=floor(time/60);
		time=time-m*60;

		s=floor(time);
	end

	if h>0 then
		text=h.."."
		if m<10 then
			text=text.."0"..m;
		else
			text=text..m;
		end
	else
		text=m..":";
		if s<10 then
			text=text.."0"..s;
		else
			text=text..s;
		end
	end

	return text;
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------Update functions--------------------------
---------------------Update functions--------------------------
---------------------Update functions--------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



function Immortal_Start()

	Immortal_Activated=GetTime();
	
	Immortal_Frame:Show();
	Immortal_Frame:SetAlpha(1);

	local IM_Val=0;
	local IM_X=190/2*(IM_Val-50)/50;
	local IM_Time=Immortal_Time_Format(60);

	Immortal_Timer_Frame:Show();
	Immortal_Timer_Frame:SetAlpha(1);
	Immortal_Timer_Bar:SetValue(IM_Val);
	Immortal_Timer_Background:Show();
	Immortal_Timer_Spark:SetPoint("CENTER",IM_X,0);
	Immortal_Timer_Spark:Show();
	Immortal_Timer_Text:SetText("Cheat Death");
	Immortal_Timer_Time:SetText(IM_Time);

end


--Updating the timers
function Immortal_Update(Elapsed)

	Immortal_TimeSinceLastUpdate = Immortal_TimeSinceLastUpdate+Elapsed;


	if (Immortal_TimeSinceLastUpdate>Immortal_UpdateInterval) then

		local time=GetTime();

		--Hide all
		if (time-Immortal_Activated>60) then
			Immortal_Hide();
	
		--Hide icon
		elseif (time-Immortal_Activated>3) then
			Immortal_Frame:Hide();

		--Update icon
		else
			Immortal_Icon:SetAlpha(1-(time-Immortal_Activated)/3);
			Immortal_Icon:Show();  
		end

		
		local IM_Time=nil;
		local IM_Elapsed=time-Immortal_Activated;
		local IM_Val=100*IM_Elapsed/60;
		local IM_X=190/2*(IM_Val-50)/50;

		if (60-IM_Elapsed<0) then
			Immortal_Hide();
		else
			IM_Time=Immortal_Time_Format(60-IM_Elapsed+1);
			Immortal_Timer_Bar:SetValue(IM_Val);
			Immortal_Timer_Spark:SetPoint("CENTER",IM_X,0);
			Immortal_Timer_Time:SetText(IM_Time);
		end	

		Immortal_TimeSinceLastUpdate=0;
	end
	
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
-----------------------Main event handler----------------------
-----------------------Main event handler----------------------
-----------------------Main event handler----------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



local function clearArgs()
	for i, v in pairs(args) do
		args[i] = nil
	end
end


--Setting the flags in the variable "args"
local function Immortal_OnCombatLogEvent(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	
	if (not event) then 
		return;
	end

	Immortal_eventNeeded = false;
	for i, v in pairs(Immortal_Combat_Events) do
		if (Immortal_Combat_Events[event]==1) then
			Immortal_eventNeeded = true;
			break;
		end
	end
	if not Immortal_eventNeeded then
		return;
	end
	

		
	clearArgs();
	args.timestamp = timestamp
	args.event = event
	args.sourceGUID = sourceGUID
	args.sourceName = sourceName
	args.sourceFlags = sourceFlags
	args.destGUID = destGUID
	args.destName = destName
	args.destFlags = destFlags
	-- taken from Blizzard_CombatLog.lua
	if event == "SWING_DAMAGE" then 
		args.amount, args.school, args.resisted, args.blocked, args.absorbed, args.critical, args.glancing, args.crushing = select(1, ...)
	elseif event == "SWING_MISSED" then 
		args.spellName = ACTION_SWING
		args.missType = select(1, ...)
	elseif event:sub(1, 5) == "RANGE" then
		args.spellId, args.spellName, args.spellSchool = select(1, ...)
		if event == "RANGE_DAMAGE" then 
			args.amount, args.school, args.resisted, args.blocked, args.absorbed, args.critical, args.glancing, args.crushing = select(4, ...)
		elseif event == "RANGE_MISSED" then 
			args.missType = select(4, ...)
		end
	elseif event:sub(1, 5) == "SPELL" then
		args.spellId, args.spellName, args.spellSchool = select(1, ...)
		if event == "SPELL_DAMAGE" then
			args.amount, args.school, args.resisted, args.blocked, args.absorbed, args.critical, args.glancing, args.crushing = select(4, ...)
		elseif event == "SPELL_MISSED" then 
			args.missType = select(4, ...)
		elseif event == "SPELL_HEAL" then 
			args.amount, args.critical = select(4, ...)
			args.school = args.spellSchool
		elseif event == "SPELL_ENERGIZE" then 
			args.valueType = 2
			args.amount, args.powerType = select(4, ...)
		elseif event:sub(1, 14) == "SPELL_PERIODIC" then
			if event == "SPELL_PERIODIC_MISSED" then
				args.missType = select(4, ...)
			elseif event == "SPELL_PERIODIC_DAMAGE" then
				args.amount, args.school, args.resisted, args.blocked, args.absorbed, args.critical, args.glancing, args.crushing = select(4, ...)
			elseif event == "SPELL_PERIODIC_HEAL" then
				args.amount, args.critical = select(4, ...)
				args.school = args.spellSchool
			elseif event == "SPELL_PERIODIC_DRAIN" then
				args.amount, args.powerType, args.extraAmount = select(4, ...)
				args.valueType = 2
			elseif event == "SPELL_PERIODIC_LEECH" then
				args.amount, args.powerType, args.extraAmount = select(4, ...)
				args.valueType = 2
			elseif event == "SPELL_PERIODIC_ENERGIZE" then 
				args.amount, args.powerType = select(4, ...)
				args.valueType = 2			
			end
		elseif event == "SPELL_DRAIN" then
			args.amount, args.powerType, args.extraAmount = select(4, ...)
			args.valueType = 2
		elseif event == "SPELL_LEECH" then
			args.amount, args.powerType, args.extraAmount = select(4, ...)
			args.valueType = 2
		elseif event == "SPELL_INTERRUPT" then
			args.extraSpellId, args.extraSpellName, args.extraSpellSchool = select(4, ...)
		elseif event == "SPELL_EXTRA_ATTACKS" then
			args.amount = select(4, ...)
		elseif event == "SPELL_INSTAKILL" then
		elseif event == "SPELL_DURABILITY_DAMAGE" then
		elseif event == "SPELL_DURABILITY_DAMAGE_ALL" then
		elseif event == "SPELL_DISPEL_FAILED" then
			args.extraSpellId, args.extraSpellName, args.extraSpellSchool = select(4, ...)
		elseif event == "SPELL_AURA_DISPELLED" then
			args.extraSpellId, args.extraSpellName, args.extraSpellSchool = select(4, ...)
			args.auraType = select(7, ...)
		elseif event == "SPELL_AURA_STOLEN" then
			args.extraSpellId, args.extraSpellName, args.extraSpellSchool = select(4, ...)
			args.auraType = select(7, ...)
		elseif event == "SPELL_AURA_APPLIED" or event == "SPELL_AURA_REMOVED" then
			args.auraType = select(4, ...)
			args.sourceName = args.destName
			args.sourceGUID = args.destGUID
			args.sourceFlags = args.destFlags
		elseif event == "SPELL_AURA_APPLIED_DOSE" or event == "SPELL_AURA_REMOVED_DOSE" then
			args.auraType, args.amount = select(4, ...)
			args.sourceName = args.destName
			args.sourceGUID = args.destGUID
			args.sourceFlags = args.destFlags
		elseif event == "SPELL_CAST_START" then
		elseif event == "SPELL_CAST_SUCCESS" then
		elseif event == "SPELL_CAST_FAILED" then 
			args.missType = select(4, ...)
		end
	elseif event == "DAMAGE_SHIELD" then
		args.spellId, args.spellName, args.spellSchool = select(1, ...)
		args.amount, args.school, args.resisted, args.blocked, args.absorbed, args.critical, args.glancing, args.crushing = select(4, ...)
	elseif event == "DAMAGE_SHIELD_MISSED" then 
		args.spellId, args.spellName, args.spellSchool = select(1, ...)
		args.missType = select(4, ...)
	elseif event == "PARTY_KILL" then
	elseif event == "ENCHANT_APPLIED" then
		args.spellName = select(1,...)
		args.itemId, args.itemName = select(2,...)
	elseif event == "ENCHANT_REMOVED" then
		args.spellName = select(1,...)
		args.itemId, args.itemName = select(2,...)
	elseif event == "UNIT_DIED" or event == "UNIT_DESTROYED" then
		args.sourceName = args.destName
		args.sourceGUID = args.destGUID
		args.sourceFlags = args.destFlags
	elseif event == "ENVIRONMENTAL_DAMAGE" then
		args.environmentalType = select(1,...)
		args.amount, args.school, args.resisted, args.blocked, args.absorbed, args.critical, args.glancing, args.crushing = select(2, ...)
		args.spellName = getglobal("ACTION_"..event.."_"..args.environmentalType)
		args.spellSchool = args.school
	elseif event == "DAMAGE_SPLIT" then
		args.spellId, args.spellName, args.spellSchool = select(1, ...)
		args.amount, args.school, args.resisted, args.blocked, args.absorbed, args.critical, args.glancing, args.crushing = select(4, ...)
	end

end


function Immortal_OnEvent(event,...)

	if ( event == "VARIABLES_LOADED") then
			
		if (UnitClass("player")=="Rogue") then
			if (Immortal_Options.enable==1) then
				Immortal_Register();
				Immortal_Icon:SetAlpha(1);
			end

			Immortal_Hide();
		end
		return;

	else
		Immortal_OnCombatLogEvent(...);

		if (not Immortal_eventNeeded) then
			return;
		end

		if (args.sourceName==UnitName("player")) and (args.spellName=="Cheating Death") then
			Immortal_Start();
		end
		return;
	end
end







---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------
-----------------------Hide function---------------------------
-----------------------Hide function---------------------------
-----------------------Hide function---------------------------
---------------------------------------------------------------
---------------------------------------------------------------
---------------------------------------------------------------



--Hiding the window
function Immortal_Hide()
	Immortal_Frame:Hide();
	Immortal_Icon:Hide();

	Immortal_Timer_Frame:Hide();
	Immortal_Timer_Bar:SetValue(0);
	Immortal_Timer_Background:Hide();
	Immortal_Timer_Spark:Hide();
	Immortal_Timer_Text:SetText(nil);
	Immortal_Timer_Time:SetText(nil);
end


--Scaling icon
function Immortal_Scale(Immortal_New_Scale)

	local IM_Scale=tonumber(Immortal_New_Scale);

	if (IM_Scale~="") then
		if type(IM_Scale)=="number" then
			Immortal_Frame:SetScale(IM_Scale);
			Immortal_Move_Frame:SetScale(IM_Scale);
			Immortal_Options.scale=IM_Scale;
			Immortal_Print("Scale on image set to: "..IM_Scale);
			return;
		end
	end
	Immortal_Print("Scale factor not recognized. Setting default image scale to 1");
	Immortal_Options.scale=1;
end


--Scaling bar
function Immortal_Scale_Bar(Immortal_New_Scale)

	local IM_Scale=tonumber(Immortal_New_Scale);

	if (IM_Scale~="") then
		if type(IM_Scale)=="number" then
			Immortal_Timer_Frame:SetScale(IM_Scale);
			Immortal_Timer_Move_Frame:SetScale(IM_Scale);
			Immortal_Options.scalebar=IM_Scale;
			Immortal_Print("Scale on timer bar set to: "..IM_Scale);
			return;
		end
	end
	Immortal_Print("Scale factor not recognized. Setting default timer scale to 1");
	Immortal_Options.scalebar=1;
end


function Immortal_Move()
	Immortal_Move_Frame:Show();
	Immortal_Move_Text:SetText("Move me");

	Immortal_Timer_Move_Frame:Show();
	Immortal_Timer_Move_Text:SetText("Move me");
	Immortal_Movetime=GetTime();
end


function Immortal_Move_Time(Elapsed)

	if (GetTime()-Immortal_Movetime>10) then
		Immortal_Move_Frame:Hide();
		Immortal_Timer_Move_Frame:Hide();
		Immortal_Movetime=0;
	end
end