----------------------------------------------------------------------
-- Console logging function
----------------------------------------------------------------------
function out(text)
	if DEFAULT_CHAT_FRAME then
		DEFAULT_CHAT_FRAME:AddMessage("|cffffffff" .. text);
	end
end

----------------------------------------------------------------------
-- Initialization
----------------------------------------------------------------------

HonorRate = {};

HonorRate.current_bg = "none";
HonorRate.current_zone = "none";

HonorRate.time = {};
HonorRate.total = {};
HonorRate.start = {};
HonorRate.begin = {};

----------------------------------------------------------------------
-- Battleground initialization function
----------------------------------------------------------------------
function HonorRateGlobal_InitBG( bg )
	HonorRate.time [ bg ] = 0;
	HonorRate.total[ bg ] = 0;
	HonorRate.start[ bg ] = 0;
	HonorRate.begin[ bg ] = 0;
end

----------------------------------------------------------------------
-- Battleground status function
----------------------------------------------------------------------
function HonorRateGlobal_StatBG( bg )
	local th = HonorRate.total[ bg ];
	local tt = HonorRate.time[ bg ] / 60;
	local dth = th;
	if (tt ~= 0) then
		dth = dth / tt;
	end
	dth = math.floor(dth);
	out("- " .. string.upper(bg) .. " : " .. th .. " HP in " .. math.floor(tt)  .. " minutes (" .. dth .. " hpm)");
end

----------------------------------------------------------------------
-- Battleground entry
----------------------------------------------------------------------
function HonorRateGlobal_EnterBG( bg )
	HonorRate.start[ bg ] = GetHonorCurrency();
	HonorRate.begin[ bg ] = GetTime();
end

----------------------------------------------------------------------
-- Battleground exit
----------------------------------------------------------------------
function HonorRateGlobal_ExitBG( bg )
	local endtotal = GetHonorCurrency();
	local endtime  = GetTime();

	local dh = endtotal - HonorRate.start[ bg ];
	local dt = endtime - HonorRate.begin[ bg ];
	
	local dht = dh * 60;
	if (dt ~= 0) then
		dht = dht / dt;
	end
	dht = math.floor(dht);

	HonorRate.time [ bg ] = HonorRate.time [ bg ] + dt;
	HonorRate.total[ bg ] = HonorRate.total[ bg ] + dh;

	HonorRate.start[ bg ] = 0;
	HonorRate.begin[ bg ] = 0;
	
	out("HonorRate: You just earned " .. dh .. " honor points in " .. string.upper(bg) .. " (" .. dht .. " hpm)");
end

----------------------------------------------------------------------
-- When the global window is loaded
----------------------------------------------------------------------
function HonorRateGlobal_OnLoad(self)
	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("ZONE_CHANGED");
	self:RegisterEvent("ZONE_CHANGED_NEW_AREA");
end

----------------------------------------------------------------------
-- Works out the slashcommands
----------------------------------------------------------------------
function HonorRateGlobal_CommandHandler(msg)
	out("HonorRate statistics :");
	HonorRateGlobal_StatBG("wsg");
	HonorRateGlobal_StatBG("av");
	HonorRateGlobal_StatBG("ab");
	HonorRateGlobal_StatBG("eots");
end

----------------------------------------------------------------------
-- Create the slashcommands
----------------------------------------------------------------------
function HonorRateGlobal_CreateCommands()
	SLASH_HonorRate1 = "/hr";
	SlashCmdList["HonorRate"] = function(msg)
		HonorRateGlobal_CommandHandler(msg);
	end
	out("HonorRate by Ac / The Venture Company : loaded. Type /hr for more info.");
end

----------------------------------------------------------------------
-- Global Event manager
----------------------------------------------------------------------
function HonorRateGlobal_OnEvent(self, event, ...)

	-- Wait that the addon is loaded
	if ( event == "ADDON_LOADED" ) then
		-- register the slashcommands
		local addon = arg1;
		if ( addon == "HonorRate" ) then
			self:UnregisterEvent("ADDON_LOADED");
			HonorRateGlobal_CreateCommands();
			
			HonorRateGlobal_InitBG("wsg");
			HonorRateGlobal_InitBG("ab");
			HonorRateGlobal_InitBG("av");
			HonorRateGlobal_InitBG("eots");
		end
	end
	
	-- Hook on the zone message
	if (event == "ZONE_CHANGED" or event == "ZONE_CHANGED_NEW_AREA") then

		local temp = GetRealZoneText();

		if (temp ~= HonorRate.current_zone) then 

			HonorRate.current_zone = temp;

			if (HonorRate.current_zone == "Goulet des Chanteguerres" or HonorRate.current_zone == "Warsong Gulch") then
				temp = "wsg";
			elseif (HonorRate.current_zone == "Bassin d'Arathi" or HonorRate.current_zone == "Arathi Basin") then
				temp = "ab";
			elseif (HonorRate.current_zone == "Vall\195\169e d'Alterac" or HonorRate.current_zone == "Alterac Valley" ) then
				temp = "av";
			elseif (HonorRate.current_zone == "L'\197\146il du cyclone" or HonorRate.current_zone == "Eye of the Storm") then
				temp = "eots";
			else
				temp = "none";
			end;

			if (HonorRate.current_bg ~= "none") then
				HonorRateGlobal_ExitBG(HonorRate.current_bg);
			end

			HonorRate.current_bg = temp;

			if (HonorRate.current_bg ~= "none") then
				HonorRateGlobal_EnterBG(HonorRate.current_bg);
			end

		end
	end
end
