﻿------------------------ Holyshield - Combat Stats ---------------------------
-- Author		: EEM, aka: Holyshield@Thunderhorn / Zanna@Thunderhorn
-- Email		: ZannaThunderhorn@gmail.com
-- Create Date	: 4/19/2008
------------------------------------------------------------------------------

local Root = HolyshieldCombatStats;
local Miss = Root.GetOrNewModule("Miss");

------------------------------------------------------------------------------
--                                Locals
------------------------------------------------------------------------------



------------------------------------------------------------------------------
--                                Methods
------------------------------------------------------------------------------

---- Method ------------------------------------------------------------------
-- root -> Miss -> ToChat(level)
---- Arguments ---------------------------------------------------------------
-- level: 
---- Description -------------------------------------------------------------
-- Reports miss chances to the default chat frame.
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
Miss.ToChat = function(self, level)
	local MH, OH = Miss.CalcluateMelee(UnitLevel("player"), level);
	local RA = Miss.CalcluateRanged(UnitLevel("player"), level);
	local SP = Miss.CalcluateSpell(UnitLevel("player"), level);
	local msg;
	
	msg = Root.ShortName.." - PvE Miss Chance List.  Target Level: "..level;
	DEFAULT_CHAT_FRAME:AddMessage(msg, 1.0, 1.0, 0.0);
	
	-- Display main-hand miss chance.
	if MH ~= nil then
		msg = "Main-Hand: "..
			string.format("%.2f", MH).."% - "..
			string.format("%.2f",Miss.GetMeleeHitBonus()).."% = "..
			string.format("%.2f", MH - Miss.GetMeleeHitBonus()).."%";
	else
		msg = Root.ShortName..": (ToChat - MH) Enter message. ";
	end
	DEFAULT_CHAT_FRAME:AddMessage(msg, 1.0, 0.0, 0.0);
	
	-- Display off-hand miss chance.
	if OH ~= nil then
		msg = "Off-Hand: "..
			string.format("%.2f", OH).."% - "..
			string.format("%.2f",Miss.GetMeleeHitBonus()).."% = "..
			string.format("%.2f", OH - Miss.GetMeleeHitBonus()).."%";
	else
		msg = "Off-Hand: No item equiped.";
	end
	DEFAULT_CHAT_FRAME:AddMessage(msg, 1.0, 0.0, 0.0);
	
	-- Display ranged weapon miss chance.
	if RA ~= nil then
		msg = "Ranged: "..
			string.format("%.2f", RA).."% - "..
			string.format("%.2f",Miss.GetRangedHitBonus()).."% = "..
			string.format("%.2f", RA - Miss.GetRangedHitBonus()).."%";
	else
		msg = "Ranged: No ranged weapon equiped.";
	end
	DEFAULT_CHAT_FRAME:AddMessage(msg, 0.0, 1.0, 0.0);
		
	-- Display spell miss chance.
	if SP ~= nil then
		msg = "Spells: "..
			string.format("%.2f", SP).."% + "..
			string.format("%.2f",Miss.GetSpellHitBonus()).."% = "..
			string.format("%.2f", SP - Miss.GetSpellHitBonus()).."%";
	else
		msg = "Spells: No value defined."
	end
	DEFAULT_CHAT_FRAME:AddMessage(msg, 0.0, 0.0, 1.0);
	
end

------------------------------------------------------------------------------
--                                Functions
------------------------------------------------------------------------------

---- Function ----------------------------------------------------------------
-- root -> Miss -> CalcluateMelee(playerLevel, targetLevel)
---- Arguments ---------------------------------------------------------------
-- playerLevel: Level of the player.
-- targetLevel: Level of the target.
---- Description -------------------------------------------------------------
-- Calcluates the melee miss chance.  Returns chance to miss as numeric.
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.CalcluateMelee(playerLevel, targetLevel)
	local MHItem = GetInventoryItemLink("player", GetInventorySlotInfo("MainHandSlot"));
	local OHItem = GetInventoryItemLink("player", GetInventorySlotInfo("SecondaryHandSlot"));
	local MHMiss;
	local OHMiss;
	
	-- Calcluate the main-hand miss chance.
	-- Specal case: When no weapon in MH is equiped, player is concidered 
	-- 		unarmed.  We instead calcluate the miss chance from the player's
	-- 		unaremd skill.
	if MHItem ~= nil then 
		local _, _, _, _, _, MHItemType = GetItemInfo(MHItem);
		if Root.Debug == true then DEFAULT_CHAT_FRAME:AddMessage("MainHand"..MHItem.." "..MHItemType); end
		if MHItemType == "Weapon" then
			MHMiss = Miss.GetWeaponMissChance(MHItem, Miss.GetMaxDefense(targetLevel));
		end
	else 
		-- No MH item equip.  Player is unarmed.
		MHMiss = Miss.GetUnarmedMissChance(Defense);
	end
	
	-- Calcluate off-hand miss chance.
	-- Specal case: Using a off-hand weapon is concidered dual-wielding.
	--		Dual-wielding causes an extra 19% miss to both MH and OH.
	if OHItem ~= nil then
		local _, _, _, _, _, OHItemType = GetItemInfo(OHItem);
			if OHItemType == "Weapon" then
			OHMiss = Miss.GetWeaponMissChance(OHItem, Miss.GetMaxDefense(targetLevel));
			
			-- Add bonus chance to miss fromt the specal case.
			MHMiss = MHMiss + 19;
			OHMiss = OHMiss + 19;
		end
	end
	
	return MHMiss, OHMiss;
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> CalcluateRanged(playerLevel, targetLevel)
---- Arguments ---------------------------------------------------------------
-- playerLevel: Level of the player.
-- targetLevel: Level of the target.
---- Description -------------------------------------------------------------
-- Calcluates the ranged miss chance.  Returns chance to miss as numeric.
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.CalcluateRanged(playerLevel, targetLevel)
	local RAItem = GetInventoryItemLink("player", GetInventorySlotInfo("RangedSlot"));
	local RAMiss;
	
	if RAItem ~= nil then
		local _, _, _, _, _, RAItemType = GetItemInfo(RAItem);
		if RAItemType == "Weapon" then
			RAMiss = Miss.GetWeaponMissChance(RAItem, Miss.GetMaxDefense(targetLevel));
		end
	end
	
	return RAMiss;
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> CalcluateSpell(playerLevel, targetLevel)
---- Arguments ---------------------------------------------------------------
-- playerLevel: Level of the player.
-- targetLevel: Level of the target.
-- 
---- Description -------------------------------------------------------------
-- Calcluates the melee spell chance.  Returns chance to miss as numeric.
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.CalcluateSpell(playerLevel, targetLevel)
	return Miss.GetSpellMissChance(playerLevel, targetLevel);
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> GetMaxDefense(level)
---- Arguments ---------------------------------------------------------------
-- level: Level of unit.
---- Description -------------------------------------------------------------
-- Calcluates the max base defense of a given unit(npc) and returns the value.
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.GetMaxDefense(level)
	return level * 5;
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.GetWeaponMissChance(item, defense)
	if Root.Debug == true then DEFAULT_CHAT_FRAME:AddMessage("GWMC: "..item.." "..defense); end
	return Miss.CalcluateBaseMiss(Miss.GetWeaponSkill(Miss.GetWeaponSubType(item)), defense);
end


---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.GetUnarmedMissChance(defense)
	return Miss.CalcluateBaseMiss(Miss.GetWeaponSkill("Unarmed"), defense);
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.GetSpellMissChance(playerLevel, targetLevel)
	local value;
	local levelDiff = targetLevel - playerLevel;
	
	if Root.Debug == true then DEFAULT_CHAT_FRAME:AddMessage("GSMC: "..levelDiff); end
	-- vs NPC
	if levelDiff <= -3 then
		value =  1;
	elseif levelDiff == -2 then
		value =  2;
	elseif levelDiff == -1 then	
		value =  3;
	elseif levelDiff == 0 then
		value =  4;
	elseif levelDiff == 1 then
		value =  5;
	elseif levelDiff == 2 then
		value =  6;
	elseif levelDiff == 3 then
		value =  17;
	elseif levelDiff == 4 then
		value =  28;
	elseif levelDiff == 5 then
		value =  39;
	elseif levelDiff >= 5 then
		value = 39 + (levelDiff - 5) * 11;
	else
		value = -999; -- 
	end
	
	return max(min(value, 99), 1);
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.GetMeleeHitBonus()
	return GetCombatRatingBonus(CR_HIT_MELEE);
end

function Miss.GetRangedHitBonus()
	return GetCombatRatingBonus(CR_HIT_RANGED);
end

function Miss.GetSpellHitBonus()
	return GetCombatRatingBonus(CR_HIT_SPELL);
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.GetWeaponSubType(itemLink)
	local _, _, _, _, _, ItemType, ItemSubType = GetItemInfo(itemLink);
	if debug == true then DEFAULT_CHAT_FRAME:AddMessage("GWST: "..itemLink.." ".. ItemType.." "..ItemSubType); end
	return Miss.ConvertWeaponType(ItemSubType); -- Convert subtype to skill name.
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.GetWeaponSkill(value)
	if type(value) ~= "string" then return; end
	if Root.Debug == true then DEFAULT_CHAT_FRAME:AddMessage("GWS "..value); end
	for skillIndex = 1, GetNumSkillLines(), 1 do
		local skillName, _, _, skillRank = GetSkillLineInfo(skillIndex);
		if skillName == value then
			return skillRank;
		end	
	end
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.CalcluateBaseMiss(weaponSkill, defense)
	if Root.Debug == true then DEFAULT_CHAT_FRAME:AddMessage("CalcluateBaseMiss: "..weaponSkill.." "..defense); end
	if (defense - weaponSkill) > 10 then
		return (7 + (defense - weaponSkill - 10) * 0.4);
	else
		return (5 + (defense - weaponSkill) * 0.1);
	end
end

---- Function ----------------------------------------------------------------
-- root -> Miss -> 
---- Arguments ---------------------------------------------------------------
-- 
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Miss.ConvertWeaponType(WeaponSubType)
	--Converts weapon subtype to combat skill.
	if WeaponSubType == "Bows" then
		return "Bows";
	elseif WeaponSubType == "Crossbows" then
		return "Crossbows";
	elseif WeaponSubType == "Daggers"  then
		return "Daggers";
	elseif WeaponSubType == "Guns" then
		return "Guns";
	elseif WeaponSubType == "Fist Weapons" then
		return "Unarmed";
	elseif WeaponSubType == "One-Handed Axes" then
		return "Axes";
	elseif WeaponSubType == "One-Handed Maces" then
		return "Maces";
	elseif WeaponSubType == "One-Handed Swords" then
		return "Swords";
	elseif WeaponSubType == "Polearms" then
		return "Polearms";
	elseif WeaponSubType == "Staves" then
		return "Staves";
	elseif WeaponSubType == "Thrown" then
		return "Thrown";
	elseif WeaponSubType == "Two-Handed Axes" then
		return "Two-Handed Axes";
	elseif WeaponSubType == "Two-Handed Maces" then
		return "Two-Handed Maces";
	elseif WeaponSubType == "Two-Handed Swords" then
		return "Two-Handed Swords";
	elseif WeaponSubType == "Wands" then
		return "Wands";
	else
		return nil;
	end
end



------------------------------------------------------------------------------
--                                Handlers
------------------------------------------------------------------------------

Miss.OnStart = function(self)
	if Root.Debug == true then Root.GotHere("Miss - OnStart"); end
end

Miss.Help = function(self, value)
	if value ~= "Miss" then return; end
	DEFAULT_CHAT_FRAME:AddMessage(Root.ShortName.." - Miss [Command] '/hcs miss ##'  Without the 's.  ## is a valid whole number between 0 and 99", 1.0, 1.0, 0.0);
	DEFAULT_CHAT_FRAME:AddMessage(Root.ShortName.." - Miss [Format] type: base - hit bonus = total (negitive = overcapped)", 1.0, 1.0, 0.0);
end
