﻿------------------------ Holyshield - Combat Stats ---------------------------
-- Author		: EEM, aka: Holyshield@Thunderhorn / Zanna@Thunderhorn
-- Email		: ZannaThunderhorn@gmail.com
-- Create Date	: 4/19/2008
------------------------------------------------------------------------------
---                      !! This file loaded first !!                      ---
------------------------------------------------------------------------------
HolyshieldCombatStats = { };
local Root = HolyshieldCombatStats;
Root.Name = "Holyshield Combat Stats";
Root.ShortName = "HCS";
Root.Folder = "Interface\\AddOns\\HolyshieldCombatStats\\";

------------------------------------------------------------------------------
--                                Globals
------------------------------------------------------------------------------
Root.Modules = { };
Root.Version = 2;
Root.Debug = false;

------------------------------------------------------------------------------
--                                Functions
------------------------------------------------------------------------------

--- Example Function Header
---- Function ----------------------------------------------------------------
-- Root -> FunctionName(Arguments)
---- Arguments ---------------------------------------------------------------
-- ArgumentName: Description
---- Description -------------------------------------------------------------
-- Description of this function.
---- Last Updated ------------------------------------------------------------
-- Author Name - Date(month/day/year): Notes
------------------------------------------------------------------------------

--- Template
---- Function ----------------------------------------------------------------
-- Root -> 
---- Arguments ---------------------------------------------------------------
-- none
---- Description -------------------------------------------------------------
-- 
---- Last Updated ------------------------------------------------------------
-- EEM - mm/dd/yyyy:  Inital Creation
------------------------------------------------------------------------------

---- Function ----------------------------------------------------------------
-- Root -> GetOrNewModule(moduleName)
---- Arguments ---------------------------------------------------------------
-- moduleName: The name of the module.
---- Description -------------------------------------------------------------
-- Gets an existing module's table object or create it if it does not exist. 
-- Whatever this function does, it will return the table.
---- Last Updated ------------------------------------------------------------
-- Unknowen - mm/dd/yyyy:  Inital Creation
------------------------------------------------------------------------------

function Root.GetOrNewModule(moduleName)
	if type(moduleName) ~= "string" then return; end
	local module = Root.Modules;
	if type(module[moduleName]) == "table" then return module[moduleName]; end
	module[moduleName] = { };
	return module[moduleName];
end

---- Function ----------------------------------------------------------------
-- Root -> InvokeHandler(handlerName, ...)
---- Arguments ---------------------------------------------------------------
-- handlerName: The name of the handler to call.
-- ...: Arguments to pass to the handler.
---- Description -------------------------------------------------------------
-- Invoke a given handler on all registered modules.
---- Last Updated ------------------------------------------------------------
-- Unknowen - mm/dd/yyyy:  Inital Creation
------------------------------------------------------------------------------
function Root.InvokeHandler(handlerName, ...)
	if type(handlerName) ~= "string" then return; end
	local k, v;
	for k, v in pairs(Root.Modules) do
		if type(v) == "table" then
			if type(v[handlerName]) == "function" then
				v[handlerName](v, ...);
			end
		end
	end
end

------------------------------------------------------------------------------
--                                Handlers
------------------------------------------------------------------------------

function Root.OnLoad()
	if Root.Debug == true then Root.GotHere("Loaded"); end
	Root.OnStart();
	SLASH_HOLYSHIELDCOMBATSTATS1 = "/hcs";
	SlashCmdList["HOLYSHIELDCOMBATSTATS"] = Root.Slash;
	--this:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED");
	--this:RegisterEvent("VARIABLES_LOADED");
end

function Root.OnEvent(event)
	Root.GotHere("OnEvent - "..event);
	--if ( event == "VARIABLES_LOADED" ) then
		--Root.GotHere("Variables Loaded");
		--Root.OnStart();
		--return;
	--end
	--if (event == "UNIT_SPELLCAST_SUCCEEDED") then
		--Root.GotHere("Unit Health");
		--Root.InvokeHandler("ToChat");	
	--end
end

function Root.OnStart()
	if Root.Debug == true then Root.GotHere("OnStart"); end
	--Root.InvokeHandler("OnStart");
	--Root.GotHere("OnStart - END");
end

function Root.Slash(text)
	if Root.Debug == true then Root.GotHere("Slash - "..text); end
	local cmd = string.sub(text, 0,4);
	local cmdText = string.sub(text, 6,7);
	if Root.Debug == true then Root.GotHere(cmd.." "..cmdText); end
	if cmd == "miss" then
		local level = tonumber(cmdText);
		
		if level == nil then
			level = UnitLevel("target");
			if level == 0 then 
				level = UnitLevel("player"); 
			end
		end
		Root.InvokeHandler("ToChat", level);
	elseif text == "help" then
		Root.InvokeHandler("Help", "Miss");
	end
end

------------------------------------------------------------------------------
-- Functions for debugging/testing
------------------------------------------------------------------------------

---- Function ----------------------------------------------------------------
-- Root -> GotHere(msg)
---- Arguments ---------------------------------------------------------------
-- msg: Message to be displayed.
---- Description -------------------------------------------------------------
-- Displayes a "Got Here!" or supplyed message for testing.
---- Last Updated ------------------------------------------------------------
-- EEM - 08/11/2008:  Inital Creation
------------------------------------------------------------------------------
function Root.GotHere(msg)
	if type(msg) ~= "string" then 
		DEFAULT_CHAT_FRAME:AddMessage(Root.ShortName..": Got Here!", 1.0, 1.0, 0.0, nil, false);
	else 
		DEFAULT_CHAT_FRAME:AddMessage(Root.ShortName..": "..msg, 1.0, 1.0, 0.0, nil, false); 
	end
end

